<?php

class ops_hook_users_habilitations
{
    
    /**
     * create_habilitations_dispositifs
     * Fonction du hook permettant les habilitations des dispositifs sur les utilisateurs 
     *
     * @param  mixed $bean
     * @param  mixed $event
     * @param  mixed $arguments
     *
     * @return void
     */
    function create_habilitations_dispositifs(&$bean, $event, $arguments = null)
    {
        if ($event != 'after_login') {
            return;
        } 
        
        global $app_list_strings, $beanFiles, $current_user;

        $tab_habilitation = array() ; 
        $tab_habilitation_individu = array() ; 
        
         // On récupère les groupes de sécurité de l'utilisateur
        $current_user->load_relationship('SecurityGroups');
        $securitygroups_ids = $current_user->SecurityGroups->get();
        
        if (!empty($securitygroups_ids)) {

            // Boucle sur les profils métiers 
            foreach ($securitygroups_ids as $security_key => $security_id) {
                
                // Récupération du profil métier 
                $obj_profil_metier = BeanFactory::getBean('SecurityGroups', $security_id);
                $obj_profil_metier->load_relationship('ops_habilitation_dispositif_securitygroups');

                // Partie Habilitation onglet individu

                $onglet_individu = [
                    'autorisations_attestations',
                    'fiche_sante',
                    'regime_alimentaire',
                    'situation_professionnelle',
                    'journal_modification',
                    'individu_calendrier',
                    'profil_calendrier',
                ];

                // Boucle sur les habilitations dispositifs 
                foreach ($onglet_individu as $onglet) 
                {
                    if(!empty($obj_profil_metier->{$onglet}))
                    {
                        $tab_habilitation_individu[$onglet] = $obj_profil_metier->{$onglet};
                    }
                }

                // Fin

                // Récupération des dispositifs liés au profil métier 
                $habilitation_ids = $obj_profil_metier->ops_habilitation_dispositif_securitygroups->get();
                
                if (!empty($habilitation_ids)) {
              
                    // Boucle sur les habilitations dispositifs 
                    foreach ($habilitation_ids as $habilitation_cle => $habiliatation_id) {

                        $obj_habilitation_dispositif = BeanFactory::getBean('OPS_habilitation_dispositif', $habiliatation_id);

                        if( !empty($obj_habilitation_dispositif)){

                            // Récupération des habilitations du dispositif
                            $tab_habilitation[$obj_habilitation_dispositif->ops_dispositif_id] = $obj_habilitation_dispositif->get_habilitations() ;                         
                            
                        }
                    }
                }
            }
        }

        $_SESSION['habilitation_dispositif'] = $tab_habilitation; 
        $_SESSION['habilitation_individu'] = $tab_habilitation_individu; 
    }


     /**
     * create_habilitations_localisations
     * Fonction du hook permettant les habilitations des localisations sur les utilisateurs 
     *
     * @param  mixed $bean
     * @param  mixed $event
     * @param  mixed $arguments
     *
     * @return void
     */
    function create_habilitations_localisations(&$bean, $event, $arguments = null)
    {
        if ($event != 'after_login') {
            return;
        } 
        
        global $app_list_strings, $beanFiles, $current_user;


         // On récupère les groupes de sécurité de l'utilisateur
        $current_user->load_relationship('ops_territoire_users');
        $localisations_ids = $current_user->ops_territoire_users->get();
        
        if (!empty($localisations_ids)) {

            $_SESSION['habilitation_localisation'] = $localisations_ids; 
            
        }

    }

     /**
     * create_requete_dossier
     * Fonction du hook permettant les habilitations des localisations sur les utilisateurs 
     *
     * @param  mixed $bean
     * @param  mixed $event
     * @param  mixed $arguments
     *
     * @return void
     */
    function create_requete_dossier(&$bean, $event, $arguments = null){
        
        global $app_list_strings, $beanFiles, $current_user;
        require_once($beanFiles['OPS_dossier']);

        $obj_dossier = new OPS_dossier();
        $obj_dossier->create_requete_dossier();

    }
  
    
}

?>