<?php
namespace ODE_API\V8\Controller;

use ODE_API\V8\Param\AjaxPointsParams;

use ODE_API\V8\Service\AjaxPointsService;

use Slim\Http\Request;
use Slim\Http\Response;

/**
* AjaxPointsController
*/
class AjaxPointsController extends BaseController
{


    /**
    * @var ajaxpointsService
    */
    protected $ajaxpointsService;

    /**
    * @param AjaxPointsService $ajaxpointsService
    */
    public function __construct(AjaxPointsService $ajaxpointsService)
    {
        $this->ajaxpointsService = $ajaxpointsService;
    }



    /**
    * @param Request $request
    * @param Response $response
    * @param array $args
    * @param AjaxPointsParams $params
    *
    * @return Response
    */
    public function getInfoFiscaleByNumRef(Request $request, Response $response, array $args, AjaxPointsParams $params)
    {
        try {
            $jsonResponse = $this->ajaxpointsService->getInfoFiscaleByNumRef($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 


}

