<?php

namespace ODE_API\V8\Controller;

use ODE_API\V8\Controller\BaseController;
use ODE_API\V8\Service\ConversationService;
use ODE_API\V8\Param\ListeConversationParams;
use Exception;
use Slim\Http\Request;
use Slim\Http\Response;


class ConversationController extends BaseController
{
    /**
     * @var ConversationService
     */
    private $ConversationService;

    /**
     * @param ConversationService $ConversationService
     */
    public function __construct(ConversationService $ConversationService)
    {
        $this->ConversationService = $ConversationService;
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param accessConversation $params
     *
     * @return Response
     */
    public function accessConversation(Request $request, Response $response, array $args, ListeConversationParams $params): Response
    {
        try {
            $jsonResponse = $this->ConversationService->accessConversation($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param fetchConversationState $params
     *
     * @return Response
     */
    public function fetchConversationState(Request $request, Response $response, array $args, ListeConversationParams $params): Response
    {
        try {
            $jsonResponse = $this->ConversationService->fetchConversationState($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param fetchMessages $params
     *
     * @return Response
     */
    public function fetchMessages(Request $request, Response $response, array $args, ListeConversationParams $params): Response
    {
        try {
            $jsonResponse = $this->ConversationService->fetchMessages($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param sendMessage $params
     *
     * @return Response
     */
    public function sendMessage(Request $request, Response $response, array $args, ListeConversationParams $params): Response
    {
        try {
            $jsonResponse = $this->ConversationService->sendMessage($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param setMessageStatut $params
     *
     * @return Response
     */
    public function setMessageStatut(Request $request, Response $response, array $args, ListeConversationParams $params): Response
    {
        try {
            $jsonResponse = $this->ConversationService->setMessageStatut($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

}