<?php

namespace ODE_API\V8\Controller;

use ODE_API\V8\Service\DossierJustificatifService;

use ODE_API\V8\Param\DossierSetParams;


use Slim\Http\Request;
use Slim\Http\Response;

/**
 * DossierController
 */
class DossierJustificatifController extends BaseController
{
    /**
     * @var DossierController
     */
    protected $DossierJustificatifService;

    /**
     * @param DossierJustificatifService $DossierJustificatifService
     */
    public function __construct(DossierJustificatifService $DossierJustificatifService)
    {
        $this->DossierJustificatifService = $DossierJustificatifService;
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function createJustificatif(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->DossierJustificatifService->createJustificatif($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierListParams $params
     *
     * @return Response
     */
    public function deleteJustificatif(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->DossierJustificatifService->deleteJustificatif($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }
	
}
