<?php
namespace ODE_API\V8\Controller;

use ODE_API\V8\Service\IndividuService;
use ODE_API\V8\Param\IndividuInfoParams;
use ODE_API\V8\Param\UpdateIndividuParams;
use ODE_API\V8\Param\IndividuMessageDetailParams;

use Slim\Http\Request;
use Slim\Http\Response;

/**
* DispositifController
*/
class IndividuController extends BaseController
{


    /**
    * @var IndividuController
    */
    protected $individuService;

    /**
    * @param IndividuService $individuService
    */
    public function __construct(IndividuService $individuService)
    {
        $this->individuService = $individuService;
    }



    /**
    * @param Request $request
    * @param Response $response
    * @param array $args
    * @param IndividuInfoParams $params
    *
    * @return Response
    */
    public function getInfoIndividu(Request $request, Response $response, array $args, IndividuInfoParams $params)
    {
        try {

            $jsonResponse = $this->individuService->getInfoIndividu($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 


    /**
    * @param Request $request
    * @param Response $response
    * @param array $args
    * @param UpdateIndividuParams $params
    *
    * @return Response
    */
    public function updateIndividu(Request $request, Response $response, array $args, UpdateIndividuParams $params)
    {
        try {
            $jsonResponse = $this->individuService->updateIndividu($params, $request);

            return $this->generateResponse($response, $jsonResponse, 201);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, 400);
        }
    }

    
    /**
    * @param Request $request
    * @param Response $response
    * @param array $args
    * @param IndividuInfoParams $params
    *
    * @return Response
    */
    public function getIndividuMessages(Request $request, Response $response, array $args, IndividuInfoParams $params)
    {
        try {

            $jsonResponse = $this->individuService->getIndividuMessages($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
        
    } 


    /**
    * @param Request $request
    * @param Response $response
    * @param array $args
    * @param IndividuMessageDetailParams $params
    *
    * @return Response
    */
    public function getIndividuMessagesDetail(Request $request, Response $response, array $args, IndividuMessageDetailParams $params)
    {
        try {

            $jsonResponse = $this->individuService->getIndividuMessagesDetail($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
    * @param Request $request
    * @param Response $response
    * @param array $args
    * @param IndividuMessageDetailParams $params
    *
    * @return Response
    */
    public function getIndividuFields(Request $request, Response $response)
    {
        try {
            $jsonResponse = $this->individuService->getIndividuFields($request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
    * @param Request $request
    * @param Response $response
    *
    * @return Response
    */
    public function getMasking(Request $request, Response $response)
    {
        try {
            $jsonResponse = $this->individuService->getMasking($request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }
}

