<?php
namespace ODE_API\V8\Param;

use ODE_API\V8\Param\Options as ParamOption;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class IndividuInfoParams extends BaseParam
{
    
    /**
     * @return objet
     */
    public function getModuleName()
    {
        return $this->parameters['moduleName'];
    }

    /**
     * @return id
     */
    public function getId()
    {
        return isset($this->parameters['id']) ? $this->parameters['id'] : '';
    }

   
    /**
     * @inheritdoc
     */
    protected function configureParameters(OptionsResolver $resolver)
    {
        $this->setOptions(
            $resolver,
            [
                ParamOption\ModuleName::class,
                ParamOption\Id::class
            ]
        );
    }
}
