<?php
namespace ODE_API\V8\Param;

use ODE_API\V8\Param\Options as ParamOption;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;
//include_once 'ODE_API/V8/Param/Options/ParentId.php';

class ListeConversationParams extends BaseParam
{
    /**
     * @return CreateModuleDataParams
     */
    public function getData()
    {
        return isset($this->parameters['data']) ? $this->parameters['data'] : [];
    }

    /**
     * @return id - OPS_individu UUID
     */
    public function getIndividuId()
    {
        return isset($this->parameters['individuId']) ? $this->parameters['individuId'] : '';
    }

    /**
     * @inheritdoc
     */
    protected function configureParameters(OptionsResolver $resolver)
    {
        $this->setOptions(
            $resolver,
            [
                ParamOption\IndividuId::class,
            /*
                ExtParamOption\ParentId::class,
                ParamOption\ModuleName::class,
            /**/
            ]
        );

        $resolver
            ->setRequired('data')
            ->setAllowedTypes('data', 'array')
            ->setNormalizer('data', function (Options $options, $values) {
                $dataParams = $values;
                return $dataParams;
            });
            
    }

}