<?php

namespace CustomParamOption\Options; // Extending for custom options Resolver ✦

use ODE_API\V8\Param\Options\BaseOption;

use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class TypeId extends BaseOption
{
    /**
     * @inheritdoc
     */
    public function add(OptionsResolver $resolver)
    {
        $resolver
            ->setRequired('typeId')
            ->setAllowedTypes('typeId', 'string')
            ->setAllowedValues('typeId', $this->validatorFactory->createClosure([
                new Assert\NotBlank(),
                new Assert\Regex('/^(\d+|[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})$/i')
            ]));
    }
}
