<?php

namespace ODE_API\V8\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\JsonApi\Response\LinksResponse;
use ODE_API\V8\JsonApi\Response\DataResponse;
use ODE_API\V8\JsonApi\Response\DispositifResponse;
use ODE_API\V8\JsonApi\Response\MetaResponse;
use ODE_API\V8\Param\FormulaireListParams;
use ODE_API\V8\Param\DispositifParams;


use ODE\Generateur\Factory\OdeViewFactory;
use ODE\Model\DispositifModel;
use ODE\Model\GenerateurFormulaireModel;

use Exception;
use Slim\Http\Request;

use UploadFile;
use Datetime;
use DateTimeZone;

class DispositifService
{
    /**
     * @var BeanManager
     */
    protected $beanManager;

    /**
     * @var AttributeObjectHelper
     */
    protected $attributeHelper;

    /**
     * @var RelationshipObjectHelper
     */
    protected $relationshipHelper;

    /**
     * @var PaginationObjectHelper
     */
    protected $paginationHelper;

    /**
     * @param BeanManager $beanManager
     * @param AttributeObjectHelper $attributeHelper
     * @param RelationshipObjectHelper $relationshipHelper
     * @param PaginationObjectHelper $paginationHelper
     */
    public function __construct(BeanManager $beanManager, AttributeObjectHelper $attributeHelper, RelationshipObjectHelper $relationshipHelper, PaginationObjectHelper $paginationHelper)
    {
        $this->beanManager        = $beanManager;
        $this->attributeHelper    = $attributeHelper;
        $this->relationshipHelper = $relationshipHelper;
        $this->paginationHelper   = $paginationHelper;
    }


    /**
     * getListDispositif
     * @param DispositifListParams $params
     * @param $path
     * @return DispositifResponse
     * @throws AccessDeniedException
     */
    public function getDetailDispositif(DispositifParams $params, Request $request)
    {
        global $db;

        $id = $params->getId();


        try {
            $obj_dispositif = $this->beanManager->getBeanSafe("OPS_dispositif", $id);
        }
        catch (\Exception $exception) {
            throw new Exception('Dispositif inconnu', 401);
        }
        

        $tab_dispositif['id'] = $obj_dispositif->id;
        $tab_dispositif['name'] = $obj_dispositif->name;
        $tab_dispositif['couleur'] = $obj_dispositif->couleur;
        $tab_dispositif['icone'] = $obj_dispositif->icone;
        $tab_dispositif['visible_usager'] = $obj_dispositif->visible_usager;
        $tab_dispositif['type_tier'] = $obj_dispositif->type_tier;
        $tab_dispositif['type_beneficiaire'] = $obj_dispositif->type_beneficiaire;
        $tab_dispositif['individu'] = $obj_dispositif->individu;
        $tab_dispositif['personne_morale'] = $obj_dispositif->personne_morale;
        $tab_dispositif['beneficiaire'] = $obj_dispositif->beneficiaire;
        
        // Implémentation 🔑 - #3152 (Evolution Hors Compte)
        $tab_dispositif['hors_compte'] = $obj_dispositif->hors_compte;


        $response = new DispositifResponse();
        $response->setData($tab_dispositif);
        
        return $response;
    }


    /**
     * getListDispositif
     * @param DispositifListParams $params
     * @param $path
     * @return DispositifResponse
     * @throws AccessDeniedException
     */
    public function getListDispositif(Request $request)
    {
        global $db;

        $dispositifs = DispositifModel::getListe();
        $tab_dispositif = array();

        foreach ( $dispositifs as $key => $dispositif ){

            $lock = true;  // Peux-t-on accèder au TS ? non ! 
            $saison = false; // Affichons-nous le TS ? non ! 
            $visible_portail = false ;  // Doit-il être afficher dans la vue Nouveau dossier ? 

            // Gestion des saisons 
            if( $dispositif['saison'] == true  ){
                
                $dateTime = new DateTime('NOW');
                $today = $dateTime->format('Y-m-d');

                $saison_affichage_date_debut = $dispositif['saison_affichage_date_debut'];
                $saison_affichage_date_fin = $dispositif['saison_affichage_date_fin'];
                $saison_date_debut = $dispositif['saison_date_debut'];
                $saison_date_fin = $dispositif['saison_date_fin'];

                // Affichage du dispositif ? 
                if( $saison_affichage_date_debut <= $today  && $today <= $saison_affichage_date_fin ){

                    $date_fin = new DateTime($saison_date_fin);
                    $date_fin = $date_fin->format('d/m/Y');

                    $date_debut = new DateTime($saison_date_debut);
                    $date_debut = $date_debut->format('d/m/Y');

                    // Dispositif ouvert ? 
                    if( $saison_date_debut <= $today  && $today <= $saison_date_fin ){

                        $date_fin = new DateTime($saison_date_fin);
                        $date_fin = $date_fin->format('d/m/Y');

                        $lock = false ; 
                        $saison = "Ouvert jusqu'au ".$date_fin." inclus";
                        $visible_portail = true ;   

                    }
                    else{
                        $visible_portail = true ;   

                        // Le dispositif va bientôt ouvrir 
                        if(  $saison_date_debut >= $today )
                        {
                            $saison = "Ouvrira le ".$date_debut;

                        }
                        else{
                            $saison = "Fermé depuis le ".$date_fin ; 
                        }
                    }
                }
            }
            else{
                $lock = false ; 
                $visible_portail = true ;   
            }

            $tab_dispositif[$dispositif['id']]['id']             = $dispositif['id'];
            $tab_dispositif[$dispositif['id']]['name']           = $dispositif['name'];
            $tab_dispositif[$dispositif['id']]['libelle_court']  = $dispositif['libelle_court'];
            $tab_dispositif[$dispositif['id']]['couleur']        = $dispositif['couleur'];
            $tab_dispositif[$dispositif['id']]['icone']          = $dispositif['icone'];
            $tab_dispositif[$dispositif['id']]['visible_usager'] = $dispositif['visible_usager']; 
            $tab_dispositif[$dispositif['id']]['aide']           = $dispositif['description'];
            $tab_dispositif[$dispositif['id']]['saison']         = $saison;
            $tab_dispositif[$dispositif['id']]['lock']           = $lock;
            $tab_dispositif[$dispositif['id']]['visible_portail']    = $visible_portail;

            // Implémentation 🔑 - #3152 (Evolution Hors Compte)
            $tab_dispositif[$dispositif['id']]['hors_compte']    = $dispositif['hors_compte'];
        }

        $response = new DispositifResponse();
        $response->setData($tab_dispositif);
        
        return $response;
    }


    /**
     * getListDocuments
     * @param FormulaireListParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function getNewFormulaire(FormulaireListParams $params, Request $request)
    {
         global $sugar_config;
        
        $entite = $params->getEntite();
        $id_demandeur = $params->getDemandeurId();
        $id_dispositif = $params->getDispositifId();


        $data = [
            "dispositif_id"     => $id_dispositif,
            "demandeur_type"    => $entite,
            "demandeur_id"      => $id_demandeur,
            "creation"          => "oui"
        ];
        //$GLOBALS['log']->fatal("params  $data  " . print_r($data , true));

        $data_retour = ["statut" => "err", "data" => "Message d'erreur"];

        do {

            //  On vérifie que l'id du dispositif n'est pas vide 
            if (empty($data["dispositif_id"])) {
                $data_retour["data"] = "L'id dispositif est vide";
                $GLOBALS['log']->fatal(" DispositifService :: getFormulaire => L'id dispositif est vide");
                break;
            }

            //  On vérifie que le type de demandeur n'est pas vide 
            if (empty($data["demandeur_type"]) ) {
                $data_retour["data"] = "Le type demandeur est vide";
                $GLOBALS['log']->fatal(" DispositifService :: getFormulaire => Le type demandeur est vide");
                break;
            }

            //  On vérifie que le type de demandeur n'est pas vide 
            if ( $data["demandeur_type"] !== "OPS_individu" && $data["demandeur_type"] !== "OPS_personne_morale" ) {
                $data_retour["data"] = "Le type demandeur doit etre égal à OPS_individu ou OPS_personne_morale";
                $GLOBALS['log']->fatal(" DispositifService :: getFormulaire => Le type demandeur doit etre égal à OPS_individu ou OPS_personne_morale");
                break;
            }

            // On récupere l'id du demandeur si il existe
            if (empty($data["demandeur_id"])) {
                $data_retour["data"] = "L'id demandeur est vide";
                $GLOBALS['log']->fatal(" DispositifService :: getFormulaire => L'id demandeur est vide");
                break;
            }

            $DispositifModel = new DispositifModel($data["dispositif_id"]);
            $dispositif = $DispositifModel->getBean();
            if (!is_array($dispositif) || count($dispositif) === 0) {
                $data_retour["data"] = "L'id du dispositif est incorrect";
                $GLOBALS['log']->fatal(" DispositifService :: getFormulaire => Le dispositif id = " . $data["dispositif_id"] . " est introuvable");
                break;
            }

            // On récupere la vue agent du formulaire associé au dispositif
            $formulaire_id = $DispositifModel->getFormulaireId();
            $GenerateurFormulaireModel = new GenerateurFormulaireModel($formulaire_id);
            $agent_vue_id = $GenerateurFormulaireModel->getVueAgentId();
            if (empty($agent_vue_id)) {
                $GLOBALS['log']->fatal(" DispositifService :: getFormulaire => La vue agent associé formulaire id = " . $formulaire_id . " est introuvable");
                break;
            } else {
                $data["vue"] = ["id" => $agent_vue_id, "type" => "usager", "creation" => "oui"];
            }

            // On récupere le html de la vue de création 
            $viewFactory = new OdeViewFactory(null, true, $data);
            $vue_html = $viewFactory->getHtml();

            $script_html = "<script>";
            if (file_exists("modules/OPS_dossier/js/OdeValidator.js")) {
                $script_html .= file_get_contents("modules/OPS_dossier/js/OdeValidator.js", true);
            }
            if (file_exists("modules/OPS_dossier/js/OdeDossier.js")) {
                $script_html .= file_get_contents("modules/OPS_dossier/js/OdeDossier.js", true);
            }
            if (file_exists("modules/OPS_dossier/js/OdeCondition.js")) {
                $script_html .= file_get_contents("modules/OPS_dossier/js/OdeCondition.js", true);
            }

            $script_html .= 'jQuery( document ).ready(function() {
                console.log( "ready!" );
                OdeDossier.start(true);
            });';
            $script_html .= "</script>";


            $style_html = "<style>";
            $style_html .= '#onglet-boutons {
                overflow: hidden;
                padding-left: 0;
            }

            #onglet-boutons li {
                text-align: center;
                width: 11%;
                float: left;
                list-style: none;
                background: #B8DAEF;
                margin-right: 2px;
                border-top-right-radius: 5px;
                border-top-left-radius: 5px;
            }

            #onglet-boutons li a {  
                padding: 15px;
                border-top: 1px solid #CCC;
                border-right: 1px solid #CCC;
                display: block;
                background: #B8DAEF;
                color: #fff;
                border-top-right-radius: 5px;
                border-top-left-radius: 5px;
            }

            #onglet-boutons li:first-child a {
                border-left: 1px solid #CCC;
            }

            #onglet-content {
                min-height: 300px;
                padding: 10px;
                margin-top: -1px;
                -moz-border-radius: 0 0 5px 5px;
                width: 100%;
                background: white;
            }

            #onglet-boutons li a.active {
                background: #35B3C5;
                margin-bottom: -3px;
            }

            .onglet-layout{
            
            }

            .ui-datepicker {
                background: #fff;
                border: 1px solid #d2d2d2;
                color: #35B3C5;
            }

            .ui-state-highlight, .ui-widget-content .ui-state-highlight, .ui-widget-header .ui-state-highlight {
                background: #fbf9ee url("images/ui-bg_glass_55_fbf9ee_1x400.png") 50% 50% repeat-x;
                color: #363636;
                /*border: 1px solid #F08377;*/
                text-align: center;
            }

            .ui-datepicker td .ui-state-active {
            border: 3px solid #F08377;
            border-radius: 5px;
            text-align: center;
            }';
            $style_html .= "</style>";


            if (!empty($vue_html)) {
                $data_retour = [
                    "statut" => "ok",
                    "data" => base64_encode($style_html ."\n". $vue_html ."\n". $script_html),
                ];
            } 

        } while (0);


        $response = new DispositifResponse();
        $response->setData($data_retour);

        return $response;
        
    }
    
}
