<?php

namespace ODE_API\V8\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\JsonApi\Response\LinksResponse;
use ODE_API\V8\JsonApi\Response\DataResponse;
use ODE_API\V8\JsonApi\Response\IndividuResponse;
use ODE_API\V8\JsonApi\Response\MetaResponse;
use ODE_API\V8\Param\IndividuInfoParams;
use ODE_API\V8\Param\UpdateIndividuParams;
use ODE_API\V8\Param\IndividuMessageDetailParams;


use ODE\Generateur\Factory\OdeViewFactory;
//use ODE\Model\DispositifModel;
//use ODE\Model\GenerateurFormulaireModel;

use Exception;
use Slim\Http\Request;

use UploadFile;

class IndividuService
{
    /**
     * @var BeanManager
     */
    protected $beanManager;

    /**
     * @var AttributeObjectHelper
     */
    protected $attributeHelper;

    /**
     * @var RelationshipObjectHelper
     */
    protected $relationshipHelper;

    /**
     * @var PaginationObjectHelper
     */
    protected $paginationHelper;

    /**
     * @param BeanManager $beanManager
     * @param AttributeObjectHelper $attributeHelper
     * @param RelationshipObjectHelper $relationshipHelper
     * @param PaginationObjectHelper $paginationHelper
     */
    public function __construct(BeanManager $beanManager, AttributeObjectHelper $attributeHelper, RelationshipObjectHelper $relationshipHelper, PaginationObjectHelper $paginationHelper)
    {
        $this->beanManager        = $beanManager;
        $this->attributeHelper    = $attributeHelper;
        $this->relationshipHelper = $relationshipHelper;
        $this->paginationHelper   = $paginationHelper;
    }


    /**
     * getInfoIndividu
     * @param IndividuInfoParams $params
     * @param $path
     * @return IndividuResponse
     * @throws AccessDeniedException
     */
    public function getInfoIndividu(IndividuInfoParams $params, Request $request)
    {
        global $sugar_config, $app_list_strings;

        $objet = $params->getModuleName();
        $id_objet = $params->getId();

        try {
            $obj_module = $this->beanManager->getBeanSafe($objet, $id_objet);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        $tab_indi = [
            'id'                  => $obj_module->id,
            'salutation'          => $obj_module->salutation,
            'name'                => $obj_module->name,
            'last_name'           => $obj_module->last_name,
            'nom_usage'           => $obj_module->nom_usage,
            'first_name'          => $obj_module->first_name,
            'situation_familiale' => $app_list_strings['ops_situation_familiale_list'][$obj_module->situation_familiale],
            'email1'              => $obj_module->email1,
            'phone_mobile'        => $obj_module->phone_mobile,
            'phone_home'          => $obj_module->phone_home,
            'date_naissance'      => $obj_module->date_naissance,

        ];

        return $tab_indi;
    }

    /**
     * getInfoIndividu
     * @param IndividuInfoParams $params
     * @param $path
     * @return IndividuResponse
     * @throws AccessDeniedException
     */
    public function getIndividuFields(Request $request)
    {
        $field_list = \OPS_individu::get_field_list();

        return $field_list;
    }


    /**
     * @param UpdateIndividuParams $params
     * @param Request $request
     *
     * @return IndividuResponse
     * @throws \InvalidArgumentException When bean is already exist.
     * @throws AccessDeniedException
     */
    public function updateIndividu(UpdateIndividuParams $params, Request $request)
    {
        global $sugar_config;

        $individu = $params->getData();
        $id_individu = $individu['id'];
        try {
            $obj_individu = $this->beanManager->getBeanSafe('OPS_individu', $id_individu);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        $obj_individu->salutation           = $individu['salutation'];
        $obj_individu->nom_usage            = $individu['nom_usage'];
        $obj_individu->first_name           = $individu['first_name'];
        $obj_individu->situation_familiale  = $individu['situation_familiale'];
        $obj_individu->date_naissance       = $individu['date_naissance'];
        $obj_individu->phone_mobile         = $individu['phone_mobile'];
        $obj_individu->phone_home           = $individu['phone_home'];

        $obj_individu->save();

        if (isset($obj_individu->id) && !empty($obj_individu->id)) {

            return true;
        } else {

            return false;
        }
    }
    
    
    /**
     * @param IndividuInfoParams $params
     * @param Request $request
     *
     * @return IndividuResponse
     * @throws \InvalidArgumentException When bean is already exist.
     * @throws AccessDeniedException
     */
    public function getIndividuMessages(IndividuInfoParams $params, Request $request){


        global $db;
    
        $id_individu = $params->getId();
        $objet = $params->getModuleName();
        
        try {
            $obj_individu = $this->beanManager->getBeanSafe('OPS_individu', $id_individu);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }
        
        $requeteMessages = "
        SELECT DISTINCT emails.id,
        emails.date_entered as recu_le,
        emails.name as sujet,
        emails_text.description_html as message
        FROM emails
        INNER JOIN emails_text ON emails_text.email_id = emails.id AND emails_text.deleted = 0
        WHERE emails.id IN ( SELECT DISTINCT emails.id
                            FROM ops_individu      
                            INNER JOIN email_addr_bean_rel ON email_addr_bean_rel.bean_id = ops_individu.id AND email_addr_bean_rel.deleted = 0
                            INNER JOIN email_addresses ON email_addresses.id = email_addr_bean_rel.email_address_id AND email_addresses.deleted = 0
                            INNER JOIN emails_email_addr_rel ON emails_email_addr_rel.email_address_id = email_addresses.id AND emails_email_addr_rel.deleted = 0
                            INNER JOIN emails ON emails.id = emails_email_addr_rel.email_id AND emails.deleted = 0
                            INNER JOIN emails_text ON emails_text.email_id = emails.id AND emails_text.deleted = 0
                            WHERE ops_individu.id = '$obj_individu->id' AND emails_email_addr_rel.address_type = 'to' AND emails.parent_type = 'OPS_dossier')
        OR
        emails.id IN ( SELECT DISTINCT ema.id
        			 FROM ops_individu ind      
        			 INNER JOIN emails ema ON ema.parent_id = ind.id AND ema.deleted = 0
        			 INNER JOIN emails_text ema2 ON ema2.email_id = ema.id AND ema2.deleted = 0
        			 WHERE ind.id = '$obj_individu->id' )
        
        ORDER BY emails.date_entered DESC";

        $resultRequete = $db->query($requeteMessages);

        while ($row = $db->fetchByAssoc($resultRequete)) 
        {         
            $result[] = $row;
        }
        
        return $result;
    }


    /**
     * @param IndividuMessageDetailParams $params
     * @param Request $request
     *
     * @return IndividuResponse
     * @throws \InvalidArgumentException When bean is already exist.
     * @throws AccessDeniedException
     */
    public function getIndividuMessagesDetail(IndividuMessageDetailParams $params, Request $request)
    {
        global $db;
    
        $id_individu = $params->getId();
        $messageId = $params->getMessageId();
        
        $requeteMessages = "
        SELECT DISTINCT emails.id,
        emails.date_entered as recu_le,
        emails.name as sujet,
        emails_text.description_html as message
        FROM emails
        INNER JOIN emails_text ON emails_text.email_id = emails.id AND emails_text.deleted = 0
        WHERE emails.id IN ( SELECT DISTINCT emails.id
                            FROM ops_individu      
                            INNER JOIN email_addr_bean_rel ON email_addr_bean_rel.bean_id = ops_individu.id AND email_addr_bean_rel.deleted = 0
                            INNER JOIN email_addresses ON email_addresses.id = email_addr_bean_rel.email_address_id AND email_addresses.deleted = 0
                            INNER JOIN emails_email_addr_rel ON emails_email_addr_rel.email_address_id = email_addresses.id AND emails_email_addr_rel.deleted = 0
                            INNER JOIN emails ON emails.id = emails_email_addr_rel.email_id AND emails.deleted = 0
                            WHERE ops_individu.id = '$id_individu' AND emails_email_addr_rel.address_type = 'to' AND emails.parent_type = 'OPS_dossier' AND emails.id = '$messageId' )
            OR
            emails.id IN ( SELECT DISTINCT emails.id
                            FROM ops_individu      
                            INNER JOIN emails ON emails.parent_id = ops_individu.id AND emails.deleted = 0
                            WHERE ops_individu.id = '$id_individu' AND emails.id = '$messageId' )
                            
        ORDER BY emails.date_entered DESC";

        $resultRequete = $db->query($requeteMessages);

        if (!$resultRequete) 
        {
            $GLOBALS['log']->fatal('Requete mes messages - erreur de la requete : ' . print_r($db->lastError(), true));
        }

        $result = $db->fetchByAssoc($resultRequete);
                             
        return $result;
    }

    /**
     * @param Request $request
     *
     * @return array
     */
    public function getMasking(Request $request)
    {
        global $sugar_config;

        if (isset($sugar_config['opensocle']['format_telephone']) && !empty($sugar_config['opensocle']['format_telephone'])) {
            $phone_masking = $sugar_config['opensocle']['format_telephone'];
        } else {
            $phone_masks_ini = parse_ini_file('custom/modules/Administration/phone_masking.ini', true);
            $phone_masking = implode(",", $phone_masks_ini['phone_masking']['france']);
        }

        return ['phone_masking' => $phone_masking];
    }
}
