<?php

namespace ODE_API\V8\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\JsonApi\Response\DocumentResponse;
use ODE_API\V8\Param\RepertoireEntrepriseParams;


use DateTime;
use Exception;
use Slim\Http\Request;

class RepertoireEntrepriseService
{
    /**
     * @var BeanManager
     */
    private $beanManager;

    /**
     * @var AttributeObjectHelper
     */
    private $attributeHelper;

    /**
     * @var RelationshipObjectHelper
     */
    private $relationshipHelper;

    /**
     * @var PaginationObjectHelper
     */
    private $paginationHelper;

    /**
     * @param BeanManager $beanManager
     * @param AttributeObjectHelper $attributeHelper
     * @param RelationshipObjectHelper $relationshipHelper
     * @param PaginationObjectHelper $paginationHelper
     */
    public function __construct(
        BeanManager $beanManager,
        AttributeObjectHelper $attributeHelper,
        RelationshipObjectHelper $relationshipHelper,
        PaginationObjectHelper $paginationHelper
    ) {
        $this->beanManager = $beanManager;
        $this->attributeHelper = $attributeHelper;
        $this->relationshipHelper = $relationshipHelper;
        $this->paginationHelper = $paginationHelper;
    }


   /**
     * getEntreprise
     * @param RepertoireEntrepriseParams $params
     * @param $path
     * @return DispositifResponse
     * @throws AccessDeniedException
     */
    public function getEntreprise(RepertoireEntrepriseParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;

        $num = $params->getNum();

        
        $requete = $db->query("SELECT * FROM `ops_rte` WHERE name = '".$num."' ");
        
        $rowResults = array();
        while ($row = $db->fetchRow($requete)) {
            $rowResults = $row;
        }
        
        $response = new DocumentResponse();
        $response->setData($rowResults);
        
        return $response;
    }


}
