<?php
/*
 * Gestion des actions retardées
 *
 */

$job_strings[] = 'generer_donnees';

use ODE\Model\DossierModel;

function generer_donnees()
{
    require_once('modules/Configurator/Configurator.php');
    
    $configuratorObj = new Configurator();

    $configuratorObj->loadConfig();
    
    $nombre     = $configuratorObj->config['generateur_donnees']['nombre_dossier'];
    $typeProfil = $configuratorObj->config['generateur_donnees']['type_profil'];
    $dispositif = $configuratorObj->config['generateur_donnees']['dispositif'];
    $email      = $configuratorObj->config['generateur_donnees']['email'];

    $nombreDossierIndividu = 10;
    $nombreDossierMax = 100;

    if( !empty($nombre) && !empty($dispositif) && $nombre > 0)
    {
        $user_nombre = (!empty($configuratorObj->config['generateur_donnees']['user_nombre'])) ? $configuratorObj->config['generateur_donnees']['user_nombre'] : 0;

        if($nombre > $nombreDossierMax)
        {
            $nombre = $nombreDossierMax;
        }

        $nombre = $nombre / $nombreDossierIndividu;

        $nombre = $user_nombre + $nombre;

        for($i = $user_nombre + 1; $i <= $nombre; ++$i)
        {
            $userName = 'UserTest ' . $i;

            //Créer individu
            $objIndividu = BeanFactory::newBean('OPS_individu');
            $objIndividu->last_name  = $userName;
            $objIndividu->first_name = $userName;

            if(!empty($email))
            {
                $objIndividu->email1     = $email;
            }

            $individu = $objIndividu->save();

            if(!empty($typeProfil))
            {
                //Créer personne morale
                $objPersonneMorale = BeanFactory::newBean('OPS_personne_morale');
                $objPersonneMorale->name = $userName;
                $personneMorale = $objPersonneMorale->save();
                $objPersonneMorale->load_relationship('ops_type_personne_ops_personne_morale');
                $objPersonneMorale->ops_type_personne_ops_personne_morale->add($typeProfil);

                //Créer personne morale individu
                $objPersonneMoraleIndividu = BeanFactory::newBean('OPS_personne_morale_individu');
                $objPersonneMoraleIndividu->save();
                $objPersonneMoraleIndividu->load_relationship('ops_individu_ops_personne_morale_individu');
                $objPersonneMoraleIndividu->ops_individu_ops_personne_morale_individu->add($individu);
                $objPersonneMoraleIndividu->load_relationship('ops_personne_morale_ops_personne_morale_individu');
                $objPersonneMoraleIndividu->ops_personne_morale_ops_personne_morale_individu->add($personneMorale);
            }

            for($j = 0; $j <= $nombreDossierIndividu; ++$j)
            {
                //Créer les dossiers
                $objDossier = BeanFactory::newBean('OPS_dossier');

                if(!empty($personneMorale))
                {
                    $objDossier->ops_personne_morale = $personneMorale;
                }

                $objDossier->beneficiaire_id = $individu;
                $objDossier->brouillon = 'non';
                $objDossier->type_tiers = 'OPS_individu';
                $objDossier->date_avancement = date("Y-m-d");
                $objDossier->save();
                $objDossier = OPS_dossier::initStatutEtapeDossier($objDossier, $dispositif);
                $objDossier->num_dossier = DossierModel::getNumDossier($objDossier->id);
                $objDossier->name = (!empty($objDossier->libelle_dossier)) ? $objDossier->num_dossier . " - " . $objDossier->libelle_dossier : (string)$objDossier->num_dossier;
                $objDossier->save();
                $objDossier->load_relationship('ops_dispositif_ops_dossier');
                $objDossier->ops_dispositif_ops_dossier->add($dispositif);
                $objDossier->load_relationship('ops_individu_ops_dossier');
                $objDossier->ops_individu_ops_dossier->add($individu);

                if(!empty($configuratorObj->config['generateur_donnees']['sous_territoire']))
                {
                    $objSousTerritoire = BeanFactory::getBean('OPS_sous_territoire', $configuratorObj->config['generateur_donnees']['sous_territoire']);
                    $objSousTerritoire->load_relationship('ops_sous_territoire_ops_dossier');
                    $objSousTerritoire->ops_sous_territoire_ops_dossier->add($objDossier->id);

                }
            }
        }

        $configuratorObj->config['generateur_donnees']['nombre_dossier'] = $configuratorObj->config['generateur_donnees']['nombre_dossier'] - ($nombreDossierIndividu * ($nombre - $user_nombre));
        $configuratorObj->config['generateur_donnees']['user_nombre'] = $user_nombre + $nombre;

        $configuratorObj->saveConfig();
    }

    return true;
} 