<?php
namespace Custom_ODE_API\Param;

use ODE_API\V8\Param\BaseParam;

use ODE_API\V8\Param\Options as ParamOption;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class DemandesPaiementParams extends BaseParam
{
    /**
     * @return id
     */
    public function getId()
    {
        return isset($this->parameters['id']) ? $this->parameters['id'] : '';
    }

   
    /**
     * @return id
     */
    public function getIndividuId()
    {
        return isset($this->parameters['individuId']) ? $this->parameters['individuId'] : '';
    }


    /**
     * @inheritdoc
     */
    protected function configureParameters(OptionsResolver $resolver)
    {
        $this->setOptions(
            $resolver,
            [
                ParamOption\Id::class,
                ParamOption\IndividuId::class
            ]
        );
    }
}
