<?php

namespace Custom_ODE_API\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\JsonApi\Response\DocumentResponse;
use ODE_API\V8\JsonApi\Response\DossierResponse;

use Custom_ODE_API\Param\DemandesPaiementParams;
use Custom_ODE_API\Param\DossierInfosParams;
use Custom_ODE_API\Param\DossiersParams;

use ODE\Model\DossierModel;
use ODE\Model\DemandeurModel;
use ODE\Model\DispositifModel;
use ODE\Model\GenerateurFormulaireModel;

use ODE\Helper\OdePdfHelper;
use ODE\Generateur\Factory\OdeViewFactory;
use ODE\Generateur\Factory\OdeFormFactory;
use ODE\Notification\OdeNotification;
use OPS_dossier;
use BeanFactory;
use DateTime;
use Exception;
use Slim\Http\Request;

class OpenSubService
{
    /**
     * @var BeanManager
     */
    private $beanManager;

    /**
     * @var AttributeObjectHelper
     */
    private $attributeHelper;

    /**
     * @var RelationshipObjectHelper
     */
    private $relationshipHelper;

    /**
     * @var PaginationObjectHelper
     */
    private $paginationHelper;

    /**
     * @param BeanManager $beanManager
     * @param AttributeObjectHelper $attributeHelper
     * @param RelationshipObjectHelper $relationshipHelper
     * @param PaginationObjectHelper $paginationHelper
     */
    public function __construct(
        BeanManager $beanManager,
        AttributeObjectHelper $attributeHelper,
        RelationshipObjectHelper $relationshipHelper,
        PaginationObjectHelper $paginationHelper
    ) {
        $this->beanManager = $beanManager;
        $this->attributeHelper = $attributeHelper;
        $this->relationshipHelper = $relationshipHelper;
        $this->paginationHelper = $paginationHelper;
    }


    /**
     * getPaiements
     *
     * Retourne la liste des demandes paiements associés à l'individu connectés ou au dossier passé en params
     *
     * @param Request $request
     *
     * @return DocumentResponse
     */
    public function getDemandesPaiement(DemandesPaiementParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;

        $id_dossier = $params->getId();
        $id_usager  = $params->getIndividuId();
        try {
            $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        }
        catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        try {
            $obj_dossier = $this->beanManager->getBeanSafe("OPS_dossier", $id_dossier);
        }
        catch (\Exception $exception) {
            $id_dossier = "" ;
        }


        // Récupération de l'ensemble des demandes de paiements
        if( empty( $id_dossier ) ){


            $tab_paiements = $this->getDemandePaiementByIndividu( $obj_individu );
        }
        else{// Si il y a un id dossier => récupération du tableau des demandes pour l'onglet 

            $tab_paiements = $this->getDemandePaiementByDossier( $obj_dossier );

        }

        $response = new DossierResponse();
        $response->setData($tab_paiements);
        return $response;

    }

    private function getDemandePaiementByIndividu( $obj_individu ){

        global $db, $app_list_strings ; 

        $tab_dossier = array();
        // Récupération de l'ensemble des dispositifs de paiement 
        $requete = $db->query( "
            SELECT distinct( ops_dispositif_paiement_id ) FROM `ops_dispositif` WHERE ops_dispositif_paiement_id in ( select id from ops_dispositif where deleted = 0 ) "
        );

        while ($row = $db->fetchRow($requete)) {
            $tab_dispositif[] = $row['ops_dispositif_paiement_id'];
        }


        // Récupération des tous les dossiers liés à l'individu qui correspondent à une demande de paiement 
        $tab_dossiers = $obj_individu->get_linked_beans(
            'ops_individu_ops_dossier',
            'ops_dossier',
            'num_dossier DESC',
            0,
            -1,
            0,
            ' (ops_dossier.ops_personne_morale IS NULL OR ops_dossier.ops_personne_morale = "") '
        );

        foreach ($tab_dossiers as $key => $un_dossier) {

            // Vérification qu'il existe bien un lien entre le dossier père et le dossier de paiement 
            $un_dossier->load_relationship('ops_dossier_ops_dossier_paiement');
            $dossiersIDS = $un_dossier->ops_dossier_ops_dossier_paiement->get();

            if( in_array( $un_dossier->ops_dispositif_id , $tab_dispositif) &&  count($dossiersIDS) == 1 ){

                $module_dispositif = 'OPS_dispositif';
                $id_dispositif = $un_dossier->ops_dispositif_id;

                if (!empty($un_dossier->ops_dispositif_id) && $un_dossier->cloture == false) {
                    $obj_dispositif = $this->beanManager->getBeanSafe($module_dispositif, $id_dispositif);
                    $instruction = $this->getDossierInstruction($un_dossier);

                    // Vérification si le dossier est modifiable soit par la complétude soit par le statut
                    $modifiable = $un_dossier->incomplet ; 
                    if( !empty($un_dossier->ops_statut_id) && !$modifiable && !empty($instruction['statut_id']) ){
                        $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $un_dossier->ops_statut_id);
                        $modifiable = $obj_statut->modifiable_usager ; 
                    }
                    
                    $tab_dossier[$un_dossier->num_dossier] = [
                        'id'                    => $un_dossier->id,
                        'numero'                => $un_dossier->num_dossier,
                        'type_paiement'         => $app_list_strings['ops_paiement_type_list'][str_replace("^", "",  $un_dossier->paiement_type)],
                        'paiement_intitule'     => $app_list_strings['ops_paiement_intitule_list'][str_replace("^", "",  $un_dossier->paiement_intitule)],
                        'montant_demande'       => $un_dossier->montant_demande,
                        'canal'                 => $un_dossier->canal,
                        'nom_demande'           => $un_dossier->fetched_rel_row['ops_dispositif_ops_dossier_name'],
                        'date_creation'         => $un_dossier->date_entered,
                        'demandeur'             => !empty($un_dossier->ops_individu_id) ? DemandeurModel::getName($un_dossier->ops_individu_id, "OPS_individu") : "",
                        'beneficiaire'          => !empty($un_dossier->beneficiaire_id) ? DemandeurModel::getName($un_dossier->beneficiaire_id, "OPS_individu") : "",
                        'beneficiaire_id'       => $un_dossier->beneficiaire_id,
                        'name_profil'           => !empty($un_dossier->ops_personne_morale) ? DemandeurModel::getName($un_dossier->ops_personne_morale, "OPS_personne_morale") : "Particulier",
                        'id_profil'             => $un_dossier->ops_personne_morale,
                        'dossier_pere'          => $dossiersIDS['0'],
                        'type_profil'           => "particulier",
                        'etape'                 => $instruction['etape'],
                        'statut'                => $instruction['statut'],
                        'couleur'               => $instruction['couleur'],
                        'brouillon'             => $un_dossier->brouillon,
                        'discussion'            => '1',
                        'duplication'           => '0',
                        'modifiable'            => $modifiable,
                        'dispositif_id'         => $obj_dispositif->id
                    ];
                }
            }
        }


        // Récupération de tous les dossiers liés aux profils liés à l'individu  
        $obj_personne_morale = \BeanFactory::newBean("OPS_personne_morale");
        $liste_tiers = $obj_personne_morale->get_profil_by_individu($obj_individu->id);

        if(!empty($liste_tiers)) 
        {
            // On récupère les id des profils 
            foreach ($liste_tiers as $id => $value) {
                $tiersIds[] = $id; 
            }

            $tiers_id =  (!empty($tiersIds)) ?  implode("','", $tiersIds) : '';
            $disposotifs_id =  (!empty($tab_dispositif)) ?  implode("','", $tab_dispositif) : '';

            // Récupération de l'ensemble des dossiers 
            $sql = "SELECT ops_dossier.id
                        FROM ops_dossier, ops_dispositif_ops_dossier
                        WHERE ops_dispositif_ops_dossier.ops_dossier_id = ops_dossier.id
                        AND ops_dispositif_ops_dossier.ops_dispositif_id in ( '".$disposotifs_id ."' )
                        AND ops_dossier.ops_personne_morale in ( '".$tiers_id ."' )
                        AND ops_dossier.deleted=0
                        AND ops_dispositif_ops_dossier.deleted = 0";

            $requete = $db->query($sql);
            
            while ($row = $db->fetchByAssoc($requete)) {

                $un_dossier = $this->beanManager->getBeanSafe("OPS_dossier", $row['id'] );

                $module_dispositif = 'OPS_dispositif';
                $id_dispositif = $un_dossier->ops_dispositif_id;

                // Vérification qu'il existe bien un lien entre le dossier père et le dossier de paiement 
                $un_dossier->load_relationship('ops_dossier_ops_dossier_paiement');
                $dossiersIDS = $un_dossier->ops_dossier_ops_dossier_paiement->get();

                if (!empty($un_dossier->ops_dispositif_id) && $un_dossier->cloture == false &&  count($dossiersIDS) == 1  ) {
                    $obj_dispositif = BeanFactory::getBean($module_dispositif, $id_dispositif);

                    // Récupération du demandeur 
                    $demandeur = $un_dossier->get_linked_beans('ops_individu_ops_dossier', 'ops_individu', '', 0, -1, 0, '');

                    $beneficiaire = ""; 
                    // Récupération du bénéficiaire
                    if (!empty($un_dossier->beneficiaire_id)  && $un_dossier->beneficiaire_id != 'undefined') {
                        $obj_indi = $this->beanManager->getBeanSafe("OPS_individu", $un_dossier->beneficiaire_id);
                        $beneficiaire = $obj_indi->full_name;
                    }

                    $instruction = $this->getDossierInstruction($un_dossier);

                     // Vérification si le dossier est modifiable soit par la complétude soit par le statut
                    $modifiable = $un_dossier->incomplet ; 
                    if( !empty($un_dossier->ops_statut_id) && !$modifiable && !empty($instruction['statut_id'])){
                        $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $un_dossier->ops_statut_id);
                        $modifiable = $obj_statut->modifiable_usager ; 
                    }
                    
                    $type_profil = "particulier" ;
                    if( !empty( $un_dossier->ops_personne_morale ) ){
                        $obj_profil = $this->beanManager->getBeanSafe("OPS_personne_morale", $un_dossier->ops_personne_morale);
                         $type_profil = $obj_profil->ops_type_personne_id;
                     }


                    $tab_dossier[$un_dossier->num_dossier] = [
                        'id'                    => $un_dossier->id,
                        'numero'                => $un_dossier->num_dossier,
                        'type_paiement'         => $app_list_strings['ops_paiement_type_list'][str_replace("^", "",  $un_dossier->paiement_type)],
                        'paiement_intitule'     => $app_list_strings['ops_paiement_intitule_list'][str_replace("^", "",  $un_dossier->paiement_intitule)],
                        'montant_demande'       => $un_dossier->montant_demande,
                        'canal'                 => $un_dossier->canal,
                        'nom_demande'           => $un_dossier->fetched_rel_row['ops_dispositif_ops_dossier_name'],
                        'date_creation'         => $un_dossier->date_entered,
                        'demandeur'             => !empty($un_dossier->ops_individu_id) ? DemandeurModel::getName($un_dossier->ops_individu_id, "OPS_individu") : "",
                        'beneficiaire'          => !empty($un_dossier->beneficiaire_id) ? DemandeurModel::getName($un_dossier->beneficiaire_id, "OPS_individu") : "",
                        'beneficiaire_id'       => $un_dossier->beneficiaire_id,
                        'name_profil'           => !empty($un_dossier->ops_personne_morale) ? DemandeurModel::getName($un_dossier->ops_personne_morale, "OPS_personne_morale") : "Particulier",
                        'id_profil'             => $un_dossier->ops_personne_morale,
                        'type_profil'           => $type_profil,
                        'dossier_pere'          => $dossiersIDS['0'],
                        'etape'                 => $instruction['etape'],
                        'statut'                => $instruction['statut'],
                        'couleur'               => $instruction['couleur'],
                        'brouillon'             => $un_dossier->brouillon,
                        'discussion'            => '1',
                        'duplication'           => '0',
                        'modifiable'            => $modifiable,
                        'dispositif_id'         => $obj_dispositif->id
                    ];
                }
            }
        }

        krsort($tab_dossier);

        return $tab_dossier;
    }



    private function getDemandePaiementByDossier( $obj_dossier ){

        global $db, $app_list_strings ; 

        $tab_dossier = array();

        // Récupération de l'ensemble des dossiers 
        $requete = $db->query( "
            SELECT ops_dossier_paiement_id 
            FROM ops_dossier_ops_dossier_paiement , ops_dossier 
            WHERE ops_dossier_ops_dossier_paiement.ops_dossier_pere_id = '".$obj_dossier->id ."' 
            AND ops_dossier_ops_dossier_paiement.ops_dossier_paiement_id = ops_dossier.id
            AND ops_dossier.deleted = 0
            AND ops_dossier_ops_dossier_paiement.deleted=0"
        );

        while ($row = $db->fetchRow($requete)) {

            $un_dossier = $this->beanManager->getBeanSafe("OPS_dossier", $row['ops_dossier_paiement_id']);


            if( isset( $un_dossier->id ) ){

                $obj_dispositif = $this->beanManager->getBeanSafe("OPS_dispositif", $un_dossier->ops_dispositif_id);
                $instruction = $this->getDossierInstruction($un_dossier);

                 // Vérification si le dossier est modifiable soit par la complétude soit par le statut
                $modifiable = $un_dossier->incomplet ; 
                if( !empty($un_dossier->ops_statut_id) && !$modifiable && !empty($instruction['statut_id']) ){
                    $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $un_dossier->ops_statut_id);
                    $modifiable = $obj_statut->modifiable_usager ; 
                }

                $profil_type = ""; 
                if( !empty( $obj_dossier->ops_personne_morale ) ){

                    $obj_profil = $this->beanManager->getBeanSafe("OPS_personne_morale", $obj_dossier->ops_personne_morale );
                    $profil_type = $obj_profil->ops_type_personne_id;
                }

                $tab_dossier[$un_dossier->num_dossier] = [
                    'id'                    => $un_dossier->id,
                    'numero'                => $un_dossier->num_dossier,
                    'type_paiement'         => $app_list_strings['ops_paiement_type_list'][str_replace("^", "",  $un_dossier->paiement_type)],
                    'paiement_intitule'     => $app_list_strings['ops_paiement_intitule_list'][str_replace("^", "",  $un_dossier->paiement_intitule)],
                    'montant_demande'       => $un_dossier->montant_demande,
                    'canal'                 => $un_dossier->canal,
                    'nom_demande'           => $un_dossier->fetched_rel_row['ops_dispositif_ops_dossier_name'],
                    'date_creation'         => $un_dossier->date_entered,
                    'demandeur'             => !empty($un_dossier->ops_individu_id) ? DemandeurModel::getName($un_dossier->ops_individu_id, "OPS_individu") : "",
                    'beneficiaire'          => !empty($un_dossier->beneficiaire_id) ? DemandeurModel::getName($un_dossier->beneficiaire_id, "OPS_individu") : "",
                    'beneficiaire_id'       => $un_dossier->beneficiaire_id,
                    'name_profil'           => !empty($un_dossier->ops_personne_morale) ? DemandeurModel::getName($un_dossier->ops_personne_morale, "OPS_personne_morale") : "Particulier",
                    'type_profil'           => $type_profil,
                    'id_profil'             => $un_dossier->ops_personne_morale,
                    'dossier_pere'          => $dossiersIDS['0'],
                    'etape'                 => $instruction['etape'],
                    'statut'                => $instruction['statut'],
                    'couleur'               => $instruction['couleur'],
                    'brouillon'             => $un_dossier->brouillon,
                    'discussion'            => '1',
                    'duplication'           => '0',
                    'modifiable'            => $modifiable,
                    'dispositif_id'         => $obj_dispositif->id
                ];
            }
        }
        krsort($tab_dossier);

        return $tab_dossier;
    }


     // Récupération uniquement des libellés visibles usager sur l'instruction 
    private function getDossierInstruction($obj_dossier)
    {

        if( !empty($obj_dossier->ops_statut_id) && !empty($obj_dossier->ops_etape_id) ){


            // Tester le statut courant => bug dde la modification du statut dans le guide d'instruction
            $obj_etape = $this->beanManager->getBeanSafe("OPS_etape", $obj_dossier->ops_etape_id);
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $obj_dossier->ops_statut_id);

            if( $obj_statut->visible_usager == true && $obj_etape->visible_usager == true ){

                $retour['statut'] = (!empty($obj_statut->libelle_usager)) ? $obj_statut->libelle_usager : $obj_statut->name;
                $retour['statut_id'] = $obj_statut->id;
                $retour['etape'] = (!empty($obj_etape->libelle_usager)) ? $obj_etape->libelle_usager : $obj_etape->name;
                $retour['etape_id'] = $obj_etape->id;
                $retour['couleur'] = $obj_statut->code_couleur ;  
                
                return $retour;

            }

        }


        $retour = array(); 
        // Récupération des status passés 
        $tab_historiques = $obj_dossier->get_linked_beans('ops_historisation_ops_dossier', 'OPS_historisation', 'date_modified', 0, -1, 0, "flag_retour = '1'");
        foreach ($tab_historiques as $key => $historisation) {
            // Si l'étape n'est pas visible on boucle 
            $empty = array();
            $obj_etape = $this->beanManager->getBeanSafe("OPS_etape", $historisation->ops_etape_id, $empty, false);

            if ($obj_etape->visible_usager == true && $obj_etape->deleted == 0) {
                $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $historisation->ops_statut_id);

                // Si le statut est visible usager => on retourne le statut et l'étape courant 
                if ($obj_statut->visible_usager == true) {
                    $retour['statut'] = (!empty($obj_statut->libelle_usager)) ? $obj_statut->libelle_usager : $obj_statut->name;
                    $retour['statut_id'] = $obj_statut->id;
                    $retour['etape'] = (!empty($obj_etape->libelle_usager)) ? $obj_etape->libelle_usager : $obj_etape->name;
                    $retour['etape_id'] = $obj_etape->id;
                    $retour['couleur'] = $obj_statut->code_couleur ;  

                } 
            }
        }

        if (empty($retour)) {
            $retour['statut'] = "Dossier en cours";
            $retour['statut_id'] = "";
            $retour['etape'] = "Instruction";
            $retour['etape_id'] = "";
        }

        return $retour;
    }

    /**
     * getDossier
     * @param DossierInfosParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function getDossierInfos(DossierInfosParams $params, Request $request)
    {

        global $beanFiles, $db, $sugar_config;

        // On récupere les données
        $id_dossier = $params->getId();
        // On vérifie que l'id du dossier n'est pas vide
        try {
            $obj_dossier = $this->beanManager->getBeanSafe("OPS_dossier", $id_dossier);
        }
        catch (\Exception $exception) {
            throw new Exception('Dossier inconnu', 401);
        }

        // Récupération du dispositif lié au dossier pour récupérer le guide d'instruction
        $dispositif = $this->beanManager->getBeanSafe("OPS_dispositif", $obj_dossier->ops_dispositif_id );



        // Vérification si le dossier est modifiable soit par la complétude soit par le statut
        $instruction = $this->getDossierInstruction($obj_dossier);
        $modifiable = $obj_dossier->incomplet ; 
        $demande_paiement_autorise = false; 

        // Vérification s'il est possible de créer une demande de paiement 
        if( !empty($obj_dossier->ops_statut_id) && $dispositif->flag_valeur_1 == 1 && !empty( $dispositif->ops_dispositif_paiement_id ) ){
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $obj_dossier->ops_statut_id);
            $demande_paiement_autorise = $obj_statut->demande_paiement_autorise ; 
        }

        // Vérification que le dossier soit modifiable 
        if( !empty($obj_dossier->ops_statut_id) && !$modifiable && !empty($instruction['statut_id']) ){
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $obj_dossier->ops_statut_id);
            $modifiable = $obj_statut->modifiable_usager ; 
        }

        $profil_type = ""; 
        if( !empty( $obj_dossier->ops_personne_morale ) ){

            $obj_profil = $this->beanManager->getBeanSafe("OPS_personne_morale", $obj_dossier->ops_personne_morale );
            $profil_type = $obj_profil->ops_type_personne_id;
        }

        $informations_dossier = array();
        $informations_dossier = [
            'dossier_id'                    => $obj_dossier->id,
            'dispositif_id'                 => $obj_dossier->ops_dispositif_id,
            'statut'                        => $instruction['statut'],
            'brouillon'                     => $obj_dossier->brouillon,
            'dossier_name'                  => $obj_dossier->name,
            'dossier_num'                   => $obj_dossier->num_dossier,
            'brouillon'                     => $obj_dossier->brouillon,
            'etape'                         => $instruction['etape'],
            'dispositif_name'               => $obj_dossier->ops_dispositif_ops_dossier_name,
            'profil_name'                   => !empty($obj_dossier->ops_personne_morale) ? DemandeurModel::getName($obj_dossier->ops_personne_morale, "OPS_personne_morale") : "",
            'profil_id'                     => !empty($obj_dossier->ops_personne_morale) ? $obj_dossier->ops_personne_morale : "",
            'profil_type'                   => !empty($profil_type) ? $profil_type : "",
            'beneficiaire_id'               => !empty($obj_dossier->beneficiaire_id) ? $obj_dossier->beneficiaire_id : "",
            'beneficiaire_name'             => !empty($obj_dossier->beneficiaire_id) ? DemandeurModel::getName($obj_dossier->beneficiaire_id, "OPS_individu") : "",
            'demandeur_name'                => !empty($obj_dossier->ops_individu_id) ? DemandeurModel::getName($obj_dossier->ops_individu_id, "OPS_individu") : "",
            'modifiable'                    => $modifiable,
            'type_tiers'                    => $obj_dossier->type_tiers,
            'num_dossier'                   => $obj_dossier->num_dossier,
            'flag_valeur_1'                 => $dispositif->flag_valeur_1,
            'ops_dispositif_paiement_id'    => $dispositif->ops_dispositif_paiement_id,
            'demande_paiement_autorise'     => $demande_paiement_autorise,
            'flag_valeur_2'                 => $dispositif->flag_valeur_2,
            'flag_valeur_3'                 => $dispositif->flag_valeur_3
        ];


        return $informations_dossier;

    }


    /**
     * Copie de getFormByEtape
     * @param DossiersParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
     public function creationDossierPaiement(DossiersParams $params, Request $request)
    {
        global $db, $sugar_config;

        // On récupere les données
        $donnees = $params->getData();


        // Vérification d'accès au dispositif dans le cadre d'une édition ( vérif saison )
        $dispositif = $this->beanManager->getBeanSafe("OPS_dispositif", $donnees["dispositif_id"] );
        $is_ouvert =  $this->verif_saison( $dispositif ); 
        if( !$is_ouvert){
            // Vérification par le profil
            $response = new DocumentResponse();
            $response->setData(["erreur" => "Ce dispositif est temporairement désactivé ou n'est pas disponible pour le moment." ] );
            return  $response;
        }

        // On vérifie les données recus 
        $verification_donnees = $this->getDataFormByEtape($donnees);
        if ($verification_donnees["statut"] === "err") {
            // Vérification par le profil
            $response = new DocumentResponse();
            $response->setData(["erreur" =>'Données invalides : ' . $verification_donnees["data"] ] );
            return  $response;
        }

        // On récupere les données formatées et on ajoute le parametre "création"
        $donnees_formated = $verification_donnees["data"];
        $donnees_formated["vue"]["creation"] = ($form_type === "creation") ? "true" : "false";

        $donnees_formated["dispositif"]["canal"] = $donnees['canal'];

        // On initilise OdeFormFactory selon le type de form
        // Ajout du bénéficiaire et PM 
        $donnees_formated['ops_personne_morale'] = $donnees['ops_personne_morale'];
        $donnees_formated['brouillon'] = true;
        $donnees_formated['beneficiaire_id'] = $donnees['beneficiaire_id'];

        // On récupere l'id du dossier 
        $dossier_id = OPS_dossier::createDossierByEtape($donnees_formated);
        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
        $obj_dossier_pere = BeanFactory::getBean('OPS_dossier', $donnees['dossier_id']);

        // Rattachement de la demande de paiement à la fiche action : 
        $obj_dossier_pere->load_relationship('ops_dossier_ops_dossier_paiement');
        $obj_dossier_pere->ops_dossier_ops_dossier_paiement->add($obj_dossier->id);

        $response = new DocumentResponse();
        $response->setData(array( "dossier_id"=> $dossier_id) );

        return $response;
    }

    private function verif_saison( $dispositif ){

        $retour = true; 

        // Gestion des saisons 
        if( $dispositif->saison == true  ){
            
            $dateTime = new DateTime('NOW');
            $today = $dateTime->format('Y-m-d');

            $saison_date_debut = $dispositif->saison_date_debut;
            $saison_date_fin = $dispositif->saison_date_fin;

            $date = date_create_from_format('d/m/Y', $saison_date_debut);
            $saison_date_debut = date_format($date, 'Y-m-d');


            $date_fin = date_create_from_format('d/m/Y', $saison_date_fin);
            $saison_date_fin = date_format($date_fin, 'Y-m-d');

            $retour = false; 

            // Dispositif ouvert ? 
            if( $saison_date_debut <= $today  && $today <= $saison_date_fin ){
                $retour = true; 
            }
           
        }

        return $retour; 
    }

    private function getDataFormByEtape($donnees)
    {
        $donnees_formated = [];
        $libelle_erreur = "";

        do {
            if (empty($donnees["demandeur_id"])) {
                $libelle_erreur = "L'id du demandeur est vide";
                break;
            } else {
                $donnees_formated["demandeur"]["id"] = $donnees["demandeur_id"];
            }

            if (empty($donnees["demandeur_type"])) {
                $libelle_erreur = "Le type de demandeur est vide";
                break;
            } else {
                $donnees_formated["demandeur"]["type"] = $donnees["demandeur_type"];
            }

            if (empty($donnees["dispositif_id"])) {
                $libelle_erreur = "L'id du dispositif est vide";
                break;
            }

            // On récupere l'objet dispositif
            $obj_dispositif = BeanFactory::getBean('OPS_dispositif', $donnees["dispositif_id"]);
            if (empty($obj_dispositif->id)) {
                $libelle_erreur = "Le dispositif n'a pas pu etre récupéré";
                break;
            } else {
                $donnees_formated["dispositif"] = ["id" => $obj_dispositif->id, "name" => $obj_dispositif->name];
            }

            // On récupere la vue agent du formulaire associé au dispositif
            $liste_formulaire = $obj_dispositif->get_linked_beans('ops_generateur_formulaire_ops_dispositif', 'OPS_generateur_formulaire');
            $obj_formulaire = (is_array($liste_formulaire) && count($liste_formulaire) > 0) ? $liste_formulaire[0] : false;
            $usager_vue_id = ($obj_formulaire !== false &&  !empty($obj_formulaire->usager_vue_id)) ? $obj_formulaire->usager_vue_id : "";
            $obj_vue = BeanFactory::getBean('OPS_generateur_vue', $usager_vue_id);
            if (empty($obj_vue->id)) {
                $libelle_erreur = "La vue usager est introuvable";
                break;
            } else {
                $donnees_formated["vue"] = ["id" => $obj_vue->id, "type" => "usager"];
            }

            $donnees_formated["etape_ordre"] = (empty($donnees["etape_ordre"])) ? 1 : $donnees["etape_ordre"];
        } while (0);

        return (empty($libelle_erreur)) ? ["statut" => "ok", "data" => $donnees_formated] : ["statut" => "err", "data" => $libelle_erreur];
    }
}