<?php

include 'custom/application/Ext/ODE_API/V8/Controller/OpenSubController.php' ;
include 'custom/application/Ext/ODE_API/V8/Service/OpenSubService.php' ;
include 'custom/application/Ext/ODE_API/V8/Param/DemandesPaiementParams.php' ;
include 'custom/application/Ext/ODE_API/V8/Param/DossierInfosParams.php' ;
include 'custom/application/Ext/ODE_API/V8/Param/DossiersParams.php' ;

use Custom_ODE_API\Param;


use ODE_API\V8\Factory\ParamsMiddlewareFactory;

$paramsMiddlewareFactory = $app->getContainer()->get(ParamsMiddlewareFactory::class);

/***
 * ROUTES POUR LES DEMANDES DE PAIEMENTS 
 * */

/**
 * @category Dossier
 * @internal Récupération des demandes de paiement
 * @method   DossierController::getDemandesPaiement()
 */
$app
    ->get('/paiements/{individuId}/{id}', 'Custom_ODE_API\Controller\OpenSubController:getDemandesPaiement')
    ->add($paramsMiddlewareFactory->bind(Param\DemandesPaiementParams::class));

/**
 * @category Dossier
 * @internal Récupération des informations d'un dossier 
 * @method   DossierController::getDossier()
 */
$app
    ->get('/paiement-dossier-info/{id}', 'Custom_ODE_API\Controller\OpenSubController:getDossierInfos')
    ->add($paramsMiddlewareFactory->bind(Param\DossierInfosParams::class));

/**
 * @category Dossier
 * @internal Création d'une demande de paiement
 * @method   DossierController::creationDossierPaiement()
 */  
$app
    ->post('/creation-paiement', 'Custom_ODE_API\Controller\OpenSubController:creationDossierPaiement')
    ->add($paramsMiddlewareFactory->bind(Param\DossiersParams::class));