<?php

global $sugar_config;

if (empty($_REQUEST['id']) || empty($_REQUEST['type'] || empty($_REQUEST['module']))) {
    die("Not a Valid Entry Point");
}

$objBean = BeanFactory::getBean($_REQUEST['module'],$_REQUEST['id']);
//Récupération de l'image
$imageSource = '';
if(!empty($objBean->image)){
	$fileName = $objBean->id . '_'.$_REQUEST['type'];
    if($sugar_config['ops_justificatif']['chemin']){
        $justificatifDir = str_replace(" ", "", $sugar_config['ops_justificatif']['chemin']);
        $last_char = substr($justificatifDir, -1);
        if ($last_char !== "/") {
          // Rajouter un slash à la fin
          $justificatifDir .= "/profils/";
        }else{
            $justificatifDir .= "profils/";
        }
        $fileDir = $justificatifDir . $fileName;
        if(file_exists($fileDir)){
            $imageSource = $fileDir;
        }
    }else{
        $uploadDir = str_replace(" ", "", $sugar_config['upload_dir']);
        $last_char = substr($uploadDir, -1);
        if ($last_char !== "/") {
          // Rajouter un slash à la fin
          $uploadDir .= "/";
        }
        $fileDir = $uploadDir . $fileName;
        if(file_exists($fileDir)){
            $imageSource = $fileDir;
        }
    }

    if(!empty($imageSource)){
    	$mime = getimagesize($imageSource);
    	if (!empty($mime)) {
        	header("Content-Type: {$mime['mime']}");
        } else {
            header("Content-Type: image/png");
        }

        header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
        header('Cache-Control: post-check=0, pre-check=0', false);
        header('Pragma: no-cache');
        header('Content-Disposition: inline; filename="' . $objBean->image . '";');
        header("X-Content-Type-Options: nosniff");
        header("Content-Length: " . filesize($imageSource));
        header('Expires: ' . gmdate('D, d M Y H:i:s \G\M\T', time() + 2592000));

        while (ob_get_level() && @ob_end_clean()) {
            ;
        }

        ob_start();
        echo clean_file_output(file_get_contents($imageSource), $mime['mime']);

        $output = ob_get_contents();
        ob_end_clean();

        echo $output;
    }
}