<?php

namespace ODE\ActionLot\Action;

if (!defined('sugarEntry')) define('sugarEntry', true);

use ODE\Modal\OdeModal;

class GenererDocumentAction
{

    /**
     * @access public
     * @name getAction()
     * Fonction qui retourne l'action " Déclencher un Flux "
     * 
     *  @return array       - $action
     */
    public function getAction()
    {

        return array(
            'module_name' => 'OPS_dossier',
            'action_content' => $this->getActionContent(),
            'action_link' => $this->getActionLink(),
        );
    }

    /**
     * @access public
     * @name getActionOrdre()
     * Fonction qui retourne l'ordre de l'action
     * 
     *  @return array       - $action_ordre
     */
    public function getActionOrdre()
    {
        return 2;
    }

    /**
     * @access private
     * @name getActionContent()
     * Fonction qui retourne le content de l'action
     * 
     *  @return array       - $action_content
     */
    private function getActionContent()
    {
        return $this->getActionLink() . $this->getActionHTML();
    }

    /**
     * @access private
     * @name getActionLink()
     * Fonction qui retourne le link de l'action
     * 
     *  @return array       - $action_link
     */
    private function getActionLink()
    {
        return '<a role="ode-modal-generer-document-btn">Générer document</a>';
    }

    /**
     * @access private
     * @name getActionHTML()
     * Fonction qui retourne l'html de l'action
     * 
     *  @return array       - $action_html
     */
    private function getActionHTML()
    {
        $modal = new OdeModal('ode_modal_generer_document');
        $modal->setTitle('GENERER DOCUMENT RECAPITULATIF');
        $modal->setCss(['modules/OPS_dossier/css/generer_document.css']);
        $modal->setJS(['modules/OPS_dossier/js/generer_document.js']);
        $modal->setPages(['modules/OPS_dossier/tpls/generer_document.tpl']);
        return $modal->getHtml();
    }
}
