<?php

namespace ODE\ActionLot;

if (!defined('sugarEntry')) define('sugarEntry', true);

class OdeActionLot
{

    private $time_start;
    private $action_path;
    private $action_namespace;

    /**
     * Constructeur de la classe OdeActionLot
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct()
    {
        $this->time_start = microtime(true);
        $this->action_path = "custom/include/Ode/ActionLot/Action/";
        $this->action_namespace = 'ODE\\ActionLot\\Action\\';
    }

    /**
     * @access public
     * @name getActions()
     * Fonction qui retourne la liste des actions configurés sur le serveur 
     * 
     *  @return array       - $actions
     */
    public function getActions()
    {
        $actions = array();
        $files = array_diff(scandir($this->action_path), array('.', '..'));
        if (is_array($files) && count($files) > 0) {
            foreach ($files as $file_name) {
                $classe_name = $this->action_namespace . ucfirst(str_replace(".php", "", $file_name));
                $classe_obj = new $classe_name();
                $ordre = $classe_obj->getActionOrdre();
                $action = $classe_obj->getAction();
                if (!empty($actions[$action['module_name']]) && count($actions[$action['module_name']]) > 0) {
                    while (array_key_exists($ordre, $actions[$action['module_name']])) {
                        $ordre++;
                    }
                }
                $actions[$action['module_name']][$ordre] = $action;
            }
        }
        return $actions;
    }
}
