<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;
use SugarEmailAddress;

use ODE\Mailer\OdeEmail;
use ODE\Mailer\OdeMailer;

if (!defined('sugarEntry')) define('sugarEntry', true);

class EnvoyerMailAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
        
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Envoyer un email "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'notification';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Envoyer un email "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Envoyer un email";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Envoyer un email "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Envoyer un mail pdf du dossier";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "EnvoyerMailAction";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {


        $liste_cible = array(
            'beneficiaire' => 'Bénéficiaire',
            'demandeur' => 'Demandeur',
            'dossier' => 'Email du dossier (email, email_cc, email_cci)',
            'profil' => 'Profil',
            'autre' => 'Autre'
        );

        if (isset($app_list_strings['moduleList']['OPS_avis'])) {
            $liste_cible['partenaire_tous'] = 'Partenaires (Tous)';
            $liste_cible['partenaire_principal'] = 'Partenaires (Uniquement le principal)';
        }

        $listeCibleOptions = get_select_options_with_id($liste_cible, $this->action->ext_valeur_1);

        $selectDestinataire  = '<select name="ext_valeur_1" id="ext_valeur_1">';
        $selectDestinataire .= $listeCibleOptions;
        $selectDestinataire .= '</select>';

        $data = array(
            'ext_valeur_1' => array(
                'type' => 'enum',
                'label' => 'A',
                'form' => $selectDestinataire
            )
        );


        $inputTO = '<input type="text" id="ext_valeur_2" name="ext_valeur_2" value="'.$this->action->ext_valeur_2.'" >';
        $data += array(
            'ext_valeur_2' => array(
                'type' => 'text',
                'label' => 'Préciser',
                'form' => $inputTO
            )
        );

        $inputCC = '<input type="text" id="ext_valeur_3" name="ext_valeur_3" value="'.$this->action->ext_valeur_3.'" >';
        $inputCC .= '<br><span id="helpBlock" class="help-block">';
        $inputCC .= 'Chaque adresse doit être séparée par un ";"';
        $inputCC .= '</span>';
        $data += array(
            'ext_valeur_3' => array(
                'type' => 'text',
                'label' => 'Cc',
                'form' => $inputCC
            )
        );

        // modeles de courriels
        $listCourriel   = get_bean_select_array(true, 'EmailTemplate', 'name', '', 'name');
        $courrielOption = get_select_options_with_id($listCourriel, $this->action->ext_valeur_4);

        $selectEmail  = '<select name="ext_valeur_4" id="ext_valeur_4" required=required>';
        $selectEmail .= $courrielOption;
        $selectEmail .= '</select>';

        $data += array(
            'ext_valeur_4' => array(
                'type' => 'enum',
                'label' => 'Modèle de mail',
                'form' => $selectEmail
            )
        );

        $inputCCI = '<input type="text" id="ext_valeur_5" name="ext_valeur_5" value="'.$this->action->ext_valeur_5.'">';
        $inputCCI .= '<br><span id="helpBlock" class="help-block">';
        $inputCCI .= 'Chaque adresse doit être séparée par un ";"';
        $inputCCI .= '</span>';
        $data += array(
            'ext_valeur_5' => array(
                'type' => 'text',
                'label' => 'Cci',
                'form' => $inputCCI
            )
        );


        $check = ($this->action->ext_valeur_6 == 'on') ? "checked=checked"  : "";

        $selectPDF = ' <input type="hidden"  name="ext_valeur_6" value ="off" >';
        $selectPDF .= ' <input type="checkbox" id="ext_valeur_6" name="ext_valeur_6"  '.$check.'>';

        $data += array(
            'ext_valeur_6' => array(
                'type' => 'enum',
                'label' => 'Joindre le dossier en PDF',
                'form' => $selectPDF
            )
        );

        $selectJustificatif = ' <input type="hidden" id="ext_valeur_text"  name="ext_valeur_text" value ="'.$this->action->ext_valeur_text.'" >';

        $data += array(
            'ext_valeur_text' => array(
                'type' => 'enum',
                'label' => 'Joindre les justificatifs du dossier',
                'form' => $selectJustificatif
            )
        );
        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {

        $template_mail = "" ; 
        $data = array();

        $liste_cible = array(
            'beneficiaire' => 'Bénéficiaire',
            'demandeur' => 'Demandeur',
            'dossier' => 'Email du dossier (email, email_cc, email_cci)',
            'profil' => 'Profil',
            'autre' => 'Autre'
        );

        if (isset($app_list_strings['moduleList']['OPS_avis'])) {
            $liste_cible['partenaire_tous'] = 'Partenaires (Tous)';
            $liste_cible['partenaire_principal'] = 'Partenaires (Uniquement le principal)';
        }

        if (!empty($this->action->ext_valeur_4)) {

            $obj_template = BeanFactory::getBean('EmailTemplates',$this->action->ext_valeur_4);
            $template_mail = $obj_template->name;
        }
        
        $pdf =  ($this->action->ext_valeur_6 == "on") ? "Oui"  : "Non";

        $data = array(
            'ext_valeur_1' => array(
                'type' => 'enum',
                'label' => 'A',
                'valeur' => $liste_cible[$this->action->ext_valeur_1]
            )
        );

        if( $this->action->ext_valeur_1 == "autre" ||$this->action->ext_valeur_1 == "dossier" ){
            $data += array(
                'ext_valeur_2' => array(
                    'type' => 'text',
                    'label' => 'Préciser',
                    'valeur' => $this->action->ext_valeur_2
                ),
            );
        }

        $data += array(
            'ext_valeur_3' => array(
                'type' => 'text',
                'label' => 'Cc',
                'valeur' => $this->action->ext_valeur_3
            ),
            'ext_valeur_4' => array(
                'type' => 'enum',
                'label' => 'Modèle de mail',
                'valeur' => $template_mail
            ),
            'ext_valeur_5' => array(
                'type' => 'text',
                'label' => 'Cci',
                'valeur' => $this->action->ext_valeur_5
            ),
            'ext_valeur_6' => array(
                'type' => 'enum',
                'label' => 'Joindre le dossier en PDF',
                'valeur' => $pdf
            )
        );

        $selectJustificatif = '<script type="text/javascript" charset="UTF-8" src="custom/include/Ode/ActionStatut/Js/EnvoyerMailAction.js"></script><script type="text/javascript">EnvoyerMailAction.start()</script><input type="hidden" id="ext_valeur_text" name="ext_valeur_text" value ="'.$this->action->ext_valeur_text.'" >';

        $data += array(
            'ext_valeur_text' => array(
                'type' => 'enum',
                'label' => 'Joindre les justificatifs du dossier',
                'valeur' => $selectJustificatif
            )
        );
        
        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        # On vérifie qu'on a bien récupéré le dossier et que l'action statut est configurée  
        if ( empty($this->dossier) || empty($this->action->ext_valeur_4) ) return;

        # On récupére la liste des destinataires, cette fonction renvoie aussi le type et l'id du bean qui servira pour l'historisation
        $listDestinataire = $this->getDesinataires();

        # On vérifie si l'ajout du dossier en pj est coché
        $with_pdf =  $this->action->ext_valeur_6 == "on" ? true  : false;

        $data = json_decode( base64_decode($this->action->ext_valeur_text),true);
        # On vérifie si l'ajout des justificatifs en pj est coché
        $with_justificatif =  $data['justificatifs'] == "on" ? true  : false;
        $type_justificatif = (!empty($data['justificatif_type']) && $data['justificatifs'] == 'on' )?$data['justificatif_type']:'';

        # On initialise le mailer 
        $mailer = new OdeMailer();

        # On initialise l'email 
        $ode_email = new OdeEmail([
            'bean_source_id' => $this->dossier->id,
            'bean_source_name' => 'OPS_dossier',
            'bean_historisation_id' => $listDestinataire['objet_id'],
            'bean_historisation_name' => $listDestinataire['objet_type'],
            'email_template_id' => $this->action->ext_valeur_4,
            'dest_to' => $listDestinataire['to'],
            'dest_cc' => $listDestinataire['cc'],
            'dest_cci ' => $listDestinataire['cci'],
            'genere_dossier_pdf' => $with_pdf,
            'ajouter_justificatifs' => $with_justificatif,
            'type_justificatifs' => $type_justificatif,
        ]);

        # On déclenche l'envoie
        $mailer->send($ode_email);

    }


    private function getDesinataires()
    {

        $retour = array(
            "to" => "", 
            "cc" => $this->action->ext_valeur_3, 
            "cci" => $this->action->ext_valeur_5, 
            "objet_id" => "", 
            "objet_type" => "" 
        );

        switch ($this->action->ext_valeur_1) {
            case 'dossier': // Récupération de l'adresse mail sur les champs email/email_cc/email_cci
                $retour['to'] = (!empty($this->dossier->email)) ? $this->dossier->email : "";
                $retour['to'] = (!empty($this->dossier->email_cc) && empty($retour['to'])) ? $this->dossier->email_cc : $retour['to'];
                $retour['to'] = (!empty($this->dossier->email_cci) && empty($retour['to'])) ? $this->dossier->email_cci : $retour['to'] ;
                $retour['objet_id'] =  $this->dossier->id ;
                $retour['objet_type'] =  "OPS_dossier" ;
                break;
            case 'demandeur':
                $demandeur = BeanFactory::getBean('OPS_individu',$this->dossier->ops_individu_id );
                $email = new SugarEmailAddress;
                $retour['to'] = $email->getPrimaryAddress($demandeur);
                $retour['objet_id'] =  $demandeur->id ;
                $retour['objet_type'] =  "OPS_individu" ;
                break;
            case 'beneficiaire':
                $beneficiaire = BeanFactory::getBean('OPS_individu',$this->dossier->beneficiaire_id);
                $email = new SugarEmailAddress;
                $retour['to'] = $email->getPrimaryAddress($beneficiaire);
                $retour['objet_id'] =  $beneficiaire->id ;
                $retour['objet_type'] =  "OPS_individu" ;
                break;
            case 'profil':
                $profil = BeanFactory::getBean('OPS_personne_morale',$this->dossier->ops_personne_morale);
                $email = new SugarEmailAddress;
                $retour['to'] = $email->getPrimaryAddress($profil);
                $retour['objet_id'] =  $profil->id ;
                $retour['objet_type'] =  "OPS_personne_morale" ;
                break;
            case 'partenaire_tous':
            case 'partenaire_principal':
                $this->dossier->load_relationship('ops_dossier_ops_avis');
                $list_avis_dossier = $this->dossier->ops_dossier_ops_avis->get();
                $retour['to'] = '';
                if (!empty($list_avis_dossier)) {
                    $email = new SugarEmailAddress;
                    // On récupère tout les avis non supprimés liés au Dossier
                    foreach ($list_avis_dossier as $id) {
                        $bean_avis = BeanFactory::getBean('OPS_avis', $id);
                        /*
                         * Si on ne veut notifier que les partenaires principaux 
                         * et que le partenaire courant n'est pas marqué comme principal
                         * on passe au partenaire suivant
                         */
                        if ($this->action->ext_valeur_1 == 'partenaire_principal' && $bean_avis->flag_principal == false) continue;

                        // Pour chaque avis, on récupère le mail et on évite les doublons
                        switch ($bean_avis->nature) {
                            case 'interne':
                                $user = BeanFactory::getBean('Users', $bean_avis->user_id);
                                if (!empty($email->getPrimaryAddress($user)) && strpos($retour['to'], $email->getPrimaryAddress($user)) === false) {
                                    $retour['to'] .= $email->getPrimaryAddress($user) . ';';
                                }
                                break;
                            case 'externe':
                                if (!empty($bean_avis->email) && strpos($retour['to'], $bean_avis->email) === false) {
                                    $retour['to'] .= $bean_avis->email . ';';
                                }
                                break;
                            case 'externe_profil':
                                $profil = BeanFactory::getBean('OPS_personne_morale', $bean_avis->profil_id);
                                if (!empty($email->getPrimaryAddress($profil)) && strpos($retour['to'], $email->getPrimaryAddress($profil)) === false) {
                                    $retour['to'] .= $email->getPrimaryAddress($profil) . ';';
                                }
                                break;
                            default:
                                break;
                        }
                    }
                    $retour['to'] = rtrim($retour['to'], ';');
                }
                $retour['objet_id'] = $this->dossier->id;
                $retour['objet_type'] = "OPS_dossier";
                break;
            default:
                $retour['to'] = $this->action->ext_valeur_2;
                break;
        }
            


        return $retour ; 

    }


}
