<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;
use Configurator;

if (!defined('sugarEntry')) define('sugarEntry', true);

class FermetureConversationAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Fermer une conversation "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'instruction';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Fermer une conversation "
     * 
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Fermer une conversation";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Fermer une conversation "
     * 
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Il n'y a pas de paramétrage pour cette action.";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     * 
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     * 
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        return []; // Aucune donnée de paramètrage exploitée dans la vue édition.
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     * 
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        return []; // Aucune donnée de paramètrage exploitée dans la vue détail.
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     * 
     *  @return void    
     */
    public function execute()
    {

        global $sugar_config;

        // $configuratorObj = new Configurator();

        // isset($configuratorObj->config['<ConfigSection>']['<param>'])

        if( !empty($this->dossier) && isset($this->dossier->id) ){

            preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $this->dossier->id, $output_array);

            if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){


                $bean_name = 'OPS_conversation';
                $Conversation = BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.

                // Objectif « Fermer une conversation » -> Fixe à 'ouverte'.
                $conversation_statut = 'fermee';
                $data_statut = $Conversation->setConversationState($this->dossier->id, 'OPS_dossier', $conversation_statut);

                $conversation_origin = 'agent'; // On initie la fermeture de ce fait par l'agent.
                $data_origin = $Conversation->setConversationOrigin($this->dossier->id, 'OPS_dossier', $conversation_origin);

                $data_result = (object) array_merge( $data_statut , $data_origin );

            }

        }


    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Fermer une conversation "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "";
    }

}
