<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ModifierAnnuaireProfilAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Modifier annuaire "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'profil';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Modifier annuaire "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Modifier annuaire";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Modifier annuaire "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Modifier annuaire";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        $objReferentiel = BeanFactory::newbean('OPS_generateur_referentiel');
        $listReferentiel = $objReferentiel->get_full_list('libelle');

        $tabReferentiel = array( '' =>  '- aucun -') ;

        foreach ($listReferentiel as $id => $ref) 
        {
            if(!empty($ref->name))
            {
                $tabReferentiel[$ref->id] = $ref->libelle . " (". $ref->name . ")" ;
            }
        }

        $liste_referentiel = get_select_options_with_id($tabReferentiel, $this->action->ext_valeur_3);

        $liste_champ  = $this->getChamps();

        $data['hidden'] = " <input type='hidden'  id='ext_valeur_5' name='ext_valeur_5' value=".base64_encode(json_encode($liste_referentiel)).">
                            <input type='hidden'  id='ext_valeur_3' name='ext_valeur_3' value=".base64_encode(json_encode($liste_champ)).">
                            <input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=".$this->action->ext_valeur_text.">";
   
        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['User']);

        $data = [];

        $data['ext_valeur_1']['label'] = 'Nom des champs';
        $data['ext_valeur_1']['type'] = 'enum';

        $liste_champ = $this->getChamps();

        $tabReferentielChamps = explode("|", $this->action->ext_valeur_text);

        $choix = 'false';
        foreach($tabReferentielChamps as $ReferentielChamp){
            if("" != str_replace(" ","",$ReferentielChamp)){

                $tabReferentielChamp = explode(";",$ReferentielChamp);
                $nomChamp = $tabReferentielChamp[0];
                $champRefetentiel = $tabReferentielChamp[1];

                if("" != str_replace(" ","", $nomChamp)){
                    $choix='true';
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel',$champRefetentiel);
                    $data['ext_valeur_1']['valeur'] .= "<p><span style='float:left;width:50%;' >" . $liste_champ[$nomChamp] . " : </span> <span style ='float:right;'>" . $objReferentiel->libelle . "</span></p><br>";
                }
            }
        }
        
        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        global $sugar_config ;        

        if(!empty($this->dossier) && !empty($this->action->ext_valeur_text) && !empty($this->dossier->ops_personne_morale))
        {
            
            $objPersonneMorale = BeanFactory::getBean('OPS_personne_morale', $this->dossier->ops_personne_morale);

            if(!empty($objPersonneMorale->id))
            {
                $listeChamps = explode('|', $this->action->ext_valeur_text);
                $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );

                foreach ($listeChamps as $champs) 
                {
                    $champ = explode(';', $champs);
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel', $champ[1]);
                    $value = "";

                    // Récupération de la valeur sur un champ basic
                    if (!empty($this->dossier->{$objReferentiel->name}) || $this->dossier->{$objReferentiel->name} === 0 || $this->dossier->{$objReferentiel->name} === '0')
                    {
                        $value = $this->dossier->{$objReferentiel->name};
                    }
                    
                    // Récupération de la valeur sur un champ custom
                    if( !empty( $customChamp->{$objReferentiel->name} ) || $customChamp->{$objReferentiel->name} === 0  || $customChamp->{$objReferentiel->name} === '0'){
                        $value = $customChamp->{$objReferentiel->name};
                    }

                    if($objReferentiel->type == 'liste' && !empty($value))
                    {
                        $value = str_replace('^', '', $value);
                    }
                   


                    if($objReferentiel->type == 'wysiwyg' && !empty($value) )
                    {
                        $value = base64_decode($value);
                    }
                    if($objReferentiel->type == 'file' && !empty($customChamp->{$objReferentiel->name}->content) &&is_array( (array) $customChamp->{$objReferentiel->name}->content  ) )
                    {
                        
                        // On redimensionne l'image 
                        $chemin = $customChamp->{$objReferentiel->name}->content;
                        $image = imagecreatefromstring(file_get_contents($chemin));

                        $maxSize = 600;
                        $originalWidth = imagesx($image);
                        $originalHeight = imagesy($image);

                        $resizeWidth = ($originalWidth > $originalHeight) ? $maxSize : null;

                        list($newWidth, $newHeight) = $this->scaleDimensions($originalWidth, $originalHeight, $resizeWidth, null);
                        $resizedImage = imagescale($image, $newWidth, $newHeight);

                        ob_start();

                        imagejpeg($resizedImage, null, 100);

                        $base64Image = base64_encode(ob_get_clean());
                        $decodedFile = base64_decode($base64Image);

                        // On sauvegarde l'image
                        file_put_contents($sugar_config['upload_dir'].$objPersonneMorale->id.'_image', $decodedFile);


                        // On stocke le nom de l'image 
                        $value = $customChamp->{$objReferentiel->name}->name;
                    }

                    if ($champ[0] == 'profil_name')
                    {
                        $objPersonneMorale->name = strtoupper($value);
                    }
                    else if(!empty($value) || $value === 0 || $value === '0')
                    {
                        $objPersonneMorale->{$champ[0]} = $value;
                    }
                    

                }
                $objPersonneMorale->save();
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "ModifierAnnuaireProfilAction";
    }

    private function getChamps()
    {
        return array(
            'publie' => 'Publié',
            'thematique' => 'Thématique',
            'accroche' => 'Accroche',
            'description_annuaire' => 'Description',
            'activites' => 'Activités',
            'tarifs' => 'Tarifs',
            'public_beneficiaire' => 'Public bénéficiaire',
            'image' => 'Image'
        );
    }

    private function scaleDimensions($width, $height, $maxWidth, $maxHeight)
    {
        if (!$maxWidth && !$maxHeight) {
            return [$width, $height];
        }

        $aspectRatio = $width / $height;

        if ($maxWidth && (!$maxHeight || ($maxWidth / $aspectRatio <= $maxHeight))) {
            return [$maxWidth, $maxWidth / $aspectRatio];
        } elseif ($maxHeight && (!$maxWidth || ($maxHeight * $aspectRatio <= $maxWidth))) {
            return [$maxHeight * $aspectRatio, $maxHeight];
        }

        return [$width, $height];
    }
}