<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;
use Configurator;

if (!defined('sugarEntry')) define('sugarEntry', true);

class OuvertureConversationAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Ouvrir une conversation "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'instruction';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Ouvrir une conversation "
     * 
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Ouvrir une conversation";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Ouvrir une conversation "
     * 
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Saisir le texte par défaut qui sera envoyer à l'usager lors de l'ouverture de la conversation.";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     * 
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     * 
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        // $textarea_default_text = '<input type="text" id="ext_valeur_1" name="ext_valeur_1" value="'.$this->action->ext_valeur_1.'" >';
        $textarea_default_text = '<textarea id="ext_valeur_1" name="ext_valeur_1" style="width: calc(100% - 5px); height: 100px;">'.$this->action->ext_valeur_1.'</textarea>';
        $textarea_default_text.= '<br><em style="font-weight: normal;margin-top: 1rem;display: flex;">Ce texte sera envoyé dans la conversation à l\'usager dès que l\'action de statut sera exécutée.</em>';
        $data = array(
            'ext_valeur_1' => array(
                'type' => 'text',
                'label' => 'Texte par défaut',
                'form' => $textarea_default_text
            )
        );

        return $data;

    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     * 
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        $data = [];
        $data['ext_valeur_1'] = array(
            'type' => 'text',
            'label' => 'Texte par défaut',
            'valeur' => $this->action->ext_valeur_1,
        );

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     * 
     *  @return void    
     */
    public function execute()
    {

        global $sugar_config;
        global $current_user;

        // Use Configurator to fetch identity paramerters.
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();

        // isset($configuratorObj->config['<ConfigSection>']['<param>'])

        if( !empty($this->dossier) && isset($this->dossier->id) ){

            preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $this->dossier->id, $output_array);

            if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){


                $bean_name = 'OPS_conversation';
                $Conversation = BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.

                // Objectif « Ouvrir une conversation » -> Fixe à 'ouverte'.
                $conversation_statut = 'ouverte';
                $data_statut = $Conversation->setConversationState($this->dossier->id, 'OPS_dossier', $conversation_statut);

                $conversation_origin = 'agent'; // On initie l'ouverture de ce fait par l'agent.
                $data_origin = $Conversation->setConversationOrigin($this->dossier->id, 'OPS_dossier', $conversation_origin);

                $data_result = (object) array_merge( $data_statut , $data_origin );


                // Envoi du message par défaut d'ouverture de conversation, si non vide.
                if( !empty($this->action->ext_valeur_1) ){

                    // On prédétermine les informations de l'auteur qui poste le message.
                    $objAuthor = new \stdClass();
                    $objAuthor->prenom    = $current_user->first_name;
                    $objAuthor->nom       = $current_user->last_name;
                    $objAuthor->source_id = $current_user->id;
                    $objAuthor->origin    = 'agent';

                    $b64_message = base64_encode($this->action->ext_valeur_1);

                    $data_message = (object) $Conversation->addMessage($this->dossier->id, 'OPS_dossier', $b64_message, $objAuthor);

                }

            }

        }


    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Ouvrir une conversation "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "";
    }

}
