<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;
use ODE\Model\GenerateurFormulaireModel;

if (!defined('sugarEntry')) define('sugarEntry', true);

class RendreVisibleModifiableOngletAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Rendre visible/modifiable un onglet "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'dossier';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Rendre visible/modifiable un onglet "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Rendre visible/modifiable un onglet";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Rendre visible/modifiable un onglet "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Rendre visible ou modifiable un champ / onglet";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        $data = [];

        $modeleDossier = $this->getModeleDossier();
        $listeOnglet = $this->getOngletVue($modeleDossier);
        $listeVue = $this->getListeVue($modeleDossier);

        $data['hidden'] = " <input type='hidden'  id='ext_valeur_1' name='ext_valeur_1' value=".base64_encode(json_encode($modeleDossier)).">
                            <input type='hidden'  id='ext_valeur_2' name='ext_valeur_2' value='modif_onglet'>
                            <input type='hidden'  id='ext_valeur_3' name='ext_valeur_3' value=".base64_encode(json_encode($listeVue)).">
                            <input type='hidden'  id='ext_valeur_4' name='ext_valeur_4' value=".base64_encode(json_encode($listeOnglet)).">
                            <input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=".$this->action->ext_valeur_text.">";

        if (isset($app_list_strings['moduleList']['OPS_avis'])) {
            $data['hidden'] .= "<input type='hidden' id='partenaire_installed' name='partenaire_installed' value='1'>";
        }

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        $data = [];

        $donnees = $this->getValues();

        $modeleDossier = '';

        if (!empty($donnees['modele_dossier'])){
            $formulaireBean = BeanFactory::getBean('OPS_generateur_formulaire',$donnees['modele_dossier']);
            if (!empty($formulaireBean)) $modeleDossier = $formulaireBean->name;
        }


        $ongletLibelleCRM = '';

        if(!empty($donnees['onglet_crm'])){
            $onglets = explode(",", $donnees['onglet_crm']);
            if(count($onglets) == 1){
                $ongletBean = BeanFactory::getBean('OPS_generateur_onglet', $onglets[0]);
                $ongletLibelleCRM .= $ongletBean->libelle;
            }else{
                foreach ($onglets as $key => $value) {
                    if(count($onglets) == $key+1){
                        $ongletBean = BeanFactory::getBean('OPS_generateur_onglet', $value);
                        $ongletLibelleCRM .= $ongletBean->libelle;
                    }else{
                        $ongletBean = BeanFactory::getBean('OPS_generateur_onglet', $value);
                        $ongletLibelleCRM .= $ongletBean->libelle.', ';
                    }
                }
            }
        }

        $ongletLibelleInternet = '';

        if(!empty($donnees['onglet_internet'])){
            $onglets = explode(",", $donnees['onglet_internet']);
            if(count($onglets) == 1){
                $ongletBean = BeanFactory::getBean('OPS_generateur_onglet', $onglets[0]);
                $ongletLibelleInternet .= $ongletBean->libelle;
            }else{
                foreach ($onglets as $key => $value) {
                    if(count($onglets) == $key+1){
                        $ongletBean = BeanFactory::getBean('OPS_generateur_onglet', $value);
                        $ongletLibelleInternet .= $ongletBean->libelle;
                    }else{
                        $ongletBean = BeanFactory::getBean('OPS_generateur_onglet', $value);
                        $ongletLibelleInternet .= $ongletBean->libelle.', ';
                    }
                }
            }
        }

        # Surcharge module Partenaire
        if (isset($app_list_strings['moduleList']['OPS_avis'])) {
            $ongletLibellePartenaire = '';

            if(!empty($donnees['onglet_partenaire'])){
                $onglets = explode(",", $donnees['onglet_partenaire']);
                if(count($onglets) == 1){
                    $ongletBean = BeanFactory::getBean('OPS_generateur_onglet', $onglets[0]);
                    $ongletLibellePartenaire .= $ongletBean->libelle;
                }else{
                    foreach ($onglets as $key => $value) {
                        if(count($onglets) == $key+1){
                            $ongletBean = BeanFactory::getBean('OPS_generateur_onglet', $value);
                            $ongletLibellePartenaire .= $ongletBean->libelle;
                        }else{
                            $ongletBean = BeanFactory::getBean('OPS_generateur_onglet', $value);
                            $ongletLibellePartenaire .= $ongletBean->libelle.', ';
                        }
                    }
                }
            }

            $checked_visible_partenaire = '';
            $checked_modifiable_partenaire = '';
        }
        # Fin surcharge module Partenaire

        $checked_visible_crm = '';
        $checked_modifiable_crm = '';
        $checked_visible_internet = '';
        $checked_modifiable_internet = '';

        if($donnees['visible_crm'] == 1 || $donnees['visible_crm'] == 'on'){
            $checked_visible_crm = 'checked';
        }
        if($donnees['modifiable_crm'] == 1 || $donnees['modifiable_crm'] == 'on'){
            $checked_modifiable_crm = 'checked';
        }
        if($donnees['visible_internet'] == 1 || $donnees['visible_internet'] == 'on'){
            $checked_visible_internet = 'checked';
        }
        if($donnees['modifiable_internet'] == 1 || $donnees['modifiable_internet'] == 'on'){
            $checked_modifiable_internet = 'checked';
        }
        # Surcharge module Partenaire
        if (isset($app_list_strings['moduleList']['OPS_avis'])) {
            if($donnees['visible_partenaire'] == 1 || $donnees['visible_partenaire'] == 'on'){
                $checked_visible_partenaire = 'checked';
            }
            if($donnees['modifiable_partenaire'] == 1 || $donnees['modifiable_partenaire'] == 'on'){
                $checked_modifiable_partenaire = 'checked';
            }
        }
        # Fin surcharge module Partenaire

        $data['ext_valeur_4']['label']   =      'Modèle de dossier';
        $data['ext_valeur_4']['type']    =      'text';
        $data['ext_valeur_4']['valeur']  =      $modeleDossier.'</div>
                                                </div>
                                            </div>
                                            <div class="row detail-view-row"><h4 style="" role="section_title">CRM</h4><hr style="border-top: 1px solid black;margin: 0;width: 100%;"></div><br>
                                            <div class="row detail-view-row">
                                                <div class="col-xs-12 col-sm-6 detail-view-row-item">
                                                    <div class="col-xs-12 col-sm-4 label col-1-label" style="margin-top: 10px;">Onglet à modifier :</div>
                                                    <div class="col-xs-12 col-sm-6 detail-view-field " type="text" field="onglet_crm">'.$ongletLibelleCRM.'</div>
                                                </div>
                                            </div>
                                            <div class="row detail-view-row">
                                                <div class="col-xs-12 col-sm-6 detail-view-row-item">
                                                    <div class="col-xs-12 col-sm-4 label col-1-label" style="margin-top: 10px;">Visible :</div>
                                                    <div class="col-xs-12 col-sm-6 detail-view-field " type="bool" field="visible_crm">
                                                        <input type="checkbox" class="checkbox" name="visible_crm" id="visible_crm" disabled="" '.$checked_visible_crm.'>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-sm-6 detail-view-row-item">
                                                    <div class="col-xs-12 col-sm-4 label col-1-label" style="margin-top: 10px;">Modifiable :</div>
                                                    <div class="col-xs-12 col-sm-6 detail-view-field " type="bool" field="modifiable_crm">
                                                        <input type="checkbox" class="checkbox" name="modifiable_crm" id="modifiable_crm" disabled="" '.$checked_modifiable_crm.'>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row detail-view-row"><h4 style="" role="section_title">Internet</h4><hr style="border-top: 1px solid black;margin: 0;width: 100%;"></div><br>
                                            <div class="row detail-view-row">
                                                <div class="col-xs-12 col-sm-6 detail-view-row-item">
                                                    <div class="col-xs-12 col-sm-4 label col-1-label" style="margin-top: 10px;">Onglet à modifier :</div>
                                                    <div class="col-xs-12 col-sm-6 detail-view-field " type="text" field="onglet_internet">'.$ongletLibelleInternet.'</div>
                                                </div>
                                            </div>
                                            <div class="row detail-view-row">
                                                <div class="col-xs-12 col-sm-6 detail-view-row-item">
                                                    <div class="col-xs-12 col-sm-4 label col-1-label" style="margin-top: 10px;">Visible :</div>
                                                    <div class="col-xs-12 col-sm-6 detail-view-field " type="bool" field="visible_internet">
                                                        <input type="checkbox" class="checkbox" name="visible_internet" id="visible_internet" disabled="" '.$checked_visible_internet.'>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-sm-6 detail-view-row-item">
                                                    <div class="col-xs-12 col-sm-4 label col-1-label" style="margin-top: 10px;">Modifiable :</div>
                                                    <div class="col-xs-12 col-sm-6 detail-view-field " type="bool" field="modifiable_internet">
                                                        <input type="checkbox" class="checkbox" name="modifiable_internet" id="modifiable_internet" disabled="" '.$checked_modifiable_internet.'>';

        # Surcharge module Partenaire
        if (isset($app_list_strings['moduleList']['OPS_avis'])) {
            $data['ext_valeur_4']['valeur'] .=      '</div>
                                                </div>
                                                <div class="row detail-view-row"><h4 style="" role="section_title">Partenaire</h4><hr style="border-top: 1px solid black;margin: 0;width: 100%;"></div><br>
                                                <div class="row detail-view-row">
                                                    <div class="col-xs-12 col-sm-6 detail-view-row-item">
                                                        <div class="col-xs-12 col-sm-4 label col-1-label" style="margin-top: 10px;">Onglet à modifier :</div>
                                                        <div class="col-xs-12 col-sm-6 detail-view-field " type="text" field="onglet_partenaire">'.$ongletLibellePartenaire.'</div>
                                                    </div>
                                                </div>
                                                <div class="row detail-view-row">
                                                    <div class="col-xs-12 col-sm-6 detail-view-row-item">
                                                        <div class="col-xs-12 col-sm-4 label col-1-label" style="margin-top: 10px;">Visible :</div>
                                                        <div class="col-xs-12 col-sm-6 detail-view-field " type="bool" field="visible_partenaire">
                                                            <input type="checkbox" class="checkbox" name="visible_partenaire" id="visible_partenaire" disabled="" '.$checked_visible_partenaire.'>
                                                        </div>
                                                    </div>
                                                    <div class="col-xs-12 col-sm-6 detail-view-row-item">
                                                        <div class="col-xs-12 col-sm-4 label col-1-label" style="margin-top: 10px;">Modifiable :</div>
                                                        <div class="col-xs-12 col-sm-6 detail-view-field " type="bool" field="modifiable_partenaire">
                                                            <input type="checkbox" class="checkbox" name="modifiable_partenaire" id="modifiable_partenaire" disabled="" '.$checked_modifiable_partenaire.'>';
        }
        # Fin surcharge module Partenaire

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier)){

        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Déclencher un Flux "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "RendreVisibleModifiableOngletAction";
    }

    public function getModeleDossier(){
        $formulaireBean = BeanFactory::getBean('OPS_generateur_formulaire');

        $listeFormulaire = $formulaireBean->get_full_list('name');

        $tableauFormulaire = [];

        foreach ($listeFormulaire as $formulaire) {
            $tableauFormulaire[$formulaire->id] = $formulaire->name;
        }

        asort($tableauFormulaire);

        return $tableauFormulaire;
    }

    public function getOngletVue($modeleDossier){

        $tableauOnglet = [];
        foreach ($modeleDossier as $id => $name) {
            
            $formulaireBean = BeanFactory::getBean('OPS_generateur_formulaire',$id);

            $tableau = [];
            $vuBeanAgent = BeanFactory::getBean('OPS_generateur_vue',$formulaireBean->agent_vue_id);
            $vuBeanAgent->load_relationship('ops_generateur_vue_ops_generateur_onglet');

            $ongletsBeanAgent = $vuBeanAgent->ops_generateur_vue_ops_generateur_onglet->get();

            foreach ($ongletsBeanAgent as $onglet) {
                $ongletBean = BeanFactory::getBean('OPS_generateur_onglet',$onglet);
                $tableau[$ongletBean->id] = $ongletBean; 
            }

            usort($tableau, function($onglet1, $onglet2) { return $onglet1->ordre > $onglet2->ordre; });

            foreach ($tableau as $id => $onglet) {
                $tableauOnglet[$formulaireBean->agent_vue_id][$onglet->id] = $onglet->libelle;
            }


            $tableau = [];
            $vuBeanUsager = BeanFactory::getBean('OPS_generateur_vue',$formulaireBean->usager_vue_id);
            $vuBeanUsager->load_relationship('ops_generateur_vue_ops_generateur_onglet');

            $ongletsBeanUsager = $vuBeanUsager->ops_generateur_vue_ops_generateur_onglet->get();

            foreach ($ongletsBeanUsager as $onglet) {
                $ongletBean = BeanFactory::getBean('OPS_generateur_onglet',$onglet);
                $tableau[$ongletBean->id] = $ongletBean; 
            }

            usort($tableau, function($onglet1, $onglet2) { return $onglet1->ordre > $onglet2->ordre; });

            foreach ($tableau as $id => $onglet) {
                $tableauOnglet[$formulaireBean->usager_vue_id][$onglet->id] = $onglet->libelle;
            }

            # Surcharge module Partenaire
            if (isset($app_list_strings['moduleList']['OPS_avis'])) {
                // Récupération des vues côté Partenaire
                $tableau = [];
                $vuBeanPartenaire = BeanFactory::getBean('OPS_generateur_vue',$formulaireBean->partenaire_vue_id);
                $vuBeanPartenaire->load_relationship('ops_generateur_vue_ops_generateur_onglet');

                $ongletsBeanPartenaire = $vuBeanPartenaire->ops_generateur_vue_ops_generateur_onglet->get();

                foreach ($ongletsBeanPartenaire as $onglet) {
                    $ongletBean = BeanFactory::getBean('OPS_generateur_onglet',$onglet);
                    $tableau[$ongletBean->id] = $ongletBean; 
                }

                usort($tableau, function($onglet1, $onglet2) { return $onglet1->ordre > $onglet2->ordre; });

                foreach ($tableau as $id => $onglet) {
                    $tableauOnglet[$formulaireBean->partenaire_vue_id][$onglet->id] = $onglet->libelle;
                }
            }
            # Fin surcharge module Partenaire
        }
        return $tableauOnglet;
    }

    public function getListeVue($modeleDossier){

        $tableauVue = [];
        foreach ($modeleDossier as $id => $name) {
            $formulaireBean = BeanFactory::getBean('OPS_generateur_formulaire',$id);

            $tableauVue[$id][$formulaireBean->agent_vue_id] = 'CRM';
            $tableauVue[$id][$formulaireBean->usager_vue_id] = 'Internet';
            # Surcharge module Partenaire
            if (isset($app_list_strings['moduleList']['OPS_avis'])) {
                $tableauVue[$id][$formulaireBean->partenaire_vue_id] = 'Partenaire';
            }
            # Fin surcharge module Partenaire
        }
        return $tableauVue;
    }

    public function getConditions($conditions){
        $donnees = getValues();
        $check = false;
        $conditions = json_decode(base64_decode($conditions),true);
        if(empty($conditions)){
            $conditions['verified'] =  "all";
        }
        $conditions['visible'] = ($donnees['visible_crm'] == 'on')?1:0;
        $conditions['modifiable'] = ($donnees['modifiable_crm'] == 'on')?1:0;

        foreach($conditions['conditions'] as $condition){
            if($condition['champ'] == 'ops_statut_id' && $condition['value'] == $this->action->ops_statut_id){
                $check = true;
                break;
            }
        }
        if(empty($check)){
            if(empty($conditions['conditions'])){
                $conditions['conditions'] = array();
            }
            $condition = array(
                'champ' => 'ops_statut_id',
                'operator' => '=' ,
                'value' => $this->action->ops_statut_id);
            array_push($conditions['conditions'], $condition);
        }
        return base64_encode(json_encode($conditions));
    }

    /**
     * @access public
     * @name getValues()
     * Fonction qui retourne les valeurs des champs de l'action
     *
     *  @return array       - $data
     */
    public function getValues()
    {
        $data = [];

        $idModele = '';
        $idOngletCRM = '';
        $idOngletInternet = '';
        $idOngletPartenaire = '';
        $visible_crm = '';
        $modifiable_crm = '';
        $visible_internet = '';
        $modifiable_internet = '';
        $visible_partenaire = '';
        $modifiable_partenaire = '';

        $champs = explode("|", $this->action->ext_valeur_text);

        foreach($champs as $champ){
            if("" != str_replace(" ","",$champ)){

                if (str_contains($champ, ';')) {
                    $champArray = explode(";",$champ);
                    $field = $champArray[0];
                    $value = $champArray[1];
                } else {
                    $field = $champ;
                    $value = '';
                }

                switch ($field) {
					case 'modele_dossier' :
						$idModele = $value;
						break;
					case 'onglet_crm' :
						$idOngletCRM = $value;;
						break;
					case 'onglet_internet' :
						$idOngletInternet = $value;;
						break;
                    case 'onglet_partenaire' :
                        $idOngletPartenaire = $value;
                        break;
					case 'visible_crm' :
						$visible_crm = $value;
						break;
					case 'modifiable_crm' :
						$modifiable_crm = $value;
						break;
					case 'visible_internet' :
						$visible_internet = $value;
						break;
					case 'modifiable_internet' :
						$modifiable_internet = $value;
						break;
                    case 'visible_partenaire' :
                        $visible_partenaire = $value;
                        break;
                    case 'modifiable_partenaire' :
                        $modifiable_partenaire = $value;
                        break;
				}
            }
        }

        $data['modele_dossier']      = $idModele;
        $data['onglet_crm']          = $idOngletCRM;
        $data['onglet_internet']     = $idOngletInternet;
        $data['visible_crm']         = $visible_crm;
        $data['modifiable_crm']      = $modifiable_crm;
        $data['visible_internet']    = $visible_internet;
        $data['modifiable_internet'] = $modifiable_internet;
        # Surcharge module Partenaire
        if (isset($app_list_strings['moduleList']['OPS_avis'])) {
            $data['onglet_partenaire']     = $idOngletPartenaire;
            $data['visible_partenaire']    = $visible_partenaire;
            $data['modifiable_partenaire'] = $modifiable_partenaire;
        }
        # Fin surcharge module Partenaire

        return $data;
    }
}