<?php

namespace ODE\Fonctions;

if (!defined('sugarEntry')) define('sugarEntry', true);

class OdeFonctions
{

    private $time_start;
    private $fonction_path;
    private $fonction_namespace;

    /**
     * Constructeur de la classe OdeFonctions
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct()
    {
        $this->time_start = microtime(true);
        $this->fonction_path = "custom/include/Ode/Fonctions/Liste/";
        $this->fonction_namespace = 'ODE\\Fonctions\\Liste\\';
    }

    /**
     * @access public
     * @name getFonctions()
     * Fonction qui retourne la liste des fonctions configurés sur le serveur 
     * 
     *  @return array       - $fonctions
     */
    public function getFonctions()
    {
        $fonctions = array();

        if(scandir($this->fonction_path) !== false)
        {
            $files = array_diff(scandir($this->fonction_path), array('.', '..'));
            if (is_array($files) && count($files) > 0) {
                foreach ($files as $file_name) {
                    $classe_name = $this->fonction_namespace . ucfirst(str_replace(".php", "", $file_name));
                    $classe_obj = new $classe_name();
                    $fonction = $classe_obj->getFonction();
                    $fonctions[$fonction['fonction_id']] = $fonction;
                }
            }
        }
        return $fonctions;
    }
}
