var FormulaireChampCondition = (function($,formulaireChamp,champ,listeCondition) {

    return { 

        display: function( champ, operator, value){

            $(`#g-condition-form-message`).hide();

            if ( champ === undefined || champ === null ) champ = "";
            if ( operator === undefined || operator === null ) operator = "";
            if ( value === undefined || value === null ) value = "";

            $("#g-condition-form-edit-champ").val(champ);
            $("#g-condition-form-edit-operator").val(operator);
            $("#g-condition-form-edit-value").val(value);
        
            if ( $(`#g-condition-form-liste-type`).val() === "onglet" ) {
                var onglet_id = `${$("#g-onglet-form-vue-type").val()}-tab-${$("#g-onglet-form-id").val()}`;
                $("#g-condition-form-id").val(onglet_id);
                this.init(champ, operator, value);
            } else {
                var formulaire_data = formulaireChamp.getData();
                if ( formulaire_data.id !== undefined && formulaire_data.id !== "" ) {
                    $("#g-condition-form-id").val(formulaire_data.id);
                    this.init(champ, operator, value);
                }
            }

        },

        init: function(champ, operator, value){

            this.viderFormulaire();
            if ( !champ.isEmpty() && !operator.isEmpty() ){
                // On initialise l'edition de la condition
                $(`#g-condition-form-select-champ option[value="${champ}"]`).prop("selected", "selected");
                $(`#g-condition-form-select-operateur option[value="${operator}"]`).prop("selected", "selected");
                $("#g-condition-form-value").val(value);
            }
            this.setSaveBouton();

        },

        viderFormulaire: function(){

            var champ_options = this.getChampOptionHtml();
            $("#g-condition-form-select-champ").empty();
            $("#g-condition-form-select-champ").append( champ_options );

            var operator_options = this.getOperatorOptionHtml();
            $("#g-condition-form-select-operateur").empty();
            $("#g-condition-form-select-operateur").append( operator_options );

            $("#g-condition-form-value").val("");
            
            champ.hideVerification( $("#g-condition-form-select-champ") );
            champ.hideVerification( $("#g-condition-form-select-operateur") );
            
        },

        getOperatorOptionHtml: function(){
            var options_html = '<option></option>';
            options_html    += '<option value="=">[ = ] est égal </option>';
            options_html    += '<option value=">">[ > ] est supérieur strict</option>';
            options_html    += '<option value=">=">[ >= ] est supérieur égal </option>';
            options_html    += '<option value="<">[ < ] est inférieur strict</option>';
            options_html    += '<option value="<=">[ <= ] est inférieur égal </option>';
            return options_html;
        }, 

        // Retourne un array, la liste des champs dans le réferentiel
        getListeChamps: function(){
            var liste = [];
            $("#list-champ-container").children().each(function() {
                liste.push({ nom: $(this).attr("data-nom"), libelle: $(this).attr("data-libelle") });
            });
            return liste;
        },

        // Retourne les options du select "Liste des champs" avec le nom comme value et libellé en text
        getChampOptionHtml: function(){
            var champ_html = "<option></option>";
            var liste = this.getListeChamps();
            if ( Object.getLength(liste) > 0 ) {
                liste.forEach(function(item) {
                    champ_html += `<option value="${item.nom}">${item.libelle}</option>`;
                }); 
            }
            return champ_html;
        },

        /**
         * Fonction qui ajoute la condition a l'input hidden du formulaire onglet ou champ 
         *
         * @return {void}
         */
        setSaveBouton: function() { 

            const self = this;

            $( "#g-condition-form-save-btn" ).off().click(function() {

                var valid = true;
                
                // On récupere les valeurs du formulaire ( la condition )
                var condition = {
                    champ: $("#g-condition-form-select-champ option:selected").val(), 
                    operator: $("#g-condition-form-select-operateur option:selected").val(),
                    value: $("#g-condition-form-value").val(),
                };

                // On vérifie le parametre champ si il est valide
                if ( condition.champ.isEmpty() ){
                    valid = false;
                    champ.displayVerification( $("#g-condition-form-select-champ") , "error", "Le champ est obligatoire" )
                } else {
                    champ.hideVerification( $("#g-condition-form-select-champ") );
                }

                // On vérifie le parametre operator si il est valide
                if ( condition.operator.isEmpty() ){
                    valid = false;
                    champ.displayVerification( $("#g-condition-form-select-operateur") , "error", "L'opérateur est obligatoire" )
                } else {
                    champ.hideVerification( $("#g-condition-form-select-operateur") );
                }

                // Si la condition est valide 
                if ( valid === true ) {

                    // On récupere les données de la condition à éditer 
                    var old_condition = {
                        champ: $("#g-condition-form-edit-champ").val(), 
                        operator: $("#g-condition-form-edit-operator").val(),
                        value: $("#g-condition-form-edit-value").val(),
                    };

                    // vérifie si il s'agit de création ou d'une modification
                    if ( old_condition.champ.isEmpty() && old_condition.operator.isEmpty() ){
                        self.addCondition( condition );
                    }else{
                        self.updateCondition( old_condition, condition );
                    }
                    
                }

            });
        },

        /**
         * Fonction qui ajoute la condition au formulaire champ ou onglet 
         * @param {object} condition
         * 
         * @return {void}
         */
        addCondition: function( condition ){

            // Création d'une nouvelle condition 
            var condition_add = ( $(`#g-condition-form-liste-type`).val() === "onglet" ) ? FormulaireOnglet.addCondition(condition) : formulaireChamp.addCondition(condition);
    
            // Redirection + message
            if ( condition_add ){
                $("#g-condition-form-btn-back").click();
                OdeAlertHelper.set( $(`#g-condition-form-liste-message`) , "success",`La condition a bien été ajoutée`);
            } else {
                OdeAlertHelper.set( $(`#g-condition-form-message`) , "warning",`Cette condition existe deja sur le champ`);
            }

        },

        /**
         * Fonction qui met à jour la condition au formulaire champ ou onglet 
         * @param {object} old_condition
         * @param {object} condition
         * 
         * @return {void}
         */
        updateCondition: function( old_condition, condition ){

            // Modification de la condition existante 
            var condition_update = ( $(`#g-condition-form-liste-type`).val() === "onglet" ) ? FormulaireOnglet.updateCondition(old_condition, condition) : formulaireChamp.updateCondition(old_condition, condition);
            
            // Redirection + message 
            if ( condition_update ){
                $("#g-condition-form-btn-back").click();
                OdeAlertHelper.set( $(`#g-condition-form-liste-message`) , "success",`La condition a bien été modifiée`);
            } else {
                OdeAlertHelper.set( $(`#g-condition-form-message`) , "warning",`Erreur de modification de la condition`);
            }  

        },
        
    }
})(jQuery,FormulaireChamp,Champ,FormulaireChampConditionListe);


