var FormulaireOnglet = (function($,Champ, Onglet) {
 
 
    return {

        /**
         * Fonction qui initialise le formulaire "formulaire-onglet.tpl" avant le display par le routeur
         * 
         * @param {string} vue_type Le type : agent, usager ou partenaire
         * @param {string} vue_id L'id de la vue 
         * @param {string} onglet_id L'id de l'onglet 
         * @return {void} 
         */
        display: function( vue_type, vue_id, onglet_id ){
            
            const self = this;

            /*******  Propriétés  ********/ 

            // Initialisation les tabs de navigation 
            this.initTabs();

            Champ.hideVerification( $(`#g-onglet-form-libelle`) );
            Champ.hideVerification( $(`#g-onglet-form-description`) );

            // On vérifie si il s'agit d'une création ou d'une modification
            var creation = ( onglet_id !== undefined && onglet_id !== null && !onglet_id.isEmpty() ) ? false : true;
   
            // On récupere les données du champ si il s'agit d'une modification sinon un object vide
            var data = ( creation ) ? Onglet.getEmptyData() : Onglet.getData(`${vue_type}-tab-${onglet_id}`);

            // Initialisation du titre du formulaire
            ( creation ) ? $("#g-onglet-form-title").text("Nouvel onglet") : $("#g-onglet-form-title").text(data.libelle) ;

            // On stocke les differents parametres du champ dans les input hidden du formulaire
            ( creation ) ? $("#g-onglet-form-id").val("") : $("#g-onglet-form-id").val( onglet_id );
            $("#g-onglet-form-libelle").val( data.libelle );
            $("#g-onglet-form-description").val( data.description );
            $("#g-onglet-form-vue-type").val( vue_type );
            $("#g-onglet-form-vue-id").val( vue_id );
            $("#g-onglet-form-conditions").val( data.conditions );

            // On initilise la valeur des boutons radio pour la visibilité et la modification
            if ( creation ) {
                $('#g-onglet-form-visible-oui').prop('checked', true);
                $('#g-onglet-form-modifiable-oui').prop('checked', true);
            } else {
                ( data.visible == 0 ) ? $('#g-onglet-form-visible-non').prop('checked', true) : $('#g-onglet-form-visible-oui').prop('checked', true);
                ( data.modifiable == 0 ) ? $('#g-onglet-form-modifiable-non').prop('checked', true) : $('#g-onglet-form-modifiable-oui').prop('checked', true);
            }


            /***********   Conditions   ***********/ 

            // On initialise la route du bouton "+" ( ajouter une condition ) avec l'id du champ si il s'agit d'une modification
            ( creation ) ? $("#g-onglet-form-condition-add-btn").attr("data-route",`/formulaire-condition?id=`) : $("#g-onglet-form-condition-add-btn").attr("data-route",`/formulaire-condition?id=${onglet_id}`);
            
            // On récupere les conditions de l'onglet au format object 
            var field_conditions = ( data.conditions !== undefined && !data.conditions.isEmpty() ) ? JSON.parse( data.conditions.b64ToUtf8() ) : { verified: "all", visible: 1, modifiable: 1, conditions: [], type_profil:[] };

            // On initialise la liste des conditions
            this.setListeConditions( field_conditions );

            // On initilise la valeur du selection de vérification " Toutes les conditions ou une seule condition "
            $(`#g-onglet-form-condition-verified option[value="${field_conditions.verified}"]`).prop('selected', true);
            
            // On initilise la valeur des boutons radio pour la visibilité
            ( field_conditions.visible === 1 || field_conditions.visible === undefined ) ? $('#g-onglet-form-condition-visible-oui').prop('checked', true) : $('#g-onglet-form-condition-visible-non').prop('checked', true);

            // On initilise la valeur des boutons radio pour la modification
            ( field_conditions.modifiable === 1 || field_conditions.modifiable === undefined ) ? $('#g-onglet-form-condition-modifiable-oui').prop('checked', true) : $('#g-onglet-form-condition-modifiable-non').prop('checked', true);

            // On initialise le click sur le bouton " Ajouter une condition "
            this.setClickAddConditionBtn();

            // On affiche la liste des conditions et on cache le formulaire 
            $("#g-onglet-form-condition-liste").show();
            $("#g-onglet-form-condition-formulaire").hide();

            // On initilise le bouton " Sauvegarde " du formulaire 
            this.setSaveFormulaireBtn();

        },

        /**
         * Fonction qui initialise le click sur les tabs "Propriétés" et "Conditions"
         * 
         * @return {void} 
        */
         initTabs: function() { 
            $('.g-onglet-tabs-nav a').off().on('click', function (event) {
                event.preventDefault();
                $('.g-onglet-tab-active').removeClass('g-onglet-tab-active');
                $(this).parent().addClass('g-onglet-tab-active');
                if ( $(this).attr('href') === "#g-onglet-form" ) {
                    $("#g-onglet-form").show();
                    $("#g-onglet-form-condition").hide();
                } else {
                    $("#g-onglet-form").hide();
                    $("#g-onglet-form-condition").show();
                }
            });
            $('.g-onglet-tabs-nav a:first').trigger('click');
        }, 

        /**
         * Fonction qui initialise le click sur les tabs "Propriétés" et "Conditions"
         * 
         * @return {void} 
        */
        setListeConditions: function ( conditions ){

            // On initialise la liste des conditions avec le message " Aucune condition "
            var liste_element_html = this.getEmptyListElement();
            // On ajoute les conditions à la liste 
            if ( Object.getLength(conditions.conditions ) > 0){
                liste_element_html = this.getListElement( conditions.conditions );
            }
            $("#g-onglet-form-condition-form-liste").empty();
            $("#g-onglet-form-condition-form-liste").append(liste_element_html);

            var liste_element_type_profil_html = this.getEmptyListElementTypeProfil();
            // On ajoute les types de profil à la liste 
            if(!Array.isArray(conditions.type_profil)) conditions.type_profil = [];
            if ( conditions.type_profil && Object.getLength(conditions.type_profil ) > 0){
                liste_element_type_profil_html = this.getListElementTypeProfil( conditions.type_profil );
            }
            $("#g-onglet-form-condition-type-profil-form-liste").empty();
            $("#g-onglet-form-condition-type-profil-form-liste").append(liste_element_type_profil_html);
            
            // On initilise le click sur les boutons " Supprimer une condition "
            this.setClickDeleteConditionBtn();

            // On initilise le click sur les boutons " Modifier une condition "
            this.setClickUpdateConditionBtn();
        },

        /**
         * Fonction qui retourne une ligne avec le message "Aucune condition" en format html  
         * 
         * @return {string} 
         */
        getEmptyListElement: function(){
            return '<li class="list-group-item d-flex justify-content-between align-items-center"> Aucune condition </li>';
        },

        /**
         * Fonction qui retourne une ligne avec le message "Aucun type de profil" en format html  
         * 
         * @return {string} 
         */
        getEmptyListElementTypeProfil: function(){
            return '<li class="list-group-item d-flex justify-content-between align-items-center"> Aucun type de profil </li>';
        },

        /**
         * Fonction retourne les conditions au format HTML
         * 
         * @param {object} conditions Les conditions du champ
         * @return {string} conditions_html Les conditions du champ en format HTML
         */
        getListElement: function( conditions ){
            var conditions_html = "";
            conditions.forEach(function(condition) {

                conditions_html += `<li class="list-group-item d-flex justify-content-between align-items-center">`;
                conditions_html +=      `<div class="row">`;
                conditions_html +=          `<div class="col-md-9">`;
                conditions_html +=              `<p> <strong>Si</strong> ${condition.champ} <strong> ${condition.operator} </strong> ${condition.value} </p>`;
                conditions_html +=          `</div>`;
                conditions_html +=          `<div class="col-md-3">`;
                conditions_html +=              `<button role="delete-condition" data-champ="${condition.champ}" data-operator="${condition.operator}" data-value="${condition.value}" title="Supprimer la condition" class="badge" style=" background-color: #dc3545; padding: 5px 6px;border: none;">`;
                conditions_html +=                  `<i class="fas fa-trash-alt"></i>`;
                conditions_html +=              `</button>`;
                conditions_html +=              `<button role="update-condition" data-champ="${condition.champ}" data-operator="${condition.operator}" data-value="${condition.value}" title="Modifier la condition" class="badge" style="background-color:#28a745;padding: 5px 6px;border: none;">`;
                conditions_html +=                  `<i class="fas fa-edit"></i>`;
                conditions_html +=              `</button>`;
                conditions_html +=          `</div>`;
                conditions_html +=      `</div>`;
                conditions_html += `</li>`;
            });
            return conditions_html;
        },

        /**
         * Fonction retourne les conditions au format HTML
         * 
         * @param {object} conditions Les conditions du champ
         * @return {string} conditions_html Les conditions du champ en format HTML
         */
        getListElementTypeProfil: function( type_profil ){
            var conditions_html = "";
            type_profil.forEach(function(tab, key) {
                $.each(tab, function(id, value) {

                    conditions_html += `<li class="list-group-item d-flex justify-content-between align-items-center">`;
                    conditions_html +=      `<div class="row">`;
                    conditions_html +=          `<div class="col-md-9">`;
                    conditions_html +=              `<p> ${value} </p>`;
                    conditions_html +=          `</div>`;
                    conditions_html +=          `<div class="col-md-3">`;
                    conditions_html +=              `<button role="delete-condition-type-profil" data-type-profil="${id}" title="Supprimer le type de profil" class="badge" style=" background-color: #dc3545; padding: 5px 6px;border: none;">`;
                    conditions_html +=                  `<i class="fas fa-trash-alt"></i>`;
                    conditions_html +=              `</button>`;
                    conditions_html +=          `</div>`;
                    conditions_html +=      `</div>`;
                    conditions_html += `</li>`;
                });
            });
            return conditions_html;
        },

        /**
         * Fonction qui initialise le click sur le bouton " Supprimer une condition "
         * 
         * @return {void} 
         */
         setClickDeleteConditionBtn: function(){ 
            const self = this;
            $("[role=delete-condition]").each(function() {
                $(this).click(function(){ 
                    // On supprime la condition des parametres du champ
                    var deleted = self.deleteCondition({
                        champ: $( this ).attr( "data-champ" ),
                        operator: $( this ).attr( "data-operator" ),
                        value: $( this ).attr( "data-value" ),
                    });
                    if ( deleted ) {
                        var data = self.getConditions();
                        self.setListeConditions( data );
                        OdeAlertHelper.set( $(`#g-onglet-form-message`) , "success",`Condition supprimée`);
                    }
                });
            });

            $("[role=delete-condition-type-profil]").each(function() {
                $(this).click(function(){ 
                    var data = FormulaireOnglet.getConditions();
                    var check = false;
                    var idCheck = $(this).attr('data-type-profil');
                    $.each(data.type_profil, function(key, tab) {
                        $.each(tab, function(id, value) {
                            if(id == idCheck ){
                                data.type_profil.splice(key,1);
                                check = true; 
                                return false;
                            } 
                        });
                        if(check) return false;
                    });
                    $("#g-onglet-form-conditions").val(JSON.stringify(data).utf8ToB64());
                    FormulaireOnglet.setListeConditions( data );
                });
            });
        },

        /**
         * Fonction qui initialise le click sur le bouton " Supprimer une condition "
         * 
         * @return {void} 
        */
        setClickUpdateConditionBtn: function(){ 
            const self = this;
            $("[role=update-condition]").each(function() {
                $(this).click(function(){ 
                    self.initFormCondition($(this).attr("data-champ"), $(this).attr("data-operator"), $(this).attr("data-value"));
                    $("#g-onglet-form-condition-liste").hide();
                    $("#g-onglet-form-condition-formulaire").show();
                });
            });
        },


        /**
         * Fonction qui initialise le formulaire d'ajout et de modification des conditions 
         * 
         * @param {string} champ 
         * @param {string} operator 
         * @param {string} value 
         * @return {void} 
        */
        initFormCondition: function( champ, operator, value){

            if ( champ === undefined || champ === null ) champ = "";
            if ( operator === undefined || operator === null ) operator = "";
            if ( value === undefined || value === null ) value = "";
            
            // On récupere la liste des champs de la vue courante 
            var champs = this.getChampVueCourante();

            // Initialisation du select champ
            var champs_options = this.getChampOptionHtml( champs );
            $("#g-onglet-form-condition-champ").empty();
            $("#g-onglet-form-condition-champ").append( champs_options );

        
            // Initialisation du select champ
            var operateurs_options = this.getOperateurOptionHtml();
            $("#g-onglet-form-condition-operateur").empty();
            $("#g-onglet-form-condition-operateur").append( operateurs_options );

            // On initilise le formulaire avec les valeurs
            $(`#g-onglet-form-condition-champ option[value="${champ}"]`).prop("selected", "selected");
            $(`#g-onglet-form-condition-operateur option[value="${operator}"]`).prop("selected", "selected");
            $("#g-onglet-form-condition-value").val(value);

            $("#g-onglet-form-condition-champ-old").val(champ), 
            $("#g-onglet-form-condition-operateur-old").val(operator),
            $("#g-onglet-form-condition-value-old").val(value),

            // On initialise le click sur le bouton " Fermer formulaire "
            this.setClickBackListeBtn();

            // On vérifie si il s'agit d'une création ou d'une modification
            var creation = ( champ.isEmpty() && operator.isEmpty() && value.isEmpty() ) ? true : false;
            ( creation ) ? $("#g-onglet-form-condition-add-btn").show() : $("#form-g-onglet-form-condition-btn").hide();
            ( creation ) ? $("#g-onglet-form-condition-update-btn").hide() : $("#g-onglet-form-condition-update-btn").show();
            ( creation ) ? $("#g-onglet-form-condition-save-btn").val("Ajouter") : $("#g-onglet-form-condition-save-btn").val("Modifier");
            
            // On initialise le click sur le bouton " Ajouter " / " Modifier "
            this.setSaveCondition();
            
    
        },

        /**
         * Fonction qui retourne un array, la liste des champs dans le réferentiel
         * 
         * @return {array} 
        */
        getChampVueCourante: function(){
            var liste = [];
            $('[role="vue"]').each(function() {
                if ( $(this).css("display") !== "none" ) {
                    var vue_champs = $(this).find($('[role="list-champ"]'));
                    vue_champs.each(function() {
                        liste.push({ nom: $(this).attr("data-nom"), libelle: $(this).attr("data-libelle") });
                    });
                }
            });
            return liste;
        },


        /**
         * Fonction qui retourne les options du select "Liste des champs" avec le nom comme value et libellé en text
         * 
         * @param {array} champs 
         * @return {string} 
        */
        getChampOptionHtml: function( champs ){
            var champs_html = "<option></option>";
            if ( Object.getLength(champs) > 0 ) {
                champs.forEach(function(item) {
                    champs_html += `<option value="${item.nom}">${item.libelle}</option>`;
                }); 
            }
            return champs_html;
        },

        /**
         * Fonction qui 
         * 
         * @return {string} 
        */
        getOperateurOptionHtml: function(){
            var options_html = '<option></option>';
            options_html    += '<option value="=">[ = ] est égal </option>';
            options_html    += '<option value=">">[ > ] est supérieur strict</option>';
            options_html    += '<option value=">=">[ >= ] est supérieur égal </option>';
            options_html    += '<option value="<">[ < ] est inférieur strict</option>';
            options_html    += '<option value="<=">[ <= ] est inférieur égal </option>';
            return options_html;
        }, 

        /**
         * Fonction qui 
         * 
         * @return {void} 
        */
        setClickBackListeBtn: function(){ 
            $("#g-onglet-form-condition-back-liste").off().click(function(){ 
                $("#g-onglet-form-condition-liste").show();
                $("#g-onglet-form-condition-formulaire").hide();
            });
        },

        /**
         * Fonction qui 
         * 
         * @return {void} 
        */
        setSaveCondition: function(){ 

            const self = this;
            OdeLog.log( OdeLog.asSuccess("setSaveCondition => value"), "value" );
            Champ.hideVerification( $("#g-onglet-form-condition-champ") );
            Champ.hideVerification( $("#g-onglet-form-condition-operateur") );

            $("#g-onglet-form-condition-save-btn").off().click(function(){ 

                var valid = true;
                // On récupere les valeurs du formulaire ( la condition )
                var condition = {
                    champ: $("#g-onglet-form-condition-champ option:selected").val(), 
                    operator: $("#g-onglet-form-condition-operateur option:selected").val(),
                    value: $("#g-onglet-form-condition-value").val(),
                };
                OdeLog.log( OdeLog.asSuccess("setSaveCondition => condition"), condition );
                // On vérifie le parametre champ si il est valide
                if ( condition.champ.isEmpty() ){
                    valid = false;
                    Champ.displayVerification( $("#g-onglet-form-condition-champ") , "error", "Le champ est obligatoire" )
                } else {
                    Champ.hideVerification( $("#g-onglet-form-condition-champ") );
                }

                // On vérifie le parametre operator si il est valide
                if ( condition.operator.isEmpty() ){
                    valid = false;
                    Champ.displayVerification( $("#g-onglet-form-condition-operateur") , "error", "L'opérateur est obligatoire" )
                } else {
                    Champ.hideVerification( $("#g-onglet-form-condition-operateur") );
                }

                // Si la condition est valide 
                if ( valid === true ) {

                    // On récupere les données de la condition à éditer 
                    var old_condition = {
                        champ: $("#g-onglet-form-condition-champ-old").val(), 
                        operator: $("#g-onglet-form-condition-operateur-old").val(),
                        value: $("#g-onglet-form-condition-value-old").val(),
                    };

                    // vérifie si il s'agit de création ou d'une modification
                    if ( old_condition.champ.isEmpty() && old_condition.operator.isEmpty() ){
                        self.addCondition( condition );
                    }else{
                        self.updateCondition( old_condition, condition );
                    }
                    
                }
            });
        },

        /**
         * Fonction qui initialise le click sur le bouton " Ajouter une condition "
         * 
         * @return {void} 
         */
         setClickAddConditionBtn: function(){ 
            const self = this;
            $("#g-onglet-form-condition-add-btn").off().click(function(){ 
                self.initFormCondition(null,null,null);
                $("#g-onglet-form-condition-liste").hide();
                $("#g-onglet-form-condition-formulaire").show();
            });

            $("#g-onglet-form-condition-type-profil-add-btn").off().click(function(){
                open_popup("OPS_type_personne",600,400,"",true,false,
                {"call_back_function":"FormulaireOnglet.getConditionTypeProfil","form_name":"generer","field_to_name_array":{"id":"id","name":"type_profil"}},"single",true);
            });
        },

        getConditionTypeProfil: function(typeProfil){
            var conditions_encoded = $("#g-onglet-form-conditions").val();
            if (  conditions_encoded !== undefined && !conditions_encoded.isEmpty() ){
                conditions = JSON.parse(conditions_encoded.b64ToUtf8());
            }else{
                conditions = FormulaireOnglet.getConditions();
            }
            if(!Array.isArray(conditions.type_profil)) conditions.type_profil = [];
            if(conditions.type_profil.length > 0){
                var check = false;
                $.each(conditions.type_profil, function(key, tab) {
                    $.each(tab, function(id, value) {
                        if(conditions.type_profil[key][id] == typeProfil.name_to_value_array.type_profil && id == typeProfil.name_to_value_array.id ){
                            conditions.type_profil[key][id] = typeProfil.name_to_value_array.type_profil;
                            check = true; 
                            return false;
                        } 
                    });
                    if(check) return false;
                });
                if(!check) conditions.type_profil.push({[typeProfil.name_to_value_array.id]: typeProfil.name_to_value_array.type_profil});
            }else{
                conditions.type_profil.push({[typeProfil.name_to_value_array.id]: typeProfil.name_to_value_array.type_profil});
            }
            FormulaireOnglet.setListeConditions(conditions);
            $("#g-onglet-form-conditions").val(JSON.stringify(conditions).utf8ToB64() );
        },

        /**
         * Fonction qui se déclenche au click du bouton sauvegarder
         *      Si l'id est present dans l'input hidden du formulaire => on modifie l'onglet
         *      Si l'id est vide, on crée l'onglet  
         * 
         * @return {void} 
         */
         setSaveFormulaireBtn: function(){
            const self = this;
            $("#g-onglet-form-save-btn").off().click(function() {
                var data = self.getData();
                if ( data.libelle !== "" ) {
                    Champ.displayVerification( $(`#g-onglet-form-libelle`) , "success", "" );
                    ( data.id !== undefined && !data.id.isEmpty() ) ? self.updateOnglet( data ) : self.createOnglet( data );
                    
                }else{
                    Champ.displayVerification( $(`#g-onglet-form-libelle`) , "error", "Le libellé est obligatoire" )
                } 
            });
        }, 

        /**
         * Fonction qui retourne les données du formulaire 
         * 
         * @return {object} 
         */
        getData: function(){
 
            var id = ( $("#g-onglet-form-id").val() !== undefined && $("#g-onglet-form-id").val() !== "" ) ? $("#g-onglet-form-id").val() : "";
            var libelle = ( $("#g-onglet-form-libelle").val() !== undefined && $("#g-onglet-form-libelle").val() !== "" ) ? $("#g-onglet-form-libelle").val() : "";
            var vue_type = ( $("#g-onglet-form-vue-type").val() !== undefined && $("#g-onglet-form-vue-type").val() !== "" ) ? $("#g-onglet-form-vue-type").val() : "";
            var vue_id = ( $("#g-onglet-form-vue-id").val() !== undefined && $("#g-onglet-form-vue-id").val() !== "" ) ? $("#g-onglet-form-vue-id").val() : "";
            var conditions = JSON.stringify( this.getOngletConditions() ).utf8ToB64();
            var description = ( $("#g-onglet-form-description").val() !== undefined && $("#g-onglet-form-description").val() !== "" ) ? $("#g-onglet-form-description").val() : "";
            var ordre = this.getOrdre(vue_type);
            var visible = ( $('#g-onglet-form-visible-oui').prop('checked') === true ) ? 1 : 0 ;
            var modifiable = ( $('#g-onglet-form-modifiable-oui').prop('checked') === true ) ? 1 : 0 ;

            return {
                id: id,
                vue_type: vue_type,
                vue_id: vue_id,
                libelle: libelle,
                ordre: ordre,
                description: description,
                visible: visible,
                modifiable: modifiable,
                conditions: conditions
            };
            
        },

        /**
         * Retourne un array des conditions de l'onglet
         * 
         * @return {object} 
         */
        getOngletConditions: function () {
            var conditions = { verified: "all", visible: 1, modifiable: 1, conditions: [], type_profil:[] }; 
            var conditions_encoded = $("#g-onglet-form-conditions").val();
            var type_profil = '';
            if (  conditions_encoded !== undefined && !conditions_encoded.isEmpty() ){
                var conditions = JSON.parse(conditions_encoded.b64ToUtf8());  
            }
            conditions.verified = $("#g-onglet-form-condition-verified option:selected").val();
            conditions.visible = ( $('#g-onglet-form-condition-visible-oui').prop('checked') === true ) ? 1 : 0 ;
            conditions.modifiable = ( $('#g-onglet-form-condition-modifiable-oui').prop('checked') === true ) ? 1 : 0 ;
            return conditions;
        },

        /**
         * Fonction qui récupere le l'ordre le plus grand + 1 
         * 
         * @return {number} 
         */
        getOrdre: function(vue_type){
            var ordres = [];
            $(`#${vue_type}`).find($("[role=tabpanel]")).each(function() {
                ordres.push($(this).attr("data-ordre"));
            });
            return ordres.length > 0 ? Math.max(...ordres) + 1 : 1;
        },

        /**
         * Fonction qui ajoute une condition a l'onglet
         * 
         * @param {object} condition La nouvelle condition
         * @return {void} 
        */
        addCondition: function ( condition ){

            var data = this.getConditions();
            OdeLog.log( OdeLog.asSuccess("data"), data );
            if ( this.isConditionValid( condition, data.conditions) ) {
                data.conditions.push(condition);
                $("#g-onglet-form-conditions").val(JSON.stringify(data).utf8ToB64() );
                OdeLog.log( OdeLog.asSuccess("addCondition :: conditions "), $("#g-onglet-form-conditions") );
                this.setListeConditions( data );
                $("#g-onglet-form-condition-liste").show();
                $("#g-onglet-form-condition-formulaire").hide();
                OdeAlertHelper.set( $(`#g-onglet-form-message`) , "success",`La condition a bien été ajoutée`);
            } else {
                OdeAlertHelper.set( $(`#g-onglet-form-message`) , "warning",`Cette condition existe deja sur le champ`);
            }
            
        },

        /**
         * Fonction qui edit une condition
         * 
         * @param {object} old_condition La condition a modifier ( anciennes valeurs )
         * @param {object} new_condition La nouvelle condition ( nouvelles valeurs )
         * @return {void} 
        */
        updateCondition: function ( old_condition, new_condition ){

            var updated = false;
            var data = this.getConditions();
            if ( !this.isConditionValid( new_condition, data.conditions) || !this.isEgalCondition(new_condition,old_condition) ) {
                var new_conditions = [];
                data.conditions.forEach(function(element) {
                    if ( element.champ === old_condition.champ && element.operator === old_condition.operator && element.value === old_condition.value ){
                        new_conditions.push(new_condition);
                        updated = true;
                    }else{
                        new_conditions.push(element);
                    }
                });
                data.conditions = new_conditions;
                $("#g-onglet-form-conditions").val( JSON.stringify(data).utf8ToB64() );
                this.setListeConditions( data );
            } else {
                updated = true;
            }

            // Redirection + message 
            if ( updated ){
                $("#g-onglet-form-condition-liste").show();
                $("#g-onglet-form-condition-formulaire").hide();
                OdeAlertHelper.set( $(`#g-onglet-form-message`) , "success",`La condition a bien été modifiée`);
            } else {
                OdeAlertHelper.set( $(`#g-onglet-form-message`) , "warning",`Erreur de modification de la condition`);
            } 

        },

        /**
         * Fonction qui vérifie si deux conditions sont identiques
         * 
         * @param {object} condition_1 La premiere condition
         * @param {object} condition_2 La deuxieme condition
         * @return {boolean} 
         */
        isEgalCondition:function (condition_1, condition_2){
            return ( condition_1.champ === condition_2.champ && condition_1.operator === condition_2.operator && condition_1.value === condition_2.value  ) ? true : false;
        },

        /**
         * Fonction qui vérifie si la condition existe deja 
         * 
         * @param {object} condition La nouvelle route
         * @param {object} conditions La nouvelle route
         * @return {boolean} 
         */
        isConditionValid:function (condition, conditions){
            if ( Object.getLength(conditions) === 0 ) return true;
            var exist = false;
            conditions.forEach(function(_condition) {
                if ( _condition.champ === condition.champ ){
                    if ( _condition.operator === condition.operator ){
                        if ( _condition.value === condition.value ){
                            exist = true;
                        }
                    }
                }
            });
            return ( exist === false ) ? true : false;
        },

        /**
         * Fonction supprime une condition au champ
         * 
         * @param {object} condition La condition a supprimer
         * @return {boolean} 
         */
        deleteCondition: function ( condition ){

            var data = this.getConditions();
            var new_conditions = [];
            var old_conditions = [];

            data.conditions.forEach(function(element) {
                if ( element.champ === condition.champ ){
                    if ( element.operator === condition.operator ){
                        if ( element.value !== condition.value ){
                            new_conditions.push(element);
                        }
                    }else{
                        new_conditions.push(element);
                    }
                }else{
                    new_conditions.push(element);
                }
            });
      
            var old_conditions = data.conditions;
            data.conditions = new_conditions;
            $("#g-onglet-form-conditions").val( JSON.stringify(data).utf8ToB64() );

            return ( Object.getLength(old_conditions) !== Object.getLength(new_conditions) ) ? true : false;
        },

        /**
         * Fonction qui ajoute la route à l'historique de navigation
         * 
         * @param {string} route La nouvelle route
         * @return {void} 
         */
        // Retourne un array des conditions du champ
        getConditions: function (){
            var conditions = { verified: "all", modifiable: 1, conditions: [], type_profil: [] };
            var conditions_encoded = $("#g-onglet-form-conditions").val();
            if (  conditions_encoded !== undefined && !conditions_encoded.isEmpty() ){
                var conditions = JSON.parse( conditions_encoded.b64ToUtf8() ); 
            }
            return conditions;
        },

        /**
         * Fonction qui crée l'onglet 
         * 
         * @param {object}  data   Les données de l'onglet
         * @return {void} 
        */
        createOnglet: function(data){

            data.fake = 'true';

            loading = function(){
                OdeLoadingHelper.addSpinnerMenu();
            };

            callBack = function(){

                setTimeout(function(){ OdeLoadingHelper.removeSpinnerMenu(); }, 1000);
                
                if ( typeof this.result === "string" ){
                    OdeAlertHelper.set($(`#g-onglet-form-message`), "error", "La ressource demandée n'existe pas");
                }  else {
                    
                    var created = Onglet.addContainerAndBtn(this.result);
                    Onglet.setDeleteOnglets();
                    Onglet.setDroppableSortableContainers();

                    if ( created ) {
                        // On redirige vers menu
                        Router.navigate(`/`);
                        $(`.onglet-navigation-bar a[href="#${this.result.vue_type}-tab-${this.result.id}"]`).click();
                        FormulaireOnglet.flagModification(this.result.vue_id);
                        OdeAlertHelper.set($(`#g-onglet-form-message`), "success", `L'onglet a bien été créé`);
                    } else {
                        OdeAlertHelper.set($(`#g-onglet-form-message`), "error", "Erreur création onglet");
                    } 
                    // On réinitialise l'event sur le role navigation pour activer l'edition du champ
                    Router.setClickRoutes();
                }
               
            };
            Onglet.create(data, loading, callBack);
        },

        /**
         * Fonction qui met à jour l'onglet 
         * 
         * @param {object}  data   Les données de l'onglet
         * @return {void} 
        */
        updateOnglet: function(data){
            Onglet.setLibelle( `${data.vue_type}-tab-${data.id}` , data.libelle);
            Onglet.setConditions( `${data.vue_type}-tab-${data.id}` , data.conditions);
            Onglet.setDescription(`${data.vue_type}-tab-${data.id}` , data.description);
            Onglet.setVisible( `${data.vue_type}-tab-${data.id}` , data.visible);
            Onglet.setModifiable(`${data.vue_type}-tab-${data.id}` , data.modifiable);
            OdeAlertHelper.set( $(`#g-onglet-form-message`), "success", `L'onglet a bien été modifié`);
            Router.navigate(`/`);
            //Flag modification
            FormulaireOnglet.flagModification(data.vue_id);
        },

        flagModification: function(vue_id){
            var vue = $('[data-id='+vue_id+']');
            if($(vue).attr('data-modified') != 'true'){
                $(vue).attr('data-modified','true');
                var element = $($('#app-container').find('[aria-controls=' + $(vue).attr('id') + ']'));
                var existingStyle = element.attr('style');
                var newStyle = existingStyle + ' color: #f20000 !important';

                element.attr('style', newStyle);
            }
        },

    }
})(jQuery,Champ,Onglet);
