<?php

namespace ODE\Generateur\Field;

use ODE\Helper\OdeArrayHelper;
use Sugar_Smarty;

class OdeCheckboxMulti extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdeCheckboxMulti
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
    */
    public function getIneditableField($champ, $value_bdd)
    {
        global $app_list_strings;

        // On récupere la valeur à afficher
        $values = $this->getFieldValue($value_bdd);
        $liste = $this->getFieldListe(base64_decode($champ["params"]));

        $field_html = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $data_value =  'data-value="';
        $options = [];
        foreach ($liste as $index => $valeur) {
            $checked = (in_array($index, $values)) ? ' checked="checked" ' : '';
            $options[$index] = [
                "libelle" => $valeur,
                "checked" => $checked
            ];
        }

        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';
        $required = '';

        $smarty = new Sugar_Smarty();
        $smarty->assign("id", $this->getUniqueId());
        $smarty->assign("name", $name);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value_bdd);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("autre", $data_value);
        $smarty->assign("options", $options);
        $smarty->assign("view", "detail");
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("aria", $champ["libelle"]);

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
            $smarty->assign("required", $required);

            // Purifier
            foreach ($options as $key => $option) {
                $options[$key]['slug_value'] = preg_replace('/\s+/', '_', trim(preg_replace('/[^0-9a-zA-Z_]/', ' ', $key)));
            }
            $smarty->assign("options", $options);

            $extra = ' data-role="champ-formulaire" data-type-field="checkboxmulti" data-name="' . $name . '" data-conditions="' . $champ["conditions"] . '" ';
            $smarty->assign("extra", $extra);

            $field_html .= $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/checkbox_front.tpl");
        }else{
            $field_html .= $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/checkbox.tpl");
        }


        return $field_html;

    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        global $app_list_strings;
        
        $isDefaut = '';
        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $values = $this->getFieldDefautValue($champ["defaut"],$isDefaut);
        } else {
            $values = $this->getFieldValue($value_bdd);
        }

        $liste = $this->getFieldListe(base64_decode($champ["params"]));

        $options = [];
        foreach ($liste as $index => $valeur) {
            $checked = (in_array($index, $values)) ? ' checked="checked" ' : '';
            $options[$index] = [
                "libelle" => $valeur,
                "checked" => $checked
            ];
        }
        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("id", $this->getUniqueId());
        $smarty->assign("required", $required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("multiple", $multiple);
        $smarty->assign("options", $options);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("value", $value_bdd);
        $smarty->assign("view", "edit");
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("isDefaut", $isDefaut);
        $smarty->assign("aria", $champ["libelle"]);
        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            // Purifier
            foreach ($options as $key => $option) {
                $options[$key]['slug_value'] = preg_replace('/\s+/', '_', trim(preg_replace('/[^0-9a-zA-Z_]/', ' ', $key)));
            }
            $smarty->assign("options", $options);

            $extra = ' data-role="champ-formulaire" data-type-field="checkboxmulti" data-name="' . $name . '" data-conditions="' . $champ["conditions"] . '" ';
            $smarty->assign("extra", $extra);

            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/checkbox_front.tpl");
        }else{
            $field_html .= $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/checkbox.tpl");
        }

        return $field_label . $field_html;
    }

    public function getLabelField($name = "", $libelle = "", $aide = "", $obligatoire = 0, $multi = '')
    {
        $regex = '/^([A-Za-z0-9+\/]{4})*([A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{2}==)?$/';
        if( !empty($aide) && preg_match($regex,$aide)){
            $aide = base64_decode($aide);
        }
        $required = ( $obligatoire == "1" ) ? ' data-required="true" ' : '';

        $label  = '<div class="col-md-4 field-label"' . $required . ' style="align-self: stretch;margin-top: 10px;">';
        $label .= '<label>' . $libelle .':</label>';
        if (!empty($aide))
        {
            $label .= '<button class="los-icon-button" aria-label="Aide : ' . $aide . '" style="padding: 0;font-size: large;">
                            <span class="sr-only">Aide : ' . $aide . '</span>
                            <i aria-hidden="true" class="fa fa-info-circle info-tooltip" title="' . $aide . '" data-avia-tooltip="' . $aide . '"></i>
                        </button>';
        }      
        $label .= '<small data-role="message-champ" style="display: none;margin-top: 10px;bottom: inherit;">Le champ est obligatoire </small>';
        $label .= '</div>';

        return $label;
    }

    public function getFieldValue($value_bdd)
    {
        $values = [];
        if (!empty($value_bdd)) {
            // On vérifie que c'est bien la valeur d'une liste choix multi
            if (strpos($value_bdd, "^") === false) {
                $values[] = html_entity_decode($value_bdd);
            } else {
                // On supprime le premier et le dernier caractère   [  ^value^ => value  |   ^value_1^,^value_2^ => value_1^,^value_2  ]  
                $value_formated = substr(substr($value_bdd, 1), 0, -1);
                $values = explode("^,^", $value_formated);
            }
        }
        return $values;
    }

    public function getFieldDefautValue($value_defaut,&$isDefaut = null)
    {
        $defautTab = json_decode( base64_decode($value_defaut), true);

        if(!empty($defautTab)){
            if($defautTab['defaut'] == 'autre'){
                $value_defaut = $defautTab['defaut_value'];
            }
            elseif($defautTab['defaut'] == 'url'){
                $value_defaut = '';
                $isDefaut = 'data-defaut="url" data-url-attr="'.$defautTab['defaut_value'].'"';
            }
            else{
                $value_defaut = $this->getDefautValue($defautTab);
                if(!empty($defautTab['defaut']) && isset($isDefaut)){
                    $isDefaut = 'data-defaut="defaut"';
                }
            }
        }
        return (!empty($value_defaut)) ? [html_entity_decode($value_defaut)] : [];
    }

    public function getFieldListe($params)
    {
        global $app_list_strings;
        $liste = [];
        $params_formated = OdeArrayHelper::jsonToArray($params);
        if ($params_formated['statut'] == "ok") {
            $params = $params_formated['data'];
            if (!empty($params['liste_name'])) {
                $liste_name = $params['liste_name'];
                if (array_key_exists($liste_name, $app_list_strings)) {
                    $liste = $app_list_strings[$liste_name];
                }
            } else if (!empty($params['liste'])) {
                $liste = $params['liste'];
            }
        }
        return $liste;
    }

    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value_bdd)
    {
        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $values = $this->getFieldDefautValue($champ["defaut"]);
        } else {
            $values = $this->getFieldValue($value_bdd);
        }

        $liste = $this->getFieldListe(base64_decode($champ["params"]));

        $checkbox_liste = '';
        foreach ($liste as $index => $valeur) 
        {
            if(!empty($checkbox_liste))
            {
               $checkbox_liste .= '<br>';
            }
            $checkbox_liste .= ((!empty($valeur) && $valeur != '') ? $valeur . ': ' : '') . ((in_array($index, $values)) ? ' Oui ' : 'Non');
        }

        return $checkbox_liste;
    }

    public static function getLibelle()
    {
        return "Case à cocher multiple";
    }

    public function getUniqueId()
    {
        return strtoupper(hash("sha256", time() . rand()));
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeCheckboxMulti::getLibelle(),
            'icon' => 'far fa-check-square',
            'route' => '/champs/?type=checkboxmulti',
            'attributes' => '',
        ];
    }
}
