<?php

namespace ODE\Generateur\Field;

use ODE\Helper\OdeArrayHelper;
use ODE\Model\DispositifModel;
use Sugar_Smarty;
use BeanFactory;

class OdeListe_referentiel extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean			    $bean: Bean du module OPS_dossier
     * @param boolean			$editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {

        $value_libelle = "";
        // On récupere la valeur à afficher
        $values = $this->getFieldValue($value_bdd);
        $liste = $this->getFieldListe(base64_decode($champ["params"]));

        $field_html = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $data_value =  'data-value="';
        $options = [];
        foreach ($values as $value) {
            if(!empty($liste[$value])){
                $options[$value] = [
                    "libelle" => $liste[$value],
                    "selected" => ' selected="selected" ',
                ];
            }
        }

        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value_libelle);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("autre", $data_value);
        $smarty->assign("options", $options);
        $smarty->assign("view", "detail");
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("aria", $champ["libelle"]);
        
        if (count($values) > 1) {
            $multiple = ' multiple="multiple" ';
            $smarty->assign("multiple", $multiple);
        }

        $field_html .= $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/select.tpl");

        return $field_html;
    }


    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        $isDefaut = '';
        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $values = $this->getFieldDefautValue($champ["defaut"],$isDefaut);
        } else {
            $values = $this->getFieldValue($value_bdd);
        }
        
        $liste = $this->getFieldListe(base64_decode($champ["params"]));

        $multiple = ($this->isMultiListe(base64_decode($champ["params"]))) ? ' multiple="multiple" ' : '';

        $options = [];
        foreach ($liste as $index => $valeur) {
            $selected = (in_array($index, $values)) ? ' selected="selected" ' : '';
            $options[$index] = [
                "libelle" => $valeur,
                "selected" => $selected
            ];
        }
        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("multiple", $multiple);
        $smarty->assign("options", $options);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("view", "edit");
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("isDefaut", $isDefaut);
        $smarty->assign("aria", $champ["libelle"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/select.tpl");

        return $field_label . $field_html;

    }

    public function getFieldValue($value_bdd)
    {
        $values = [];
        if (!empty($value_bdd)) {
            // On vérifie que c'est bien la valeur d'une liste choix multi
            if (strpos($value_bdd, "^") === false) {
                $values[] = html_entity_decode($value_bdd);
            } else {
                // On supprime le premier et le dernier caractère   [  ^value^ => value  |   ^value_1^,^value_2^ => value_1^,^value_2  ]  
                $value_formated = substr(substr($value_bdd, 1), 0, -1);
                $values = explode("^,^", $value_formated);
            }
        }
        return $values;
    }

    public function getFieldDefautValue($value_defaut,&$isDefaut = null)
    {
        $defautTab = json_decode( base64_decode($value_defaut), true);

        if(!empty($defautTab)){
            if($defautTab['defaut'] == 'autre'){
                $value_defaut = $defautTab['defaut_value'];
            }
            elseif($defautTab['defaut'] == 'url'){
                $value_defaut = '';
                $isDefaut = 'data-defaut="url" data-url-attr="'.$defautTab['defaut_value'].'"';
            }
            else{
                $value_defaut = $this->getDefautValue($defautTab);
                if(!empty($defautTab['defaut']) && isset($isDefaut)){
                    $isDefaut = 'data-defaut="defaut"';
                }
            }
        }
        return (!empty($value_defaut)) ? [html_entity_decode($value_defaut)] : [];
    }

    public function getFieldListe($params)
    {
        global $app_list_strings;
        $liste = [];
        $liste[''] = '';
        $params_formated = OdeArrayHelper::jsonToArray($params);
        if ($params_formated['statut'] == "ok") {
            $params = $params_formated['data'];
            if (!empty($params['liste_referentiel'])) {
                $liste_name = $params['liste_referentiel'];
                $objListeReferentiel = BeanFactory::getBean('OPS_liste_referentiel',$liste_name);
                if(!empty($objListeReferentiel->id)){
                    $listeValeur = $objListeReferentiel->get_linked_beans('ops_liste_valeur_ops_liste_referentiel', 'OPS_liste_valeur', 'ordre, libelle');
                    foreach ($listeValeur as $valeur) {
                        $liste[$valeur->name] = $valeur->libelle;
                    }
                }
            }
        }
        return $liste;
    }


    public function isMultiListe($params)
    {
        $params_formated = OdeArrayHelper::jsonToArray($params);
        $params = ($params_formated['statut'] == "ok") ? $params_formated['data'] : [];
        return (!empty($params['multiple']) && $params['multiple'] == "1") ? true : false;
    }

    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {

        $values = [];
        $value_display = "";
        $liste = $this->getFieldListe(base64_decode($champ["params"]));
        if (strpos($value, "^,^") === false) {
            $value = str_replace("^", "", $value);
            $values[] = $value;
        } else {
            $value = substr($value, 1, -1) ;
            $values = explode("^,^", $value ) ;
        }
        foreach ($liste as $index => $valeur) {
            if (in_array($index, $values)) {
                $value_display .= $valeur. ", ";
            }
        }

        $value_display = substr($value_display, 0, -2);
        return (!empty($value_display)) ? html_entity_decode($value_display) : "";
    }

    public static function getLibelle()
    {
        return "Liste référentiel";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeListe_referentiel::getLibelle(),
            'icon' => 'fas fa-list-ol',
            'route' => '/champs/?type=liste_referentiel',
            'attributes' => '',
        ];
    }
}