<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;
use Configurator;

class OdePourcentage extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean			    $bean: Bean du module OPS_dossier
     * @param boolean			$editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();

        // On récupere la valeur à afficher
        $value = ( !empty($this->getFieldValue($value_bdd)))? $this->getFieldValue($value_bdd) . " %": "" ;
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';
        $autre = ' data-separateur="'.$configuratorObj->config['default_number_grouping_seperator'].'" data-separateur-decimal="'.$configuratorObj->config['default_decimal_seperator'].'"';

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
    
        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("type", "text");
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("autre", ' data-type="number"'.$autre);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("aria", $champ["libelle"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/input_text.tpl");

        return $field_label . $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();

        $isDefaut = '';
        // On récupere la valeur à afficher
        if (empty($value_bdd) && $value_bdd !== "0") {
            $value = $this->getFieldDefautValue($champ["defaut"],$isDefaut);
        } else {
            $value = $this->getFieldValue($value_bdd);
        }

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';
        $minimum = '0';
        $maximum = '';
        $step = '0.01';
        $autre = ' data-decimal="1" rel="percentage" data-separateur="'.$configuratorObj->config['default_number_grouping_seperator'].'" data-separateur-decimal="'.$configuratorObj->config['default_decimal_seperator'].'"';

        $value = str_replace(',', '.', $value);

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("type", "number");
        $smarty->assign("minimum", $minimum);
        $smarty->assign("maximum", $maximum);
        $smarty->assign("step", $step);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("autre", $autre);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("isDefaut", $isDefaut);
        $smarty->assign("aria", $champ["libelle"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/input_pourcentage.tpl");

        return $field_label . $field_html;
    }

    public function getFieldValue($value_bdd)
    {
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();
        $value_fomated = (!empty($value_bdd) || $value_bdd == "0") ? number_format(floatval($value_bdd), 2, $configuratorObj->config['default_decimal_seperator'], ' ') : "";
        return (gettype($value_fomated) === "integer" && gettype($value_fomated) === "double" || gettype($value_fomated) === "string" && $value_bdd !== '') ? str_replace(" ", "", $value_fomated) : "";
    }

    public function getFieldDefautValue($value_defaut,&$isDefaut = null)
    {
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();
        $defautTab = json_decode( base64_decode($value_defaut), true);

        if(!empty($defautTab)){
            if($defautTab['defaut'] == 'autre'){
                $value_defaut = $defautTab['defaut_value']; 
            }
            elseif($defautTab['defaut'] == 'url'){
                $value_defaut = '';
                $isDefaut = 'data-defaut="url" data-url-attr="'.$defautTab['defaut_value'].'"';
            }
            else{
                $value_defaut = $this->getDefautValue($defautTab);
                if(!empty($defautTab['defaut']) && isset($isDefaut)){
                    $isDefaut = 'data-defaut="defaut"';
                }
            }
        }
        $value_fomated = (!empty($value_defaut) || $value_defaut == "0") ? number_format(floatval($value_defaut), 2, $configuratorObj->config['default_decimal_seperator'], ' ') : "";
        return (gettype($value_fomated) === "integer" && gettype($value_fomated) === "double" || gettype($value_fomated) === "string" && $value_defaut !== '') ? str_replace(" ", "", $value_fomated) : "";
    }

    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        $value_display = ( !empty($this->getFieldValue($value)))? $this->getFieldValue($value) . " %": "" ;
        return (!empty($value_display)) ? html_entity_decode($value_display) : "";
    }

    public static function getLibelle()
    {
        return "Pourcentage";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdePourcentage::getLibelle(),
            'icon' => 'fas fa-percent',
            'route' => '/champs/?type=pourcentage',
            'attributes' => '',
        ];
    }
}
