<link rel="stylesheet" href="https://unpkg.com/leaflet@1.8.0/dist/leaflet.css" integrity="sha512-hoalWLoI8r4UszCkZ5kL8vayOGVae1oxXe/2A4AO6J9+580uKHDO3JdHb7NzwwzK5xr/Fs0W40kiNHxM9vyTtQ==" crossorigin=""/>

<!-- Make sure you put this AFTER Leaflet's CSS -->
<script src="https://unpkg.com/leaflet@1.8.0/dist/leaflet.js" integrity="sha512-BB3hKbKWOc9Ez/TAwyWxNXeoV9c1v6FIeYiBieIWkpLjauysF18NzgR1MBNBXf8/KABdlkX68nAhlwcDFLGPCQ==" crossorigin=""></script>

{if $leaflet_view eq 'static'}
<script src="https://unpkg.com/dom-to-image@2.6.0/dist/dom-to-image.min.js"></script>
{/if}




<div {if !empty($id)} id="{$id}" {/if} data-type="{$adresse_geoloc}" data-latitude="{$latitude}" data-longitude="{$longitude}" data-zoom="{$zoom}" data-disablebpiban="{$disable_api_ban}" class="row field-line" style="width: -moz-available;width: -webkit-fill-available;" role="group" aria-label="{$aria}">
    
    <div id="{$id}-map" class="col-md-12" style="height: {$hauteur}px; margin-bottom: 10px;"></div>

    <input data-role="champ-formulaire" data-name="{$name}" id="{$id}_value" type="hidden" value="{$value}" data-conditions="{$conditions}" {$autre}>
    
    {$bouton_position}


    {if $disable_api_ban eq '1'}

    <div class="col-md-12 align-items-center d-flex">
        <div class="row field-line " style="width: -moz-available;width: -webkit-fill-available;">
            
            <div style="padding-bottom: 8px;" class="col-md-6 align-items-center d-flex">
                <div class="row field-line " style="width: -moz-available;width: -webkit-fill-available;">
                    <div style="padding-bottom: 8px;" class="col-md-12 align-items-center d-flex field-box" {$data_required} >
                        <div class="col-md-4 field-label">
                            <label>Adresse : </label>
                            <small data-role="message-champ" style="display: none;">Le champ est obligatoire </small>
                        </div>
                        <div class="col-md-8">
                            <textarea data-name="{$name_adresse_libre}" data-type-field="text_long" style="min-height: 74px;" data-role="champ-formulaire" data-conditions="{$conditions}" {$required} {$disabled}>{$value_adresse_libre}</textarea>
                        </div>
                    </div>
                </div>
            </div>

            <div style="padding-bottom: 8px;" class="col-md-6 align-items-center d-flex field-box">
                <div class="row field-line " style="width: -moz-available;width: -webkit-fill-available;">
                    <div style="padding-bottom: 8px;" class="col-md-12 align-items-center d-flex">
                        <div class="col-md-4 field-label">
                            <label>Latitude : </label>
                        </div>
                        <div class="col-md-8">
                            <input data-name="{$name_latitude}" type="text" disabled="disabled" value="{$value_latitude}">
                        </div>
                    </div>
                    <div style="padding-bottom: 8px;" class="col-md-12 align-items-center d-flex">
                        <div class="col-md-4 field-label">
                            <label>Longitude : </label>
                        </div>
                        <div class="col-md-8">
                            <input data-name="{$name_longitude}" type="text" disabled="disabled" value="{$value_longitude}">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {else}

    <fieldset class="row field-line">
        <legend class="sr-only">{$aria}</legend>
        <div class="col-md-6 align-items-center d-flex" style="padding-bottom: 8px;">
            <div class="col-md-4 field-label">
                <label>{$label_num_rue} : </label>
            </div>
            <div class="col-md-8">
                <input aria-label="{$aria} : {$label_num_rue}" data-name="{$name_numero}" type="text" {$disabled} value="{$value_numero}">
            </div>
        </div>
        <div class="col-md-6 align-items-center d-flex field-box" style="padding-bottom: 8px;" {$data_required} >
            <div class="col-md-4 field-label">
                <label>{$label_rue} : </label>
                <small data-role="message-champ" style="display: none;">Le champ est obligatoire </small>
            </div>
            <div class="col-md-8">
                <input aria-label="{$aria} : {$label_rue}" data-name="{$name_rue}" type="text" data-role="champ-formulaire" {$required} {$disabled} value="{$value_rue}">
            </div>
        </div>

        <div class="col-md-6 align-items-center d-flex" style="padding-bottom: 8px;">
            <div class="col-md-4 field-label">
                <label>{$label_bat_etage} </label>
            </div>
            <div class="col-md-8">
                <input aria-label="{$aria} : {$label_bat_etage}" data-name="{$name_complement_batiment}" type="text" {$disabled} value="{$value_complement_batiment}">
            </div>
        </div>
        <div class="col-md-6 align-items-center d-flex" style="padding-bottom: 8px;">
            <div class="col-md-4 field-label">
                <label>{$label_lieu_dit}</label>
            </div>
            <div class="col-md-8">
                <input aria-label="{$aria} : {$label_lieu_dit}" data-name="{$name_complement_lieu}" type="text" {$disabled} value="{$value_complement_lieu}">
            </div>
        </div>

        <div class="col-md-6 align-items-center d-flex field-box" style="padding-bottom: 8px;" {$data_required} >
            <div class="col-md-4 field-label">
                <label>{$label_code_postal} : </label>
                <small data-role="message-champ" style="display: none;">Le champ est obligatoire </small>
            </div>
            <div class="col-md-8">
                <input aria-label="{$aria} : {$label_code_postal}" data-name="{$name_code_postal}" type="text" data-role="champ-formulaire" {$required} {$disabled} value="{$value_code_postal}">
            </div>
        </div>
        <div class="col-md-6 align-items-center d-flex field-box" style="padding-bottom: 8px;" {$data_required} >
            <div class="col-md-4 field-label">
                <label>{$label_ville} : </label>
                <small data-role="message-champ" style="display: none;">Le champ est obligatoire </small>
            </div>
            <div class="col-md-8">
                <input aria-label="{$aria} : {$label_ville}" data-name="{$name_ville}" type="text" data-role="champ-formulaire" {$required} {$disabled} value="{$value_ville}">
            </div>
        </div>
        <div class="col-md-6 align-items-center d-flex" style="padding-bottom: 8px;">
            <div class="col-md-4 field-label">
                <label>Latitude : </label>
            </div>
            <div class="col-md-8">
                <input aria-label="{$aria} : Latitude" data-name="{$name_latitude}" type="text" disabled="disabled" value="{$value_latitude}">
            </div>
        </div>
        <div class="col-md-6 align-items-center d-flex" style="padding-bottom: 8px;">
            <div class="col-md-4 field-label">
                <label>Longitude : </label>
            </div>
            <div class="col-md-8">
                <input aria-label="{$aria} : Longitude" data-name="{$name_longitude}" type="text" disabled="disabled" value="{$value_longitude}">
            </div>
        </div>
    </fieldset>
    
    {/if}

</div>


<!-- MODALE ADRESSE TROUVE -->
<div id="{$id}-modal-adresse" 
     class="modal" 
     role="dialog"
     aria-labelledby="{$id}-titre_modal_trouve"
     aria-describedby="{$id}-modal-adresse-body"
     aria-modal="true" 
     tabindex="-1">
  <div class="modal-dialog" style="max-width: 800px;">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="{$id}-titre_modal_trouve">Adresses trouvées</h4>
        <button type="button" class="button" aria-label="Fermer la fenêtre modale" onclick="jQuery('#{$id}-modal-adresse').modal('hide');">
            <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div data-role="etape-formulaire" id="{$id}-modal-adresse-body" class="modal-body"></div>
    </div>
  </div>
</div>