<?php

namespace ODE\Model;

use ODE\Helper\OdeArrayHelper;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);


class DossierModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe DossierModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données de la personne morale en tableau
     *
     *  @return array               - $appairage: retourne l'appairage de la personne morale
     */
    public function getBean()
    {

        global $db;
        $dossiers = array();

        $sql = "SELECT * FROM `ops_dossier` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $dossiers[] = $row;
        }
        return (!empty($dossiers) && count($dossiers) === 1) ? $dossiers[0] : array();
    }

    /**
     * @access public
     * @name getChamps()
     * Fonction qui retourne les noms des champs
     *
     *  @return array               - $appairage: retourne l'appairage de la personne morale
     */
    public function getChamps()
    {

        $champs = [];
        $champs_exclu = ["id", "name", "date_entered", "date_modified", "modified_user_id", "created_by", "deleted", "num_dossier", "doublon", "ops_etape_id", "ops_statut_id"];
        $dossier = $this->getBean();

        foreach ($dossier as $champ_name => $champ_value) {
            if (!in_array($champ_name, $champs_exclu)) {
                $champs[] = $champ_name;
            }
        }

        return $champs;
    }

    /**
     * @access public
     * @name getDemandeurType()
     * Fonction qui retourne le type de demandeur du dossier
     *
     *  @return array               - $demandeur_type : le type de demandeur "Individu" ou "Personne Morale"
     */
    public function getCustomChamps()
    {

        $champs_custom = array();
        $dossier = $this->getBean();
        if (is_array($dossier) && count($dossier) > 0 && !empty($dossier['champs_custom'])) {
            $retour_json_to_array = OdeArrayHelper::jsonToArray(base64_decode($dossier['champs_custom']));
            if ($retour_json_to_array['statut'] === "ok") {
                $champs_custom = $retour_json_to_array['data'];
            } else {
                $GLOBALS['log']->fatal(" DossierModel :: getCustomChamps => Erreur récupération des champs custom ( " . $retour_json_to_array['data'] . " ) ");
            }
        }
        return $champs_custom;
    }
    /**
     * @access public
     * @name getAppairage()
     * Fonction qui retourne l'id du dossier par num 
     *
     *  @return array               - $dossier_id : l'id du dossier
     */
    public static function getDossierIdByNum($dossier_num)
    {

        global $db;
        $dossier = array();
        $sql = "SELECT * FROM `ops_dossier` WHERE `num_dossier` = '" . $dossier_num . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $dossier[] = $row;
        }
        return (!empty($dossier) && count($dossier) === 1) ? $dossier[0]["id"] : "";
    }

    /**
     * @access public
     * @name getAppairage()
     * Fonction qui retourne l'id du dossier par num 
     *
     *  @return array               - $dossier_id : l'id du dossier
     */
    public static function getNum($id)
    {

        global $db;
        $dossier = array();
        $sql = "SELECT * FROM `ops_dossier` WHERE `id` = '" . $id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $dossier[] = $row;
        }
        return (!empty($dossier) && count($dossier) === 1 && !empty($dossier[0]["num_dossier"])) ? $dossier[0]["num_dossier"] : "";
    }


    /**
     * @access public
     * @name getAppairage()
     * Fonction qui retourne l'appairage de la personne morale
     *
     *  @return array               - $appairage: retourne l'appairage de la personne morale
     */
    public function getAppairage()
    {

        global $db;
        $appairages = array();

        $sql = "SELECT * FROM `ops_appairage` WHERE `parent_type` = 'OPS_dossier' AND `parent_id` = '" . $this->id . "' AND `logiciel` = 'gestionfin' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $appairages[] = $row;
        }

        return (!empty($appairages) && count($appairages) === 1) ? $appairages[0] : array();
    }

    /**
     * @access public
     * @name getAppairageName()
     * Fonction qui retourne le nom de l'appairage de la personne morale
     *
     *  @return array               - $appairage_name : retourne le nom de l'appairage de la personne morale
     */
    public function getAppairageName()
    {

        $appairage_name = "";
        $appairage = $this->getAppairage();
        if (!empty($appairage) && count($appairage) > 0) {
            if (!empty($appairage['name']) && !empty($appairage['statut']) && $appairage['statut'] === "ok") {
                $appairage_name = $appairage['name'];
            }
        }
        return $appairage_name;
    }

    /**
     * @access public
     * @name getDemandeurType()
     * Fonction qui retourne le type de demandeur du dossier
     *
     *  @return array               - $demandeur_type : le type de demandeur "Individu" ou "Personne Morale"
     */
    public function getDemandeurType()
    {

        $dossier = $this->getBean();
        return (!empty($dossier) && count($dossier) > 0 && !empty($dossier['type_tiers'])) ? $dossier['type_tiers'] : "";
    }

    /**
     * @access public
     * @name getDemandeurType()
     * Fonction qui retourne le type de demandeur du dossier
     *
     *  @return array               - $demandeur_type : le type de demandeur "Individu" ou "Personne Morale"
     */
    public function getDemandeurName()
    {
        global $db;
        $demandeurs = array();
        $demandeur_id = $this->getDemandeurId();
        $demandeur_type = $this->getDemandeurType();
        if ($demandeur_type === "OPS_personne_morale") {
            $sql = " SELECT `name` FROM `ops_personne_morale` WHERE `id` = '" . $demandeur_id . "' AND `deleted` = '0' ";
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                $demandeurs[] = $row;
            }
            return (!empty($demandeurs) && count($demandeurs) === 1) ? $demandeurs[0]['name'] : "";
        }
        if ($demandeur_type === "OPS_individu") {
            $sql = " SELECT * FROM `ops_individu` WHERE `id` = '" . $demandeur_id . "' AND `deleted` = '0' ";
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                $demandeurs[] = $row;
            }
            return (!empty($demandeurs) && count($demandeurs) === 1) ? $demandeurs[0]['salutation'] . " " . $demandeurs[0]['first_name'] . " " . $demandeurs[0]['last_name'] : "";
        }

        return "";
    }

    /**
     * @access public
     * @name getDemandeurType()
     * Fonction qui retourne le type de demandeur du dossier
     *
     *  @return array               - $demandeur_type : le type de demandeur "Individu" ou "Personne Morale"
     */
    public static function getNameDemandeurByTypeAndId($type, $id)
    {
        global $db;

        if ($type === "OPS_personne_morale") {
            $sql = " SELECT `name` FROM `ops_personne_morale` WHERE `id` = '" . $id . "' AND `deleted` = '0' ";
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                $demandeurs[] = $row;
            }
            return (!empty($demandeurs) && count($demandeurs) === 1) ? $demandeurs[0]['name'] : "";
        }

        if ($type === "OPS_individu") {
            $sql = " SELECT * FROM `ops_individu` WHERE `id` = '" . $id . "' AND `deleted` = '0' ";
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                $demandeurs[] = $row;
            }
            return (!empty($demandeurs) && count($demandeurs) === 1) ? $demandeurs[0]['salutation'] . " " . $demandeurs[0]['first_name'] . " " . $demandeurs[0]['last_name'] : "";
        }

        if ($type === "OPE_enfants") {
            $sql = " SELECT * FROM `ope_enfants` WHERE `id` = '" . $id . "' AND `deleted` = '0' ";
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                $demandeurs[] = $row;
            }
            return (!empty($demandeurs) && count($demandeurs) === 1) ? $demandeurs[0]['first_name'] . " " . $demandeurs[0]['last_name'] : "";
        }

        return "";
    }

    /**
     * @access public
     * @name getDemandeurId()
     * Fonction qui retourne l'id du demandeur
     *
     *  @return array               - $demandeur_id : retourne l'id du demandeur si il existe
     */
    public function getDemandeurId()
    {

        $demandeur_type = $this->getDemandeurType();

        if ($demandeur_type === "OPS_personne_morale") {
            return $this->getPersonneMoraleId();
        }

        if ($demandeur_type === "OPS_individu") {
            return $this->getIndividuId();
        }

        return "";
    }

    /**
     * @access public
     * @name getIndividuId()
     * Fonction qui retourne 
     *
     *  @return array       
     */
    public function getIndividuId()
    {
        global $db;
        $sql = " SELECT `ops_individu_id` FROM `ops_individu_ops_dossier` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $demandeurs[] = $row;
        }
        return (!empty($demandeurs) && count($demandeurs) === 1) ? $demandeurs[0]['ops_individu_id'] : "";
    }

    /**
     * @access public
     * @name getPersonneMoraleId()
     * Fonction qui retourne 
     *
     *  @return array       
     */
    public function getPersonneMoraleId()
    {
        global $db;
        $sql = " SELECT `ops_personne_morale` FROM `ops_dossier` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $demandeurs[] = $row;
        }
        return (!empty($demandeurs) && count($demandeurs) === 1) ? $demandeurs[0]['ops_personne_morale_id'] : "";
    }

    /**
     * @access public
     * @name getDispositifId()
     * Fonction qui retourne l'id du dispositif
     *
     *  @return array               - $dispositif_id : retourne l'id du dispositif si il existe
     */
    public function getDispositifId()
    {

        global $db;
        $dispositifs = array();
        $sql = " SELECT `ops_dispositif_id` FROM `ops_dispositif_ops_dossier` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $dispositifs[] = $row;
        }
        return (!empty($dispositifs) && count($dispositifs) === 1) ? $dispositifs[0]['ops_dispositif_id'] : "";
    }

    /**
     * @access public
     * @name getDispositifName()
     * Fonction qui retourne l'id du dispositif
     *
     *  @return array               - $dispositif_id : retourne l'id du dispositif si il existe
     */
    public function getDispositifName()
    {

        global $db;
        $dispositifs = array();
        $dispositif_id = $this->getDispositifId();
        $sql = " SELECT `name` FROM `ops_dispositif` WHERE `id` = '" . $dispositif_id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $dispositifs[] = $row;
        }
        return (!empty($dispositifs) && count($dispositifs) === 1) ? $dispositifs[0]['name'] : "";
    }

    /**
     * @access public
     * @name getCampagneName()
     * Fonction qui retourne l'id du dispositif
     *
     *  @return array               - $campagne_id : retourne l'id du dispositif si il existe
     */
    public function getCampagneName()
    {
        global $db;
        $campagnes = array();
        $campagne_id = $this->getCampagneId();
        $sql = " SELECT `name` FROM `ops_campagne` WHERE `id` = '" . $campagne_id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $campagnes[] = $row;
        }
        return (!empty($campagnes) && count($campagnes) === 1) ? $campagnes[0]['name'] : "";
    }

    /**
     * @access public
     * @name getCampagneId()
     * Fonction qui retourne l'id du campagne
     *
     *  @return array               - $campagne_id : retourne l'id du campagne si il existe
     */
    public function getCampagneId()
    {

        global $db;
        $campagnes = array();
        $sql = " SELECT `ops_campagne_id` FROM `ops_campagne_ops_dossier` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $campagnes[] = $row;
        }
        return (!empty($campagnes) && count($campagnes) === 1) ? $campagnes[0]['ops_campagne_id'] : "";
    }

    /**
     * @access public
     * @name getReunionIds()
     * Fonction qui retourne l'id du reunion
     *
     *  @return array               - $reunion_id : retourne l'id du reunion si il existe
     */
    public function getReunionIds()
    {

        global $db;
        $reunions = array();
        $sql = " SELECT `ops_reunion_id` FROM `ops_reunion_ops_dossier` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $reunions[] = $row['ops_reunion_id'];
        }
        return $reunions;
    }

    /**
     * @access public
     * @name getReunions()
     * Fonction qui retourne l'id du reunion
     *
     *  @return array               - $reunions : retourne l'id du reunion si il existe
     */
    public function getReunions()
    {
        $reunions = [];
        $reunion_ids = $this->getReunionIds();
        if (is_array($reunion_ids) && count($reunion_ids) > 0) {
            foreach ($reunion_ids as $reunion_id) {
                $reunionModel = new ReunionModel($reunion_id);
                $reunions[] = ["id" => $reunion_id, "name" => $reunionModel->getName()];
            }
        }
        return $reunions;
    }
    /**
     * @access public
     * @name getCommissions()
     * Fonction qui retourne l'id du reunion
     *
     *  @return array               - $reunions : retourne l'id du reunion si il existe
     */
    public function getCommissions()
    {
        $commissions = [];
        $commission_ids = $this->getCommissionIds();
        if (is_array($commission_ids) && count($commission_ids) > 0) {
            foreach ($commission_ids as $commission_id) {
                $commissionModel = new CommissionModel($commission_id);
                $commissions[] = ["id" => $commission_id, "name" => $commissionModel->getName()];
            }
        }
        return $commissions;
    }

    /**
     * @access public
     * @name getContrat()
     * Fonction qui retourne l'id du reunion
     *
     *  @return array               - $reunions : retourne l'id du reunion si il existe
     */
    public function getContrats()
    {
        $contrats = [];
        $contrat_ids = $this->getContratIds();
        if (is_array($contrat_ids) && count($contrat_ids) > 0) {
            foreach ($contrat_ids as $contrat_id) {
                $contratModel = new ContratModel($contrat_id);
                $contrats[] = ["id" => $contrat_id, "name" => $contratModel->getName()];
            }
        }
        return $contrats;
    }

    /**
     * @access public
     * @name getContrat()
     * Fonction qui retourne l'id du sous territoire
     *
     *  @return array               - $sousTerritoire : retourne l'id du territoire si il existe
     */
    public function getSousTerritoire()
    {
        $sousTerritoires = [];
        $sousTerritoire_ids = $this->getSousTerritoireIds();
        if (is_array($sousTerritoire_ids) && count($sousTerritoire_ids) > 0) {
            foreach ($sousTerritoire_ids as  $sousTerritoireId) {
                $objSousTerritoire = BeanFactory::getBean('OPS_sous_territoire',$sousTerritoireId);
                $sousTerritoires[] = ["id" => $sousTerritoireId, "name" => $objSousTerritoire->name];
            }
        }
        return $sousTerritoires;
    }

    /**
     * @access public
     * @name getElus()
     * Fonction qui retourne l'id du reunion
     *
     *  @return array               - $reunions : retourne l'id du reunion si il existe
     */
    public function getElus()
    {
        $elus = [];
        $elu_ids = $this->getEluIds();
        if (is_array($elu_ids) && count($elu_ids) > 0) {
            foreach ($elu_ids as $elu_id) {
                $eluModel = new EluModel($elu_id);
                $elus[] = ["id" => $elu_id, "name" => $eluModel->getNomComplet()];
            }
        }
        return $elus;
    }

    /**
     * @access public
     * @name getCommissionIds()
     * Fonction qui retourne l'id du commission
     *
     *  @return array               - $commission_id : retourne l'id du commission si il existe
     */
    public function getCommissionIds()
    {

        global $db;
        $commissions = array();
        $sql = " SELECT `ops_commission_id` FROM `ops_commission_ops_dossier` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $commissions[] = $row['ops_commission_id'];
        }
        return $commissions;
    }

    /**
     * @access public
     * @name getContratIds()
     * Fonction qui retourne l'id du contrat
     *
     *  @return array               - $contrat_id : retourne l'id du contrat si il existe
     */
    public function getContratIds()
    {

        global $db;
        $contrats = array();
        $sql = " SELECT `ops_contrat_id` FROM `ops_contrat_ops_dossier` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $contrats[] = $row['ops_contrat_id'];
        }
        return $contrats;
    }

    /**
     * @access public
     * @name getLocalisationIds()
     * Fonction qui retourne l'id du localisation
     *
     *  @return array               - $localisation_id : retourne l'id du localisation si il existe
     */
    public function getLocalisationIds()
    {

        global $db;
        $localisations = array();
        $sql = " SELECT `ops_localisation_id` FROM `ops_dossier_ops_localisation` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $localisations[] = $row['ops_localisation_id'];
        }
        return $localisations;
    }


    /**
     * @access public
     * @name getLocalisationIds()
     * Fonction qui retourne l'id du localisation
     *
     *  @return array               - $localisation_id : retourne l'id du localisation si il existe
     */
    public function getNotesIds()
    {

        global $db;
        $localisations = array();
        $sql = " SELECT `note_id` FROM `ops_dossier_notes` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $localisations[] = $row['note_id'];
        }
        return $localisations;
    }


    /**
     * @access public
     * @name getLocalisationIds()
     * Fonction qui retourne l'id du localisation
     *
     *  @return array               - $localisation_id : retourne l'id du localisation si il existe
     */
    public function getSousTerritoireIds()
    {

        global $db;
        $localisations = array();
        $sql = " SELECT `ops_sous_territoire_id` FROM `ops_sous_territoire_ops_dossier` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $localisations[] = $row['ops_sous_territoire_id'];
        }
        return $localisations;
    }


    /**
     * @access public
     * @name getLocalisationIds()
     * Fonction qui retourne l'id du localisation
     *
     *  @return array               - $localisation_id : retourne l'id du localisation si il existe
     */
    public function getTrancheIds()
    {

        global $db;
        $localisations = array();
        $sql = " SELECT `ops_tranche_id` FROM `ops_tranche_ops_dossier` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $localisations[] = $row['ops_tranche_id'];
        }
        return $localisations;
    }

    /**
     * @access public
     * @name getEngagementIds()
     * Fonction qui retourne l'id du engagement
     *
     *  @return array               - $engagement_id : retourne l'id du engagement si il existe
     */
    public function getEngagementIds()
    {

        global $db;
        $engagements = array();
        $sql = " SELECT `ops_engagement_id` FROM `ops_engagement_ops_dossier` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $engagements[] = $row['ops_engagement_id'];
        }
        return $engagements;
    }

    /**
     * @access public
     * @name getEluIds()
     * Fonction qui retourne l'id des élus
     *
     *  @return array               - $elu_id 
     */
    public function getEluIds()
    {

        global $db;
        $engagements = array();
        $sql = " SELECT `ops_elu_id` FROM `ops_elu_ops_dossier` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $engagements[] = $row['ops_elu_id'];
        }
        return $engagements;
    }

    /**
     * @access public
     * @name getListeIdsByType()
     * Fonction qui retourne la liste des dossiers par type type
     *
     *  @return array               - $dossiers_ids: retourne l'appairage de la personne morale
     */
    public function getListeIds($type_tiers = null)
    {

        global $db;
        $dossiers = array();
        if ($type_tiers === "Personne Morale" || $type_tiers === "Individu") {
            $sql = "SELECT * FROM `ops_dossier` WHERE `type_tiers` = '" . $type_tiers . "' AND `deleted` = '0' AND `name` != 'TEMP' ";
        } else {
            $sql = "SELECT * FROM `ops_dossier` WHERE `deleted` = '0' AND `name` != 'TEMP' ";
        }
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            if (array_key_exists("id", $row)) {
                $dossiers[] = $row["id"];
            }
        }
        return (!empty($dossiers) && count($dossiers) > 0) ? $dossiers : array();
    }

    /**
     * @access public
     * @name getNumDossier()
     * Fonction qui retourne le dernier num_dossier sinon 1
     * 
     *  @return int       $last_num_dossier : le dernier numéro dossier
     */
    public static function getNumDossier($id)
    {

        global $db;
        $last_num_dossier = 0;
        $requete = "SELECT num_dossier FROM ops_dossier WHERE id = '" . $id . "'";
        $resultat = $db->query($requete);

        if ($resultat) {
            if ($db->getRowCount($resultat) !== 0) {
                $dossier = $db->fetchByAssoc($resultat);
                if (!empty($dossier['num_dossier'])) {
                    $last_num_dossier = $dossier['num_dossier'];
                }
            }
        } else {
            $GLOBALS['log']->fatal(" OPS_dossier :: initNumDossier => Erreur requete SQL = " . print_r($db->lastError(), true));
        }

        return $last_num_dossier;
    }

    /**
     * @access public
     * @name getDossiers()
     * Fonction qui retourne l'id du dossier
     *
     *  @return array               - $dossiers : retourne l'id du dossier si il existe
     */
    public function getDossiersLies()
    {
        $dossiers = [];
        $dossier_ids = $this->getDossierIds();
        if (is_array($dossier_ids) && count($dossier_ids) > 0) {
            foreach ($dossier_ids as $dossier_id) {
                $dossierObj = BeanFactory::getBean('OPS_dossier', $dossier_id);
                $name = (!empty($dossierObj->dossier_libelle)) ? $dossierObj->name . ' - ' . $dossierObj->dossier_libelle : $dossierObj->name . ' - ' . $dossierObj->ops_dispositif_ops_dossier_name;
                $dossiers[] = ["id" => $dossier_id, "name" => $name];
            }
        }
        return $dossiers;
    }

    /**
     * @access public
     * @name getDossierIds()
     * Fonction qui retourne l'id du dossier
     *
     *  @return array               - $dossier_id : retourne l'id du dossier si il existe
     */
    public function getDossierIds()
    {

        global $db;
        $dossiers = array();
        $sql = " SELECT `ops_dossier_id2` FROM `ops_dossier_ops_dossier` WHERE `ops_dossier_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $dossiers[] = $row['ops_dossier_id2'];
        }
        return $dossiers;
    }
}