<?php

namespace ODE\Notification;


use BeanFactory;
use EmailTemplate;
use SugarPHPMailer;
use Email;
use Note;
use ODE\Helper\OdePdfHelper;

if (!defined('sugarEntry')) define('sugarEntry', true);

class OdeNotification
{

    /**
     * Constructeur de la classe DemandeurModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct()
    {

    }


public function sendMail($email_template_id, $objet_source, $email_destinataire_to = '', $email_destinataire_cc = '', $email_destinataire_cci = '', $historisation_type = '', $historisation_id = '' , $with_pdf = false)
    {
        global $beanFiles, $sugar_config, $timedate, $current_user, $app_strings;
        include_once $beanFiles['EmailTemplate'];
        include_once 'include/SugarPHPMailer.php';
        include_once $beanFiles['OPS_individu'];

        $retour = false ; 


        // Récupération du template de mail => sinon rien 
        $obj_email_template = new EmailTemplate();
        $obj_email_template->retrieve($email_template_id);

        if (isset($obj_email_template->id)) {

            // Construction de l'objet mail 
            $obj_mail     = new SugarPHPMailer();
            $obj_mail->setMailerForSystem();

            $nom_objet = $objet_source->object_name;

            $body      = $obj_email_template->body;
            $html_body = $obj_email_template->body_html;
            $sujet     = $obj_email_template->subject;

            $filename = "" ;

            // Remplacement des variables selon l'objet source 
            switch ($nom_objet) {
                case 'OPS_dossier':
                    $body      = $this->remplaceChampsDossier($objet_source, $body);
                    $html_body = $this->remplaceChampsDossier($objet_source, $html_body);
                    $sujet     = $this->remplaceChampsDossier($objet_source, $sujet);

                    if( $with_pdf == true ){
                        $OdePdf  = new OdePdfHelper($objet_source->id, 'usager', 'mail');
                        $ode_pdf = $OdePdf->generer();
                        $filename = 'dossier_' . $objet_source->num_dossier . '.pdf';
                        $file_location = $_SERVER['DOCUMENT_ROOT'] . 'upload/'.$filename;
                        $obj_mail->AddAttachment($file_location);
                    }
                    break;
                case 'OPS_individu':
                    $body      = $this->remplaceChampsIndividu($objet_source, $body);
                    $html_body = $this->remplaceChampsIndividu($objet_source, $html_body);
                    $sujet     = $this->remplaceChampsIndividu($objet_source, $sujet);
                    break;
                case 'OPS_personne_morale':
                    $body      = $this->remplaceChampsProfil($objet_source, $body);
                    $html_body = $this->remplaceChampsProfil($objet_source, $html_body);
                    $sujet     = $this->remplaceChampsProfil($objet_source, $sujet);
                    break;
                
            }
            

            // Récupération de la configuration -> page admin 
            $obj_conf_mail = new Email();
            $defaults = $obj_conf_mail->getSystemDefaultEmail();
            $obj_mail->From     = $defaults['email'];
            $obj_mail->FromName = $defaults['name'];

            // Clear les destinataires de l'objet
            $obj_mail->ClearAllRecipients();
            $obj_mail->ClearReplyTos();

            $obj_mail->Subject = from_html($sujet);

            // Envoyer en texte brut ? 
            if ($obj_email_template->text_only == 1) {
                $obj_mail->Body_html = from_html($html_body);
                $obj_mail->Body      = from_html($body);
            } else {
                $obj_mail->IsHTML(true);
                $obj_mail->Body    = from_html($html_body);
                $obj_mail->AltBody = from_html($body);
            }

           // Préparation des destinataires TO / CC / CCI 
           $obj_mail->prepForOutbound();
            if (!empty($email_destinataire_to)) {
                $liste_destinataires = explode(";", $email_destinataire_to);
                foreach ($liste_destinataires as  $adresse) {
                    if (!empty(trim($adresse))) {
                        $obj_mail->AddAddress(trim($adresse));
                    }
                }
            }
            if (!empty($email_destinataire_cc)) {
                $liste_destinataires_cc = explode(";", $email_destinataire_cc);
                foreach ($liste_destinataires_cc as $adresse) {
                    if (!empty(trim($adresse))) {
                        $obj_mail->AddCC(trim($adresse));
                    }
                }
            }
            if (!empty($email_destinataire_cci)) {
                $liste_destinataires_cci = explode(";", $email_destinataire_cci);
                foreach ($liste_destinataires_cci as $adresse) {
                    if (!empty(trim($adresse))) {
                        $obj_mail->AddBCC(trim($adresse));
                    }
                }
            }
            
            // Si existe des destinataires 
            if ( !empty($email_destinataire_to) || !empty($email_destinataire_cc) || !empty($email_destinataire_cci) ) {

                $is_send = @$obj_mail->Send();

                // Si le mail est envoyé => historisation du mail sur l'objet
                if ($is_send == true && !empty($historisation_type) && !empty($historisation_id)) {

                    $obj_conf_mail->team_id          = 1;
                    $obj_conf_mail->type             = 'archived';
                    $obj_conf_mail->name             = $obj_mail->Subject;
                    $obj_conf_mail->description      = $obj_mail->AltBody;
                    $obj_conf_mail->description_html = $obj_mail->Body;
                    $obj_conf_mail->from_addr        = $obj_mail->From;
                    $obj_conf_mail->parent_type      = $historisation_type;
                    $obj_conf_mail->parent_id        = $historisation_id;
                    $obj_conf_mail->date_sent        = $timedate->now();
                    $obj_conf_mail->status           = 'sent';
                    $email_id                        = $obj_conf_mail->save();
                    
                    if( file_exists($file_location )){

                        $obj_note                   = new Note();
                        $obj_note->type             = 'archived';
                        $obj_note->filename         = $filename;
                        $obj_note->name             = $filename;
                        $obj_note->file_mime_type   = "application/pdf";
                        $obj_note->assigned_user_id = $bean->assigned_user_id;
                        $obj_note->parent_id        = $email_id;
                        $obj_note->parent_type      = "Emails";
                        $note_id = $obj_note->save();
                        unlink($file_location);
                    }

                    if( empty( $email_id  ) ){
                        $GLOBALS['log']->fatal( "OdeNotification :  sendMail - Erreur lors de l'historisation du mail" );
                    }
                    else{
                        $retour = true ; 
                    }

                } else {
                   $GLOBALS['log']->fatal( "OdeNotification :  sendMail - Erreur lors de l'historisation du mail" );
                }
            }
            else {
                $GLOBALS['log']->fatal( "OdeNotification :  sendMail - Aucun destinataire" );
            }
        } else {
            $GLOBALS['log']->fatal( "OdeNotification :  sendMail - Template email inconnu" );
        }
        return $retour;
    }

    function remplaceChampsDossier($bean, $texte) {
        global $sugar_config, $beanList, $beanFiles, $app_list_strings;

        $texte_retour = $texte;

        if ($bean->object_name != 'OPS_dossier') {
            return $texte;
        }

        // Gestion du dispositif
        $texte_retour = str_replace('$ops_dossier_ops_dispositif_ops_dossier_name', $bean->ops_dispositif_ops_dossier_name , $texte_retour);

        // boucle de remplacement des champs de la dossier dans le mail
        foreach ($bean->field_defs as $field) {
            $field_name = $field['name'];

            if (isset($bean->$field_name) && !(is_a($bean->$field_name, 'Link2')) && ($field_name != 'email') ) {

                $field_value = $bean->$field_name;
                if (preg_match("^date_\w*",$field_name)){
                    $field_value = $this->format_date($bean->$field_name);
                }
                if ($field_name == 'ops_statut_id'){
                    $objStatut = BeanFactory::getBean('OPS_statut', $bean->$field_name);
                    $field_value = $objStatut->name;
                }
                if ($field_name == 'ops_etape_id'){
                    $objEtape = BeanFactory::getBean('OPS_etape', $bean->$field_name);
                    $field_value = $objEtape->name;
                }
                if(preg_match("^ops_individu\d*_id$",$field_name)){
                    $objIndividu = BeanFactory::getBean('OPS_individu', $bean->$field_name);
                    $field_value = $objIndividu->salutation+' '+$objIndividu->firdt_name+' '+$objIndividu->last_name;
                }
                if($field_name == 'ops_exercice_id' && !empty($bean->$field_name)){
                    $objExercice = BeanFactory::getBean('OPS_exercice', $bean->$field_name);
                    $field_value = $objExercice->name;
                }
                $texte_retour = str_replace('$ops_dossier_'.$field_name, $field_value, $texte_retour);
            }
        }

        // Initialisation des champs du beneficiaire
        $beneficiaire = BeanFactory::getBean('OPS_individu', $bean->beneficiaire_id);
        if (!empty($beneficiaire)) {
            $texte_retour = $this->remplaceChampsIndividu( $beneficiaire, $texte_retour );
        }

        // Initialisation des champs du demandeur
        $demandeur = BeanFactory::getBean('OPS_individu', $bean->ops_individu_id);
        if (!empty($demandeur)) {
            $texte_retour = $this->remplaceChampsIndividu( $demandeur, $texte_retour );
        }
        
        // Initialisation des champs du profil
        $profil = BeanFactory::getBean('OPS_personne_morale', $bean->ops_personne_morale);
        if (!empty($profil)) {
            $texte_retour = $this->remplaceChampsProfil( $profil, $texte_retour );
        }

        # Surchage BON
        if(isset($app_list_strings['moduleList']['OPS_bon'])){
            //Initialisation des champs du bon
            $bon = BeanFactory::getBean('OPS_bon', $bean->ops_bon);
            if (!empty($bon)) {
                $texte_retour = $this->remplaceChampsBons($bon, $texte_retour);
            }
        }
        # Fin Surcharge

        // Remplacement des champs utilisateur
        $texte_retour = $this->remplaceChampsUsers($bean, $texte_retour);

        return $texte_retour;
    }

    function remplaceChampsBons($bean, $texte)
    {
        global $sugar_config, $beanList, $beanFiles;

        $texte_retour = $texte;

        if ($bean->object_name != 'OPS_bon') {
            return $texte;
        }

        // boucle de remplacement des champs de l'individu dans le mail
        foreach ($bean->field_defs as $field) {
            $field_name = $field['name'];
            if (isset($bean->$field_name) && !(is_a($bean->$field_name, 'Link2')) && ($field_name != 'email')) {
                $field_value = $bean->$field_name;
                if (preg_match("^date_\w*", $field_name)) {
                    $field_value = $this->format_date($bean->$field_name);
                }
                $texte_retour = str_replace('$ops_bon_' . $field_name, $field_value, $texte_retour);
            }
        }
        return $texte_retour;
    }
    
    function remplaceChampsIndividu($bean, $texte) {
        global $sugar_config, $beanList, $beanFiles;

        $texte_retour = $texte;

        if ($bean->object_name != 'OPS_individu') {
            return $texte;
        }

        // boucle de remplacement des champs de l'individu dans le mail
        foreach ($bean->field_defs as $field) {
            $field_name = $field['name'];
            if (isset($bean->$field_name) && !(is_a($bean->$field_name, 'Link2')) && ($field_name != 'email') ) {
                $field_value = $bean->$field_name;
                if (preg_match("^date_\w*",$field_name)){
                    $field_value = $this->format_date($bean->$field_name);
                }
                $texte_retour = str_replace('$ops_individu_'.$field_name, $field_value, $texte_retour);
                $texte_retour = str_replace('$demandeur_'.$field_name, $field_value, $texte_retour);
                $texte_retour = str_replace('$beneficiaire_'.$field_name, $field_value, $texte_retour);
            }
        }
        return $texte_retour;
    }

    function remplaceChampsProfil($bean, $texte) {
        global $sugar_config, $beanList, $beanFiles;

        $texte_retour = $texte;

        if ($bean->object_name != 'OPS_personne_morale') {
            return $texte;
        }

        // boucle de remplacement des champs de l'individu dans le mail
        foreach ($bean->field_defs as $field) {
            $field_name = $field['name'];
            if (isset($bean->$field_name) && !(is_a($bean->$field_name, 'Link2')) && ($field_name != 'email') ) {
                $field_value = $bean->$field_name;
                if (preg_match("^date_\w*",$field_name)){
                    $field_value = $this->format_date($bean->$field_name);
                }
                $texte_retour = str_replace('$ops_personne_morale_'.$field_name, $field_value, $texte_retour);
            }
        }
        return $texte_retour;
    }

    /*
     * formate a date passée en paramètre en fonction du format défini par l'utilisateur courant
     */
    protected function format_date($date) {
        global $timedate, $current_user;

        $valeur_retour = '';

        if (empty($current_user->id)) {
            // cas des WS ou le current_user n'est pas correctement initialisé
            $current_user->getSystemUser();
        }

        if (!empty($date)) {
            // mise au format de la date
            $newTimeDate = $timedate->fromUserDate($date,false,$current_user);
            if (empty($newTimeDate))
                $newTimeDate = $timedate->fromDbDate($date);

            $valeur_retour = $newTimeDate->format('d/m/Y');
        }

        return $valeur_retour;
    }

    protected function remplaceChampsUsers($bean, $texte) {
        global $beanFiles;

        require_once($beanFiles['User']);

        $texte_retour = $texte;

        // Remplacement des champs de l'utilisateur assigné 
        if (isset($bean->assigned_user_id) && !empty($bean->assigned_user_id)) {

            $obj_users = BeanFactory::getBean('Users',$bean->assigned_user_id);

            foreach ($obj_users->field_defs as $field) {

                $field_name = $field['name'];

                if ( isset($obj_users->$field_name) && !( is_a($obj_users->$field_name, 'Link2') ) && ($obj_users != 'email') ) {
                    $texte_retour = str_replace('$contact_'.$field_name, $obj_users->$field_name, $texte_retour);
                }

            }

        }

        return $texte_retour;
    }
}
