<?php

namespace ODE\Sms;

class ErreurApiSms
{

    /**
    * Selon la reponse de l'API, retourne :
    * Libellé erreur : trouvée ou null
    * Token  : token ou null
    * @param mixed : Reponse de l'api
    * @return array|int : tableau avec deux valeurs [ Libellé erreur  , Token  ]
    */
    public function verifie_token($response)
    {


        if (isset($response['status'])) {
            $tab_token = [$this->get_erreur_token($response['status']), null];
        } elseif (isset($response['error'])) {
            $tab_token = [$this->get_erreur_token($response['error']), null];
        } elseif (isset($response['access_token'])) {
            $tab_token = [null, $response['access_token']];
        } else {
            $tab_token = -1;
        }

        return $tab_token;

    }


    /**
     * Récupération du libellé de l'erreur, selon le status de la reponse de l'API
     * @param mixed $erreur
     * @return int|string libellé erreur
     */
    public function get_erreur_token($erreur)
    {

        $tab_erreur_token = array(
            '404' => 'Assurez vous que le chemin HTTP fourni est correct',
            '401' => 'Vérifier que l\'utilisateur et le mot de passe fournis sont corrects',
            "invalid_grant" => 'Vérifier que l\'utilisateur et le mot de passe fournis sont corrects',
        );

        foreach ($tab_erreur_token as $key => $value) {
            $libelle_erreur = null;

            if ($erreur == $key) {
                echo "************ 1" . $key;
                $libelle_erreur = $value;
                return $value;
            } elseif (strpos($erreur, $key) !== false) {
                $libelle_erreur = "999";
                echo "************ 2";
                return $libelle_erreur;
            } else {
                $libelle_erreur = "Erreur non traité";
            }

        }
        return $libelle_erreur;
    }


    /**
     * Verification de l'erreur sur un groupe en fonction de la reponse de l'API
     * - libellé de l'erreur trouvée ou null
     * - groups ou null
     * @param mixed $response Reponse de l'api
     * @return array|int tableau avec deux valeurs [libellé erreur, groups]
     */
    public function verifie_groups($response)
    {

        if (isset($response['status'])) {
            $tab_token = [$this->get_erreur_groups($response['status']), null];
        } elseif (isset($response['error'])) {
            $tab_token = [$this->get_erreur_groups($response['error']), null];
        } elseif (is_array($response[0])) {
            $tab_token = [null, $response];
        } else {
            $tab_token = -1;
        }

        return $tab_token;
    }


    /**
     * Récupération du libellé de l'erreur sur un groupe
     * @param mixed $erreur
     * @return string libellé erreur
     */
    public function get_erreur_groups($erreur)
    {

        $tab_erreur_groups = array(
            "invalid_token" => 'Le token n\'est plus valable'
        );

        foreach ($tab_erreur_groups as $key => $value) {
            $libelle_erreur = null;

            if ($erreur == $key) {
                $libelle_erreur = $value;
                return $value;
            } else {
                $libelle_erreur = "Erreur non traité";
            }
        }
        return $libelle_erreur;
    }
}