<?php

namespace ODE\Sms;

class Smsbox
{

    public $url_api;
    public $api_key;

    public function __construct($config = false)
    {
        if(!$config)
        {
            global $sugar_config;

            $this->url_api = $sugar_config['ops_sms']['url_appel_api'];
            $this->api_key = $sugar_config['ops_sms']['api_key'];
        }
        else
        {
            $this->url_api = $config['url_appel_api'];
            $this->api_key = $config['api_key'];
        }
    }

    /**
     * post_sms
     * Fonction permettant l'envoi du SMS
     *
     *  @param numeros $numeros   - numéro format +33645124578  ou tableau de numéro [+33645124578,+33645124578]
     *  @param string $message   - Le message a envoyer
     *  @return           -  !!!!!!!!!!!! Le retour n'est pas géré !!!!!!!!
     */
    public function post_sms($numeros, $message)
    {
        // initialisation de curl
        $curl = curl_init();

        // Problemes avec le certificat, à supprimer si useless
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);

        // On encode le Message pour le passage dans l'url
        $message_encoded = urlencode($message);

        if (strpos($this->url_api, '1.1')) {
            $encoding = '&charset=utf-8';
        } else {
            $encoding = '';
        }
        $data = '?apikey=' . $this->api_key . '&msg=' . $message_encoded . '&dest=' . $numeros . '&mode=Standard&strategy=4' . $encoding;

        $url = $this->url_api . $data;
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_TIMEOUT, 30);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");

        // On décode la réponse
        $response = curl_exec($curl);

        curl_close($curl);

        // Si c'est une erreur cUrl , on renvoie [ Le libellé de l'erreur , token = null ]
        if ($response !== false) {
            if ($response == "OK") {
                $sms_envoye = true;
            } else {
                $GLOBALS['log']->fatal('OPS_SMS - smsbox.php - Impossible d\'envoyer le SMS - Erreur : : ' . $response);
                $sms_envoye = false;
            }
        } else {
            $GLOBALS['log']->fatal('OPS_SMS - smsbox.php - Impossible d\'envoyer le SMS - Erreur : : ' . $response);
            $sms_envoye = false;
        }
        return $sms_envoye;
    }
}