$(document).ready(function () {

	// Valeur de la couleur à avoir
	const colorValue = window.getComputedStyle(document.getElementById("name")).getPropertyValue("color");
	$("#couleur").css("color", colorValue);

	// Elément à observer pour les changements
	const elmCouleur = document.getElementById("couleur");

	// Création d'un nouvel observer
	const observer = new MutationObserver(function (mutationsList) {
		for (let mutation of mutationsList) {

			// Si une modification de couleur a été effectué
			if (mutation.type === "attributes" && mutation.attributeName === "style") {
				$("#couleur").css("color", colorValue);
			}
		}
	});


	// Config de l'observer
	const observerConfig = {
		attributes: true, // Surveiller les changements d'attributs
		attributeFilter: ["style"], // Filtrer sur le style
	};


	// Démarrage de l'observation de l'élément cible
	observer.observe(elmCouleur, observerConfig);

});