<?php

namespace ops_notifications;

use BeanFactory;
use EmailTemplate;
use SugarPHPMailer;
use Email;
use Note;

class OpsNotificationMail{

    function __construct(){
        
    }

    public function sendMailPortail($bean, $idModelMail, $array_pj = array(), $destinataire_id = '', $dest_to = '', $dest_cc = '', $dest_cci = '')
    {
        global $beanFiles, $app_list_strings, $sugar_config, $timedate, $current_user, $app_strings;
        include_once $beanFiles['EmailTemplate'];
        include_once 'include/SugarPHPMailer.php';
        include_once $beanFiles['OPS_individu'];
        $return = false;
        $emailTemp = new EmailTemplate();
        $emailTemp->disable_row_level_security = true;
        $emailTemp->retrieve($idModelMail);
        if (isset($emailTemp->id)) {
            $html_body = $emailTemp->body_html;
            $body = $emailTemp->body;
            $sujet = $emailTemp->subject;
            $nom_objet = $bean->object_name;
            $email_destinataire = '';
            $id_destinataire    = '';

            // Remplissage des variables dans le corps et le titre de l'email
            if ($nom_objet == 'OPS_dossier') {
                $body      = $this->remplacChampsDossier($bean, $body);
                $html_body = $this->remplacChampsDossier($bean, $html_body);
                $sujet     = $this->remplacChampsDossier($bean, $sujet);
            }

            // Construcion du mail
            $emailObj = new Email();
            $defaults = $emailObj->getSystemDefaultEmail();
            $mail     = new SugarPHPMailer();
            $mail->setMailerForSystem();
            $mail->From     = $defaults['email'];
            $mail->FromName = $defaults['name'];
            $mail->ClearAllRecipients();
            $mail->ClearReplyTos();
            $mail->Subject = from_html($sujet);
            if ($emailTemp->text_only != 1) {
                $mail->IsHTML(true);
                $mail->Body    = from_html($html_body);
                $mail->AltBody = from_html($body);
            } else {
                $mail->Body_html = from_html($html_body);
                $mail->Body      = from_html($body);
            }
            if ($mail->Mailer == 'smtp' && $mail->Host == '' && $current_user->is_admin) {
                $msg .= $app_strings['ERR_SERVER_SMTP_EMPTY'];
                $GLOBALS['log']->fatal($msg);
                return $return;
            }
            // ajout des pieces jointes si il y en a
            foreach ($array_pj as $file_name) {
                $nom_pj = $sugar_config['upload_dir'] . $file_name;
                if (!empty($file_name) && file_exists($nom_pj)) {
                    $mail->AddAttachment($nom_pj);
                }
            }
            $mail->prepForOutbound();
            if (!empty($dest_to)) {
                $array_to = explode(";", $dest_to);
                foreach ($array_to as $key => $address) {
                    $adresse_clean = trim($address);
                    if (!empty($adresse_clean)) {
                        $mail->AddAddress($adresse_clean);
                    }
                }
                $hasRecipients = true;
            }
            if (!empty($dest_cc)) {
                $array_cc = explode(";", $dest_cc);
                foreach ($array_cc as $key => $address) {
                    $adresse_clean = trim($address);
                    if (!empty($adresse_clean)) {
                        $mail->AddCC($adresse_clean);
                    }
                }
            }
            if (!empty($dest_cci)) {
                $array_cci = explode(";", $dest_cci);
                foreach ($array_cci as $key => $address) {
                    $adresse_clean = trim($address);
                    if (!empty($adresse_clean)) {
                        $mail->AddBCC($adresse_clean);
                    }
                }
            }
            if (!empty($dest_to)) {
                $result = @$mail->Send();
                if ($result == true) {
                    $emailObj->team_id          = 1;
                    $emailObj->to_addrs         = '';
                    $emailObj->type             = 'archived';
                    $emailObj->deleted          = '0';
                    $emailObj->name             = $mail->Subject;
                    $emailObj->description      = $mail->AltBody;
                    $emailObj->description_html = $mail->Body;
                    $emailObj->from_addr        = $mail->From;
                    $emailObj->parent_type      = 'OPS_individu';
                    $emailObj->parent_id        = $destinataire_id;
                    $emailObj->date_sent        = $timedate->now();
                    $emailObj->modified_user_id = '1';
                    $emailObj->created_by       = '1';
                    $emailObj->status           = 'sent';
                    $email_id                   = $emailObj->save();
                    // ajout des pieces jointes si elles existent
                    foreach ($array_pj as $file_name) {
                        $nom_pj = $sugar_config['upload_dir'] . $file_name;
                        if (!empty($file_name) && file_exists($nom_pj)) {
                            // Sauvegarde de la pice jointe PDF
                            $note                   = new Note();
                            $note->filename         = $file_name;
                            $note->name             = $file_name;
                            $note->file_mime_type   = 'application/pdf';
                            $note->assigned_user_id = $bean->assigned_user_id;
                            $note->parent_id        = $email_id;
                            $note->parent_type      = 'Emails';
                            $note_id                = $note->save();
                            $source                 = $sugar_config['upload_dir'] . $file_name;
                            $destination            = $sugar_config['upload_dir'] . $note_id;
                            if (!rename($source, $destination)) {
                                $msg = 'Erreur nommage de la pièce jointe de';
                                $msg .= $source . ' en ' . $destination;
                                $GLOBALS['log']->fatal($msg);
                                $result = false;
                            }
                        }
                    }
                } else {
                    $msg = 'Erreur d\'envoie du mail : ';
                    $GLOBALS['log']->fatal($msg . print_r($result, true));
                }
            }
        } else {
            $msg = 'Template inexistant  ';
            $GLOBALS['log']->fatal($msg . $idModelMail);
        }
        return $result;
    }

    function remplacChampsDossier($bean, $texte) {
        global $sugar_config, $beanList, $beanFiles;

        $texte_retour = $texte;

        if ($bean->object_name != 'OPS_dossier') {
            return $texte;
        }

        // boucle de remplacement des champs de la demande dans le mail
        foreach ($bean->field_defs as $field) {
            $field_name = $field['name'];
            if (isset($bean->$field_name) && !(is_a($bean->$field_name, 'Link2'))) {
                $field_value = $bean->$field_name;
                if (preg_match("^date_\w*",$field_name)){
                    $field_value = $this->format_date($bean->$field_name);
                }
                if ($field_name == 'ops_statut_id'){
                    $objStatut = BeanFactory::getBean('OPS_statut', $bean->$field_name);
                    $field_value = $objStatut->name;
                }
                if ($field_name == 'ops_etape_id'){
                    $objEtape = BeanFactory::getBean('OPS_etape', $bean->$field_name);
                    $field_value = $objEtape->name;
                }
                if(preg_match("^ops_individu\d*_id$",$field_name)){
                    $objIndividu = BeanFactory::getBean('OPS_individu', $bean->$field_name);
                    $field_value = $objIndividu->salutation+' '+$objIndividu->firdt_name+' '+$objIndividu->last_name;
                }
                if($field_name == 'ops_exercice_id' && !empty($bean->$field_name)){
                    $objExercice = BeanFactory::getBean('OPS_exercice', $bean->$field_name);
                    $field_value = $objExercice->name;
                }
                $texte_retour = str_replace('$demande_'.$field_name, $field_value, $texte_retour);
            }
        }

        // Initialisation des champs du demandeur
        if($bean->type_tiers == 'OPS_individu'){
            $demandeurs_array = $bean->get_linked_beans('ops_individu_ops_dossier','OPS_individu');
        }else if($bean->type_tiers == 'OPS_personne_morale'){
            $demandeurs_array = $bean->get_linked_beans('ops_personne_morale_ops_dossier','OPS_personne_morale');
        }
        if (count($demandeurs_array) == 1) {
            $demandeur = $demandeurs_array[0];
            foreach ($demandeur->field_defs as $field) {
                $field_name  = $field['name'];
                if (isset($demandeur->$field_name) && !(is_a($demandeur->$field_name, 'Link2')) && ($field_name != 'email')) {
                    $field_value = $demandeur->$field_name;
                    if ($field_name == 'date_naissance') {
                        $field_value = $this->format_date($demandeur->$field_name);
                    }
                    $texte_retour = str_replace('$demandeur_'.$field_name, $field_value, $texte_retour);
                }
            }
        }

        // Initialisation des champs du beneficiaire
        $beneficiaire = BeanFactory::getBean('OPS_individu', $bean->ops_personne_individu);
        if (!empty($beneficiaire)) {
            foreach ($beneficiaire->field_defs as $field) {
                $field_name = $field['name'];
                if (isset($beneficiaire->$field_name) && !(is_a($beneficiaire->$field_name, 'Link2')) && ($field_name != 'email')) {
                    $field_value = $beneficiaire->$field_name;
                    if ($field_name == 'date_naissance') {
                        $field_value = $this->format_date($beneficiaire->$field_name);
                    }
                    $texte_retour = str_replace('$beneficiaire_'.$field_name, $field_value, $texte_retour);
                }
            }
         }

         // Initialisation de l'entité beneficiaire
        if ((!empty($bean->parent_id)) && (!empty($bean->parent_type))){
            $class = $beanList[$bean->parent_type] ;
            require_once($beanFiles[$class]);

            $entite = new $class;
            $entite->retrieve($bean->parent_id);

            foreach ($entite->field_defs as $field) {
                $field_name = $field['name'];
                if (isset($entite->$field_name) && !(is_a($entite->$field_name, 'Link2'))) {
                    $texte_retour = str_replace('$entite_'.$field_name, $entite->$field_name, $texte_retour);
                }
            }
        }

        // Remplacement des champs utilisateur
        $texte_retour = $this->remplace_champs_utilisateur($bean, $texte_retour);

        return $texte_retour;
    }


    /*
     * formate a date passée en paramètre en fonction du format défini par l'utilisateur courant
     */
    protected function format_date($date) {
        global $timedate, $current_user;

        $valeur_retour = '';

        if (empty($current_user->id)) {
            // cas des WS ou le current_user n'est pas correctement initialisé
            $current_user->getSystemUser();
        }

        if (!empty($date)) {
            // mise au format de la date
            $newTimeDate = $timedate->fromUserDate($date,false,$current_user);
            if (empty($newTimeDate))
                $newTimeDate = $timedate->fromDbDate($date);

            $valeur_retour = $newTimeDate->format('d/m/Y');
        }

        return $valeur_retour;
    }

    protected function remplace_champs_utilisateur($bean, $texte) {
        global $current_user, $beanFiles;

        $texte_retour = $texte;
        // boucle de remplacement des champs de l'utilisateur connecté dans le mail
        foreach ($current_user->field_defs as $field) {
            $field_name = $field['name'];
            if (isset($current_user->$field_name) && !(is_a($current_user->$field_name, 'Link2')) && ($field_name != 'email')) {
                $texte_retour = str_replace('$util_connecte_'.$field_name, $current_user->$field_name, $texte_retour);
            }
        }

        // Remplacement des champs de l'utilisateur assigné dans le mail
        if (isset($bean->assigned_user_id) && !empty($bean->assigned_user_id)) {
            require_once($beanFiles['User']);
            $util_assigne = BeanFactory::getBean('Users',$bean->assigned_user_id);
            foreach ($util_assigne->field_defs as $field) {
                $field_name = $field['name'];
                if (isset($util_assigne->$field_name) && !(is_a($util_assigne->$field_name, 'Link2')) && ($util_assigne != 'email')) {
                    $texte_retour = str_replace('$util_assigne_'.$field_name, $util_assigne->$field_name, $texte_retour);
                }
            }
        }

        return $texte_retour;
    }
}
