
<div class="moduleTitle">
    <h2>Géolocalisation leaflet</h2>
    <div class="clear"></div>
</div>

<BR>

<form id="ConfigureSettings" name="ConfigureSettings" enctype='multipart/form-data' method="POST" action="index.php?module=Administration&action=geoloc_leaflet&process=true" onSubmit="return checkSubmit()">

    <span class='error'>{$error.main}</span>

    <table width="100%" cellpadding="0" cellspacing="1" border="0" class="actionsContainer">
        <tr>
            <td>
                <input id="bouton_save" title="{$APP.LBL_SAVE_BUTTON_TITLE}" accessKey="{$APP.LBL_SAVE_BUTTON_KEY}" class="button primary" type="submit" name="save" onclick="onSubmitForm()" value="  {$APP.LBL_SAVE_BUTTON_LABEL}  "> &nbsp;
                <input title="{$MOD.LBL_CANCEL_BUTTON_TITLE}" onclick="document.location.href='index.php?module=Administration&action=opencrm'" class="button" type="button" name="cancel" value="  {$APP.LBL_CANCEL_BUTTON_LABEL}  "> </td>
        </tr>
    </table>

    <br />

    <div style="background: white; padding-left: 2%; padding-right: 2%;">

        <div class="row" style="background: white;margin: 0px;margin-bottom: 15px; padding-top: 10px">
            <h4>Centrage par défaut sur la carte</h4>
            <div style="display: block;border-bottom: 2px solid #eee;margin-top: 10px;"></div>
        </div>
    
        <div class="row" style="background: white; margin: 0px; padding: 5px;">
            <div class="col-md-2" style="white-space: initial;padding-top: 13px;">
                Latitude par défaut :
            </div>
            <div class="col-md-4">
                <input type="text" size="20" id='latitude' value="{ $LATITUDE }" name="latitude">
                <small role="message-champ" style="display: none;color:red">La latitude n'est pas correct</small>
            </div>
            <div class="col-md-2" style="white-space: initial;padding-top: 13px;">
                Longitude par défaut :
            </div>
            <div class="col-md-4">
                <input type="text" size="20" id='longitude' value="{ $LONGITUDE }" name="longitude">
                <small role="message-champ" style="display: none;color:red">La longitude n'est pas correct</small>
            </div>
            <em>Les valeurs de longitude et latitude sont des nombres décimaux avec un point (.) comme séparateur décimal !</em>
        </div>

        <div class="row" style="background: white;margin: 0px;margin-bottom: 15px; padding-top: 10px">
            <h4>Pagination des dossiers</h4>
            <div style="display: block;border-bottom: 2px solid #eee;margin-top: 10px;"></div>
        </div>

        <div class="row" style="background: white; margin: 0px; padding: 5px;">
            <div class="col-md-2" style="white-space: initial;padding-top: 13px;">
                Nombre maximum d’éléments affichés par page sur la carte :
            </div>
            <div class="col-md-4">
                <input type="text" size="20" id='pagination' value="{ $PAGINATION }" name="pagination">
            </div>
        </div>

        <div class="row" style="background: white;margin: 0px;margin-bottom: 15px; padding-top: 10px">
            <h4>Taille par défaut de la carte</h4>
            <div style="display: block;border-bottom: 2px solid #eee;margin-top: 10px;"></div>
        </div>
    
        <div class="row" style="background: white; margin: 0px; padding: 5px;">
            <div class="col-md-2" style="white-space: initial;padding-top: 13px;">
                Hauteur par défaut :
            </div>
            <div class="col-md-4">
                <input type="text" size="20" id='hauteur' value="{ $HAUTEUR }" name="hauteur">
                <small role="message-champ" style="display: none;color:red">La hauteur doit être un nombre entier</small>
            </div>
            <div class="col-md-2" style="white-space: initial;padding-top: 13px;">
                Zoom par défaut :
            </div>
            <div class="col-md-4">
                <input type="text" size="20" id='zoom' value="{ $ZOOM }" name="zoom">
                <small role="message-champ" style="display: none;color:red">Le zoom doit se trouver entre 5 et 19</small>
            </div>
            <em>La valeur du zoom doit être un nombre entier compris entre 5 et 19.</em>
        </div>

        {$JAVASCRIPT}

    </div>

</form>

{literal}
<script>

function checkSubmit(){

    $('#latitude').next().hide();
    $('#longitude').next().hide();
    $('#hauteur').next().hide();
    $('#zoom').next().hide();

    var check = true

    var latitude = $('#latitude').val();
    latitude.replace(',','.');
    latitude = Number.parseFloat(latitude);
    if(Number.isNaN(latitude)){
        $('#latitude').next().show();
        check = false;
    }

    var longitude = $('#longitude').val();
    longitude.replace(',','.');
    longitude = Number.parseFloat(longitude);
    if(Number.isNaN(longitude)){
        $('#longitude').next().show();
        check = false;
    }

    var hauteur = $('#hauteur').val();
    hauteur = Number.parseInt(hauteur);
    if(Number.isNaN(hauteur)){
        $('#hauteur').next().show();
        check = false;
    }

    var zoom = $('#zoom').val();
    zoom = Number.parseInt(zoom);
    if(Number.isNaN(zoom) || zoom > 19 || zoom < 5){
        $('#zoom').next().show();
        check = false;
    }

    return check;
}

</script>

{/literal}