<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $current_user, $sugar_config;
if (!is_admin($current_user)) sugar_die("Unauthorized access to administration.");

require_once('modules/Configurator/Configurator.php');

$configuratorObj = new Configurator();
$sugar_smarty    = new Sugar_Smarty();
$errors        = array();


$target_dir = "themes/default/images/";
$target_file = $target_dir . "pdf_logo.png";

$bribe_stylesheet = '<style type="text/css">form#ConfigureSettings ::placeholder{ opacity: 0.6; }</style>';

$configuratorObj->loadConfig();

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') {

    # Initialisation des paramètres généraux du PDF
    $configuratorObj->config['module_conversation']['enable_custom']        = (isset($_REQUEST['enable_custom']) && intval($_REQUEST['enable_custom']) == 1)? 1 : 0;
    $configuratorObj->config['module_conversation']['custom_exp_identity'] = trim($_REQUEST['custom_exp_identity']);

    $configuratorObj->saveConfig();

    header('Location:index.php?module=Administration&action=opencrm');
    
}

// Default params... Si non existant on le fixe à 0 (non activé).
if( !isset( $configuratorObj->config['module_conversation']['enable_custom'] )
 || intval( $configuratorObj->config['module_conversation']['enable_custom'] ) == 0 ){
    $configuratorObj->config['module_conversation']['enable_custom'] = 0; 
    $configuratorObj->saveConfig();
}
if( trim( $configuratorObj->config['module_conversation']['custom_exp_identity'] ) == '' ){
    $configuratorObj->config['module_conversation']['custom_exp_identity'] = ''; 
    $configuratorObj->saveConfig();
}

$sugar_smarty->assign('ENABLE_CUSTOM', (intval($configuratorObj->config['module_conversation']['enable_custom'])===1)?' checked="checked" ':'' );
$sugar_smarty->assign('CUSTOM_EXP_IDENTITY', $configuratorObj->config['module_conversation']['custom_exp_identity']);


$sugar_smarty->assign('MOD', $mod_strings);
$sugar_smarty->assign('APP', $app_strings);
$sugar_smarty->assign('APP_LIST', $app_list_strings);
$sugar_smarty->assign('LANGUAGES', get_languages());
$sugar_smarty->assign("STYLESHEET", $bribe_stylesheet);
$sugar_smarty->assign("JAVASCRIPT", OPS_conversation::get_inline_js() );
$sugar_smarty->assign('config', $sugar_config);
$sugar_smarty->assign('error', $errors);

$sugar_smarty->clearCache('custom/modules/Administration/module_conversation.tpl');
$sugar_smarty->display('custom/modules/Administration/module_conversation.tpl');