/**
 * Point d'entrée de la création d'un arrêté
 * @param $ JQuery
 * @param router RoutingView
 * @param layout Layouts
 * @param champs Champs
 * 
*/
 
String.prototype.isEmpty = function() { return (this.length === 0 || !this.trim() ); };

String.prototype.b64ToUtf8 = function() { return decodeURIComponent(escape(window.atob( this ))); };
String.prototype.utf8ToB64 = function() { return window.btoa(unescape(encodeURIComponent( this ))); };

Object.getLength = function(obj) { var size = 0,key; for (key in obj) { if (obj.hasOwnProperty(key)) size++; } return size; };

if (!String.prototype.includes) {
    String.prototype.includes = function() {
        'use strict';
        return String.prototype.indexOf.apply(this, arguments) !== -1;
    };
}
 
if (!Object.prototype.forEach) {
	Object.defineProperty(Object.prototype, 'forEach', {
		value: function (callback, thisArg) {
			if (this == null) {
				throw new TypeError('Not an object');
			}
			thisArg = thisArg || window;
			for (var key in this) {
				if (this.hasOwnProperty(key)) {
					callback.call(thisArg, this[key], key, this);
				}
			}
		}
	});
}


/** Transforms a base64 coded to a memory Blob format and return it **/
/**/const b64toBlob=(b64Data,contentType='',sliceSize=512)=>{const byteCharacters=atob(b64Data);const byteArrays=[];for(let offset=0;offset<byteCharacters.length;offset+=sliceSize){const slice=byteCharacters.slice(offset,offset+sliceSize);const byteNumbers=new Array(slice.length);for(let i=0;i<slice.length;i++){byteNumbers[i]=slice.charCodeAt(i);}const byteArray=new Uint8Array(byteNumbers);byteArrays.push(byteArray);}const blob=new Blob(byteArrays,{type:contentType});return blob;}


var DIALOG;
var App = (function($,router) {
    return {
        start: function() {
            
            BlisterAssets.import(); // Importe le materiel - Blister Assets tools.

            // Initialisation des dimensions du main container
            void this.setHeightContainer();

            // Mappe les événements 'click' sur les boutons d'action [SAUVEGARDER|ANNULER|EXPORTER]
            void this.bindBtnActionEvents();

            // Initilisation du bouton open menu
            void this.setToggleMenu();
            router.start();
        },
        
        setHeightContainer: function(){
            let document_height = $(window).height();
            let app_container_height = document_height * 0.75;
            $("#app-container").css("height", app_container_height);
        },
        setToggleMenu: function(){
            $( "#toggle-menu-btn" ).click(function() {
                $('#g-menu').toggleClass('active');
            });
        }, 

        bindBtnActionEvents: function(){

            // [EXPORTER] Binder
            $( '#btn_export_choice[name="export"]' ).off().on('click', function(event){
                void App.export_choice( event );
            } );

            // [ANNULER] Binder
            $( '#btn_cancel_create[name="cancel"]' ).off().on('click', function(event){
                void App.cancel_create();
            } );
            
            // [SAUVEGARDER] Binder
            $( '#btn_save_draft[name="save"]' ).off().on('click', function(event){
                void App.save_draft(true); // @param redirect after
            } );

        },



        export_choice: function(evt){

            var dialog_html  =  '<div class="row">';
            dialog_html     +=      '<div class="col-xs-4">';
            dialog_html     +=          '<img role="choix_type_document" data-type="odt" class="choix-type-document" src="custom/modules/Documents/App/img/logo_odt.svg" title="Exporter au format .odt" alt="Exporter au format .odt"/>';
            dialog_html     +=      '</div>';
            dialog_html     +=      '<div class="col-xs-4">';
            dialog_html     +=          '<img role="choix_type_document" data-type="docx" class="choix-type-document" src="custom/modules/Documents/App/img/logo_doc.svg" title="Exporter au format .doc" alt="Exporter au format .doc"/>';
            dialog_html     +=      '</div>';
            dialog_html     +=      '<div class="col-xs-4">';
            dialog_html     +=          '<img role="choix_type_document" data-type="pdf" class="choix-type-document" src="custom/modules/Documents/App/img/logo_pdf.svg" title="Exporter au format .pdf" alt="Exporter au format .pdf"/>';
            dialog_html     +=      '</div>';
            dialog_html     +=  '</div>';
            dialog_html     +=  '<div class="row">';
            dialog_html     +=      '<div class="col-xs-4">';
            dialog_html     +=          '<div class="col-xs-12 col-sm-12 label">';
            dialog_html     +=              '<div role="modal-document-succes" style="color:green;"></div>';
            dialog_html     +=              '<div role="modal-document-error" style="color:red;"></div>';
            dialog_html     +=          '</div>';
            dialog_html     +=      '</div>';
            dialog_html     +=  '</div>';

            DIALOG = $('<div style="overflow: hidden;"></div>').appendTo('body').html(dialog_html).dialog({
                title: 'Sélectionnez le format à exporter', 
                modal: true, zIndex: 10000, autoOpen: true,
                width: 'auto', resizable: false,
                buttons: {},
                close: function (event, ui) {
                    $(this).remove();
                }
            });

            $('[role="choix_type_document"]').each(function(){
                $(this).click(function () {

                    var selected_format = String( $(this).attr("data-type") );
                    if( selected_format == '' ){ DIALOG.dialog("close"); }
                    else{

                        $("#form_export_format").attr("data-type", selected_format );
                        void App.export_to_format( selected_format , 'download' ); // esporte and download

                    }
                    
                });
            })

        },


        export_to_format: function(selected_format, callback_custom){

            var _id = $('#id').val();
            var data = {};
                data.id           = _id;
                data.format       = String(selected_format);
                data.html_pdf_b64 = String( tinyMCE.activeEditor.getContent() ).utf8ToB64();
                data.modele_id = $('#ops_modele_document_id').val();

            var url = '/index.php?module=Documents&action=export_format';

            Loading.addSpinner();

            window.setTimeout( function(){

                jQuery.post( url, 
                    data
                    ).done(function(dataReturned) {

                        var result = JSON.parse( dataReturned );

                        if( typeof result == 'object' ){

                            switch( result.statut ) {
                                case 'ok':

                                    // Force to download the exported (generated) document...
                                    if( typeof callback_custom != 'undefined' && callback_custom == 'download' ){

                                        $('[role="modal-document-succes"]').html( "Document prêt à télécharger." );
                                        void App.download( result.export.content, result.export.mime, result.export.filename, result.export.length);

                                    }

                                    // Embed the exported (generated) document to b64 iframe source...
                                    if( typeof callback_custom != 'undefined' && callback_custom == 'embed' ){

                                        void App.embed( result.export.content, result.export.mime, result.export.filename, result.export.length);

                                    }

                                    break;
                                case 'ko':
                                    alert( result.data + ((typeof result.reason != 'undefined')? "\n\n"+result.reason: '') ); // Message from controller.
                                    $('[role="modal-document-error"]').html( result.data );
                                    break;
                                default:
                                    console.log( data.id , result );
                            }

                        }

                    }).fail(function(x) {
                        console.log( x );                        
                        alert("Une erreur s'est produite, veuillez contacter l'administrateur.");
                        return;

                    }).always(function() {
                        Loading.removeSpinner();

                        setTimeout( function(){
                            $('[role="modal-document-succes"]').html( '' );
                            $('[role="modal-document-error"]').html( '' );
                        } , 1500 );

                    });

            } , 250 );


        },


        cancel_create: function(){
            
            var _id = $('#id').val();
            var data = {};
                data.id              = _id;
                data.module_origin   = $("#module_name").val();
                data.record_origin   = $("#module_id").val()
            var url = '/index.php?module=Documents&action=cancel_create';

            window.setTimeout( function(){

                jQuery.post( url, 
                    data
                    ).done(function(result) {

                    }).fail(function(x) {
                        console.log( x );
                        alert("Une erreur s'est produite, veuillez contacter l'administrateur");
                        return;

                    }).always(function() {
                        SUGAR.ajaxUI.loadContent('index.php?action=DetailView&module='+$("#module_name").val()+'&record='+$("#module_id").val());
                    });

            } , 250 );            

        },

        save_draft: function( _redirect ){

            Loading.addSpinner();

            var _id = $('#id').val();
            var _rel_type_id = $('#rel_type').val();
            var data = {};
                data.id = _id;
                data.modele_document = $('#ops_modele_document_id').val();
                data.type_doc_id = String( _rel_type_id ).trim();
                data.html_pdf_b64 = String( tinyMCE.activeEditor.getContent() ).utf8ToB64();
            var url = '/index.php?module=Documents&action=sauvegarde';

            if( data.type_doc_id == '' ){
                alert( "Aucun modèle utilisé a été détecté !\n\nVous devez à minima utiliser un modèle de document pour sélectionner et affeter un type de document." );
                Loading.removeSpinner();
                return;
            }

            window.setTimeout( function(){

                jQuery.post( url, 
                    data
                    ).done(function(dataReturned) {

                        var result = JSON.parse( dataReturned );

                        if( typeof result == 'object' ){

                            switch( result.statut ) {
                                case 'ok':
                                    result.redirect = _redirect;
                                    break;
                                case 'ko':
                                    result.redirect = false;
                                    alert( result.data ); // Message from controller.
                                    break;
                                default:
                                    result.redirect = false;
                                    console.log( data.id , result );
                            }

                        }

                        if( result.redirect ){
                            document.title = "Redirection après sauvegarde...";
                            SUGAR.ajaxUI.loadContent('index.php?action=DetailView&module='+$("#module_name").val()+'&record='+$("#module_id").val()); 
                        }else{
                             Loading.removeSpinner();
                        }

                    }).fail(function(x) {
                        console.log( x );                        
                        alert("Une erreur s'est produite, veuillez contacter l'administrateur");
                        return;

                    }).always(function() {
                        Loading.removeSpinner();

                    });

            } , 250 );


        },

        download: function( _file_b64_content, _file_mime, _file_name, _file_length) {

    /*@use*/var blob = b64toBlob(_file_b64_content, _file_mime); // Use b64toBlob.
            var blob_url = (URL || webkitURL).createObjectURL(blob);
            const a = document.createElement('a');
            a.style.display = 'none';
            a.href = blob_url;
            // Set the filename.
            a.download = _file_name;
            document.body.appendChild(a);
            a.click();
            window.URL.revokeObjectURL(blob_url);
            a.remove();

        },


        embed: function( _file_b64_content, _file_mime, _file_name, _file_length) {

    /*@use*/var blob = b64toBlob(_file_b64_content, _file_mime); // Use b64toBlob.
        
            bstr = atob(_file_b64_content);
            n = bstr.length;
            u8arr = new Uint8Array(n);

            while(n--){
                u8arr[n] = bstr.charCodeAt(n);
            }

            const file = new File([u8arr], _file_name, {type:_file_mime});
      
            const custom_b64_data_url = (URL || webkitURL).createObjectURL(file);

            //$("#viewer_pdf").attr("src", "data:"+_file_mime+";filename:"+_file_name+";base64,"+_file_b64_content );
            $("#viewer_pdf").attr("src", custom_b64_data_url );

        },


        _:function() {}

    }
})(jQuery,RoutingView);




var Loading = (function ($) {
    return {

        addOverlay: function(){
            $('body').append($('<div id="overlay_body" class="overlay-body" ></div>'));
        },
    
        addSpinner: function( el = null , static_pos ){
            this.showOverlay();
            el = ( el !== null ) ? el : $(document.body);
            var spinner = el.children('.spinner');
            if (spinner.length && !spinner.hasClass('spinner-remove')) return null;
            !spinner.length && (spinner = $('<div class="spinner' + (static_pos ? '' : ' spinner-absolute') + '"/>').appendTo(el));
            this.animateSpinner(spinner, 'add');
        },
    
        removeSpinner: function(el = null, complete){
            this.hideOverlay();
            el = ( el !== null ) ? el : $(document.body);
            var spinner = el.children('.spinner');
            spinner.length && this.animateSpinner(spinner, 'remove', complete);
        },
    
        hideOverlay: function(){ $("#overlay_body").hide();},

        showOverlay: function(){ 
            if ( $("#overlay_body").length === 0 ) this.addOverlay();
            $("#overlay_body").show();
            // $("#overlay_body").show("fade", { direction: "right", align: "center" }, 200 ) ;
        },
    
        animateSpinner: function(el, animation, complete){
            if (el.data('animating')) {
                el.removeClass(el.data('animating')).data('animating', null);
                el.data('animationTimeout') && clearTimeout(el.data('animationTimeout'));
            }
            el.addClass('spinner-' + animation).data('animating', 'spinner-' + animation);
            el.data('animationTimeout', setTimeout(function() { animation == 'remove' && el.remove(); complete && complete(); }, parseFloat(el.css('animation-duration')) * 1000));
        },

    }    
})(jQuery);



$(document).ready(function() {

    App.start();
    $('#g-menu').addClass('active');

    $('#visualisation[role="vue"]').hide();
    $('#edition[role="vue"]').show('display:flex !important');

    // Insertion du contenu dans l'éditeur.
    $("#corps").val( $("#pdf_html").val() );

    $(window).on('resize' , function(e){
        $('#corps_ifr').css('height', $('#g-menu').height() - 20);
    }).trigger('resize');

    // Mappe les événements 'click' sur les boutons d'action [Édition|Visualisation]
    $( 'a[data-toggle="pannel"][role="pannel"]' ).each(function(i,o){
        $(o).off().on('click', function(evt){
            evt.preventDefault();
            pannel_slug = $(this).attr('aria-controls');
            
            switch( pannel_slug ) {
                case 'visualisation':

                    $( '#g-menu' ).removeClass("active");
                    $( '#edition' ).removeClass("active");
    
                    void App.export_to_format( 'pdf' , 'embed' ); // Export and embed

                    break;
                case 'corps':
                default:
                    $('#g-menu').addClass('active');
                    $( '#visualisation' ).removeClass("active");
                    
                    break;
            }

            $('[role="vue"]').hide();
            $('#'+ pannel_slug + '[role="vue"]').show('display:flex !important');
            $(o).parent().addClass('active');
        })
    });

    window.setTimeout( ()=>{
        
        // Permet de brancher un observer sur le changement du contenu (après insertion d'initialisation) et notifier les changements.
        void ContentManager.bindContentChanges();
        
        void ContentManager.overrideTinyMcePageBreak();

    }, 250 );

});