<?php

require_once('custom/modules/Documents/App/tpls/containers/viewer_pdf.php');

use ODE\Helper\ReplaceVariable;
use Mpdf\Mpdf;

class Documents_editiques extends Document
{

    /**
     * @access public
     * get_valid_slugfile()
     * Fonction qui génère un slug name sur la base d'un nom  de template et d'un uid
     * 
     *  @param String   $unsafe_name  - Nom humain du template
     *  @return String  $valid_slugfile   - Slug file valid sur la base des règles définies
    */
    public function get_valid_slugfile( $unsafe_name ){

        // A mastered and complete dashed slugify | Implementation Lanteas (by Sebounet)
        $valid_slugfile = strtoupper( $unsafe_name );
        if( class_exists('Transliterator') ){
            try {
                $valid_slugfile =  \Transliterator::create('NFD; [:Nonspacing Mark:] Remove; NFC')->transliterate( $valid_slugfile );
            } catch (Exception $e) {
                if ( class_exists( 'Normalizer' ) ) {
                    try {
                        $valid_slugfile = Normalizer::normalize( $valid_slugfile, Normalizer::NFD );
                    } catch (Exception $e) {
                        $valid_slugfile = preg_replace( '@[^\0-\x80]@u' , "", $valid_slugfile );
                    }
                }
            }
        }
        $valid_slugfile = trim( $valid_slugfile );
        $valid_slugfile = preg_replace( '/[.]|(\s)/', "",  $valid_slugfile );
        $valid_slugfile = preg_replace( '/[\']/', "",  $valid_slugfile );
        $valid_slugfile = preg_replace( '/[-]/', "_",  $valid_slugfile );
        $valid_slugfile = preg_replace( '/[^a-zA-Z0-9_]/', "_",  $valid_slugfile );
        $valid_slugfile = preg_replace( '/([_]+)/', "_",  $valid_slugfile );
        $valid_slugfile = preg_replace( '/(^[_]|[_]$)/', "",  $valid_slugfile );
        $valid_slugfile = strtolower( $valid_slugfile );

        $valid_slugfile = $valid_slugfile;

        return $valid_slugfile;
    } 

    # A exploiter avec le filtre
    public function get_types_documents($type = '*')
    {
        global $db;

        $sql_type_precision = (trim($type) == '*')? "" : "AND modele_document.type = '".$type."' ";

        // Fetch only modele actif and not deleted... and linked to type document.
        $sql = "SELECT type_document.id, type_document.name 
                FROM ops_type_document as type_document
                WHERE type_document.deleted=0 AND type_document.statut=1 
                AND type_document.id IN (
                    SELECT modele_document.ops_type_document_id_c as id 
                    FROM ops_modele_document as modele_document
                    WHERE modele_document.actif=1
                    ". $sql_type_precision ."
                )
                ORDER BY type_document.name ASC";

        $type_document_list = $db->query($sql);

        while ($type_document = $db->fetchRow($type_document_list)) {
            $tab[] = $type_document;
        }

        return $tab;
    }

    # A exploiter avec le filtre
    public function get_modeles_documents($type = '*')
    {
        global $db;

        $sql_type_precision = (trim($type) == '*')? "" : "AND modele_document.type = '".$type."' ";

        // Fetch only modele actif and not deleted...
        $sql = "SELECT modele_document.id, modele_document.name, modele_document.description, modele_document.type,
                ops_type_document.icone, ops_type_document.name as type_name, ops_type_document.id as type_id
                FROM ops_modele_document as modele_document
                LEFT JOIN ops_type_document ON modele_document.ops_type_document_id_c = ops_type_document.id
                WHERE modele_document.deleted=0 AND modele_document.actif=1 
                AND ops_type_document.statut=1
                ". $sql_type_precision ."
                ORDER BY modele_document.name ASC";

        $modele_document_list = $db->query($sql);

        while ($modele_document = $db->fetchRow($modele_document_list)) {
            $tab[] = $modele_document;
        }

        return $tab;
    }

    # Récupère id/label d'un type spécifique.
    # Permet de connaitre son statut et si ce type est supprimé.
    public function get_type_document_by_id( $id )
    {
        global $db;

        $tab = array();
        // Default model
        $tab[] = array(
            'id'      => $id,
            'name'    => 'inconnu',
            'deleted' => 1,
            'statut'  => 0
        );

        $sql = "SELECT type_document.id, type_document.name,
                type_document.deleted, type_document.statut
                FROM ops_type_document as type_document
                WHERE type_document.id = '".$id."'";

        $type_document_list = $db->query($sql);

        while ($type_document = $db->fetchRow($type_document_list)) {
            $tab[] = $type_document;
        }

        return array_pop($tab);
    }

    # Oriente vers le choix du format de génération : MSWord/DOCX , OpenOffoce/ODT , Acrobat/PDF.
    public function export_to_format($id, $type = "", $html_b64_content, $modeleId)
    {

        if( empty($html_b64_content) && isset($_SESSION['editique_html_b64_content']) && !empty($_SESSION['editique_html_b64_content']) ){
            $html_b64_content = $_SESSION['editique_html_b64_content'];
        }

        # Security : Check Bean ID
        $obj_document = BeanFactory::getBean( 'Documents' , $id );

        $html_content = base64_decode( $html_b64_content );

        // Prépare une réponse type par défaut.
        $export_editique = false;

        $result = new \stdClass();
        $result->content   = "";
        $result->mime      = "";
        $result->length    = 0;
        $result->filename  = "";

        if( $obj_document && isset($obj_document->id) && $obj_document->origine == 'editique' ){

            switch ($type) {
                case 'odt':
                    $export_editique = $this->genere_odt($id, $type = "odt", $html_content, false, $modeleId);
                    break;
                case 'docx':
                    $export_editique = $this->genere_doc($id, $type = "docx", $html_content, false, $modeleId);
                    break;
                case 'pdf':
                    $export_editique = $this->genere_pdf($id, $type = "pdf", $html_content, false, $modeleId);
                    break;
                default:
                    $export_editique = false;
                    break;
            }

            // Affectation des résultats de l'exportation et retour au process en amont.
            if( $export_editique !== false ){
                $result->content   = $export_editique->content;
                $result->mime      = $export_editique->mime;
                $result->length    = $export_editique->length;
                $result->filename  = $export_editique->filename;
            }
            return $result;

        }else{
            return $result;
        }
    }

    /**
     * Génération du document dans un format éditable de type MSWord/DOCX , OpenOffoce/ODT
     */
    public function genere_odt($document_id, $type = "odt", $html_content, $from_template=false, $modeleId)
    {

        $final_name = "Export_" ."Document_Editique_".date('Y-m-d').'_'.date('His').'.'.$type; // The default final exported file !
        $base_download = './upload/'; // Place to manipulate I/O file and data...

        # Prepare a properly parsed html input without exotic characters....
        $cleanup_corps = !empty($html_content)? $html_content : "<h1>Document Éditique vide pour son export</h1>";
        $cleanup_corps = trim( $cleanup_corps );

        // sorte de flag sur les caractères spéciaux qui font planter la génération word
        // ils sont enlever lors du replacevar, et lors du add border table
        // bout de Code récupéré dans : vendor\phpoffice\phpword\src\PhpWord\Shared\Html.php (addHtml() l.69)
        $cleanup_corps = str_replace(array('&lt;', '&gt;', '&amp;', '&quot;'), array('_lt_', '_gt_', '_amp_', '_quot_'), $cleanup_corps);

        $cleanup_corps = html_entity_decode( $cleanup_corps );


        $cleanup_corps = preg_replace('/ /', ' ', $cleanup_corps); // ULTRA IMPORTANT

        // Streamlining
        $cleanup_corps = preg_replace('/(\n)/', ' ', $cleanup_corps);
        $cleanup_corps = preg_replace('/(\r)/', ' ', $cleanup_corps);

        $cleanup_corps = preg_replace('/(\s)+/', ' ', $cleanup_corps);


        # Remplacement via le dictionnaire de champs.
        $cleanup_corps = $this->replace_variable_champs( $document_id, $cleanup_corps, $from_template );

        // Variables du dictionnaire de champs non traitées.
        $cleanup_corps = $this->replace_unknow_champs( $document_id, $cleanup_corps, $from_template );

        // HTML Tags self-closing ► HTML3+ (<br /> | <br  /> | <p class="..." rel="...")
        // HTML Tags non-closing ► HTML3+ (<br > | <br   >) ► HTML3+ (<br />)
        // HTML Tags self-closing ► HTML3+ (<br>) ► HTML3+ (<br />)
        $cleanup_corps = preg_replace('/<([a-z]+)([^>]*)\/>/', '<$1$2 />', $cleanup_corps);
        $cleanup_corps = preg_replace('/<(hr|br)[^>]+[\s]*>/', '<$1 />', $cleanup_corps);
        $cleanup_corps = preg_replace('/<(hr|br)>/', '<$1 />', $cleanup_corps);

        # Unsupported tags (<hr>...<br>) ► Remplacement par extraction injection directement le source du ZIP

        /**
         * Cette partie mise en commentaire
         * ne comprend pas l'utilité ?
         * casse l'odt... 
         * peut etre cela pourra servir un jour
         */
        // <h1>[PlainTextTitle]</h1> ► <text:h text:style-name="Heading_20_1" text:outline-level="1">[PlainTextTitle]</text:h>
        // $cleanup_corps = preg_replace('/<h1>/', '<p>__--h1:start--__', $cleanup_corps); // Trick to replace after in xml file.
        // $cleanup_corps = preg_replace('/<\/h1>/', '__--h1:stop--__</p>', $cleanup_corps); // Trick to replace after in xml file.

        // // <h2>[PlainTextTitle]</h2> ► <text:h text:style-name="Heading_20_2" text:outline-level="2">[PlainTextTitle]</text:h>
        // $cleanup_corps = preg_replace('/<h2>/', '<p>__--h2:start--__', $cleanup_corps); // Trick to replace after in xml file.
        // $cleanup_corps = preg_replace('/<\/h2>/', '__--h2:stop--__</p>', $cleanup_corps); // Trick to replace after in xml file.

        // // <h3>[PlainTextTitle]</h3> ► <text:h text:style-name="Heading_20_3" text:outline-level="3">[PlainTextTitle]</text:h>
        // $cleanup_corps = preg_replace('/<h3>/', '<p>__--h3:start--__', $cleanup_corps); // Trick to replace after in xml file.
        // $cleanup_corps = preg_replace('/<\/h3>/', '__--h3:stop--__</p>', $cleanup_corps); // Trick to replace after in xml file.

        // // <h4>[PlainTextTitle]</h4> ► <text:h text:style-name="Heading_20_4" text:outline-level="4">[PlainTextTitle]</text:h>
        // $cleanup_corps = preg_replace('/<h4>/', '<p>__--h4:start--__', $cleanup_corps); // Trick to replace after in xml file.
        // $cleanup_corps = preg_replace('/<\/h4>/', '__--h4:stop--__</p>', $cleanup_corps); // Trick to replace after in xml file.

        // <hr /> ► <p>[VectorgraphicLine]</p>
        $cleanup_corps = preg_replace('/<hr[^>]+[\s]*\/>/', '<p style="width:100%;height:3px;border-top:black solid 1px;margin:0;">__--line--__</p>', $cleanup_corps); // Trick to replace after in xml file.

        

        // <br /> ► <text:line-break/>
        $cleanup_corps = preg_replace('/<br \/>/', '__--line-break--__', $cleanup_corps); // Trick to replace after in xml file.
        
        // HTML PageBreaks <p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;"> </p> ► PageBreak
        // HTML PageBreaks <p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;"> <strong>  ... </strong> </p> ► PageBreak
        $cleanup_corps = preg_replace('/<p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;">[\s]*<.*?>[\s]*<\/p>/', '__--page-break--__', $cleanup_corps);

        $cleanup_corps = preg_replace('/<p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;"> <\/p>/', '__--page-break--__', $cleanup_corps);
        $cleanup_corps = preg_replace('/<p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;">[\s]*<\/p>/', '__--page-break--__', $cleanup_corps);

        /**
         * mise en commentaire car sur l'ancien ODT writer 
         * les listes ne fonctionnait pas
         * 
         * avec la lib à jour, ca fonctionne
         */
        // <ul><li>item</li></ul> ► On remet en forme les items
        // $cleanup_corps = preg_replace('/<ul>/', '<p>', $cleanup_corps);

        // $cleanup_corps = preg_replace('/<li>/', '&nbsp;&bull; ', $cleanup_corps);
        // $cleanup_corps = preg_replace('/<\/li>/', '__--line-break--__', $cleanup_corps);

        // $cleanup_corps = preg_replace('/<\/ul>/', '</p>', $cleanup_corps);

        # Insertion de la date au format
        $cleanup_corps = preg_replace_callback('/\{DATE\s+(.*?)\}/',
            function ($matches) {
                return date($matches[1]);
            },
            $cleanup_corps);

        $cleanup_corps = preg_replace('/ /', ' ', $cleanup_corps); // ULTRA IMPORTANT

        # Include PhpOffice\PhpWord\PhpWord library
        require_once 'vendor/autoload.php';

        try {
            $phpWord = new \PhpOffice\PhpWord\PhpWord();
        } catch (Exception $e) {
            
            $GLOBALS['log']->fatal("Erreur Critique, la classe de génération « PhpOffice\PhpWord » n'est pas disponible!");

            // Prépare le retour de la génération (exportation) du Document Éditique.
            $export_editique = new \stdClass();
            $export_editique->content   = "";
            $export_editique->mime      = "";
            $export_editique->length    = 0;
            $export_editique->filename  = "";

            return $export_editique;

        }

        \PhpOffice\PhpWord\Settings::setOutputEscapingEnabled(true);

        # Création des sauts de pages de manière physique en découpant le contenu HTML en plusieurs parties.
        $cleanup_corps = preg_replace('/<p>__--page-break--__<\/p>/', '__--page-break--__', $cleanup_corps);
        $content_pages = preg_split('/__--page-break--__/', $cleanup_corps, -1, PREG_SPLIT_NO_EMPTY);

        $objModeleDocument = BeanFactory::getBean( 'OPS_modele_document' , $modeleId );
        
        $headerHtml = (!empty($objModeleDocument->pdfheader))?html_entity_decode($objModeleDocument->pdfheader):'';
        if(!empty($headerHtml)){
            $headerHtml = $this->replace_variable_champs( $document_id, $headerHtml, $from_template);
            $headerHtml = $this->replace_unknow_champs( $document_id, $headerHtml, $from_template);
        }

        $footerHtml = (!empty($objModeleDocument->pdffooter))?html_entity_decode($objModeleDocument->pdffooter):'';
        if(!empty($footerHtml)){
            $footerHtml = $this->replace_variable_champs( $document_id, $footerHtml, $from_template);
            $footerHtml = $this->replace_unknow_champs( $document_id, $footerHtml, $from_template);
        }

        // Pagebreak identifiés... Plusieurs sections, saut de pages contrôlés, pagination et saut de page libre.
        if( sizeof($content_pages) > 0 ){

            foreach ($content_pages as $key => $page) {
                $page_section = $phpWord->addSection(); // Création d'une nouvelle section.
                $header = $page_section->addHeader();
                $footer = $page_section->addFooter();

                if( $key > 0 ){
                    $page_section->addPageBreak(); // Ajoute un saut de page après cette section, partir de la seconde.
                }
                
                $page = str_replace(array('_lt_', '_gt_', '_amp_', '_quot_'), array('&lt;', '&gt;', '&amp;', '&quot;'), $page);

                \PhpOffice\PhpWord\Shared\Html::addHtml($header, $headerHtml, false, true);
                \PhpOffice\PhpWord\Shared\Html::addHtml($page_section, trim($page), false, true);
                \PhpOffice\PhpWord\Shared\Html::addHtml($footer, $footerHtml, false, true);
            }

        }
        // Une seule section, pagination et saut de page libre.
        else{

            $section = $phpWord->addSection();
            $header = $page_section->addHeader();
            $footer = $page_section->addFooter();

            $cleanup_corps = str_replace(array('_lt_', '_gt_', '_amp_', '_quot_'), array('&lt;', '&gt;', '&amp;', '&quot;'), $cleanup_corps);
            \PhpOffice\PhpWord\Shared\Html::addHtml($header, $headerHtml, false, true);
            \PhpOffice\PhpWord\Shared\Html::addHtml($section, $cleanup_corps, false, true);
            \PhpOffice\PhpWord\Shared\Html::addHtml($footer, $footerHtml, false, true);
        }

        $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'ODText');
        $final_name = "Export_" ."Document_Editique_".date('Y-m-d').'_'.date('His').'.odt';

        $objWriter->save($final_name);

        // Prépare le retour de la génération (exportation) du Document Éditique.
        $export_editique = new \stdClass();
        $export_editique->content   = "";
        $export_editique->mime      = "";
        $export_editique->length    = 0;
        $export_editique->filename  = "";

        if (file_exists($final_name)) {

            // Permet le remplacement par injection au sein du content.xml
            $zip = new ZipArchive;
            $file_to_modify = 'content.xml';
            if ($zip->open( $final_name ) === TRUE) {

                $old_html_content = $zip->getFromName($file_to_modify);
                $new_html_content = str_replace('?>','?><!-- [PhpOffice + Passiflore]-->', $old_html_content);
                
                # HTML Entities
                $new_html_content = str_replace(['&lt;', '&gt;', '&amp;', '&quot;'], ['_lt_', '_gt_', '_amp_', '_quot_'], $new_html_content);
                $new_html_content = html_entity_decode($new_html_content, ENT_QUOTES, 'UTF-8');
                $new_html_content = str_replace('&', '&amp;', $new_html_content);
                $new_html_content = str_replace(['_lt_', '_gt_', '_amp_', '_quot_'], ['&lt;', '&gt;', '&amp;', '&quot;'], $new_html_content);

                # Vector HR Lines styles
                $replace_s = array();

                // Special Graphic vector line.
                $replace_s[] = '<style:style style:family="paragraph" style:name="P9999"><loext:graphic-properties draw:fill-color="#000000"/><style:paragraph-properties fo:margin-bottom="0cm" fo:margin-top="0cm"/></style:style>';
                $replace_s[] = '<style:style style:family="graphic" style:name="gr9999"><style:graphic-properties draw:fill-color="#000000" draw:wrap-influence-on-position="once-concurrent" loext:allow-overlap="true" style:flow-with-text="false" style:horizontal-pos="from-left" style:horizontal-rel="paragraph" style:run-through="background" style:vertical-pos="top" style:vertical-rel="baseline" svg:stroke-color="#000000"/></style:style>';

                $new_html_content = preg_replace('/<\/office:automatic-styles>/', join('', $replace_s).'</office:automatic-styles>' , $new_html_content);

                # Vector HR Lines objects
                $replace = '<text:p text:style-name="Standard"><draw:rect draw:name="Forme1" draw:style-name="gr9999" draw:text-style-name="P9999" draw:z-index="0" svg:height="0.003cm" svg:width="15.869cm" text:anchor-type="as-char"><text:p/></draw:rect></text:p>';
                $new_html_content = preg_replace('/<text:p text:style-name="P([0-9]*)"><text:span text:style-name="T([0-9]*)">__--line--__<\/text:span><\/text:p>/', $replace, $new_html_content);

                # Line-Break
                $replace = '<text:line-break/>'; // __--line-break--__
                $new_html_content = preg_replace('/__--line-break--__/', $replace, $new_html_content);

                # Heading 20 H1
                $replace = '<text:h text:style-name="Heading_20_1" text:outline-level="1">'; // __--h1:start--__
                $new_html_content = preg_replace('/<text:p text:style-name="P([0-9]*)"><text:span text:style-name="T([0-9]*)">__--h1:start--__/', $replace, $new_html_content);

                $replace = '</text:h>'; // __--h1:stop--__
                $new_html_content = preg_replace('/__--h1:stop--__<\/text:span><\/text:p>/', $replace, $new_html_content);

                # Heading 20 H2
                $replace = '<text:h text:style-name="Heading_20_2" text:outline-level="2">'; // __--h2:start--__
                $new_html_content = preg_replace('/<text:p text:style-name="P([0-9]*)"><text:span text:style-name="T([0-9]*)">__--h2:start--__/', $replace, $new_html_content);

                $replace = '</text:h>'; // __--h2:stop--__
                $new_html_content = preg_replace('/__--h2:stop--__<\/text:span><\/text:p>/', $replace, $new_html_content);

                # Heading 20 H3
                $replace = '<text:h text:style-name="Heading_20_3" text:outline-level="3">'; // __--h3:start--__
                $new_html_content = preg_replace('/<text:p text:style-name="P([0-9]*)"><text:span text:style-name="T([0-9]*)">__--h3:start--__/', $replace, $new_html_content);

                $replace = '</text:h>'; // __--h3:stop--__
                $new_html_content = preg_replace('/__--h3:stop--__<\/text:span><\/text:p>/', $replace, $new_html_content);

                # Heading 20 H4
                $replace = '<text:h text:style-name="Heading_20_4" text:outline-level="4">'; // __--h4:start--__
                $new_html_content = preg_replace('/<text:p text:style-name="P([0-9]*)"><text:span text:style-name="T([0-9]*)">__--h4:start--__/', $replace, $new_html_content);

                $replace = '</text:h>'; // __--h4:stop--__
                $new_html_content = preg_replace('/__--h4:stop--__<\/text:span><\/text:p>/', $replace, $new_html_content);

                $zip->deleteName($file_to_modify);
                $zip->addFromString($file_to_modify, $new_html_content);

                # Injection des styles du support de police pour les balises de titre H1 à H4 (H5 et H6 n'exstent pas sur OpenOffice).
                $file_xml_name = 'styles.xml';

                $styleFichier = $zip->getFromName($file_xml_name);

                $motifHeaderStyle = '/<style:header-style>(.*?)<\/style:header-style>/s';
                preg_match($motifHeaderStyle, $styleFichier, $headerStyle);
                $headerStyle = (isset($headerStyle[1]))?$headerStyle[1]:'';

                $motifFooterStyle = '/<style:footer-style>(.*?)<\/style:footer-style>/s';
                preg_match($motifFooterStyle, $styleFichier, $footerStyle);
                $footerStyle = (isset($footerStyle[1]))?$footerStyle[1]:'';

                $motifMasterPage = '/<style:master-page style:name="Standard1" style:page-layout-name="Mpm1">(.*?)<\/style:master-page>/s';
                preg_match($motifMasterPage, $styleFichier, $masterPage);
                $masterPage = (isset($masterPage[1]))?$masterPage[1]:'';

                $file_xml_content = '<?xml version="1.0" encoding="UTF-8"?>';
                $file_xml_content.= '<office:document-styles  xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:ooo="http://openoffice.org/2004/office" xmlns:fo="urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" xmlns:style="urn:oasis:names:tc:opendocument:xmlns:style:1.0" xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" xmlns:rpt="http://openoffice.org/2005/report" xmlns:draw="urn:oasis:names:tc:opendocument:xmlns:drawing:1.0" xmlns:dr3d="urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0" xmlns:svg="urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0" xmlns:chart="urn:oasis:names:tc:opendocument:xmlns:chart:1.0" xmlns:table="urn:oasis:names:tc:opendocument:xmlns:table:1.0" xmlns:number="urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0" xmlns:ooow="http://openoffice.org/2004/writer" xmlns:oooc="http://openoffice.org/2004/calc" xmlns:css3t="http://www.w3.org/TR/css3-text/" xmlns:of="urn:oasis:names:tc:opendocument:xmlns:of:1.2" xmlns:tableooo="http://openoffice.org/2009/table" xmlns:calcext="urn:org:documentfoundation:names:experimental:calc:xmlns:calcext:1.0" xmlns:drawooo="http://openoffice.org/2010/draw" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:loext="urn:libreoffice:names:experimental:ooxml-odf-interop:xmlns:loext:1.0" xmlns:grddl="http://www.w3.org/2003/g/data-view#" xmlns:field="urn:openoffice:names:experimental:ooo-ms-interop:xmlns:field:1.0" xmlns:math="http://www.w3.org/1998/Math/MathML" xmlns:form="urn:oasis:names:tc:opendocument:xmlns:form:1.0" xmlns:script="urn:oasis:names:tc:opendocument:xmlns:script:1.0" xmlns:dom="http://www.w3.org/2001/xml-events" xmlns:officeooo="http://openoffice.org/2009/office" office:version="1.3"><office:font-face-decls><style:font-face style:name="Arial" svg:font-family="Arial"/><style:font-face style:name="Arial1" svg:font-family="Arial" style:font-family-generic="system" style:font-pitch="variable"/><style:font-face style:name="Liberation Sans" svg:font-family="&apos;Liberation Sans&apos;" style:font-family-generic="swiss" style:font-pitch="variable"/><style:font-face style:name="Microsoft YaHei" svg:font-family="&apos;Microsoft YaHei&apos;" style:font-family-generic="system" style:font-pitch="variable"/><style:font-face style:name="Segoe UI" svg:font-family="&apos;Segoe UI&apos;" style:font-family-generic="system" style:font-pitch="variable"/><style:font-face style:name="Tahoma" svg:font-family="Tahoma" style:font-family-generic="system" style:font-pitch="variable"/></office:font-face-decls><office:styles><style:default-style style:family="graphic"><style:graphic-properties svg:stroke-color="#3465a4" draw:fill-color="#729fcf" fo:wrap-option="no-wrap" draw:shadow-offset-x="0.3cm" draw:shadow-offset-y="0.3cm" draw:start-line-spacing-horizontal="0.283cm" draw:start-line-spacing-vertical="0.283cm" draw:end-line-spacing-horizontal="0.283cm" draw:end-line-spacing-vertical="0.283cm" style:writing-mode="lr-tb" style:flow-with-text="false"/><style:paragraph-properties style:text-autospace="ideograph-alpha" style:line-break="strict" style:writing-mode="lr-tb" style:font-independent-line-spacing="false"><style:tab-stops/></style:paragraph-properties><style:text-properties style:use-window-font-color="true" loext:opacity="0" loext:color-lum-mod="100%" loext:color-lum-off="0%" style:font-name="Arial" fo:font-size="10pt" fo:language="fr" fo:country="FR" style:letter-kerning="true" style:font-name-asian="Segoe UI" style:font-size-asian="10pt" style:language-asian="zh" style:country-asian="CN" style:font-name-complex="Tahoma" style:font-size-complex="10pt" style:language-complex="hi" style:country-complex="IN"/></style:default-style><style:default-style style:family="paragraph"><style:paragraph-properties fo:hyphenation-ladder-count="no-limit" style:text-autospace="ideograph-alpha" style:punctuation-wrap="hanging" style:line-break="strict" style:tab-stop-distance="1.249cm" style:writing-mode="page"/><style:text-properties style:use-window-font-color="true" loext:opacity="0" style:font-name="Arial" fo:font-size="10pt" fo:language="fr" fo:country="FR" style:letter-kerning="true" style:font-name-asian="Segoe UI" style:font-size-asian="10pt" style:language-asian="zh" style:country-asian="CN" style:font-name-complex="Tahoma" style:font-size-complex="10pt" style:language-complex="hi" style:country-complex="IN" fo:hyphenate="false" fo:hyphenation-remain-char-count="2" fo:hyphenation-push-char-count="2" loext:hyphenation-no-caps="false" loext:hyphenation-no-last-word="false" loext:hyphenation-word-char-count="no-limit" loext:hyphenation-zone="no-limit"/></style:default-style><style:default-style style:family="table"><style:table-properties table:border-model="separating"/></style:default-style><style:default-style style:family="table-row"><style:table-row-properties fo:keep-together="auto"/></style:default-style><style:style style:name="Standard" style:family="paragraph" style:class="text"/><style:style style:name="Heading" style:family="paragraph" style:parent-style-name="Standard" style:next-style-name="Text_20_body" style:class="text"><style:paragraph-properties fo:margin-top="0.423cm" fo:margin-bottom="0.212cm" style:contextual-spacing="false" fo:keep-with-next="always"/><style:text-properties style:font-name="Liberation Sans" fo:font-family="&apos;Liberation Sans&apos;" style:font-family-generic="swiss" style:font-pitch="variable" fo:font-size="14pt" style:font-name-asian="Microsoft YaHei" style:font-family-asian="&apos;Microsoft YaHei&apos;" style:font-family-generic-asian="system" style:font-pitch-asian="variable" style:font-size-asian="14pt" style:font-name-complex="Arial1" style:font-family-complex="Arial" style:font-family-generic-complex="system" style:font-pitch-complex="variable" style:font-size-complex="14pt"/></style:style><style:style style:name="Text_20_body" style:display-name="Text body" style:family="paragraph" style:parent-style-name="Standard" style:class="text"><style:paragraph-properties fo:margin-top="0cm" fo:margin-bottom="0.247cm" style:contextual-spacing="false" fo:line-height="115%"/></style:style><style:style style:name="Heading_20_1" style:display-name="Heading 1" style:family="paragraph" style:parent-style-name="Heading" style:next-style-name="Text_20_body" style:default-outline-level="1" style:class="text"><style:paragraph-properties fo:margin-top="0.423cm" fo:margin-bottom="0.212cm" style:contextual-spacing="false"/><style:text-properties fo:font-size="18pt" fo:font-weight="bold" style:font-size-asian="18pt" style:font-weight-asian="bold" style:font-size-complex="18pt" style:font-weight-complex="bold"/></style:style><style:style style:name="Heading_20_2" style:display-name="Heading 2" style:family="paragraph" style:parent-style-name="Heading" style:next-style-name="Text_20_body" style:default-outline-level="2" style:class="text"><style:paragraph-properties fo:margin-top="0.353cm" fo:margin-bottom="0.212cm" style:contextual-spacing="false"/><style:text-properties fo:font-size="16pt" fo:font-weight="bold" style:font-size-asian="16pt" style:font-weight-asian="bold" style:font-size-complex="16pt" style:font-weight-complex="bold"/></style:style><style:style style:name="Heading_20_3" style:display-name="Heading 3" style:family="paragraph" style:parent-style-name="Heading" style:next-style-name="Text_20_body" style:default-outline-level="3" style:class="text"><style:paragraph-properties fo:margin-top="0.247cm" fo:margin-bottom="0.212cm" style:contextual-spacing="false"/><style:text-properties fo:font-size="14pt" fo:font-weight="bold" style:font-size-asian="14pt" style:font-weight-asian="bold" style:font-size-complex="14pt" style:font-weight-complex="bold"/></style:style><style:style style:name="Heading_20_4" style:display-name="Heading 4" style:family="paragraph" style:parent-style-name="Heading" style:next-style-name="Text_20_body" style:default-outline-level="4" style:class="text"><style:paragraph-properties fo:margin-top="0.212cm" fo:margin-bottom="0.212cm" style:contextual-spacing="false"/><style:text-properties fo:font-size="13pt" fo:font-style="italic" fo:font-weight="bold" style:font-size-asian="13pt" style:font-style-asian="italic" style:font-weight-asian="bold" style:font-size-complex="13pt" style:font-style-complex="italic" style:font-weight-complex="bold"/></style:style><style:style style:name="Line_20_numbering" style:display-name="Line numbering" style:family="text"/><text:outline-style style:name="Outline"><text:outline-level-style text:level="1" loext:num-list-format="%1%" style:num-format=""><style:list-level-properties text:list-level-position-and-space-mode="label-alignment"><style:list-level-label-alignment text:label-followed-by="listtab"/></style:list-level-properties></text:outline-level-style><text:outline-level-style text:level="2" loext:num-list-format="%2%" style:num-format=""><style:list-level-properties text:list-level-position-and-space-mode="label-alignment"><style:list-level-label-alignment text:label-followed-by="listtab"/></style:list-level-properties></text:outline-level-style><text:outline-level-style text:level="3" loext:num-list-format="%3%" style:num-format=""><style:list-level-properties text:list-level-position-and-space-mode="label-alignment"><style:list-level-label-alignment text:label-followed-by="listtab"/></style:list-level-properties></text:outline-level-style><text:outline-level-style text:level="4" loext:num-list-format="%4%" style:num-format=""><style:list-level-properties text:list-level-position-and-space-mode="label-alignment"><style:list-level-label-alignment text:label-followed-by="listtab"/></style:list-level-properties></text:outline-level-style><text:outline-level-style text:level="5" loext:num-list-format="%5%" style:num-format=""><style:list-level-properties text:list-level-position-and-space-mode="label-alignment"><style:list-level-label-alignment text:label-followed-by="listtab"/></style:list-level-properties></text:outline-level-style><text:outline-level-style text:level="6" loext:num-list-format="%6%" style:num-format=""><style:list-level-properties text:list-level-position-and-space-mode="label-alignment"><style:list-level-label-alignment text:label-followed-by="listtab"/></style:list-level-properties></text:outline-level-style><text:outline-level-style text:level="7" loext:num-list-format="%7%" style:num-format=""><style:list-level-properties text:list-level-position-and-space-mode="label-alignment"><style:list-level-label-alignment text:label-followed-by="listtab"/></style:list-level-properties></text:outline-level-style><text:outline-level-style text:level="8" loext:num-list-format="%8%" style:num-format=""><style:list-level-properties text:list-level-position-and-space-mode="label-alignment"><style:list-level-label-alignment text:label-followed-by="listtab"/></style:list-level-properties></text:outline-level-style><text:outline-level-style text:level="9" loext:num-list-format="%9%" style:num-format=""><style:list-level-properties text:list-level-position-and-space-mode="label-alignment"><style:list-level-label-alignment text:label-followed-by="listtab"/></style:list-level-properties></text:outline-level-style><text:outline-level-style text:level="10" loext:num-list-format="%10%" style:num-format=""><style:list-level-properties text:list-level-position-and-space-mode="label-alignment"><style:list-level-label-alignment text:label-followed-by="listtab"/></style:list-level-properties></text:outline-level-style></text:outline-style><text:notes-configuration text:note-class="footnote" style:num-format="1" text:start-value="0" text:footnotes-position="page" text:start-numbering-at="document"/><text:notes-configuration text:note-class="endnote" style:num-format="i" text:start-value="0"/><text:linenumbering-configuration text:style-name="Line_20_numbering" text:number-lines="false" text:offset="0.499cm" style:num-format="1" text:number-position="left" text:increment="5"/></office:styles><office:automatic-styles><style:page-layout style:name="Mpm1"><style:page-layout-properties fo:page-width="21.001cm" fo:page-height="29.7cm" style:num-format="1" style:print-orientation="portrait" fo:margin-top="2cm" fo:margin-bottom="2cm" fo:margin-left="2cm" fo:margin-right="2cm" style:writing-mode="lr-tb" style:layout-grid-color="#c0c0c0" style:layout-grid-lines="20" style:layout-grid-base-height="0.706cm" style:layout-grid-ruby-height="0.353cm" style:layout-grid-mode="none" style:layout-grid-ruby-below="false" style:layout-grid-print="false" style:layout-grid-display="false" style:footnote-max-height="0cm" loext:margin-gutter="0cm"><style:footnote-sep style:width="0.018cm" style:distance-before-sep="0.101cm" style:distance-after-sep="0.101cm" style:line-style="solid" style:adjustment="left" style:rel-width="25%" style:color="#000000"/></style:page-layout-properties><style:header-style>'.$headerStyle.'</style:header-style><style:footer-style>'.$footerStyle.'</style:footer-style></style:page-layout><style:page-layout style:name="Mpm2"><style:page-layout-properties fo:page-width="21.001cm" fo:page-height="29.7cm" style:num-format="1" style:print-orientation="portrait" fo:margin-top="2.54cm" fo:margin-bottom="2.54cm" fo:margin-left="2.54cm" fo:margin-right="2.54cm" style:writing-mode="lr-tb" style:layout-grid-color="#c0c0c0" style:layout-grid-lines="25199" style:layout-grid-base-height="0.423cm" style:layout-grid-ruby-height="0cm" style:layout-grid-mode="none" style:layout-grid-ruby-below="false" style:layout-grid-print="false" style:layout-grid-display="false" style:footnote-max-height="0cm" loext:margin-gutter="0cm"><style:footnote-sep style:width="0.018cm" style:line-style="solid" style:adjustment="left" style:rel-width="25%" style:color="#000000"/></style:page-layout-properties><style:header-style>'.$headerStyle.'</style:header-style><style:footer-style>'.$footerStyle.'</style:footer-style><style:footer-style/></style:page-layout><style:style style:name="Mdp1" style:family="drawing-page"><style:drawing-page-properties draw:background-size="full"/></style:style></office:automatic-styles><office:master-styles><style:master-page style:name="Standard" style:page-layout-name="Mpm1" draw:style-name="Mdp1">'.$masterPage.'</style:master-page><style:master-page style:name="Standard1" style:page-layout-name="Mpm2" draw:style-name="Mdp1">'.$masterPage.'</style:master-page></office:master-styles></office:document-styles>';
                $zip->addFromString($file_xml_name, $file_xml_content);

                # Injection des meta-informations autorisant le support de styles étendus pour les balises de titre H1 à H4.
                $file_xml_name = 'meta.xml';
                $file_xml_content = '<?xml version="1.0" encoding="UTF-8"?>';
                $file_xml_content.= '<office:document-meta xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:ooo="http://openoffice.org/2004/office" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" xmlns:grddl="http://www.w3.org/2003/g/data-view#" office:version="1.3"><office:meta><dc:title/><dc:subject/><dc:description/><dc:date>'. date('Y-m-d').'T'.date('H:i:s').'.223000000</dc:date><meta:generator>Lanteas/2.3$OpenCRM Document_Éditique/</meta:generator><meta:initial-creator/><meta:creation-date>'. date('Y-m-d').'T'.date('H:i:s').'.000</meta:creation-date><meta:keyword/><meta:editing-duration>PT34S</meta:editing-duration><meta:editing-cycles>1</meta:editing-cycles><meta:document-statistic meta:table-count="0" meta:image-count="0" meta:object-count="0" meta:page-count="1" meta:paragraph-count="35" meta:word-count="135" meta:character-count="881" meta:non-whitespace-character-count="736"/><meta:user-defined meta:name="Category"/><meta:user-defined meta:name="Company"/><meta:user-defined meta:name="Manager"/></office:meta></office:document-meta>';
                $zip->addFromString($file_xml_name, $file_xml_content);


                $zip->close();
            }
         
            $export_editique->content   = base64_encode( file_get_contents($final_name) );
            $export_editique->mime      = "application/vnd.oasis.opendocument.text";
            $export_editique->length    = filesize($final_name);
            $export_editique->filename  = $final_name;

            unlink($final_name);
        }

        return $export_editique;
    }

    /**
     * Génération du document dans un format éditable de type MSWord/Doc.
     */
    public function genere_doc($document_id, $type = "docx", $html_content, $from_template=false, $modeleId)
    {

        $final_name = "Export_" ."Document_Editique_".date('Y-m-d').'_'.date('His').'.'.$type; // The default final exported file !
        $base_download = './upload/'; // Place to manipulate I/O file and data...

        # Prepare a properly parsed html input without exotic characters....
        $cleanup_corps = !empty($html_content)? $html_content : "<h1>Document Éditique vide pour son export</h1>";
        $cleanup_corps = trim( $cleanup_corps );

        $cleanup_corps = preg_replace('/ /', ' ', $cleanup_corps); // ULTRA IMPORTANT

        // Streamlining
        $cleanup_corps = preg_replace('/(\n)/', ' ', $cleanup_corps);
        $cleanup_corps = preg_replace('/(\r)/', ' ', $cleanup_corps);

        $cleanup_corps = preg_replace('/(\s)+/', ' ', $cleanup_corps);

        // sorte de flag sur les caractères spéciaux qui font planter la génération word
        // ils sont enlever lors du replacevar, et lors du add border table
        // bout de Code récupéré dans : vendor\phpoffice\phpword\src\PhpWord\Shared\Html.php (addHtml() l.69)
        $cleanup_corps = str_replace(array('&lt;', '&gt;', '&amp;', '&quot;'), array('_lt_', '_gt_', '_amp_', '_quot_'), $cleanup_corps);


        # Remplacement via le dictionnaire de champs.
        $cleanup_corps = $this->replace_variable_champs( $document_id, $cleanup_corps, $from_template );

        // Variables du dictionnaire de champs non traitées.
        $cleanup_corps = $this->replace_unknow_champs( $document_id, $cleanup_corps, $from_template );

        // HTML PageBreaks <p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;"> </p> ► PageBreak
        // HTML PageBreaks <p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;"> <strong>  ... </strong> </p> ► PageBreak
        $cleanup_corps = preg_replace('/<p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;">[\s]*<.*?>[\s]*<\/p>/', '__--page-break--__', $cleanup_corps);

        $cleanup_corps = preg_replace('/<p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;"> <\/p>/', '__--page-break--__', $cleanup_corps);
        $cleanup_corps = preg_replace('/<p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;">[\s]*<\/p>/', '__--page-break--__', $cleanup_corps);

        $cleanup_corps = preg_replace('/__--page-break--__/', '<br style="page-break-before: always; break-before: page; margin: 0; height: 1pt; line-height:1pt;" />', $cleanup_corps);

        # Insertion de la date au format
        $cleanup_corps = preg_replace_callback('/\{DATE\s+(.*?)\}/',
            function ($matches) {
                return date($matches[1]);
            },
            $cleanup_corps);

        $cleanup_corps = preg_replace('/ /', ' ', $cleanup_corps); // ULTRA IMPORTANT

        // Prépare le retour de la génération (exportation) du Document Éditique.
        $export_editique = new \stdClass();
        $export_editique->content   = "";
        $export_editique->mime      = "";
        $export_editique->length    = 0;
        $export_editique->filename  = "";

        $document_content = '';

        # Include PhpOffice\PhpWord\PhpWord library
        require_once 'vendor/autoload.php';

        try {
            $phpWord = new \PhpOffice\PhpWord\PhpWord();
        } catch (Exception $e) {
            $GLOBALS['log']->fatal("Erreur Critique, la classe de génération « PhpOffice\PhpWord » n'est pas disponible!");
            // Prépare le retour de la génération (exportation) du Document Éditique.
            $export_editique = new \stdClass();
            $export_editique->content   = "";
            $export_editique->mime      = "";
            $export_editique->length    = 0;
            $export_editique->filename  = "";

            return $export_editique;
        }

        \PhpOffice\PhpWord\Settings::setOutputEscapingEnabled(true);

        # Création des sauts de pages de manière physique en découpant le contenu HTML en plusieurs parties.
        $cleanup_corps = preg_replace('/<p>__--page-break--__<\/p>/', '__--page-break--__', $cleanup_corps);
        $content_pages = preg_split('/__--page-break--__/', $cleanup_corps, -1, PREG_SPLIT_NO_EMPTY);

        $objModeleDocument = BeanFactory::getBean( 'OPS_modele_document' , $modeleId );

        $headerHtml = (!empty($objModeleDocument->pdfheader))?html_entity_decode($objModeleDocument->pdfheader):'';
        if(!empty($headerHtml)){
            $headerHtml = $this->replace_variable_champs( $document_id, $headerHtml, $from_template);
            $headerHtml = $this->replace_unknow_champs( $document_id, $headerHtml, $from_template);
        }

        $footerHtml = (!empty($objModeleDocument->pdffooter))?html_entity_decode($objModeleDocument->pdffooter):'';
        if(!empty($footerHtml)){
            $footerHtml = $this->replace_variable_champs( $document_id, $footerHtml, $from_template);
            $footerHtml = $this->replace_unknow_champs( $document_id, $footerHtml, $from_template);
        }

        // Pagebreak identifiés... Plusieurs sections, saut de pages contrôlés, pagination et saut de page libre.
        if( sizeof($content_pages) > 0 ){

            foreach ($content_pages as $key => $page) {
                $page_section = $phpWord->addSection(); // Création d'une nouvelle section.
                $header = $page_section->addHeader();
                $footer = $page_section->addFooter();

                if( $key > 0 ){
                    $page_section->addPageBreak(); // Ajoute un saut de page après cette section, partir de la seconde.
                }

                $page = $this->addBorderTable($page);
                $page = str_replace(array('_lt_', '_gt_', '_amp_', '_quot_'), array('&lt;', '&gt;', '&amp;', '&quot;'), $page);

                
                \PhpOffice\PhpWord\Shared\Html::addHtml($header, $headerHtml, false, true);
                \PhpOffice\PhpWord\Shared\Html::addHtml($page_section, trim($page), false, true);
                \PhpOffice\PhpWord\Shared\Html::addHtml($footer, $footerHtml, false, true);
            }
        }
        // Une seule section, pagination et saut de page libre.
        else{
            $section = $phpWord->addSection();
            $header = $page_section->addHeader();
            $footer = $page_section->addFooter();
            $cleanup_corps = $this->addBorderTable($cleanup_corps);

            $cleanup_corps = str_replace(array('_lt_', '_gt_', '_amp_', '_quot_'), array('&lt;', '&gt;', '&amp;', '&quot;'), $cleanup_corps);

            \PhpOffice\PhpWord\Shared\Html::addHtml($header, $headerHtml, false, true);
            \PhpOffice\PhpWord\Shared\Html::addHtml($section, $cleanup_corps, false, true);
            \PhpOffice\PhpWord\Shared\Html::addHtml($footer, $footerHtml, false, true);
        }

        $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
        $final_name = "Export_" ."Document_Editique_".date('Y-m-d').'_'.date('His').'.docx';

        $objWriter->save($final_name);

        // Prépare le retour de la génération (exportation) du Document Éditique.
        $export_editique = new \stdClass();
        $export_editique->content   = "";
        $export_editique->mime      = "";
        $export_editique->length    = 0;
        $export_editique->filename  = "";

        if ( file_exists($final_name) ) {

            $export_editique->content   = base64_encode( file_get_contents($final_name) );
            $export_editique->mime      = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            $export_editique->length    = filesize($final_name);
            $export_editique->filename  = $final_name;

            unlink($final_name);

        }

        return $export_editique;

    }

    /**
     * Génération du document dans un format transportable de type Acrobat/PDF.
     */
    public function genere_pdf($document_id, $type = "pdf", $html_content, $from_template=false, $modeleId)
    {

        $final_name = "Export_" ."Document_Editique_".date('Y-m-d').'_'.date('His').'.'.$type; // The default final exported file !

        # Prepare a properly parsed html input without exotic characters....
        $cleanup_corps = !empty($html_content)? $html_content : "<h1>Document Éditique vide pour son export</h1>";
        $cleanup_corps = trim( $cleanup_corps );

        // sorte de flag sur les caractères spéciaux qui font planter la génération word
        // ils sont enlever lors du replacevar, et lors du add border table
        // bout de Code récupéré dans : vendor\phpoffice\phpword\src\PhpWord\Shared\Html.php (addHtml() l.69)
        $cleanup_corps = str_replace(array('&lt;', '&gt;', '&amp;', '&quot;'), array('_lt_', '_gt_', '_amp_', '_quot_'), $cleanup_corps);

        $cleanup_corps = html_entity_decode( $cleanup_corps );

        $cleanup_corps = mb_convert_encoding($cleanup_corps, 'HTML-ENTITIES', 'UTF-8');

        # Convertir les caractères spéciaux
        $special_char = array(
            '&#769;' => 'acute;', 
            '&#770;' => 'circ;',
            '&#768;' => 'grave;',
        );

        foreach($special_char as $encoded_char => $decoded_char)
        {
            $pattern = '/[aeiouyAEIOUY]' . $encoded_char . '/u';

            if(preg_match_all($pattern, $cleanup_corps, $matches))
            {
                foreach($matches[0] as $matche)
                {
                    $char = $matche[0];
                    $cleanup_corps = str_replace($char . $encoded_char, '&' . $char . $decoded_char, $cleanup_corps);
                }
            }
        }

        $cleanup_corps = preg_replace('/ /', ' ', $cleanup_corps); // ULTRA IMPORTANT

        # Remplacement via le dictionnaire de champs.
        $cleanup_corps = $this->replace_variable_champs( $document_id, $cleanup_corps, $from_template );

        // Variables du dictionnaire de champs non traitées.
        $cleanup_corps = $this->replace_unknow_champs( $document_id, $cleanup_corps, $from_template );

        $cleanup_corps = preg_replace('/<p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;">[\s]*<.*?>[\s]*<\/p>/', '__--page-break--__', $cleanup_corps);

        $cleanup_corps = preg_replace('/<p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;"> <\/p>/', '__--page-break--__', $cleanup_corps);
        $cleanup_corps = preg_replace('/<p style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;">[\s]*<\/p>/', '__--page-break--__', $cleanup_corps);

        # Création des sauts de pages de manière physique en découpant le contenu HTML en plusieurs parties.
        $cleanup_corps = preg_replace('/<p>__--page-break--__<\/p>/', '__--page-break--__', $cleanup_corps);
        $content_pages = preg_split('/__--page-break--__/', $cleanup_corps, -1, PREG_SPLIT_NO_EMPTY);


        # Insertion de la date au format
        $cleanup_corps = preg_replace_callback('/\{DATE\s+(.*?)\}/',
            function ($matches) {
                return date($matches[1]);
            },
            $cleanup_corps);

        $cleanup_corps = preg_replace('/ /', ' ', $cleanup_corps); // ULTRA IMPORTANT

        # Include mPDF library...
        ini_set("pcre.backtrack_limit", "1000000");

        $pdf = new mPDF([
                'mode' => 'en',
                'format' => 'A4',
                'orientation' => '',
                'autoLangToFont' => true,
                'backupSubsFont' => ['DejaVuSansCondensed'],
                'margin_header' => 9,     
                'margin_footer' => 9,
                'margin_top' => 16,     
                'margin_bottom' => 16,
                'margin_left' => 15,        
                'margin_right' => 15,      
            ]);

        $pdf->setAutoTopMargin = 'stretch';
        $pdf->setAutoBottomMargin = 'stretch';

        //Ajout des Header et Footer si existant;
        $headerHtml = "";
        $footerHtml = "";

        if(!empty($modeleId) && !empty($document_id)){

            $objModeleDocument = BeanFactory::getBean( 'OPS_modele_document' , $modeleId );
            $objDocumentEditique = new Documents_editiques();

            $headerHtml = (!empty($objModeleDocument->pdfheader))?html_entity_decode($objModeleDocument->pdfheader):'';
            if(!empty($headerHtml)){
                $headerHtml = $objDocumentEditique->replace_variable_champs( $document_id, $headerHtml);
                $headerHtml = $objDocumentEditique->replace_unknow_champs( $document_id, $headerHtml);
            }

            $footerHtml = (!empty($objModeleDocument->pdffooter))?html_entity_decode($objModeleDocument->pdffooter):'';
            if(!empty($footerHtml)){
                $footerHtml = $objDocumentEditique->replace_variable_champs( $document_id, $footerHtml);
                $footerHtml = $objDocumentEditique->replace_unknow_champs( $document_id, $footerHtml);
            }
        }

        $pdf->SetHTMLHeader($headerHtml);
        $pdf->SetHTMLFooter($footerHtml);

        # Création des sauts de pages de manière physique en découpant le contenu HTML en plusieurs parties.
        $content_pages = preg_split('/__--page-break--__/', $cleanup_corps, -1, PREG_SPLIT_NO_EMPTY);

        // Pagebreak identifiés... Plusieurs pages manuelles donnant des sauts de pages contrôlés, pagination et saut de page libre en fonction du contenu.
        if( sizeof($content_pages) > 0 ){
            foreach ($content_pages as $key => $page) {
                $page = str_replace(array('_lt_', '_gt_', '_amp_', '_quot_'), array('&lt;', '&gt;', '&amp;', '&quot;'), $page);
                $pdf->WriteHTML($page);
            }
        }
        // Une seule page, pagination et saut de page libre en fonction du contenu.
        else{
            $cleanup_corps = str_replace(array('_lt_', '_gt_', '_amp_', '_quot_'), array('&lt;', '&gt;', '&amp;', '&quot;'), $cleanup_corps);
            $pdf->WriteHTML($cleanup_corps);
        }

        $file_location = $_SERVER['DOCUMENT_ROOT'] . '/upload/tmp-editique-' . create_guid();
        $fp = fopen($file_location, 'wb');
        fclose($fp);
        $pdf->Output($file_location, 'F');
        // Prépare le retour de la génération (exportation) du Document Éditique.
        $export_editique = new \stdClass();
        $export_editique->content   = "";
        $export_editique->mime      = "";
        $export_editique->length    = 0;
        $export_editique->filename  = "";

        if (file_exists($file_location)) {

            $export_editique->content   = base64_encode( file_get_contents($file_location) );
            $export_editique->mime      = "application/pdf";
            $export_editique->length    = filesize($file_location);
            $export_editique->filename  = $final_name;

            unlink($file_location);

        }

        return $export_editique;

    }

    public function replace_variable_champs($document_id, $content, $from_template=false)
    {

        if( $from_template === false ){

            # On remonte sur les informations via le document...
            $obj_document = BeanFactory::getBean( 'Documents' , $document_id );

            # Permet de récupérer les potentiels Bean via les relations.
            # Cela offre aussi la possibilité de savoir dans quel module le Document Éditique est généré / exporté !
            $loaded_relationships = [];
            $relationships = [];
            try {
                $loaded_relationships = $obj_document->loaded_relationships;
            } catch (Exception $e) {}

            foreach ($loaded_relationships as $key => $relationship) {
                if( strtolower($relationship) != "ops_type_document_id" ){
                    $relationships[] = preg_replace('/^(ops_)/', 'OPS_', str_replace('_id', '', $relationship ));
                }
            }

            # Module Bean courant... recherche par itération sur un petit nombre d'éléments.
            $current_bean_name = "";
            foreach ($relationships as $key => $bean_name) {

                $id_bean = $obj_document->{strtolower($bean_name)."_id"};
                preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $id_bean, $output_array);

                if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){
                    $current_bean_name = $bean_name;
                }
            }        

            $current_bean = BeanFactory::getBean( $current_bean_name , $obj_document->{strtolower($current_bean_name)."_id"} );

        }
        elseif( is_string($from_template) && !empty( trim($from_template) ) ){

            $current_bean_name = trim($from_template);
            $current_bean = BeanFactory::getBean( $current_bean_name , $document_id );

        }
        else{
            $current_bean_name = ""; // Fallback / Pas de traitement de remplacement.
        }

        if ( in_array( $current_bean_name, array(
            'OPS_dossier',
            'OPS_individu',
            'OPS_personne_morale',
        ) ) ) {
            $ReplaceVariable = new ReplaceVariable($current_bean);
            $content = $ReplaceVariable->replace($content);
        } 

        return $content;
    }

    public function replace_unknow_champs($document_id, $content, $from_template=false)
    {
        global $sugar_config;

        # Remplacement des variables restantes non utilisées... 

        // Cette fonctionnalité est conditionnée par le paramétrage.
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();

        // Default params...
        if( intval( $configuratorObj->config['module_editique']['replacement_enabled'] ) == 0 ){
            $configuratorObj->config['module_editique']['replacement_enabled'] = 0; 
            $configuratorObj->saveConfig();
        }

        if( $configuratorObj->config['module_editique']['replacement_enabled'] ){

            // Remplacement des champs variables inconnus par (nc):
            $content = preg_replace('/(\$ops)([_]([a-z]*))*/', "<em>(nc)</em>", $content); 

        }

        return $content;
    }

    public function addBorderTable($html){
        $dom = new DOMDocument();
        libxml_use_internal_errors(true);
        $dom->loadHTML('<?xml encoding="utf-8" ?>' . $html, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
        libxml_clear_errors();

        $xpath = new DOMXPath($dom);
        // Trouver toutes les tables
        $tables = $xpath->query('//table');

        foreach ($tables as $table) {
            $hasBorder = false;

            // Vérifier si la table a déjà un style avec une bordure
            $tableStyle = $table->getAttribute('style');
            if (strpos($tableStyle, 'border:') !== false) {
                $hasBorder = true;
            }

            // Si la table n'a pas de bordure, chercher dans les cellules <td>
            if (!$hasBorder) {
                $cells = $table->getElementsByTagName('td');
                foreach ($cells as $cell) {
                    $cellStyle = $cell->getAttribute('style');
                    if (preg_match('/border:\s*[^;]+;/', $cellStyle, $matches)) {
                        // Ajouter la bordure au style de la table
                        $border = explode(' ', $matches[0]);
                        $newBorder = "border-style: ".$border[1]."; border-width: ".$border[2]."; border-color: ".$border[3]."";
                        $newTableStyle = trim($tableStyle . ' ' . $newBorder);
                        $table->setAttribute('style', $newTableStyle);
                        break;
                    }
                }
            }
        }


        // Enregistrer le HTML sans encoder les caractères spéciaux
        $htmlOutput = $dom->saveHTML();
        
        // apres le savehtml le / de la balise image est enlevé : <img>
        // pour permettre l'ajout d'une image il faut corrigé ça
        $htmlOutput = preg_replace('/<img([^>]*)>/', '<img$1 />', $htmlOutput);

        $htmlOutput = preg_replace('/<\?xml.*?\?>/', '', $htmlOutput); // Supprimer l'entête XML
        $htmlOutput = html_entity_decode($htmlOutput, ENT_QUOTES, 'UTF-8');
        $htmlOutput = str_replace('<br>','<br />',$htmlOutput);

        return $htmlOutput;
    }
}