 <?php
/*
 * Gestion des rappels des rendez-vous 
 *
 */

$job_strings[] = 'notification_justificatifs';

use ODE\Mailer\OdeEmail;
use ODE\Mailer\OdeMailer;

function notification_justificatifs()
{
    global $db, $sugar_config, $beanFiles;
    
    require_once($beanFiles["OPS_justificatif"]);
    
    $requete = $db->query(
        "SELECT ops_justificatif.id as id_justificatif,
            ops_type_document.id as id_type_document,
            ops_type_document.name as nom_document,
            ops_type_document.ops_notifications_email_id as id_modele_email,
            ops_type_document.objet as objet
        FROM ops_justificatif, ops_type_document_ops_justificatif , ops_type_document 
        WHERE ops_justificatif.id = ops_type_document_ops_justificatif.ops_justificatif_id 
        AND ops_type_document_ops_justificatif.ops_type_document_id = ops_type_document.id 
        AND ops_type_document.notification =  true
        AND ( ops_justificatif.statut  = 'rejete' OR ops_justificatif.statut  = 'non_fourni')
        AND ops_justificatif.notification = false
        AND ops_justificatif.date_modified < DATE_ADD(UTC_TIMESTAMP(), INTERVAL -ops_type_document.nb_jours day)
        LIMIT 10 "
    );

    while ($row = $db->fetchRow($requete)) {
        $liste_justificatifs[$row['id_justificatif']] = $row; 
    }

    if( count($liste_justificatifs) > 0 ){

        foreach ($liste_justificatifs as $id_justif => $un_justif) {
            // Récupération du type de document 
            $id_modele_mail = $un_justif['id_modele_email']; 

            if ( !empty($id_modele_mail) ) {

                $obj_justificatif = BeanFactory::getBean('OPS_justificatif',$un_justif['id_justificatif']);

                // Récupération de l'objet du mail : 
                switch ($un_justif['objet']) {
                    case 'dossier':
                        $bean_source_name = 'OPS_dossier';
                        $obj_justificatif->load_relationship("ops_dossier_ops_justificatif");
                        $liste_beans = $obj_justificatif->ops_dossier_ops_justificatif->getBeans() ; 
                        foreach ($liste_beans as $key => $bean) {
                            $objet = $bean ; 
                        }
                        // Récupération du demandeur : 
                        $obj_individu = new OPS_individu();
                        $obj_individu->retrieve( $objet->ops_individu_id ); 
                        $email = $obj_individu->email1;
                        $type_historique = 'OPS_individu';
                        $id_historique = $objet->ops_individu_id;
                        break;
                    case 'tiers':
                        $bean_source_name = 'OPS_personne_morale';
                        $obj_justificatif->load_relationship("ops_personne_morale_ops_justificatif");
                        $liste_beans = $obj_justificatif->ops_personne_morale_ops_justificatif->getBeans() ; 
                        foreach ($liste_beans as $key => $bean) {
                            $objet = $bean ; 
                        }
                        $email = $objet->email1;
                        $type_historique = 'OPS_personne_morale';
                        $id_historique = $objet->id;
                        break;
                    default:   
                        $GLOBALS['log']->fatal('Justififs - Objet non pris en compte ' . $un_justif['objet'] );
                        continue;
                }

                if( !empty( $email ) ){

                    # On initialise le mailer 
                    $mailer = new OdeMailer();

                    # On initialise l'email 
                    $ode_email = new OdeEmail([
                        'bean_source_id' => $objet->id,
                        'bean_source_name' => $bean_source_name,
                        'bean_historisation_id' => $id_historique,
                        'bean_historisation_name' => $type_historique,
                        'email_template_id' => $id_modele_mail,
                        'dest_to' => $email,
                    ]);

                    # On déclenche l'envoie
                    $mailer->send($ode_email);

                    $obj_justificatif->notification = true; 
                    $obj_justificatif->save();
                }

            }
            else{
                $GLOBALS['log']->fatal('Justififs - Notification pas de modèle mail pour le type ' . $un_justif['id_modele_email']);

            }
        }
    }
    
    return true;
} 