 <?php

/*
 * Supprime les justificatifs périmés
 *
 */

$job_strings[] = 'supprimer_justificatif';

function supprimer_justificatif()
{
    global $beanFiles, $db;
    
    require_once($beanFiles["OPS_justificatif"]);

    require_once('modules/Configurator/Configurator.php');

    $configuratorObj = new Configurator();
    $jours_perime = $configuratorObj->config['opensocle']['justificatif_jours_perime'];
    $jours_perime = (isset($jours_perime) && !empty($jours_perime)) ? $jours_perime : 0;

    $query = "
        SELECT id 
        FROM ops_justificatif 
        WHERE deleted = 0 
        AND statut = 'perime' 
        AND date_modified <= DATE_ADD(UTC_TIMESTAMP(), INTERVAL -" . $jours_perime . " day)";

    $requete = $db->query($query);

    while ($row = $db->fetchRow($requete)) 
    {
        $obj_justificatif = BeanFactory::getBean('OPS_justificatif', $row['id']);
        $obj_justificatif->mark_deleted($row['id']);
        $obj_justificatif->save();
    }

    return true;
}