<?php

class ops_hook_users_dashlets
{
    /**
     * set_user_profile
     * Fonction du hook permettant le paramétrage de la page d'accueil et des vues listes de l'agent après la connexion
     *
     * @param  mixed $bean
     * @param  mixed $event
     * @param  mixed $arguments
     *
     * @return void
     */
    public function set_user_profile($bean, $event, $arguments = null)
    {
        global $beanFiles, $current_user;

        if ($event != 'after_login') {
            return;
        }

        $this->set_user_dashlets();
    }

    public function set_user_dashlets()
    {
        global $beanFiles;

        $tab_onglets_dashlets = $this->get_user_onglets();

        // On initialise la page d'accueil de l'agent vide par défaut
        $array_dashlets['dashlets'] = array();

        if (!empty($tab_onglets_dashlets)) {
            for ($i = 0; $i < count($tab_onglets_dashlets); $i++) {
                $array_dashlets['pages'][$i]['numColumns']            = $tab_onglets_dashlets[$i]['nb_colonnes'];
                $array_dashlets['pages'][$i]['pageTitle']             = $tab_onglets_dashlets[$i]['name'];

                $num_dashlet = 0;

                foreach ($tab_onglets_dashlets[$i]['colonnes'] as $num_colonne => $colonne) {
                    foreach ($colonne['dashlets'] as $id => $dashlet) {
                        if ($dashlet['dashlet_modele']) {
                            if (strpos($dashlet['dashlet_modele'], '-')) {
                                $modele = explode('-', $dashlet['dashlet_modele'])[1];
                            } else {
                                $modele = $dashlet['dashlet_modele'];
                            }
                        } else {
                            $modele = $dashlet['dashlet_objet'];
                        }

                        $array_dashlets['dashlets'][$id]['className']          = $modele . 'Dashlet';
                        $array_dashlets['dashlets'][$id]['options']            = unserialize(base64_decode($dashlet['options']));
                        $array_dashlets['dashlets'][$id]['options']['filters'] = unserialize(base64_decode($dashlet['filtres']));

                        if ($dashlet['dashlet_objet'] == "OPS_dossier") {
                            if(!empty($array_dashlets['dashlets'][$id]['options']['filters']) && array_key_exists('territoire', $array_dashlets['dashlets'][$id]['options']['filters']))
                            {
                                foreach($array_dashlets['dashlets'][$id]['options']['filters']['territoire'] as $territoire) 
                                {
                                    $obj_territoire = BeanFactory::getBean('OPS_territoire', $territoire);
                                    if(!empty($obj_territoire->id))
                                    {
                                        $list_sous_territoire = $obj_territoire->get_linked_beans('ops_sous_territoire_ops_territoire', 'OPS_sous_territoire');
                                        foreach($list_sous_territoire as $sous_territoire)
                                        {
                                            $array_dashlets['dashlets'][$id]['options']['filters']['ops_sous_territoire_ops_dossier_name'][] = $sous_territoire->id;
                                        }
                                    }
                                }

                                unset($array_dashlets['dashlets'][$id]['options']['filters']['territoire']);
                            }

                            if (isset($array_dashlets['dashlets'][$id]['options']['filters']['filtre_metadata']) && isset($array_dashlets['dashlets'][$id]['options']['filters']['metadata_value'])) {
                                $filtre_metadata       = $array_dashlets['dashlets'][$id]['options']['filters']['filtre_metadata'];
                                $filtre_metadata_value = $array_dashlets['dashlets'][$id]['options']['filters']['metadata_value'];

                                unset($array_dashlets['dashlets'][$id]['options']['filters']['filtre_metadata']);
                                unset($array_dashlets['dashlets'][$id]['options']['filters']['metadata_value']);

                                

                                require_once($beanFiles['OPS_dossier']);
                                $bean_dossier              = BeanFactory::getBean('OPS_dossier');
                                $field_defs['OPS_dossier'] = $bean_dossier->getFieldDefinitions();

                                require_once 'modules/ModuleBuilder/views/view.modulefields.php';
                                $viewmodfields = new ViewModulefields();

                                foreach ($field_defs['OPS_dossier'] as $name => $value) {
                                    if ($viewmodfields->isValidStudioField($value)) {
                                        if ($filtre_metadata == $value['name']) {
                                            if ($value['type'] == 'bool') {
                                                $array_dashlets['dashlets'][$id]['options']['filters'][$filtre_metadata] = $filtre_metadata_value;
                                            } else {
                                                $array_dashlets['dashlets'][$id]['options']['filters'][$filtre_metadata][] = $filtre_metadata_value;
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        $array_dashlets['dashlets'][$id]['options']['title'] = $dashlet['name'];

                        $array_dashlets['dashlets'][$id]['options']['displayRows'] = ($dashlet['dashlet_objet'] == 'Favorites') ? 100 : (!empty($dashlet['nb_ligne']) ? $dashlet['nb_ligne'] : 5);
                        $liste_colonnes_affichees                                  = array_filter(explode("\n", $dashlet['description']));
                        for ($j = 0; $j < count($liste_colonnes_affichees); $j++) {
                            $array_dashlets['dashlets'][$id]['options']['displayColumns'][$j] = $liste_colonnes_affichees[$j];
                        }
                        $array_dashlets['dashlets'][$id]['options']['autoRefresh'] = 1;

                        $array_dashlets['dashlets'][$id]['module']       = $dashlet['dashlet_objet'];
                        if (file_exists('custom/modules/' . $dashlet['dashlet_objet'] . '/Dashlets/' . $modele . 'Dashlet/')) {
                            $array_dashlets['dashlets'][$id]['fileLocation'] = 'custom/modules/' . $dashlet['dashlet_objet'] . '/Dashlets/' . $modele . 'Dashlet/' . $modele . 'Dashlet.php';
                        } else {
                            $array_dashlets['dashlets'][$id]['fileLocation'] = 'modules/' . $dashlet['dashlet_objet'] . '/Dashlets/' . $modele . 'Dashlet/' . $modele . 'Dashlet.php';
                        }

                        $array_dashlets['pages'][$i]['columns'][$num_colonne]['dashlets'][$num_dashlet] = $id;
                        $num_dashlet++;
                    }
                }
            }

            require_once('modules/UserPreferences/UserPreference.php');

            $user_pref = new UserPreference();
            $user_home = $user_pref->retrieve_by_string_fields(array(
                'category' => 'Home',
                'deleted' => '0',
                'assigned_user_id' => $_SESSION['authenticated_user_id']
            ));

            $user_pref_bean = BeanFactory::getBean('UserPreferences', $user_home->id);
            $user_pref_bean->contents = base64_encode(serialize($array_dashlets));
            $user_pref_bean->save();
        }
    }

    public function get_user_onglets()
    {
        global $current_user;

        // On récupère les groupes de sécurité de l'utilisateur
        $current_user->load_relationship('SecurityGroups');
        $securitygroups_ids = $current_user->SecurityGroups->get();

        if (!empty($securitygroups_ids)) {
            $securitygroup_bean = BeanFactory::getBean('SecurityGroups', $securitygroups_ids[0]);

            // On paramètre un variable de session pour brider la page d'accueil dans le TPL d'affichage des Dashlets :
            // (themes/SuiteP/include/Dashlets/DashletHeader.tpl)
            $_SESSION['bridage_accueil'] = $securitygroup_bean->bridage_page_accueil_c;

            // On récupère les liaisons ONGLETS et Groupes de sécurité
            $securitygroup_bean->load_relationship('ops_onglet_securitygroups_securitygroups');
            $onglet_ids = $securitygroup_bean->ops_onglet_securitygroups_securitygroups->get();

            // Pour chaque liaison, on récupère le bean de la liaison (module intermédiaire)
            for ($i = 0; $i < count($onglet_ids); $i++) {
                $onglet_securitygroups_bean = BeanFactory::getBean('OPS_onglet_securitygroups', $onglet_ids[$i]);

                // On récupère la relation entre le module intermédiaire et l'onglet
                $onglet_securitygroups_bean->load_relationship('ops_onglet_securitygroups_ops_onglet');
                $onglet_securitygroups_link = $onglet_securitygroups_bean->ops_onglet_securitygroups_ops_onglet->get();

                // On récupère le bean de l'onglet
                $onglet_bean = BeanFactory::getBean('OPS_onglet', $onglet_securitygroups_link[0]);

                // On intialise le tableau contenant les onglets avec pour chaque onglet, les dashlets à l'interieur
                $tab_onglets_dashlets[$i]['name']        = empty($onglet_bean->libelle) ? $onglet_bean->name : $onglet_bean->libelle;
                $tab_onglets_dashlets[$i]['ordre']       = $onglet_securitygroups_bean->ordre;
                $tab_onglets_dashlets[$i]['nb_colonnes'] = empty($onglet_bean->nb_colonnes) ? 1 : $onglet_bean->nb_colonnes;

                // On récupère la liste des dashlets de l'onglet
                $onglet_bean->load_relationship('ops_dashlet_onglet_ops_onglet');
                $dashlet_onglet_ids = $onglet_bean->ops_dashlet_onglet_ops_onglet->get();

                for ($j = 0; $j < count($dashlet_onglet_ids); $j++) {
                    $dashlet_onglet_bean = BeanFactory::getBean('OPS_dashlet_onglet', $dashlet_onglet_ids[$j]);

                    $dashlet_onglet_bean->load_relationship('ops_dashlet_onglet_ops_dashlet');
                    $dashlet_ids = $dashlet_onglet_bean->ops_dashlet_onglet_ops_dashlet->get();

                    $dashlet_bean = BeanFactory::getBean('OPS_dashlet', $dashlet_ids[0]);

                    if ($onglet_bean->nb_colonnes == 2) {
                        switch ($dashlet_onglet_bean->colonne) {
                            case 'gauche':
                                $num_colonne = 0;
                                break;
                            case 'droite':
                                $num_colonne = 1;
                                break;
                            default:
                                $num_colonne = 0;
                                break;
                        }
                    } else {
                        $num_colonne = 0;
                    }

                    if ($dashlet_bean->flag_actif == 1) {
                        $tab_onglets_dashlets[$i]['colonnes'][$num_colonne]['dashlets'][$dashlet_bean->id]['name']          = $dashlet_bean->name;
                        $tab_onglets_dashlets[$i]['colonnes'][$num_colonne]['dashlets'][$dashlet_bean->id]['nb_ligne']          = $dashlet_bean->nb_ligne;
                        $tab_onglets_dashlets[$i]['colonnes'][$num_colonne]['dashlets'][$dashlet_bean->id]['description']   = $dashlet_bean->description;
                        $tab_onglets_dashlets[$i]['colonnes'][$num_colonne]['dashlets'][$dashlet_bean->id]['ordre']         = $dashlet_onglet_bean->ordre;
                        $tab_onglets_dashlets[$i]['colonnes'][$num_colonne]['dashlets'][$dashlet_bean->id]['dashlet_objet'] = $dashlet_bean->dashlet_objet;
                        $tab_onglets_dashlets[$i]['colonnes'][$num_colonne]['dashlets'][$dashlet_bean->id]['dashlet_modele'] = $dashlet_bean->dashlet_modele;
                        $tab_onglets_dashlets[$i]['colonnes'][$num_colonne]['dashlets'][$dashlet_bean->id]['options']       = $dashlet_bean->options;
                        $tab_onglets_dashlets[$i]['colonnes'][$num_colonne]['dashlets'][$dashlet_bean->id]['filtres']       = $dashlet_bean->filtres;

                        ksort($tab_onglets_dashlets[$i]['colonnes']);
                        
                        // On trie le tableau des dashlets par la colonne "Ordre"
                        $ordre_dashlets = array_column($tab_onglets_dashlets[$i]['colonnes'][$num_colonne]['dashlets'], 'ordre');
                        array_multisort($ordre_dashlets, SORT_ASC, $tab_onglets_dashlets[$i]['colonnes'][$num_colonne]['dashlets']);
                    }
                }
            }

            if (is_array($tab_onglets_dashlets)) {
                // On trie le tableau des onglets par la colonne "Ordre"
                $ordre_onglets = array_column($tab_onglets_dashlets, 'ordre');
                array_multisort($ordre_onglets, SORT_ASC, $tab_onglets_dashlets);
            }

            return $tab_onglets_dashlets;
        } else {
            $_SESSION['bridage_accueil'] = 0;
        }

        return;
    }
}
