<?php

if (!defined('sugarEntry')) define('sugarEntry', true);

require_once 'modules/OPS_generateur_champ/generateur_champ.php';

use ODE\Model\DossierModel;
use ODE\Model\CampagneModel;
use ODE\Model\CommissionModel;
use ODE\Model\DispositifModel;
use ODE\Model\DomiciliationModel;
use ODE\Model\EngagementModel;
use ODE\Model\IndividuModel;
use ODE\Model\LocalisationModel;
use ODE\Model\PersonneMoraleModel;
use ODE\Model\ReunionModel;

class OPS_dossierAPI
{

    private $dossierModel;
    private $GenerateurChamp;
    private $dossier;
    private $champs;

    /**
     * @access public
     * @name getChamps()
     * Fonction qui 
     * 
     *  @param string             - $dossier_id
     *  @return array             - $champs_additionnel
     */
    public function getChamps($dossier_id, $config)
    {

        $this->champs = array();
        $this->dossierModel = new DossierModel($dossier_id);

        do {

            // On vérifie la configuration
            if (!is_array($config) || count($config) === 0) {
                $GLOBALS['log']->fatal(" [ Erreur API ] OPS_dossierAPI :: getChamps() => Tableau de configuration vide. ");
                break;
            }

            // On vérifie que le dossier existe bien
            $this->dossier = $this->dossierModel->getBean();
            if (!is_array($this->dossier) || count($this->dossier) === 0 || empty($this->dossier['id'])) {
                $GLOBALS['log']->fatal(" [ Erreur API ] OPS_dossierAPI :: getChamps() => Le dossier ( id = " . $dossier_id . " ) est introuvable.");
                break;
            }

            foreach ($config as $module_name => $module_config) {

                switch ($module_name) {
                    case 'OPS_dispositif':
                        $this->getChampsDispositif($module_config);
                        break;
                    case 'OPS_campagne':
                        $this->getChampsCampagne($module_config);
                        break;
                    case 'OPS_reunion':
                        $this->getChampsReunion($module_config);
                        break;
                    case 'OPS_commission':
                        $this->getChampsCommission($module_config);
                        break;
                    case 'OPS_engagement':
                        $this->getChampsEngagement($module_config);
                        break;
                    case 'Coriolis':
                        $this->getChampsCoriolis($module_config);
                        break;
                    case 'Demandeur':
                        $this->getChampsDemandeur($module_config);
                        break;
                    case 'OPS_appairage':
                        $this->getChampsAppairage($module_config);
                        break;
                    default:
                        $GLOBALS['log']->fatal(" [ Erreur API ] OPS_dossierAPI :: getChamps() => le module -" . $module_name . "- n'est pas géré par l'api ODE");
                        break;
                }
            }
        } while (0);
        /*
        $GLOBALS['log']->fatal(
            ' -------------------------- OPS_dossierAPI :: getChamps() => ' . print_r(
            array( 
                "dossier_id" => $dossier_id,
                "this->champs" => $this->champs
            ), true) 
        );
*/
        return $this->champs;
    }

    /**
     * @access public
     * @name getChampsDispositif()
     * Fonction qui 
     *
     */
    private function getChampsDispositif($config)
    {

        if (is_array($config) && count($config) > 0 && !empty($config['champs']) && !empty($config['type_retour'])) {

            // On récupere le type de retour "string" ou "array"
            $type_retour = (!empty($config['type_retour'])) ? $config['type_retour'] : "string";

            // On récupere l'id du dispositif associé au dossier
            $dispositif_id = $this->dossierModel->getDispositifId();

            // On récupere le dispositif
            $dispositifModel = new DispositifModel($dispositif_id);
            $dispositif = $dispositifModel->getBean();

            foreach ($config['champs'] as $champ_label => $champ_name) {
                $value = (array_key_exists($champ_name, $dispositif) === true) ? $dispositif[$champ_name] : "";
                if ($type_retour === "string") {
                    $this->champs[$champ_label] = $value;
                } else {
                    $this->champs["dispositif"][$champ_label] = $value;
                }
            }
        }
    }

    /**
     * @access public
     * @name getChampsAppairage()
     * Fonction qui 
     *
     */
    private function getChampsAppairage($config)
    {

        global $beanFiles;

        if (is_array($config) && count($config) > 0 && !empty($config['champs']) && !empty($config['type_retour'])) {

            // On récupere le type de retour "string" ou "array"
            $type_retour = (!empty($config['type_retour'])) ? $config['type_retour'] : "string";

            $obj_appairage = new OPS_appairage();
            $un_appairage  = $obj_appairage->retrieve_by_string_fields(array(
                'logiciel' => $config['logiciel'],
                'parent_type' => "OPS_dossier",
                'parent_id' => $this->dossier['id']
            ));

            if (!empty($un_appairage->id)) {
                $this->champs['num_' . $config['logiciel']] = $un_appairage->name;
            }
        }
    }

    /**
     * @access public
     * @name getChampsCampagne()
     * Fonction qui 
     *
     */
    private function getChampsCampagne($config)
    {

        if (is_array($config) && count($config) > 0 && !empty($config['champs']) && !empty($config['type_retour'])) {

            // On récupere le type de retour "string" ou "array"
            $type_retour = (!empty($config['type_retour'])) ? $config['type_retour'] : "string";

            // On récupere l'id de la campagne associé au dossier
            $campagne_id = $this->dossierModel->getCampagneId();

            // On récupere le campagne
            $campagneModel = new CampagneModel($campagne_id);
            $campagne = $campagneModel->getBean();

            foreach ($config['champs'] as $champ_label => $champ_name) {
                $value = (array_key_exists($champ_name, $campagne) === true) ? $campagne[$champ_name] : "";
                if ($type_retour === "string") {
                    $this->champs[$champ_label] = $value;
                } else {
                    $this->champs["campagne"][$champ_label] = $value;
                }
            }
        }
    }

    /**
     * @access public
     * @name getChampsReunion()
     * Fonction qui 
     *
     */
    private function getChampsReunion($config)
    {

        $reunions = array();

        if (is_array($config) && count($config) > 0 && !empty($config['champs']) && !empty($config['type_retour'])) {

            // On récupere le type de retour "string" ou "array"
            $type_retour = (!empty($config['type_retour'])) ? $config['type_retour'] : "string";

            // On récupere l'id de la reunion associé au dossier
            $reunion_ids = $this->dossierModel->getReunionIds();
            if (is_array($reunion_ids) && count($reunion_ids) > 0) {
                foreach ($reunion_ids as $reunion_id) {
                    $reunionModel = new ReunionModel($reunion_id);
                    $reunions[] = $reunionModel->getBean();
                }
            }

            if (count($reunions) > 1) {
                foreach ($reunions as $reunion) {
                    foreach ($config['champs'] as $champ_label => $champ_name) {
                        $value = (array_key_exists($champ_name, $reunion) === true) ? $reunion[$champ_name] : "";
                        if ($type_retour === "string") {
                            $this->champs["reunions"] = "Plusieurs réunions sont associés à ce dossier, changez la configuration API pour retourner un tableau.";
                        } else {
                            $this->champs["reunions"][$reunion['id']][$champ_label] = $value;
                        }
                    }
                }
            } else {
                foreach ($config['champs'] as $champ_label => $champ_name) {
                    $value = (count($reunions) === 1 && array_key_exists($champ_name, $reunions[0]) === true) ? $reunions[0][$champ_name] : "";
                    if ($type_retour === "string") {
                        $this->champs[$champ_label] = $value;
                    } else {
                        $this->champs["reunions"][$champ_label] = $value;
                    }
                }
            }
        }
    }

    /**
     * @access public
     * @name getChampsCommission()
     * Fonction qui 
     *
     */
    private function getChampsCommission($config)
    {

        $commissions = array();

        if (is_array($config) && count($config) > 0 && !empty($config['champs']) && !empty($config['type_retour'])) {

            // On récupere le type de retour "string" ou "array"
            $type_retour = (!empty($config['type_retour'])) ? $config['type_retour'] : "string";

            // On récupere l'id de la commission associé au dossier
            $commission_ids = $this->dossierModel->getCommissionIds();
            if (is_array($commission_ids) && count($commission_ids) > 0) {
                foreach ($commission_ids as $commission_id) {
                    $commissionModel = new CommissionModel($commission_id);
                    $commissions[] = $commissionModel->getBean();
                }
            }

            if (count($commissions) > 1) {
                foreach ($commissions as $commission) {
                    foreach ($config['champs'] as $champ_label => $champ_name) {
                        $value = (array_key_exists($champ_name, $commission) === true) ? $commission[$champ_name] : "";
                        if ($type_retour === "string") {
                            $this->champs["commissions"] = "Plusieurs réunions sont associés à ce dossier, changez la configuration API pour retourner un tableau.";
                        } else {
                            $this->champs["commissions"][$commission['id']][$champ_label] = $value;
                        }
                    }
                }
            } else {
                foreach ($config['champs'] as $champ_label => $champ_name) {
                    $value = (count($commissions) === 1 && array_key_exists($champ_name, $commissions[0]) === true) ? $commissions[0][$champ_name] : "";
                    if ($type_retour === "string") {
                        $this->champs[$champ_label] = $value;
                    } else {
                        $this->champs["commissions"][$champ_label] = $value;
                    }
                }
            }
        }
    }

    /**
     * @access public
     * @name getChampsDemandeur()
     * Fonction qui 
     *
     */
    private function getChampsDemandeur($config)
    {

        if (is_array($config) && count($config) > 0 && !empty($config['champs']) && !empty($config['type_retour'])) {

            // On récupere le type de retour "string" ou "array"
            $type_retour = (!empty($config['type_retour'])) ? $config['type_retour'] : "string";

            // On récupere le type de demandeur
            $demandeur_type = $this->dossierModel->getDemandeurType();

            if ($demandeur_type === "Personne Morale") {
                // On récupere l'id de la personne_morale associé au dossier
                $personne_morale_id = $this->dossierModel->getDemandeurId();
                // On récupere le personne_morale
                $personneMoraleModel = new PersonneMoraleModel($personne_morale_id);
                $demandeur = $personneMoraleModel->getBean();
            } else {
                // On récupere l'id de la individu associé au dossier
                $individu_id = $this->dossierModel->getDemandeurId();
                // On récupere le individu
                $individuModel = new IndividuModel($individu_id);
                $demandeur = $individuModel->getBean();
            }

            foreach ($config['champs'] as $champ_label => $champ_name) {

                $value = "";
                if (is_array($champ_name)) {
                    if (!empty($champ_name['module_id']) && !empty($champ_name['module_name']) && !empty($champ_name['champ_name'])) {
                        if (array_key_exists($champ_name['module_id'], $demandeur) === true) {
                            if ($champ_name['module_name'] === "OPS_individu") {
                                $individuModel = new IndividuModel($demandeur[$champ_name['module_id']]);
                                $individu = $individuModel->getBean();
                                $value = (array_key_exists($champ_name['champ_name'], $individu) === true) ? $individu[$champ_name['champ_name']] : "";
                            }
                        }
                    }
                } else {
                    $value = (array_key_exists($champ_name, $demandeur) === true) ? $demandeur[$champ_name] : "";
                }

                if ($type_retour === "string") {
                    $this->champs[$champ_label] = $value;
                } else {
                    $this->champs["demandeur"][$champ_label] = $value;
                }
            }
        }
    }

    /**
     * @access public
     * @name getChampsEngagement()
     * Fonction qui 
     *
     */
    private function getChampsEngagement($config)
    {

        $engagements = array();

        if (is_array($config) && count($config) > 0 && !empty($config['champs']) && !empty($config['type_retour'])) {

            // On récupere le type de retour "string" ou "array"
            $type_retour = (!empty($config['type_retour'])) ? $config['type_retour'] : "string";

            // On récupere l'id de la engagement associé au dossier
            $engagement_ids = $this->dossierModel->getEngagementIds();
            if (is_array($engagement_ids) && count($engagement_ids) > 0) {
                foreach ($engagement_ids as $engagement_id) {
                    $engagementModel = new EngagementModel($engagement_id);
                    $engagements[] = $engagementModel->getBean();
                }
            }

            if (count($engagements) > 1) {
                foreach ($engagements as $engagement) {
                    foreach ($config['champs'] as $champ_label => $champ_name) {
                        if (is_array($champ_name)) {
                            foreach ($champ_name as $module_name => $config_module) {
                                if ($module_name === "OPS_liquidation") {
                                    $this->champs["engagements"][$engagement['id']]["liquidations"] = $this->getChampsLiquidationsByEngagement($engagement['liquidations'], $config_module);
                                }
                            }
                        } else {
                            $value = (array_key_exists($champ_name, $engagement) === true) ? $engagement[$champ_name] : "";
                            if ($type_retour === "string") {
                                $this->champs["engagements"] = "Plusieurs engagements sont associés à ce dossier, changez la configuration API pour retourner un tableau.";
                            } else {
                                $this->champs["engagements"][$engagement['id']][$champ_label] = $value;
                            }
                        }
                    }
                }
            } else {
                foreach ($config['champs'] as $champ_label => $champ_name) {
                    if (is_array($champ_name)) {
                        foreach ($champ_name as $module_name => $config_module) {
                            if ($module_name === "OPS_liquidation") {
                                if (count($engagements) === 1) {
                                    $this->champs["engagements"]["liquidations"] = $this->getChampsLiquidationsByEngagement($engagements[0]['liquidations'], $config_module);
                                } else {
                                    $this->champs["engagements"] = array();
                                }
                            }
                        }
                    } else {

                        $value = (count($engagements) === 1 && array_key_exists($champ_name, $engagements[0]) === true) ? $engagements[0][$champ_name] : "";
                        if ($type_retour === "string") {
                            $this->champs[$champ_label] = $value;
                        } else {
                            if (count($engagements) === 1) {
                                $this->champs["engagements"][$champ_label] = $value;
                            }
                        }
                    }
                }
            }
        }

        $this->champs["engagements"] = array_values($this->champs["engagements"]);
    }


    /**
     * @access public
     * @name getChampsLiquidationsByEngagement()
     * Fonction qui 
     *
     */
    private function getChampsLiquidationsByEngagement($liquidations, $config_module)
    {

        $liquidations_value = array();

        if (is_array($config_module) && count($config_module) > 0 && !empty($config_module['champs']) && !empty($config_module['type_retour'])) {

            $type_retour = (!empty($config_module['type_retour'])) ? $config_module['type_retour'] : "string";

            if (count($liquidations) > 1) {
                foreach ($liquidations as $liquidation) {
                    foreach ($config_module['champs'] as $champ_label => $champ_name) {
                        $value = (array_key_exists($champ_name, $liquidation) === true) ? $liquidation[$champ_name] : "";
                        if ($type_retour === "string") {
                            $liquidations_value = "Plusieurs liquidations sont associés à cet engagement, changez la configuration API pour retourner un tableau.";
                        } else {
                            $liquidations_value[$liquidation['id']][$champ_label] = $value;
                        }
                    }
                }
            } else {
                foreach ($config_module['champs'] as $champ_label => $champ_name) {
                    if (count($liquidations) === 1) {
                        $value = (array_key_exists($champ_name, $liquidations[0]) === true) ? $liquidations[0][$champ_name] : "";
                        if ($type_retour === "string") {
                            $liquidations_value[$champ_label] = $value;
                        } else {
                            $liquidations_value[$champ_label] = $value;
                        }
                    }
                }
            }
        }

        return array_values($liquidations_value);
    }

    /**
     * @access public
     * @name getChampsLocalisation()
     * Fonction qui 
     *
     */
    private function getChampsLocalisation($config)
    {

        $localisations = array();

        if (is_array($config) && count($config) > 0 && !empty($config['champs']) && !empty($config['type_retour'])) {

            // On récupere le type de retour "string" ou "array"
            $type_retour = (!empty($config['type_retour'])) ? $config['type_retour'] : "string";

            // On récupere l'id de la localisation associé au dossier
            $localisation_ids = $this->dossierModel->getLocalisationIds();
            if (is_array($localisation_ids) && count($localisation_ids) > 0) {
                foreach ($localisation_ids as $localisation_id) {
                    $localisationModel = new LocalisationModel($localisation_id);
                    $localisations[] = $localisationModel->getBean();
                }
            }

            if (count($localisations) > 1) {
                foreach ($localisations as $localisation) {
                    foreach ($config['champs'] as $champ_label => $champ_name) {
                        $value = (array_key_exists($champ_name, $localisation) === true) ? $localisation[$champ_name] : "";
                        if ($type_retour === "string") {
                            $this->champs["localisations"] = "Plusieurs localisations sont associés à ce dossier, changez la configuration API pour retourner un tableau.";
                        } else {
                            $this->champs["localisations"][$localisation['id']][$champ_label] = $value;
                        }
                    }
                }
            } else {
                foreach ($config['champs'] as $champ_label => $champ_name) {
                    $value = (count($localisations) === 1 && array_key_exists($champ_name, $localisations[0]) === true) ? $localisations[0][$champ_name] : "";
                    if ($type_retour === "string") {
                        $this->champs[$champ_label] = $value;
                    } else {
                        if (count($localisations) === 1) {
                            $this->champs["localisations"][$localisations[0]["id"]][$champ_label] = $value;
                        } else {
                            $this->champs["localisations"] = array();
                        }
                    }
                }
            }
        }

        $this->champs["localisations"] = array_values($this->champs["localisations"]);
    }

    /**
     * @access public
     * @name getChampsDispositif()
     * Fonction qui 
     *
     */
    private function getChampsCoriolis($config)
    {

        if (is_array($config) && count($config) > 0 && !empty($config['champs']) && !empty($config['type_retour'])) {

            // On récupere le type de retour "string" ou "array"
            $type_retour = (!empty($config['type_retour'])) ? $config['type_retour'] : "string";
            $donnes_coriolis = $this->getDonneesCoriolis();

            foreach ($config['champs'] as $champ_label => $champ_name) {

                switch ($champ_name) {
                    case 'num_tiers':
                        $value = (!empty($donnes_coriolis["num_tiers"])) ? $donnes_coriolis["num_tiers"] : "";
                        break;
                    case 'raison_sociale_tiers':
                        $value = (!empty($donnes_coriolis["raison_sociale_tiers"])) ? $donnes_coriolis["raison_sociale_tiers"] : "";
                        break;
                    case 'domiciliation_tiers':
                        $value = (!empty($donnes_coriolis["domiciliation_tiers"])) ? $donnes_coriolis["domiciliation_tiers"] : "";
                        break;
                    case 'num_domiciliation':
                        $value = (!empty($donnes_coriolis["num_domiciliation_tiers"])) ? $donnes_coriolis["num_domiciliation_tiers"] : "";
                        break;
                    case 'num_mandataire':
                        $value = (!empty($donnes_coriolis["num_mandataire"])) ? $donnes_coriolis["num_mandataire"] : "";
                        break;
                    case 'raison_sociale_mandataire':
                        $value = (!empty($donnes_coriolis["raison_sociale_mandataire"])) ? $donnes_coriolis["raison_sociale_mandataire"] : "";
                        break;
                    case 'domiciliation_mandataire':
                        $value = (!empty($donnes_coriolis["domiciliation_mandataire"])) ? $donnes_coriolis["domiciliation_mandataire"] : "";
                        break;
                    case 'num_domiciliation_mandataire':
                        $value = (!empty($donnes_coriolis["num_domiciliation_mandataire"])) ? $donnes_coriolis["num_domiciliation_mandataire"] : "";
                        break;

                    default:
                        $value = "";
                        break;
                }

                if ($type_retour === "string") {
                    $this->champs[$champ_label] = $value;
                } else {
                    $this->champs["coriolis"][$champ_label] = $value;
                }
            }
        }
    }

    /**
     * @access private
     * @name getDonneesCoriolis()
     * Fonction qui retourne les données Coriolis
     *
     *  @return array          $donnes_coriolis: les données Coriolis
     */
    private function getDonneesCoriolis()
    {

        $donnes_coriolis = array(
            "num_tiers" => "",
            "num_mandataire" => "",
            "raison_sociale_tiers" => "",
            "raison_sociale_mandataire" => "",
            "num_domiciliation_tiers" => "",
            "num_domiciliation_mandataire" => "",
            "domiciliation_mandataire" => "",
            "domiciliation_tiers" => ""
        );

        do {

            // On vérifie que le demandeur est bien de type Personne Morale
            $demandeur_type = $this->dossierModel->getDemandeurType();
            if (empty($demandeur_type)) {
                $GLOBALS['log']->fatal(" OPS_dossierAPI => getDonneesCoriolis :: type_tiers du dossier est vide ");
                break;
            }

            // Si le demandeur est différent de Personne morale
            if ($demandeur_type !== "Personne Morale") {
                break;
            }

            // On récupere l'id du demandeur 
            $demandeur_id = $this->dossierModel->getDemandeurId();
            if (empty($demandeur_id)) {
                $GLOBALS['log']->fatal(" OPS_dossierAPI => getDonneesCoriolis :: l'id du demandeur est vide ");
                break;
            }

            // On récupere l'id du mandataire
            $demandeurModel = new PersonneMoraleModel($demandeur_id);
            $mandataire_id = $demandeurModel->getMandataireId();

            // Si le demandeur dispose d'un mandataire, on récupere son mandataire sinon celui du demandeur
            if (!empty($mandataire_id)) {
                $tiers_coriolisModel =  new PersonneMoraleModel($mandataire_id);
                $type_tiers = "M";
            } else {
                $tiers_coriolisModel = $demandeurModel;
                $type_tiers = "D";
            }


            // On récupere le numéro d'appairage et la raison sociale du tiers sur Coriolis
            $appairage_tiers_name = $tiers_coriolisModel->getAppairageName();
            $raison_sociale_coriolis = $tiers_coriolisModel->getRaisonSociale();

            // On récupere les domiciliations du tiers
            $domiciliationModel = (!empty($this->dossier['domiciliation'])) ? new DomiciliationModel($this->dossier['domiciliation']) : false;
            $appairage_domiciliation_name = ($domiciliationModel !== false) ? $domiciliationModel->getAppairageName() : "";
            $domiciliation_coriolis = ($domiciliationModel !== false) ? $domiciliationModel->getBean() : array();

            $domiciliation_coriolis_name = (is_array($domiciliation_coriolis) && count($domiciliation_coriolis) > 0 && !empty($domiciliation_coriolis['name']))
                ? str_replace("_", "", str_replace(" ", "", strtoupper($domiciliation_coriolis['bic']))) . " - " . str_replace("_", "", str_replace(" ", "", strtoupper($domiciliation_coriolis['iban'])))
                :  "";

            if ($type_tiers === "D") {
                $donnes_coriolis['num_tiers'] = (!empty($appairage_tiers_name)) ? $appairage_tiers_name : "";
                $donnes_coriolis['raison_sociale_tiers'] = (!empty($raison_sociale_coriolis)) ? $raison_sociale_coriolis : "";
                $donnes_coriolis['num_domiciliation_tiers'] = (!empty($appairage_domiciliation_name)) ? $appairage_domiciliation_name : "";
                $donnes_coriolis['domiciliation_tiers'] = $domiciliation_coriolis_name;
            } else {
                $donnes_coriolis['num_mandataire'] = (!empty($appairage_tiers_name)) ? $appairage_tiers_name : "";
                $donnes_coriolis['raison_sociale_mandataire'] = (!empty($raison_sociale_coriolis)) ? $raison_sociale_coriolis : "";
                $donnes_coriolis['num_domiciliation_mandataire'] = (!empty($appairage_domiciliation_name)) ? $appairage_domiciliation_name : "";
                $donnes_coriolis['domiciliation_mandataire'] = $domiciliation_coriolis_name;
            }
        } while (0);

        return $donnes_coriolis;
    }

    /**
     * @access public
     * @name getChampsDispositif()
     * Fonction qui retourne les champs custom
     *
     */
    public function getChampsCustom($dossier_id)
    {

        $champs_custom_values = array();

        $this->dossierModel = new DossierModel($dossier_id);
        $champs_custom = $this->dossierModel->getCustomChamps();

        $this->GenerateurChamp = new GenerateurChamp($dossier_id, 'api');
        foreach ($champs_custom as $champ_name => $champ_value) {
            if (stristr($string, 'coriolis') === FALSE) {
                $champ_value = (gettype($champ_value) !== "NULL") ? $champ_value : "";
                $value = $this->GenerateurChamp->getChampValueDisplay($champ_name);
                $champs_custom_values[$champ_name] = (!empty($value)) ? $value : $champ_value;
            }
        }

        return (is_array($champs_custom_values) && count($champs_custom_values) > 0) ? $champs_custom_values : array();
    }
}
