<?php

use ODE\Helper\OdeArrayHelper;

require_once 'service/v4_1/SugarWebServiceImplv4_1.php';
require_once 'custom/service/ODE/ODEDefinitionsErreurs.php';
require_once 'custom/service/ODE/ODEServiceUtils.php';
require_once 'custom/service/ODE/Api/OPS_dossierAPI.php';



# Déprécié pour « set_dossier » : set_dossier($session, $id_dossier, $array_values) - [cf ticket Anomalie #897]

class ODEServiceImpl extends SugarWebServiceImplv4_1
{

    private $OPS_dossierAPI;
    private $configuration;

    function __construct()
    {
        parent::__construct();
        $this->OPS_dossierAPI = new OPS_dossierAPI();
        $this->configuration = $this->getConfig();
    }

    /**
     * @access private
     * @name getConfig()
     * Fonction qui retourne la configuration de l'api
     * 
     *  @return void
     */
    private function getConfig()
    {
        if (file_exists("custom/service/ODE/Config/config.json")) {
            $json_content = file_get_contents("custom/service/ODE/Config/config.json");
            $retour_json_to_array = OdeArrayHelper::jsonToArray($json_content);
            if ($retour_json_to_array['statut'] == "ok") {
                $configuration = $retour_json_to_array['data'];
            } else {
                $GLOBALS['log']->fatal(" ODEServiceImpl :: getConfig => Erreur récupération du fichier de configuration de l'api ( " . $retour_json_to_array['data'] . " ) ");
            }
        }
        return (is_array($configuration) && count($configuration) > 0) ? $configuration : array();
    }

    /**
     * set_dossier
     *
     *
     * @param String $session       -- ID de la session
     * @param String $dossier_id    -- ID du dossier à gérer
     * @param String $array_values  -- Tableau de valeurs à mettre à jour
     *
     * @return ID du dossier mis à jour 
     * 
     */
    function set_dossier($session, $dossier_id, $champs)
    {

        $error = new SoapError();

        // Vérification de la session 
        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        // Vérification des paramètres d'entrées obligatoires
        if (empty($dossier_id) || empty($champs)) {
            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
        if (!empty($obj_dossier->id)) {

            $champs['id'] = $dossier_id;
            $retour_id = $this->update_dossier($session, $champs);
            //$retour_id = $obj_dossier->editDossier( $dossier_id , $champs );
            return array("id" => $retour_id);
        } else {

            // ERREUR : l'enregistrement courant n'existe pas
            $error->set_error('invalid_enregistrement');
            self::$helperObject->setFaultObject($error);
            return false;
        }
    }


    /**
     * set_documents_by_objet
     *
     *
     * @param String $session                   -- ID de la session
     * @param String $objet                     -- Parent du document 
     * @param String $id_objet                  -- ID de l'objet
     * @param String $filename                  -- Nom du document
     * @param String $file                      -- Document (encoder base64)
     * @param String $file_type_id              -- Type du document
     * @param String|Integer $file_importable   -- Si le document est importable ou pas  true = '1',1
     *
     * @return ID_file 'Liste documents' -- Array 
     * 
     */
    function set_documents_by_objet($session, $objet, $id_objet, $filename, $file, $file_type_nom, $file_importable = "false")
    {

        global $beanFiles, $sugar_config;

        $error = new SoapError();
        $id_retour;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        // Vérification de la session 
        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        // Vérification des paramètres d'entrées obligatoires
        if (empty($objet) || empty($id_objet) || empty($file) || empty($filename) || empty($file_type_nom)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        } elseif (!array_key_exists($objet, $app_list_strings['moduleList'])) {

            // ERREUR : objet inconnu
            $error->set_error('objet_inconnu');
            self::$helperObject->setFaultObject($error);
            return false;
        } else {

            $obj_module = new $objet();
            $obj_module->retrieve($id_objet);


            if (empty($obj_module->id)) {

                // ERREUR : l'enregistrement courant n'existe pas
                $error->set_error('invalid_enregistrement');
                self::$helperObject->setFaultObject($error);
                return false;
            } else {

                $new_doc = true;

                // Vérification de l'unicité du type de document
                if (!empty($file_type_nom)) {

                    $obj_type_document = new OPS_type_document();
                    $obj_type_document->retrieve_by_string_fields(array(
                        'identifiant' => $file_type_nom
                    ));

                    // Si type de document unique alors mise à jour du document courant
                    if (!empty($obj_type_document->name) && $obj_type_document->document_unique == true) {

                        // Vérification de l'existance d'un document sur l'objet courant 
                        $tab_documents = $obj_module->get_linked_beans(strtolower($objet) . '_documents', 'Documents', '', 0, -1, 0, '');

                        if (count($tab_documents) > 0) {

                            foreach ($tab_documents as $key => $un_document) {

                                $obj_type = $un_document->get_linked_beans('ops_type_document_documents', 'OPS_type_document');

                                $id_type_doc = $obj_type[0]->id;

                                if ($id_type_doc == $obj_type_document->id) {

                                    $new_doc      = false;
                                    $obj_document = $un_document;
                                }
                            }
                        }
                    }
                }

                if (true == $new_doc) {

                    // Création du document 
                    $obj_document              = new Document();
                    $obj_document->parent_type = $objet;
                    $obj_document->parent_id   = $id_objet;
                }

                $obj_document->document_name    = $filename;
                $obj_document->related_doc_id   = $id_objet;
                $obj_document->filename         = $filename;
                $obj_document->importable         = $this->verifie_boolean($file_importable);
                $obj_document->modified_user_id = 1;
                $obj_document->created_by       = 1;
                $obj_document->doc_type         = "Sugar";
                $obj_document->related_doc_id   = null;
                $obj_document->save();

                if (!empty($obj_document->id)) {
                    require_once('modules/Documents/DocumentSoap.php');
                    $obj_document_soap = new DocumentSoap();

                    $decodedFile = base64_decode($file);
                    $obj_document_soap->upload_file->set_for_soap($filename, $decodedFile);

                    $ext_pos                                  = strrpos($obj_document_soap->upload_file->stored_file_name, ".");
                    $obj_document_soap->upload_file->file_ext = substr($obj_document_soap->upload_file->stored_file_name, $ext_pos + 1);
                    if (in_array($obj_document_soap->upload_file->file_ext, $sugar_config['upload_badext'])) {
                        $obj_document_soap->upload_file->stored_file_name .= ".txt";
                        $obj_document_soap->upload_file->file_ext = "txt";
                    }

                    $revision                 = new DocumentRevision();
                    $revision->filename       = $obj_document_soap->upload_file->get_stored_file_name();
                    $revision->file_mime_type = $obj_document_soap->upload_file->getMimeSoap($revision->filename);
                    $revision->file_ext       = $obj_document_soap->upload_file->file_ext;
                    //$revision->document_name = ;
                    $revision->revision       = '1';
                    $revision->document_id    = $obj_document->id;
                    $revision->save();

                    $obj_document->document_revision_id = $revision->id;
                    $obj_document->save();

                    $obj_document_soap->upload_file->final_move($revision->id);


                    $obj_module->load_relationship(strtolower($objet) . '_documents');
                    $nom_rel = strtolower($objet) . '_documents';
                    $obj_module->$nom_rel->add($obj_document->id);
                    $obj_module->save();

                    if (!empty($obj_type_document->name)) {
                        $obj_type_document->load_relationship('ops_type_document_documents');
                        $obj_type_document->ops_type_document_documents->add($obj_document->id);
                        $obj_type_document->save();
                    }
                }
            }
        }

        return array(
            'id' => $obj_document->id
        );
    }


      /**
     * set_justificatifs_by_objet
     *
     *
     * @param String $session                   -- ID de la session
     * @param String $objet                     -- Parent du document 
     * @param String $id_objet                  -- ID de l'objet
     * @param String $filename                  -- Nom du document
     * @param String $file                      -- Document (encoder base64)
     * @param String $file_type_id              -- Type du document
     * @param String|Integer $file_importable   -- Si le document est importable ou pas  true = '1',1
     *
     * @return ID_file 'Liste documents' -- Array 
     * 
     */
    function set_justificatifs_by_objet($session, $objet, $id_objet, $filename, $file, $file_type_mime, $file_type_nom, $statut = "valide")
    {

        global $beanFiles, $sugar_config;

        $error = new SoapError();
        $id_retour;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        // Vérification de la session 
        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        // Vérification des paramètres d'entrées obligatoires
        if (empty($objet) || empty($id_objet) || empty($file) || empty($filename) || empty($file_type_nom)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        } elseif (!array_key_exists($objet, $app_list_strings['moduleList'])) {

            // ERREUR : objet inconnu
            $error->set_error('objet_inconnu');
            self::$helperObject->setFaultObject($error);
            return false;
        } else {

            $obj_module = new $objet();
            $obj_module->retrieve($id_objet);

            if (empty($obj_module->id)) {

                // ERREUR : l'enregistrement courant n'existe pas
                $error->set_error('invalid_enregistrement');
                self::$helperObject->setFaultObject($error);
                return false;

            } else {
            

                $obj_type_document = new OPS_type_document();
                $obj_type_document->retrieve_by_string_fields(array(
                    'identifiant' => $file_type_nom
                ));
               
                $ext = explode(".",$filename);

                $obj_justificatif = BeanFactory::newBean('OPS_justificatif');
                $obj_justificatif->document_name = $filename;
                $obj_justificatif->statut = $statut;
                $obj_justificatif->depot = "initial";
                $obj_justificatif->filename = $filename;
                $obj_justificatif->file_ext = end($ext);
                $obj_justificatif->file_mime_type = $file_type_mime;
                $obj_justificatif->save();


                $obj_justificatif->load_relationship('ops_type_document_ops_justificatif');
                $obj_justificatif->ops_type_document_ops_justificatif->add($obj_type_document);

                $nom_rel = strtolower($objet) . '_ops_justificatif';
                
                $obj_module->load_relationship($nom_rel);
                $obj_module->$nom_rel->add($obj_justificatif);
                $chemin = $sugar_config['ops_justificatif']['chemin']."/".$obj_module->id;


                @mkdir($chemin, 0755);
                if( is_dir($chemin) ){
                    $fichier = fopen($chemin.'/'.$obj_justificatif->id, "wb");
                    fwrite($fichier,base64_decode($file));
                    fclose($fichier);
                }

            }
        }

        return array(
            'id' => $obj_justificatif->id
        );
    }

    /**
     * get_documents_list_by_objet
     *
     *
     * @param String $session    -- ID de la session
     * @param String $objet      -- Parent type de l'appairage 
     * @param String $id_objet   -- ID de l'objet
     * 
     * @return Array 'Liste documents' -- Array 
     * 
     */
    function get_documents_list_by_objet($session, $objet, $id_objet)
    {
        global $beanFiles, $sugar_config;

        $error = new SoapError();
        $array_retour;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($objet) || empty($id_objet)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        } elseif (!array_key_exists($objet, $app_list_strings['moduleList'])) {

            // ERREUR : objet inconnu
            $error->set_error('objet_inconnu');
            self::$helperObject->setFaultObject($error);
            return false;
        } else {

            $obj_module = new $objet();
            $obj_module->retrieve($id_objet);

            if (!empty($obj_module->id)) {

                $tab_documents = $obj_module->get_linked_beans(strtolower($objet) . '_documents', 'Documents', '', 0, -1, 0, '');

                if (count($tab_documents) > 0) {

                    foreach ($tab_documents as $key => $un_document) {

                        $doc_array                  = array();
                        $doc_array['id']            = $un_document->id;
                        $doc_array['document_name'] = $un_document->document_name;
                        $doc_array['date_depot']    = $un_document->date_entered;
                        $doc_array['importable']    = $un_document->importable;

                        $obj_type = $un_document->get_linked_beans('ops_type_document_documents', 'OPS_type_document');

                        $doc_array['type_piece_id']   = $obj_type[0]->id;
                        $doc_array['type_piece_name'] = $obj_type[0]->name;


                        $documentRevisions = BeanFactory::getBean('DocumentRevisions', $un_document->document_revision_id);

                        if (!empty($documentRevisions->filename)) {

                            $doc_array['fichier']['filename']      = $documentRevisions->filename;
                            $doc_array['fichier']['file_contents'] = base64_encode(file_get_contents($sugar_config['upload_dir'] . $un_document->document_revision_id));
                            $doc_array['fichier']['mime_type']     = $documentRevisions->file_mime_type;
                            $doc_array['fichier']['file_id']       = $documentRevisions->id;
                        } else {

                            $doc_array['fichier'] = "Fichier introuvable";
                        }

                        $array_retour[] = $doc_array;
                    }
                } else {

                    $error->set_error('document_null');
                    self::$helperObject->setFaultObject($error);
                    return false;
                }
            } else {

                // ERREUR : enregistrement invalide
                $error->set_error('invalid_enregistrement');
                self::$helperObject->setFaultObject($error);
                return;
            }
        }

        return $array_retour;
    }


    /**
     * get_objet_by_appairage
     *
     *
     * @param String $session           -- ID de la session
     * @param String $objet             -- Parent type de l'appairage 
     * @param String $logiciel          -- Logiciel de l'appairage 
     * @param String $code_appairage    -- Code de l'appairage 
     * 
     * @return Array 'Objet' -- Array 
     * 
     */
    function get_objet_by_appairage($session, $objet, $logiciel, $code_appairage)
    {
        global $app_list_strings;

        $error = new SoapError();
        $array_retour;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($logiciel) || empty($code_appairage)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        } elseif (!array_key_exists($objet, $app_list_strings['ops_appairage_type_list'])) {

            // ERREUR : objet inconnu
            $error->set_error('objet_inconnu');
            self::$helperObject->setFaultObject($error);
            return false;
        } else {

            $obj_appairage = new OPS_appairage();
            $un_appairage  = $obj_appairage->retrieve_by_string_fields(array(
                'name' => $code_appairage,
                'logiciel' => $logiciel,
                'parent_type' => $objet
            ));

            if (!empty($un_appairage->id) && !empty($un_appairage->parent_id)) {

                if ($objet == "OPS_dossier") {

                    $array_retour = $this->get_dossier_by_id($session, $id_dossier);
                } else {

                    $array_retour = $this->get_entry($session, $objet, "id", $un_appairage->parent_id);
                }
            } else {

                // ERREUR : enregistrement invalide
                $error->set_error('invalid_enregistrement');
                self::$helperObject->setFaultObject($error);
                return;
            }
        }

        $utils        = new ODEServiceUtils();
        $tab = $utils->formater_html($array_retour);

        return $tab;
    }


    /**
     * get_user_by_id
     *
     *
     * @param String $session           -- ID de la session
     * @param String $num_dossier      -- ID de l'utilisateur
     * 
     * @return Array 'Users' -- Array 
     * 
     */
    function get_user_by_id($session, $id_user)
    {

        global $app_list_strings, $beanFiles;

        require_once($beanFiles["User"]);
        $error = new SoapError();
        $array_retour;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($id_user)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        } else {

            $obj_user = new User();
            $obj_user = $obj_user->retrieve($id_user);

            if (!empty($obj_user->id)) {

                $array_retour['id'] = $obj_user->id;
                $array_retour['user_name'] = $obj_user->user_name;
                $array_retour['first_name'] = $obj_user->first_name;
                $array_retour['last_name'] = $obj_user->last_name;
                $array_retour['email1'] = $obj_user->email1;
                $array_retour['phone_work'] = $obj_user->phone_work;
                $array_retour['unite_travail'] =  $obj_user->employee_unite_travail;
                $array_retour['service'] =  $obj_user->employee_service;
                $array_retour['direction'] = $obj_user->employee_direction;
                $array_retour['pole'] = $obj_user->employee_pole;
                $array_retour['direction_generale'] =  $obj_user->employee_direction_generale;
                $array_retour['boite_aux_lettres'] = $obj_user->boite_aux_lettres;
            } else {

                // ERREUR : enregistrement invalide
                $error->set_error('invalid_enregistrement');
                self::$helperObject->setFaultObject($error);
                return;
            }
        }

        $utils        = new ODEServiceUtils();
        $tab = $utils->formater_html($array_retour);

        return $tab;
    }


    /**
     * get_tiers_by_id
     *
     *
     * @param String $session     -- ID de la session
     * @param String $type_tiers      -- Type du tiers 
     * @param String $id_tiers      -- ID du tiers 
     * 
     * @return Array 'Tiers' -- Array 
     * 
     */
    function get_tiers_by_id($session, $type_tiers, $id_tiers)
    {

        global $app_list_strings, $beanFiles;

        require_once($beanFiles["User"]);
        $error = new SoapError();
        $array_retour;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($type_tiers) || empty($id_tiers)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        } elseif ($type_tiers == "Individu") {

            $obj_indi =  $this->get_entry($session, "OPS_individu", "id", $id_tiers);

            if (empty($obj_indi['id'])) {

                $error->set_error('individu_inconnu');
                self::$helperObject->setFaultObject($error);
                return false;
            } else {

                $utils        = new ODEServiceUtils();
                $tab = $utils->formater_html($obj_indi);
                return $tab;
            }
        } elseif ($type_tiers == "Personne Morale") {

            if (array_key_exists('OPS_personne_morale', $app_list_strings['moduleList'])) {

                $obj_pm =  $this->get_entry($session, "OPS_personne_morale", "id", $id_tiers);

                if (empty($obj_pm['id'])) {

                    $error->set_error('personne_morale_inconnu');
                    self::$helperObject->setFaultObject($error);
                    return false;
                } else {

                    $utils        = new ODEServiceUtils();
                    $tab = $utils->formater_html($obj_pm);

                    return $tab;
                }
            } else {

                $error->set_error('module_inconnu');
                self::$helperObject->setFaultObject($error);
                return false;
            }
        } else {

            $error->set_error('type_tiers_inconnu');
            self::$helperObject->setFaultObject($error);
            return false;
        }
    }


    /**
     * get_dossier_by_num
     *
     *
     * @param String $session     -- ID de la session
     * @param String $num_dossier      -- Numéro du dossier
     * 
     * @return Array 'Dossiers' -- Array 
     * 
     */
    function get_list_territoire_by_dossier($session, $id_dossier)
    {

        global $beanFiles, $sugar_config;

        $error = new SoapError();
        $liste_territoire;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($id_dossier)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        $obj_dossier = new OPS_dossier();
        $obj_dossier->retrieve($id_dossier);


        if (!empty($obj_dossier->id)) {

            $tab_territoire = $obj_dossier->get_linked_beans('ops_sous_territoire_ops_dossier', 'OPS_sous_territoire', '', 0, -1, 0, '');

            if (count($tab_territoire) > 0) {

                foreach ($tab_territoire as $key => $un_sous_territoire) {

                    $liste_territoire[$key]['id'] = $un_sous_territoire->id;
                    $liste_territoire[$key]['nom'] = $un_sous_territoire->name;
                    $liste_territoire[$key]['code'] = $un_sous_territoire->code;

                    $tab_terre = $un_sous_territoire->get_linked_beans('ops_sous_territoire_ops_territoire', 'OPS_territoire', '', 0, -1, 0, '');
                    foreach ($tab_terre as $cle => $un_territoire) {

                        $liste_territoire[$key]["territoires"][$cle]['id'] = $un_territoire->id;
                        $liste_territoire[$key]["territoires"][$cle]['nom'] = $un_territoire->name;
                        $liste_territoire[$key]["territoires"][$cle]['code'] = $un_territoire->code;

                        $obj_type_territoire = new OPS_type_territoire();
                        $obj_type_territoire->retrieve($un_territoire->ops_type_territoire_id);

                        $liste_territoire[$key]["territoires"][$cle]["type"] = $obj_type_territoire->name;
                    }
                }
            } else {

                $error->set_error('territoire_null');
                self::$helperObject->setFaultObject($error);
                return false;
            }
        } else {

            // ERREUR : enregistrement invalide
            $error->set_error('invalid_enregistrement');
            self::$helperObject->setFaultObject($error);
            return;
        }

        return $liste_territoire;
    }


    /**
     * get_dossier_by_num
     *
     *
     * @param String $session     -- ID de la session
     * @param String $num_dossier      -- Numéro du dossier
     * 
     * @return Array 'Dossiers' -- Array 
     * 
     */
    function get_dossier_by_num($session, $num_dossier)
    {

        $config_fonction = (is_array($this->configuration) && !empty($this->configuration['get_dossier_by_id'])) ? $this->configuration['get_dossier_by_id'] : array();

        $array_retour = $this->get_entry($session, "OPS_dossier", "num_dossier", $num_dossier);


        if (isset($array_retour["champs_custom"])) {
            unset($array_retour["champs_custom"]);
        }

        $champs_custom = $this->OPS_dossierAPI->getChampsCustom($array_retour['id']);
        if (is_array($champs_custom) && count($champs_custom) > 0) {
            $array_retour = array_merge($array_retour, $champs_custom);
        }

        $champs_additionnel = $this->OPS_dossierAPI->getChamps($array_retour['id'], $config_fonction);

        return (is_array($champs_additionnel) && count($champs_additionnel) > 0) ? $this->getApiFormat(array_merge($array_retour, $champs_additionnel)) : $this->getApiFormat($array_retour);
    }

    /**
     * get_dossier_by_id
     *
     *
     * @param String $session     -- ID de la session
     * @param String $id_dossier  -- ID du dossier
     * 
     * @return Array 'Dossiers' -- Array 
     * 
     */
    function get_dossier_by_id($session, $id_dossier)
    {

        $config_fonction = (is_array($this->configuration) && !empty($this->configuration['get_dossier_by_id'])) ? $this->configuration['get_dossier_by_id'] : array();

        $array_retour = $this->get_entry($session, "OPS_dossier", "id", $id_dossier);

        if (isset($array_retour["champs_custom"])) {
            unset($array_retour["champs_custom"]);
        }

        $champs_custom = $this->OPS_dossierAPI->getChampsCustom($array_retour['id']);
        if (is_array($champs_custom) && count($champs_custom) > 0) {
            $array_retour = array_merge($array_retour, $champs_custom);
        }

        $champs_additionnel = $this->OPS_dossierAPI->getChamps($array_retour['id'], $config_fonction);

        return (is_array($champs_additionnel) && count($champs_additionnel) > 0) ? $this->getApiFormat(array_merge($array_retour, $champs_additionnel)) : $this->getApiFormat($array_retour);
    }

    /**
     * get_dossier_by_demandeur
     *
     *
     * @param String $session     -- ID de la session
     * @param String $type_tiers  -- Type tiers du demandeur
     * @param String $demandeur   -- ID demandeur
     * 
     * @return Array 'Liste Dossiers' -- Array 
     * 
     */
  /*  function get_list_dossier_by_demandeur($session, $type_tiers, $demandeur) // TO DO A REVOIR 
    { 
        global $app_list_strings;


        $error = new SoapError();
        $array_retour = array();
        $app_list_strings = return_app_list_strings_language('fr_FR');
        $config_fonction = (is_array($this->configuration) && !empty($this->configuration['get_dossier_by_id'])) ? $this->configuration['get_dossier_by_id'] : array();

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($type_tiers)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        } elseif ($type_tiers == "Individu") {


            $obj_individu = new OPS_individu();
            $obj_individu->retrieve($demandeur);

            if (!empty($obj_individu->id)) {

                $tab_dossiers = $obj_individu->get_linked_beans('ops_individu_ops_dossier', 'OPS_dossier', '', 0, -1, 0, '');

                if (count($tab_dossiers) > 0) {

                    foreach ($tab_dossiers as $key => $un_dossier) {

                        $array_dossier = $this->get_dossier_by_id($session, $un_dossier->id);
                        $array_retour[] = $tab;
                    }
                } else {

                    $error->set_error('dossier_null');
                    self::$helperObject->setFaultObject($error);
                    return false;
                }
            } else {

                $error->set_error('demandeur_inconnu');
                self::$helperObject->setFaultObject($error);
                return false;
            }
        } elseif ($type_tiers == "Personne Morale") {

            if (array_key_exists('OPS_personne_morale', $app_list_strings['moduleList'])) {

                $obj_personne_morale = new OPS_personne_morale();
                $obj_personne_morale->retrieve($demandeur);

                if (!empty($obj_personne_morale->id)) {

                    $tab_dossiers = $obj_personne_morale->get_linked_beans('ops_personne_morale_ops_dossier', 'OPS_dossier', '', 0, -1, 0, '');

                    if (count($tab_dossiers) > 0) {

                        foreach ($tab_dossiers as $key => $un_dossier) {

                            $array_dossier = $this->get_entry($session, "OPS_dossier", "id", $un_dossier->id);

                            $utils        = new ODEServiceUtils();
                            $tab = $utils->formater_html($array_dossier);

                            $champs_additionnel = $this->OPS_dossierAPI->getChamps($un_dossier->id, $config_fonction);
                            $tab = array_merge($tab, $champs_additionnel);
                            $array_retour[] = $this->getApiFormat($tab);
                        }
                    } else {

                        $error->set_error('dossier_null');
                        self::$helperObject->setFaultObject($error);
                        return false;
                    }
                } else {

                    $error->set_error('demandeur_inconnu');
                    self::$helperObject->setFaultObject($error);
                    return false;
                }
            } else {

                $error->set_error('module_inconnu');
                self::$helperObject->setFaultObject($error);
                return false;
            }
        } else {

            $error->set_error('type_tiers_inconnu');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        return $array_retour;
    }
*/
    /**
     * get_entry
     *
     *
     * @param String $session     -- ID de la session
     * @param String $module      -- Module de l'enregistrement
     * @param String $champ       -- Champ à rechercher
     * @param String $valeur      -- Valeur à chercher
     * 
     * @return Array 'enregistrement' -- Array 
     * 
     */
    function get_entry($session, $module, $champ, $valeur)
    {
        global $beanFiles, $sugar_config;

        $error        = new SoapError();
        $utils        = new ODEServiceUtils();
        $return_array = array();

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($valeur)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        } else {


            require_once($beanFiles[$module]);
            $obj_module = new $module();
            $un_module  = $obj_module->retrieve_by_string_fields(array(
                $champ => $valeur
            ));

            if (!empty($un_module->id)) {


                $list_module = self::get_entries($session, $module, array(
                    $un_module->id
                ), "", "", "");

                if (count($list_module['entry_list']) > 0) {


                    foreach ($list_module['entry_list'] as $key => $un_enreg) {

                        foreach ($un_enreg['name_value_list'] as $cle => $value) {

                            $return_array[$value['name']] = $value['value'];
                        }
                    }

                    return $return_array;
                }
            } else {

                // ERREUR : enregistrement invalide
                $error->set_error('invalid_enregistrement');
                self::$helperObject->setFaultObject($error);
                return false;
            }
        }
    }


    /**
     * Mise à jour de l'objet courant 
     *
     *
     * @param String $session          -- ID de la session
     * @param String $module_name      -- Module de l'enregistrement
     * @param String $name_value_list  -- Champ à mettre à jour
     * @param Bool $track_view         -- Should the tracker be notified that the action was performed on the bean.
     *
     * @return Array    'id'           -- the ID of the bean that was written to (-1 on error)
     * @exception 'SoapFault'          -- The SOAP error, if any
     */
    function set_entry($session, $module_name, $name_value_list, $track_view = FALSE)
    {
        global $beanList, $beanFiles, $current_user;

        if (self::$helperObject->isLogLevelDebug()) {
            $GLOBALS['log']->debug('SoapHelperWebServices->set_entry - input data is ' . var_export($name_value_list, true));
        } // if
        $error = new SoapError();
        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', $module_name, 'write', 'no_access', $error)) {
            $GLOBALS['log']->info('End: SugarWebServiceImpl->set_entry');
            return;
        } // if
        $class_name = $beanList[$module_name];
        require_once($beanFiles[$class_name]);
        $seed = new $class_name();
        foreach ($name_value_list as $name => $value) {
            if (is_array($value) && $value['name'] == 'id') {
                $seed->retrieve($value['value']);
                break;
            } else if ($name === 'id') {

                $seed->retrieve($value);
            }
        }

        $return_fields = array();
        foreach ($name_value_list as $name => $value) {
            if ($module_name == 'Users' && !empty($seed->id) && ($seed->id != $current_user->id) && $name == 'user_hash') {
                continue;
            }
            if (!empty($seed->field_name_map[$name]['sensitive'])) {
                continue;
            }

            if (!is_array($value)) {
                $seed->$name     = $value;
                $return_fields[] = $name;
            } else {
                $seed->{$value['name']} = $value['value'];
                $return_fields[]        = $value['name'];
            }
        }
        if (!self::$helperObject->checkACLAccess($seed, 'Save', $error, 'no_access') || ($seed->deleted == 1 && !self::$helperObject->checkACLAccess($seed, 'Delete', $error, 'no_access'))) {
            $GLOBALS['log']->info('End: SugarWebServiceImpl->set_entry');
            return;
        } // if

        $seed->save(self::$helperObject->checkSaveOnNotify());

        $return_entry_list = self::$helperObject->get_name_value_list_for_fields($seed, $return_fields);

        if ($seed->deleted == 1) {
            $seed->mark_deleted($seed->id);
        }

        if ($track_view) {
            self::$helperObject->trackView($seed, 'editview');
        }

        $GLOBALS['log']->info('End: SugarWebServiceImpl->set_entry');
        return array(
            'id' => $seed->id,
            'entry_list' => $return_entry_list
        );
    } // fn



    /**
     * @access private
     * verifie_boolean()
     * Fonction qui :
     *    - retourne 1 si $bool == '1' ou $bool == 1 ou $bool == 'true'
     *    - retourne 0 sinon 
     *
     *
     * @param integer|boolean           $bool    
     * 
     * @return integer 0 ou 1
     * 
     */
    private function verifie_boolean($bool)
    {

        $bool_verified = 0;

        if (is_string($bool) && trim($bool) === '1') {
            if (trim($bool) === '1' || strcasecmp($bool, 'true') == 0) {
                $bool_verified = 1;
            }
        } elseif (is_int($bool) && $bool === 1) {
            $bool_verified = 1;
        }

        return $bool_verified;
    }

    /**
     * @access private
     * get_individu_by_email_address()
     * Fonction qui Retourne l'ID d'un Individus en fonction de l'email passé en paramètre 
     *
     *
     * @param string            $id   : l'id de l'individu recherché
     * 
     * @return array|boolean 
     * 
     */
    public function get_objet_by_email_address($session, $objet, $email_address)
    {


        global $beanFiles, $sugar_config, $db;

        $error = new SoapError();
        $array_retour;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }
        if (empty($email_address) && empty($objet)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        $qry  = "select " . strtolower($objet) . ".id from " . strtolower($objet) . "
                inner join email_addr_bean_rel on email_addr_bean_rel.bean_id=" . strtolower($objet) . ".id and email_addr_bean_rel.deleted=0
                inner join email_addresses on email_addresses.id=email_addr_bean_rel.email_address_id and email_addresses.deleted=0
                where email_addresses.email_address like '" . $email_address . "'
                    and email_addr_bean_rel.primary_address=1
                    and email_addresses.deleted=0";


        $result = $db->query($qry);
        if (!$result) {
            $GLOBALS['log']->fatal($objet . "::retrieve_by_email_address - requete invalide : " . $db->lastError());
        } else {
            $row = $db->fetchByAssoc($result);

            if (!empty($row['id'])) {

                $array_retour = $this->get_entry($session, $objet, "id",  $row['id']);
            }
        }

        return $array_retour;
    }

    /*
     * Retourne l'ID d'un Individus en fonction du nom prenom date nais passé en paramètre
     * retourne "" si aucun individu ne répond aux critères
     */
    function get_individu_by_civilite($session, $nom, $prenom, $date_naissance)
    {


        global $beanFiles, $sugar_config, $db;

        $error = new SoapError();
        $array_retour;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($nom) || empty($prenom)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        $utils        = new ODEServiceUtils();
        $nom = $utils->delete_caractere($nom);
        $prenom = $utils->delete_caractere($prenom);


        // Verification de l'unicite dans le cas d'une création et d'une modification
        $requete = "SELECT id, concat(last_name,' ',first_name) as fullname FROM ops_individu WHERE deleted=0 ";

        // Verification de l'unicité du nom d'usage
        $requete .= " AND ( (UPPER(TRIM(REPLACE( REPLACE( REPLACE( `last_name`, '_', ''), ' ', ''), '-', ''))) like '" . $db->quote(strtoupper($nom)) . "') ";

        // verification du prénom
        if (!empty($prenom)) {
            $requete .= "AND (UPPER(TRIM(REPLACE( REPLACE( REPLACE( `first_name`, '_', ''), ' ', ''), '-', ''))) like '" . $db->quote(strtoupper($prenom)) . "') ";
        }

        // verification de la date de naissance
        if (!empty($date_naissance)) {
            $requete .= "AND (date_naissance like '" . $db->quote($date_naissance) . "') ";
        } else {
            $requete .= "AND (date_naissance IS NULL) ";
        }

        $requete .= " )";

        $resultat = $db->query($requete);
        $nb_result = $resultat->num_rows;

        if ($nb_result == 1) {

            while (($row = $db->fetchByAssoc($resultat)) != null) {
                $array_retour[] = $this->get_entry($session, "OPS_individu", "id",  $row['id']);
            }
        }
        $array_retour['nb_result'] = $nb_result;

        return $array_retour;
    }


    /**
     * set_appairage_by_objet
     *
     *
     * @param String $session           -- ID de la session
     * @param String $objet             -- Parent type de l'appairage 
     * @param String $logiciel          -- Logiciel de l'appairage 
     * @param String $code_appairage    -- Code de l'appairage 
     * 
     * @return Array 'Objet' -- Array 
     * 
     */
    function set_appairage_by_objet($session, $objet, $objet_id,  $logiciel, $code_appairage)
    {
        global $app_list_strings;

        $error = new SoapError();
        $array_retour;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($logiciel) || empty($code_appairage) || empty($objet_id)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (!array_key_exists($objet, $app_list_strings['ops_appairage_type_list'])) {

            // ERREUR : objet inconnu
            $error->set_error('objet_inconnu');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        $obj_appairage = new OPS_appairage();
        $obj_appairage->parent_type = $objet;
        $obj_appairage->parent_id = $objet_id;
        $obj_appairage->name = $code_appairage;
        $obj_appairage->logiciel = $logiciel;
        $array_retour = $obj_appairage->save();

        $utils        = new ODEServiceUtils();
        $tab = $utils->formater_html($array_retour);

        return $tab;
    }

    /*
     */
    function get_domiciliations_by_objet($session, $objet, $objet_id)
    {


        global $beanFiles, $sugar_config, $db;

        $error = new SoapError();
        $array_retour = false;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($objet) || empty($objet_id)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        $obj = new $objet();
        $obj = $obj->retrieve($objet_id);

        if (!empty($obj->id)) {

            $tab_domiciliation = $obj->get_linked_beans(strtolower($objet) . '_ops_domiciliation', 'OPS_domiciliation', '', 0, -1, 0, '');

            if (count($tab_domiciliation) > 0) {
                foreach ($tab_domiciliation as $key => $une_domiciliation) {

                    $array_retour[$key]["id"] = $une_domiciliation->id;
                    $array_retour[$key]["titulaire_compte"] = $une_domiciliation->titulaire_compte;
                    $array_retour[$key]["iban"] = $une_domiciliation->iban;
                    $array_retour[$key]["bic"] = $une_domiciliation->bic;
                }
            }
        } else {

            // ERREUR : enregistrement invalide
            $error->set_error('invalid_enregistrement');
            self::$helperObject->setFaultObject($error);
            return;
        }

        return $array_retour;
    }

    function set_domiciliation_by_objet($session, $objet, $objet_id, $domiciliation)
    {


        global $beanFiles, $sugar_config, $db;

        $error = new SoapError();
        $retour_domiciliation = false;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($objet) || empty($objet_id)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        $obj = new $objet();
        $obj = $obj->retrieve($objet_id);

        if (!empty($obj->id)) {


            $obj_domiciliation = new OPS_domiciliation();
            $obj_domiciliation->name = $domiciliation['titulaire_compte'];
            $obj_domiciliation->iban = $domiciliation['iban'];
            $obj_domiciliation->bic = $domiciliation['bic'];
            $obj_domiciliation->actif = true;
            $id_domi = $obj_domiciliation->save();

            if (!empty($id_domi)) {
                // Création de la relation avec l'objet 
                $obj->load_relationship(strtolower($objet) . '_ops_domiciliation');
                $nom_rel = strtolower($objet) . '_ops_domiciliation';
                $obj->$nom_rel->add($obj_domiciliation);
                $obj->save();

                $retour_domiciliation = $id_domi;
            }
        } else {

            // ERREUR : enregistrement invalide
            $error->set_error('invalid_enregistrement');
            self::$helperObject->setFaultObject($error);
            return;
        }

        return $retour_domiciliation;
    }


    function create_dossier($session, $tab_dossier)
    {

        global $beanFiles, $sugar_config, $db;

        $error = new SoapError();
        $retour_domiciliation = false;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($tab_dossier) || !isset( $tab_dossier['dispositif'] ) || empty($tab_dossier['dispositif']) ) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }
    
        // Récupération de l'id du dispositif via le paramètre unique « cle »
        $cle_dispositif = trim($tab_dossier['dispositif']);
        $tab_dispositif = $this->get_entry($session, "OPS_dispositif", "cle", $cle_dispositif);

        if (!empty($tab_dispositif["id"])) {

            // Reaffecte avec l'ID de dispositif et non plus la clé.
            $tab_dossier["dispositif"] = $tab_dispositif["id"];

            if (array_key_exists("exercice", $tab_dossier)) {

                // Récupération de l'id de l'exercice via le paramètre unique « name »
                $obj_exercie = new OPS_exercice();
                $tab_exercice  = $obj_exercie->retrieve_by_string_fields(array(
                    "name" => $tab_dossier['exercice']
                ));

                // Si pas d'exrcice, ce dossier sera flagé 'Sans exercice'.
                if (!empty($tab_exercice->id)) {

                    $tab_dossier["ops_exercice_id"] = $tab_exercice->id;
                    unset($tab_dossier["exercice"]);
                } else {

                    unset($tab_dossier["exercice"]);
                }
            }
               
            $obj_dossier = new OPS_dossier();
            $dossier_id = $obj_dossier->createDossier($tab_dossier);

            return $dossier_id;
        } else {
            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        return false;
    }

    /**
     * @access public
     * set_documents_by_objet()
     * Fonction qui récupere l'enregistrement d'un objet 
     *
     *  @param String $session          - La session 
     *  @param String $dossier_id       - ID Dossier 
     *  @param String $sous_territoire  - Code sous territoire 
     *  @return id|false             - Retour de la methode 
     */
    public function set_territoire_by_dossier($session, $dossier_id, $code_sous_territoire)
    {


        global $beanFiles, $sugar_config, $db;

        $error = new SoapError();
        $retour = false;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($dossier_id) || empty($code_sous_territoire)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }


        // Récupération du dossier
        $obj_dossier = new OPS_dossier();
        $obj_dossier = $obj_dossier->retrieve($dossier_id);

        if (!empty($obj_dossier->id)) {

            // Récupération du sous territoire 
            $obj_sous_territoire = new OPS_sous_territoire();
            $un_sous_territoire  = $obj_sous_territoire->retrieve_by_string_fields(array(
                'code' => $code_sous_territoire
            ));

            if (!empty($un_sous_territoire->id)) {

                // Création de la relation avec le dossier ops_sous_territoire_ops_dossier 
                $un_sous_territoire->load_relationship('ops_sous_territoire_ops_dossier');
                $un_sous_territoire->ops_sous_territoire_ops_dossier->add($obj_dossier->id);
                $retour = $un_sous_territoire->save();
            }
        } else {
            // ERREUR : objet inconnu
            $error->set_error('objet_inconnu');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        return $retour;
    }

    function update_dossier($session, $tab_dossier)
    {


        global $beanFiles, $sugar_config, $db;

        $error = new SoapError();
        $retour_domiciliation = false;
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($tab_dossier) && !array_key_exists("id", $tab_dossier)) {

            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }


        $obj_dossier = new OPS_dossier();
        $obj_dossier->retrieve($tab_dossier['id']);

        if (!empty($obj_dossier->id)) {

            // Traitement du statut 
            if (array_key_exists("statut", $tab_dossier)) {
                $query =  'SELECT DISTINCT(ops_statut.id) 
                FROM ops_statut 
                INNER JOIN ops_etape_ops_statut ON ops_statut.id = ops_etape_ops_statut.ops_statut_id AND ops_etape_ops_statut.deleted=0
                INNER JOIN ops_etape ON ops_etape_ops_statut.ops_etape_id = ops_etape.id AND ops_etape.deleted=0
                INNER JOIN ops_guide_instruction_ops_etape ON ops_etape.id = ops_guide_instruction_ops_etape.ops_etape_id AND ops_guide_instruction_ops_etape.deleted=0 
                INNER JOIN ops_guide_instruction ON ops_guide_instruction_ops_etape.ops_guide_instruction_id = ops_guide_instruction.id AND ops_guide_instruction.deleted=0
                INNER JOIN ops_guide_instruction_ops_dispositif ON ops_guide_instruction.id = ops_guide_instruction_ops_dispositif.ops_guide_instruction_id AND ops_guide_instruction_ops_dispositif.deleted=0
                INNER JOIN ops_dispositif ON ops_guide_instruction_ops_dispositif.ops_dispositif_id = ops_dispositif.id AND ops_dispositif.deleted=0
                INNER JOIN ops_dispositif_ops_dossier ON ops_dispositif.id = ops_dispositif_ops_dossier.ops_dispositif_id AND ops_dispositif_ops_dossier.deleted=0 AND ops_dispositif_ops_dossier.ops_dossier_id = "' . $obj_dossier->id . '" 
                where ops_statut.name like "' . $tab_dossier['statut'] . '"
                AND ops_statut.deleted=0';

                $id_statut = $db->getOne($query);

                $obj_statut = new OPS_statut();
                $obj_statut->retrieve($id_statut);


                if (empty($obj_statut->id)) {

                    // ERREUR : parametre invalide
                    $error->set_error('statut_inconnu');
                    self::$helperObject->setFaultObject($error);
                    return false;
                } else {

                    $obj_dossier->updateStatut($obj_statut->id);
                }
            }

            if (array_key_exists("exercice", $tab_dossier)) {

                $tab_exercice = $this->get_entry($session, "OPS_exercice", "name", $tab_dossier['exercice']);

                if (!empty($tab_exercice['id'])) {

                    $tab_dossier["ops_exercice_id"] = $tab_exercice["id"];
                    unset($tab_dossier["exercice"]);
                } else {

                    unset($tab_dossier["exercice"]);
                }
            }
            $dossier_id = $obj_dossier->editDossier($obj_dossier->id, $tab_dossier);
        } else {

            // ERREUR : parametre invalide
            $error->set_error('invalid_enregistrement');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        return $dossier_id;
    }

    /**
     * set_journal_by_objet
     *
     *
     * @param String $session           -- ID de la session
     * @param String $objet             -- Parent type de l'appairage 
     * @param String $logiciel          -- Logiciel de l'appairage 
     * @param String $code_appairage    -- Code de l'appairage 
     * 
     * @return Array 'Objet' -- Array 
     * 
     */
    function set_journal_by_objet($session, $objet_name, $objet_id, $journal)
    {

        $error = new SoapError();
        $app_list_strings = return_app_list_strings_language('fr_FR');

        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (empty($objet_name) || empty($objet_id) || empty($journal)) {
            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }

        if (!array_key_exists($objet_name, $app_list_strings['ops_journal_type_list'])) {
            // ERREUR : objet inconnu
            $error->set_error('objet_inconnu');
            self::$helperObject->setFaultObject($error);
            return false;
        }


        $verification_journal = $this->isValidJournal($journal);
        if ($verification_journal['statut'] === "err") {
            // ERREUR : objet inconnu
            $error->set_error($verification_journal['data']);
            self::$helperObject->setFaultObject($error);
            return false;
        } else {
            $journal = $verification_journal['data'];
        }

        $obj_journal = BeanFactory::newBean('OPS_journal');
        $obj_journal->parent_type = $objet_name;
        $obj_journal->parent_id = $objet_id;
        $obj_journal->name = $journal["name"];
        $obj_journal->description = $journal["description"];
        $obj_journal->statut = $journal["statut"];
        $obj_journal->erreur = $journal["erreur"];
        $obj_journal->save();

        foreach ($journal["details"] as $ordre => $detail) {

            $obj_detail = BeanFactory::newBean('OPS_journal_detail');
            $obj_detail->name = $detail['name'];
            $obj_detail->description = $detail['description'];
            $obj_detail->statut = $detail['statut'];
            $obj_detail->erreur = $detail['erreur'];
            $obj_detail->tache = $detail['tache'];
            $obj_detail->reponse = $detail['reponse'];
            $obj_detail->ordre = $ordre;
            $obj_detail->save();

            // On crée la relation journal <-> detail
            $obj_journal->load_relationship('ops_journal_detail_ops_journal');
            $obj_journal->ops_journal_detail_ops_journal->add($obj_detail);
        }

        return array("id" => $obj_journal->id);
    }

    private function isValidJournal($journal)
    {

        $erreur = "";
        $journal_formated = array();

        do {

            if (!is_array($journal)) {
                $erreur = "Journal type = " . gettype($journal) . ", JSON attendu.";
                break;
            }

            if (count($journal) === 0) {
                $erreur = "Journal vide : Le champ name est obligatoire";
                break;
            }

            if (empty($journal['name'])) {
                $erreur = "Journal : Le champ name est obligatoire";
                break;
            } else {
                $journal_formated["name"] = $journal['name'];
            }

            $journal_formated["description"] = (!empty($journal['description'])) ? $journal['description'] : "";
            $journal_formated["statut"] = (!empty($journal['statut']) && $journal['statut'] === "ok") ? "ok" : "err";
            $journal_formated["erreur"] = (!empty($journal['erreur'])) ? $journal['erreur'] : "";

            if (is_array($journal["details"]) && count($journal["details"]) > 0) {

                $details = array();
                $details_bis = array();
                foreach ($journal["details"] as $_detail) {
                    if (!empty($_detail['name'])) {

                        $detail["name"] = $_detail['name'];
                        $detail["description"] = (!empty($_detail['description'])) ? $_detail['description'] : "";
                        $detail["statut"] = (!empty($_detail['statut']) && $_detail['statut'] === "ok") ? "ok" : "err";
                        $detail["erreur"] = (!empty($_detail['erreur'])) ? $_detail['erreur'] : "";
                        $detail["tache"] = (!empty($_detail['tache'])) ? $_detail['tache'] : "";
                        $detail["reponse"] = (!empty($_detail['reponse'])) ? $_detail['reponse'] : "";

                        if (!empty($_detail['ordre']) && array_key_exists(intval($_detail['ordre']), $details) === false) {
                            $details[intval($_detail['ordre'])] = $detail;
                        } else {
                            $details_bis[] = $detail;
                        }
                    }
                }

                $journal_formated["details"] = (count($details_bis) > 0) ? array_merge($details_bis, $details) : $details;
            } else {
                $journal_formated["details"] = array();
            }
        } while (0);


        return (!empty($erreur)) ? array("statut" => "err", "data" => $erreur) : array("statut" => "ok", "data" => $journal_formated);
    }


    private function getApiFormat($array)
    {
        $array_formated = array();
        if (is_array($array) && count($array) > 0) {
            foreach ($array as $key => $value) {
                if (gettype($value) === "string") {
                    $array_formated[$key] =  str_replace("&#039;", "'", $value);
                } else {
                    $array_formated[$key] = $value;
                }
            }
        }
        return (is_array($array_formated) && count($array_formated) > 0) ? $array_formated : $array;
    }

        public function get_dossier_for_capdemat($session, $dossier_id, $statut_id)  {


        $error = new SoapError();
        $retour = array( "statut" => "ok", "erreur" => "" );
        
        // Vérification de la session 
        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }
        
        // Vérification des paramètres d'entrées obligatoires
        if ( empty($dossier_id) || empty($statut_id) ) {
            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
        }
        
        // Récupération du dossier 
        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);

        // Récupération du statut à mettre à jour 
        $obj_statut = new OPS_statut();
        $obj_statut->retrieve($statut_id);

        // Faire le traitement lorsqu'il y a un statut GRU 
        if( !empty($obj_statut->nom_statut_gru ) ){

            $retour['statut_gru'] = $obj_statut->nom_statut_gru ; 

            // Récupération du numéro d'apparaige CDE
            $appairage = $obj_dossier->get_linked_beans("ops_dossier_ops_appairage");
            foreach ($appairage as $key => $appli_ext_cde) {
                if( $appli_ext_cde->logiciel == "cde" ){
                    $retour['num_demande'] = $appli_ext_cde->name ; 
                }
            }

            // Récupération des documents à mettre dans le porte document inversé 
            $tab_doc = $obj_dossier->get_linked_beans("ops_dossier_documents");
            $tab_documents = array() ; 
            if( !empty($tab_doc) && is_array($tab_doc) ){
                foreach ($tab_doc as $key => $document) {

                    // Si le document est importable dans CDE alors on lance le connecteur 
                    if( $document->importable == '1' ){
                        // Vérification que le type de document à un type de document CDE sinon pas d'export de document 
                        $type_document = $document->get_linked_beans("ops_type_document_documents");
                        if( !empty($type_document["0"]->type_capdemat) ){
                            $id_document_revision = $document->document_revision_id ;
                            if( isset( $id_document_revision ) && !empty($id_document_revision ) ){
                                $obj_doc_revision = new DocumentRevision() ;
                                $obj_doc_revision->retrieve( $id_document_revision );
                                $fichier_64 = base64_encode (  file_get_contents('upload/'.$id_document_revision ) ) ;
                                $retour['documents'][$key]['type_document'] = $type_document["0"]->type_capdemat ; 
                                $retour['documents'][$key]['document_name'] = $document->document_name ; 
                                $retour['documents'][$key]['document_file_ext'] = $obj_doc_revision->file_ext ; 
                                $retour['documents'][$key]['document_file_mime_type'] = $obj_doc_revision->file_mime_type ; 
                                $retour['documents'][$key]['document'] = $fichier_64 ; 
                            }
                        }
                    }
                }
            }
            else{
                $retour['documents'] = "Aucun";
            }

        }
        else{
            $retour['erreur'] = "Statut GRU vide";
            $retour['statut'] = "err";
        }

        if( !isset($retour['num_demande']) || empty($retour['num_demande']) ){
            $retour['erreur'] = "Numéro demande GRU inconnu";
            $retour['statut'] = "err";
        }

        return $retour ;     
        
    }



    /**
     * get_objet_by_appairage
     *
     *
     * @param String $session           -- ID de la session
     * @param String $objet             -- Parent type de l'appairage 
     * @param String $logiciel          -- Logiciel de l'appairage 
     * @param String $code_appairage    -- Code de l'appairage 
     * 
     * @return Array 'Objet' -- Array 
     * 
     */
    function get_appairage($session, $logiciel, $parent_id)
    {
        global $app_list_strings;
        
        $error = new SoapError();
        $array_retour;
        $app_list_strings = return_app_list_strings_language('fr_FR');
        
        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', '', '', $error)) {
            $error->set_error('invalid_session');
            self::$helperObject->setFaultObject($error);
            return false;
        }
        
        if (empty($logiciel) || empty($parent_id)) {
            
            // ERREUR : parametre invalide
            $error->set_error('invalid_parameters');
            self::$helperObject->setFaultObject($error);
            return false;
            
        }  else {
            
            $obj_appairage = new OPS_appairage();
            $un_appairage  = $obj_appairage->retrieve_by_string_fields(array(
                'logiciel' => $logiciel,
                'parent_id' => $parent_id
            ));
            
            if (!empty($un_appairage->id) && !empty($un_appairage->parent_id)) {

                $appairage = $un_appairage->name; 
                
            } else {
                
                // ERREUR : enregistrement invalide
                $error->set_error('objet_inconnu');
                self::$helperObject->setFaultObject($error);
                return;
                
            }
        }
        
        return $appairage;
        
    }
}
