<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

use ODE\Model\GenerateurReferentielModel;

class AOS_PDF_TemplatesViewEdit extends ViewEdit
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @deprecated deprecated since version 7.6, PHP4 Style Constructors are deprecated and will be remove in 7.8, please update your code, use __construct instead
     */
    public function AOS_PDF_TemplatesViewEdit()
    {
        $deprecatedMessage = 'PHP4 Style Constructors are deprecated and will be remove in 7.8, please update your code';
        if (isset($GLOBALS['log'])) {
            $GLOBALS['log']->deprecated($deprecatedMessage);
        } else {
            trigger_error($deprecatedMessage, E_USER_DEPRECATED);
        }
        self::__construct();
    }


    public function display()
    {
        $this->setFields();
        parent::display();
        $this->displayTMCE();
    }

    public function setFields()
    {
        global $app_list_strings, $mod_strings, $beanList, $sugar_config;

        //Loading Sample Files
        $json = getJSONobj();
        $samples = array();
        if ($handle = opendir('modules/AOS_PDF_Templates/samples')) {
            $sample_options_array[] = ' ';
            while (false !== ($file = readdir($handle))) {
                if ($value = ltrim(rtrim($file, '.php'), 'smpl_')) {
                    require_once('modules/AOS_PDF_Templates/samples/'.$file);
                    $file = rtrim($file, '.php');
                    $file = new $file();
                    $fileArray =
                        array(
                            $file->getType(),
                            $file->getBody(),
                            $file->getHeader(),
                            $file->getFooter()
                        );
                    $fileArray = $json->encode($fileArray);
                    $value = $mod_strings['LBL_'.strtoupper($value)];
                    $sample_options_array[$fileArray] = $value;
                }
            }
            $samples = get_select_options($sample_options_array, '');
            closedir($handle);
        }

        $this->ss->assign('CUSTOM_SAMPLE', '<select id="sample" name="sample" onchange="insertSample(this.options[this.selectedIndex].value)">'.
            $samples.
            '</select>');

        $insert_fields_js ="<script>var moduleOptions = {\n";
        $insert_fields_js2 ="<script>var regularOptions = {\n";
        $modules = $app_list_strings['pdf_template_type_dom'];

        foreach ($modules as $moduleName => $value) {
            $options_array = array(''=>'');
            $mod_options_array = array();

            //Getting Fields
            if (!$beanList[$moduleName]) {
                continue;
            }
            $module = new $beanList[$moduleName]();

            foreach ($module->field_defs as $name => $arr) {
                if (!((isset($arr['dbType']) && strtolower($arr['dbType']) == 'id') || (isset($arr['type']) && $arr['type'] == 'id') || (isset($arr['type']) && $arr['type'] == 'link'))) {
                    if (!isset($arr['reportable']) || $arr['reportable']) {
                        $options_array['$'.$module->table_name.'_'.$name] = translate($arr['vname'], $module->module_dir);
                    }
                }
            } //End loop.
            //Surcharge Contrat
            if($module->table_name == 'ops_contrat'){
                $options_array['$ops_contrat_montant_alloue_local'] .= ' local';
                $options_array['$ops_contrat_montant_consomme_local'] .= ' local';
                $options_array['$ops_contrat_montant_disponible_local'] .= ' local';
                $options_array['$ops_contrat_montant_alloue_territorial'] .= ' térritorial';
                $options_array['$ops_contrat_montant_consomme_territorial'] .= ' térritorial';
                $options_array['$ops_contrat_montant_disponible_territorial'] .= ' térritorial';
                $options_array['$ops_contrat_montant_alloue_total'] .= ' total';
                $options_array['$ops_contrat_montant_consomme_total'] .= ' total';
                $options_array['$ops_contrat_montant_disponible_total'] .= ' total';
                $options_array['$ops_contrat_liste_dossier'] .= 'Liste des dossiers';

            }

            $options = json_encode($options_array);
            $mod_options_array[$module->module_dir] = translate('LBL_MODULE_NAME', $module->module_dir);
            # Customisation du fonctionnement standard pour ajouter les champs custom au module OPS_dossier
            if ( $moduleName === 'OPS_dossier' ) {
                $options = $this->getDossierOptions( $options );
            }
            $insert_fields_js2 .="'$moduleName':$options,\n";
            $firstOptions = $options;

            $fmod_options_array = array();
            //Surcharge Contrat
                if($moduleName == 'OPS_contrat'){
                    unset($module->field_defs);
                    $module->field_defs['ops_contrat_ops_programmation'] = array
                    (
                       'name' => 'ops_contrat_ops_programmation',
                       'type' => 'relate',
                       'source' => 'non-db',
                       'vname' => 'LBL_OPS_CONTRAT_OPS_PROGRAMMATION_FROM_OPS_PROGRAMMATION_TITLE',
                       'id_name' => 'ops_programmation_id',
                       'link' => 'ops_contrat_ops_programmation',
                       'table' => 'ops_programmation',
                       'module' => 'OPS_programmation',
                       'rname' => 'name',
                    );
                }
                foreach ($module->field_defs as $module_name => $module_arr) {
                    if (isset($module_arr['type']) && $module_arr['type'] == 'relate' && isset($module_arr['source']) && $module_arr['source'] == 'non-db') {
                        $options_array = array(''=>'');
                        if (isset($module_arr['module']) &&  $module_arr['module'] != '' && $module_arr['module'] != 'EmailAddress') {
                            $relate_module_name = $beanList[$module_arr['module']];
                            $relate_module = new $relate_module_name();

                            if($module_arr['module'] == 'Users' && !empty($app_list_strings['replace_variable_users'])){
                                foreach($app_list_strings['replace_variable_users'] as $relate_name => $relate_arr){
                                    $options_array['$'.$module_arr['name'].'_'.$relate_name] = $relate_arr;
                                }
                            }else{
                                foreach ($relate_module->field_defs as $relate_name => $relate_arr) {
                                    if (!((isset($relate_arr['dbType']) && strtolower($relate_arr['dbType']) == 'id') || $relate_arr['type'] == 'id' || $relate_arr['type'] == 'link')) {
                                        if ((!isset($relate_arr['reportable']) || $relate_arr['reportable']) && isset($relate_arr['vname'])) {
                                            $options_array['$'.$module_arr['name'].'_'.$relate_name] = translate($relate_arr['vname'], $relate_module->module_dir);
                                        }
                                    }
                                } //End loop.
                            }
                            $options = json_encode($options_array);

                            if ($module_arr['vname'] != 'LBL_DELETED') {
                                $options_array['$'.$module->table_name.'_'.$name] = translate($module_arr['vname'], $module->module_dir);
                                $fmod_options_array[$module_arr['vname']] = translate($relate_module->module_dir).' : '.translate($module_arr['vname'], $module->module_dir);
                            }
                            $test = $module_arr['vname'];
                            $insert_fields_js2 .="'$test':$options,\n";
                        }
                    }
                }

            # Surcharge module partenaires
            if ($moduleName === 'OPS_dossier' && isset($app_list_strings['moduleList']['OPS_avis'])) {
                $name = 'OPS_avis';
                $relate_module_name = $beanList[$name];
                $relate_module = new $relate_module_name();

                $options_avis_array = array();
                foreach ($relate_module->field_defs as $relate_name => $relate_arr) {
                    if (!((isset($relate_arr['dbType']) && strtolower($relate_arr['dbType']) == 'id') || $relate_arr['type'] == 'id' || $relate_arr['type'] == 'link')) {
                        if ((!isset($relate_arr['reportable']) || $relate_arr['reportable']) && isset($relate_arr['vname'])) {
                            if($relate_name !== 'name') {
                                $options_avis_array['$' . $module->table_name . '_' . $relate_module->table_name . '_' . $relate_name] = translate($relate_arr['vname'], $relate_module->module_dir);
                            }
                        }
                    }
                }

                $fmod_options_array['LBL_OPS_DOSSIER_OPS_AVIS'] =  translate('LBL_OPS_DOSSIER_OPS_AVIS_FROM_OPS_AVIS_TITLE', $module->module_dir) . ' : ' . translate('LBL_OPS_DOSSIER_OPS_AVIS_FROM_OPS_AVIS_TITLE', $module->module_dir);

                $options_avis_array['$' . $module->table_name . '_' . $relate_module->table_name . '_telephone'] = 'Téléphone';
                $options_avis_array['$' . $module->table_name . '_' . $relate_module->table_name . '_siret'] = 'Siret';
                $options_avis_array['$' . $module->table_name . '_' . $relate_module->table_name . '_rna'] = 'RNA';
                $options_avis_array['$' . $module->table_name . '_' . $relate_module->table_name . '_raison_sociale'] = 'Raison sociale';
                $options_avis_array['$' . $module->table_name . '_' . $relate_module->table_name . '_adresse'] = 'Adresse';
                $options_avis_array['$' . $module->table_name . '_' . $relate_module->table_name . '_email'] = 'Email';

                $options = json_encode($options_avis_array);

                $insert_fields_js2 .= "'LBL_OPS_DOSSIER_OPS_AVIS':$options,\n";
            }
            # Fin surcharge module partenaires

            $name = 'Documents';
            $options_array = array(
                '$documents_date_generer' => 'Date de génération',
            );

            $options = json_encode($options_array);

            $insert_fields_js2 .="'$name':$options,\n";

            //LINE ITEMS CODE!
            if (isset($module->lineItems) && $module->lineItems) {

                //add group fields
                $options_array = array(''=>'');
                $group_quote = BeanFactory::newBean('AOS_Line_Item_Groups');
                foreach ($group_quote->field_defs as $line_name => $line_arr) {
                    if (!((isset($line_arr['dbType']) && strtolower($line_arr['dbType']) == 'id') || $line_arr['type'] == 'id' || $line_arr['type'] == 'link')) {
                        if ((!isset($line_arr['reportable']) || $line_arr['reportable'])) {//&& $line_arr['vname']  != 'LBL_NAME'
                            $options_array['$'.$group_quote->table_name.'_'.$line_name] = translate($line_arr['vname'], $group_quote->module_dir);
                        }
                    }
                }

                $options = json_encode($options_array);

                $line_module_name = $beanList['AOS_Line_Item_Groups'];
                $fmod_options_array[$line_module_name] = translate('LBL_LINE_ITEMS', 'AOS_Quotes').' : '.translate('LBL_MODULE_NAME', 'AOS_Line_Item_Groups');
                $insert_fields_js2 .="'$line_module_name':$options,\n";

                //PRODUCTS
                $options_array = array(''=>'');

                $product_quote = BeanFactory::newBean('AOS_Products_Quotes');
                foreach ($product_quote->field_defs as $line_name => $line_arr) {
                    if (!((isset($line_arr['dbType']) && strtolower($line_arr['dbType']) == 'id') || $line_arr['type'] == 'id' || $line_arr['type'] == 'link')) {
                        if (!isset($line_arr['reportable']) || $line_arr['reportable']) {
                            $options_array['$'.$product_quote->table_name.'_'.$line_name] = translate($line_arr['vname'], $product_quote->module_dir);
                        }
                    }
                }

                $product_quote = BeanFactory::newBean('AOS_Products');
                foreach ($product_quote->field_defs as $line_name => $line_arr) {
                    if (!((isset($line_arr['dbType']) && strtolower($line_arr['dbType']) == 'id') || $line_arr['type'] == 'id' || $line_arr['type'] == 'link')) {
                        if ((!isset($line_arr['reportable']) || $line_arr['reportable']) && $line_arr['vname']  != 'LBL_NAME') {
                            $options_array['$'.$product_quote->table_name.'_'.$line_name] = translate($line_arr['vname'], $product_quote->module_dir);
                        }
                    }
                }

                $options = json_encode($options_array);

                $line_module_name = $beanList['AOS_Products_Quotes'];
                $fmod_options_array[$line_module_name] = translate('LBL_LINE_ITEMS', 'AOS_Quotes').' : '.translate('LBL_MODULE_NAME', 'AOS_Products');
                $insert_fields_js2 .="'$line_module_name':$options,\n";

                //Services
                $options_array = array(''=>'');
                $options_array['$aos_services_quotes_name'] = translate('LBL_SERVICE_NAME', 'AOS_Quotes');
                $options_array['$aos_services_quotes_number'] = translate('LBL_LIST_NUM', 'AOS_Products_Quotes');
                $options_array['$aos_services_quotes_service_list_price'] = translate('LBL_SERVICE_LIST_PRICE', 'AOS_Quotes');
                $options_array['$aos_services_quotes_service_discount'] = translate('LBL_SERVICE_DISCOUNT', 'AOS_Quotes');
                $options_array['$aos_services_quotes_service_unit_price'] = translate('LBL_SERVICE_PRICE', 'AOS_Quotes');
                $options_array['$aos_services_quotes_vat_amt'] = translate('LBL_VAT_AMT', 'AOS_Quotes');
                $options_array['$aos_services_quotes_vat'] = translate('LBL_VAT', 'AOS_Quotes');
                $options_array['$aos_services_quotes_service_total_price'] = translate('LBL_TOTAL_PRICE', 'AOS_Quotes');

                $options = json_encode($options_array);

                $s_line_module_name = 'AOS_Service_Quotes';
                $fmod_options_array[$s_line_module_name] = translate('LBL_LINE_ITEMS', 'AOS_Quotes').' : '.translate('LBL_SERVICE_MODULE_NAME', 'AOS_Products_Quotes');
                $insert_fields_js2 .="'$s_line_module_name':$options,\n";

                $options_array = array(''=>'');
                $currencies = new currency();
                foreach ($currencies->field_defs as $name => $arr) {
                    if (!((isset($arr['dbType']) && strtolower($arr['dbType']) == 'id') || $arr['type'] == 'id' || $arr['type'] == 'link' || $arr['type'] == 'bool' || $arr['type'] == 'datetime' || (isset($arr['link_type']) && $arr['link_type'] == 'relationship_info'))) {
                        if (isset($arr['vname']) && $arr['vname'] != 'LBL_DELETED' && $arr['vname'] != 'LBL_CURRENCIES_HASH' && $arr['vname'] != 'LBL_LIST_ACCEPT_STATUS' && $arr['vname'] != 'LBL_AUTHENTICATE_ID' && $arr['vname'] != 'LBL_MODIFIED_BY' && $arr['name'] != 'created_by_name') {
                            $options_array['$currencies_'.$name] = translate($arr['vname'], 'Currencies');
                        }
                    }
                }
                $options = json_encode($options_array);

                $line_module_name = $beanList['Currencies'];
                $fmod_options_array[$line_module_name] = translate('LBL_MODULE_NAME', 'Currencies').' : '.translate('LBL_MODULE_NAME', 'Currencies');
                $insert_fields_js2 .="'$line_module_name':$options,\n";
            }
            //Surcharge Contrat
            if($moduleName != 'OPS_contrat'){
                $fmod_options_array = array_merge($fmod_options_array,array('Documents' => 'Documents'));
            }
            array_multisort($fmod_options_array, SORT_ASC, $fmod_options_array);
            $mod_options_array = array_merge($mod_options_array, $fmod_options_array);
            $module_options = json_encode($mod_options_array);

            $insert_fields_js .="'$moduleName':$module_options,\n";
            $moduleOptions[$moduleName] = array("module" => $module_options,"option" => $firstOptions);

        } //End loop.

        $customModules = [
            'OPS_individu' => OPS_individu::get_field_list(false, true),
            'OPS_personne_morale' => OPS_personne_morale::get_field_list(false),
        ];

        $collection = [];
        foreach($customModules as $module_key => $field_list)
        {
            $selectListeDefautModule = '';
            foreach($field_list as $onglet_key => $onglet)
            {
                $selectListeDefautModule .= '<optgroup label="' . $onglet['libelle'] . '">';

                foreach ($onglet['champs'] as $champ) 
                {
                    $selectListeDefautModule .= '<option value="' . $champ['name'] . '">' . $champ['libelle'] . '</option>';
                }

                $selectListeDefautModule .= '</optgroup>';
            }
            $collection[$module_key] = $selectListeDefautModule;
        }

        $individu_field_list = "var individu_field_list = '" . str_replace( "'", "\'", $collection['OPS_individu'] ) .  "';";
        $personne_morale_field_list = "var personne_morale_field_list = '" . str_replace( "'", "\'", $collection['OPS_personne_morale'] ) .  "';";

        $insert_fields_js2 .= '};';
        $insert_fields_js2 .= $individu_field_list . "\n" . $personne_morale_field_list . "\n";

        //Sets options to original options on load.
        $insert_fields_js .= "} ;</script>";
        $insert_fields_js2 .= "</script>";
        if ($this->bean->type=='') {
            $type = key($app_list_strings['pdf_template_type_dom']);
        } else {
            $type = $this->bean->type;
        }

        $signatureElectronique  = $sugar_config['opensocle']['signature_externe_utilise'] ?? "";


        $htmlSignatureAncre = "";
        $jsSignatureAncre = "";
        if($signatureElectronique != ""){
            $nom = $app_list_strings['ops_signature_ext_list'][$signatureElectronique] ?? "";
            $variable = $app_list_strings['ops_signature_ext_ancre_list'][$signatureElectronique] ?? "";
            $description = $app_list_strings['ops_signature_ext_ancre_description_list'][$signatureElectronique] ?? "";
            
            $htmlSignatureAncre =  "<div class='row'>
                    <div class='col-md-6' ><input class='hover-hide button' type='button' tabindex=\"70\" onclick='insert_variable(\"${variable}\", \"email_template_editor\");' class='button' value='Insérer la signature électronique ${nom}'>";
            $htmlSignatureAncre .= "</div><div class='col-md-6' ><span  class='description_signature' style='display:none'>${description}</span></div></div>";
            $jsSignatureAncre = "<script> 
                $('.hover-hide').on('mouseenter', function(){
                    $('.description_signature').show();
                });

                $('.hover-hide').on('mouseleave', function(){
                    $('.description_signature').hide();
                });

            </script>";
            //$htmlSignatureAncre .= "<p> blabla </p>";
        }

        $fonctionList = get_select_options($app_list_strings['ops_role_list'],'');



        //Start of insert_fields
        $insert_fields = '';
        $insert_fields .= <<<HTML
        $insert_fields_js
        $insert_fields_js2
        
        <select name='module_name' id='module_name' tabindex="50" onchange="populateVariables(this.options[this.selectedIndex].value);">
        </select>
        <select name='fonction_name' id='fonction_name' tabindex="50" style="display:none;">
            $fonctionList;
        </select>
        <select name='variable_name' id='variable_name' tabindex="50" onchange="showVariable(this.options[this.selectedIndex].value);">
        </select>
        <input type="text" size="30" tabindex="60" name="variable_text" id="variable_text" />
        <input type='button' tabindex="70" onclick='insert_variable(document.EditView.variable_text.value, "email_template_editor");' class='button' value='${mod_strings['LBL_BUTTON_INSERT']}'>
        $htmlSignatureAncre
        $jsSignatureAncre
        <script type="text/javascript">
            populateModuleVariables("$type");
    </script>


HTML;

        $this->ss->assign('INSERT_FIELDS', $insert_fields);
    }

    public function displayTMCE()
    {
        require_once("include/SugarTinyMCE.php");
        global $locale;

        $tiny = new SugarTinyMCE();
        $tinyMCE = $tiny->getConfig();

        $js =<<<JS
        <script language="javascript" type="text/javascript">
        $tinyMCE
        var df = '{$locale->getPrecedentPreference('default_date_format')}';

        tinyMCE.init({
            selector: '#description',
            plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
            license_key: 'gpl',
            toolbar: 'undo redo | blocks fontfamily fontsizeinput | bold italic underline forecolor backcolor removeformat | align numlist bullist | link image | table quickimage | lineheight indent outdent | pagebreak | code fullscreen preview | wordcount',
            quickbars_selection_toolbar: 'bold italic underline | quicklink h2 h3 blockquote quickimage quicktable',
            inline_styles: true,
            directionality: 'ltr',
            remove_redundant_brs: true,
            entity_encoding: 'raw',
            verify_html: false,
            valid_children: '+a[*]',
            cleanup: false,
            cleanup_on_startup: false,
            convert_urls: false,
            plugin_insertdate_dateFormat: "{DATE {$defaultDateFormat}}",
            pagebreak_separator: '<pagebreak />',
            extended_valid_elements: '*[*]',  // Allow all elements and attributes
            valid_elements: '*[*]',           // Allow all elements and attributes
            custom_elements: 'textblock',
            language: 'fr_FR',
            language_url: '/vendor/tweeb/tinymce-i18n/langs/fr_FR.js',
            promotion: false,
            branding: false,
            relative_urls: false,
            remove_script_host: false,
        });

        tinyMCE.init({
            selector: '#pdfheader,#pdffooter',
            advcode_inline: true,
            plugins: 'insertdatetime,table,searchreplace,directionality,pagebreak,link,code,fullscreen',
            license_key: 'gpl',
            width: '100%',
            height: 100,
            toolbar: "undo redo | blocks | bold italic underline | alignleft aligncenter alignright alignjustify | outdent indent | code",
            inline_styles: true,
            directionality: 'ltr',
            remove_redundant_brs: true,
            entity_encoding: 'raw',
            verify_html: false,
            valid_children: '+a[*]',
            cleanup: false,
            cleanup_on_startup: false,
            convert_urls: false,
            plugin_insertdate_dateFormat: "{DATE {$defaultDateFormat}}",
            pagebreak_separator: '<pagebreak />',
            extended_valid_elements: '*[*]',  // Allow all elements and attributes
            valid_elements: '*[*]',           // Allow all elements and attributes
            custom_elements: 'textblock',
            language: 'fr_FR',
            language_url: '/vendor/tweeb/tinymce-i18n/langs/fr_FR.js',
            promotion: false,
            branding: false,
            relative_urls: false,
            remove_script_host: false,
        });

        </script>

JS;
        echo $js;
    }

/**
     * Fonction qui ajoute les champs custom du module OPS_dossier aux options en entrée ( format Json en entrée )
     * @param string     $options 
     * 
     * @return string    $options 
     */
    private function getDossierOptions( $options = "" ){
                        
        do {

            # On vérifie que la variable est bien de type string non vide 
            if ( empty($options) || gettype($options) !== "string" ) break;

            # On converti les options en tableau
            $options_array =  json_decode($options,true);

            # On vérifie qu'on a bien un tableau de données
            if ( !is_array($options_array) || count($options_array) === 0 ) break;

            # On formate le tableau pour enlever le début des clés '$ops_dossier_', j'enleve aussi l'option vide  
            $options_formated = [];
            foreach ($options_array as $option_key => $option_value) {
                if ( !empty($option_key) ) {
                    $options_formated[str_replace('$ops_dossier_','',$option_key)] = $option_value;
                }
            }

            # On récupére les champs custom du module OPS_dossier
            $dossier_custom_fields = GenerateurReferentielModel::getCustomFieldListe();
            if ( !is_array($dossier_custom_fields) || count($dossier_custom_fields) === 0 ) break;

            # On merge les deux tableaux avant de les trier  
            $new_options = array_merge( $options_formated, $dossier_custom_fields);

            # On reboucle sur le tableau pour remettre '$ops_dossier_'
            $new_options_formated = [];
            $new_options_formated[''] = '';
            foreach ($new_options as $option_key => $option_value) {
                $new_options_formated['$ops_dossier_'.$option_key] = $option_value;
            }

            # On réencode le tableau en Json 
            $options = json_encode($new_options_formated);

        } while (0);

        return $options;
    }
}
