<?php
require_once("custom/modules/AOS_PDF_Templates/OPS_generate_PDF.php");

class DocumentsController extends SugarController
{
    public function action_Popup()
    {
        $this->view = 'popup';
    }

    public function action_generer_document()
    {

        global $app_list_strings;

        if (!empty($_REQUEST['array_champs'])) {

            $obj_template = BeanFactory::getBean('AOS_PDF_Templates', $_REQUEST['array_champs']['template_id']);
            $module       = $_REQUEST['array_champs']['module'];
            $module_id    = $_REQUEST['array_champs']['record'];
            $statut_id    = $_REQUEST['array_champs']['statut_id'];
            $filename     = $obj_template->name;
            $importable   = ($_REQUEST['array_champs']['importable'] == 'true') ? 1 : 0;
            # Surcharge module Partenaire
            if (isset($app_list_strings['moduleList']['OPS_avis'])) {
                $visible_partenaire = ($_REQUEST['array_champs']['visible_partenaire'] == 'true') ? 1 : 0;
                $partenaires_destinataires = $_REQUEST['array_champs']['partenaires_destinataires'];
            }
            # Fin surcharge module Partenaire

            $bean = BeanFactory::getBean($module, $module_id);

            // Création du document 
            $obj_document              = BeanFactory::newBean('Documents');
            $obj_document->parent_type = $module;
            $obj_document->parent_type = $module;
            $obj_document->status_id   = $statut_id;
            $obj_document->origine   = "pdf";
            $obj_document->importable  = $importable;
            # Surcharge module Partenaire
            if (isset($app_list_strings['moduleList']['OPS_avis'])) {
                $obj_document->visible_partenaire  = $visible_partenaire;
                $obj_document->partenaires_destinataires  = $partenaires_destinataires;
            }
            # Fin surcharge module Partenaire

            $obj_document->document_name  = $filename . '.pdf';
            $obj_document->related_doc_id = $module_id;
            $obj_document->filename       = $filename . '.pdf';
            $obj_document->date_generer = date('Y-m-d');
            $obj_document->save();

            $pdf_file = OPS_generate_PDF::transform_to_pdf($bean, $obj_template->id, array(), $filename . '.pdf', $obj_document->id);

            $pdf_streamb64 = base64_encode(file_get_contents($pdf_file['path']));

            if (!empty($obj_document->id)) {
                require_once('modules/Documents/DocumentSoap.php');
                $obj_document_soap = new DocumentSoap();

                $decodedFile = base64_decode($pdf_streamb64);
                $obj_document_soap->upload_file->set_for_soap($filename, $decodedFile);

                $ext_pos                                  = strrpos($obj_document_soap->upload_file->stored_file_name, ".");
                $obj_document_soap->upload_file->file_ext = substr($obj_document_soap->upload_file->stored_file_name, $ext_pos + 1);
                if (!empty($sugar_config['upload_badext']) && in_array($obj_document_soap->upload_file->file_ext, $sugar_config['upload_badext'])) {
                    $obj_document_soap->upload_file->stored_file_name .= ".txt";
                    $obj_document_soap->upload_file->file_ext = "txt";
                }

                $revision                 = BeanFactory::newBean('DocumentRevisions');
                $revision->filename       = $obj_document->document_name;
                $revision->file_mime_type = $obj_document_soap->upload_file->getMimeSoap($revision->filename);
                $revision->file_ext       = $obj_document_soap->upload_file->file_ext;
                //$revision->document_name = ;
                $revision->revision       = '1';
                $revision->document_id    = $obj_document->id;
                $revision->save();

                $obj_document->document_revision_id = $revision->id;

                $obj_document_soap->upload_file->final_move($revision->id);
                $obj_document->save();



                $bean->load_relationship(strtolower($module) . '_documents');
                $nom_rel = strtolower($module) . '_documents';
                $bean->$nom_rel->add($obj_document->id);
                $bean->save();

                if (!empty($obj_template->ops_type_document_id)) {
                    $obj_type_document = BeanFactory::getBean("OPS_type_document", $obj_template->ops_type_document_id);

                    $obj_type_document->load_relationship('ops_type_document_documents');
                    $obj_type_document->ops_type_document_documents->add($obj_document->id);
                    $obj_type_document->save();
                }
            }

            $erased = OPS_generate_PDF::erase_pdf($pdf_file['path']);
            $data   = array(
                "OK"
            );
        } else {
            return;
        }
        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }
}
