<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('include/MVC/View/SugarView.php');

class Viewuserwise_theme_settings extends SugarView {

    public function display() {

        global $db, $current_user;

        if ( !is_admin( $current_user ) ) {
            echo "You don't have permission to access this page";
            die();
        }

        ## START Module License For Access Rights
        require_once('modules/OE_SuitePro/license/OE_SuitePro_Outfitters_License.php');
        if ( isset($GLOBALS['sugar_config']['outfitters_licenses']['suitepro']) && $GLOBALS['sugar_config']['outfitters_licenses']['suitepro'] == 'No_License_Key' )
            $validate_license = '1';
        else
            $validate_license = OE_SuitePro_Outfitters_License::isValid('OE_SuitePro', '', false);

        if($validate_license != '1')
        {
            sugar_die('<font style="color:red">Please enter your valid license key to use this module. If you already have key <a href="index.php?module=OE_SuitePro&action=license">Click here</a> to set. License did NOT validate. Reason:'.$validate_license.'</font>');
        }
        ?>

        <style>
            .oe_user_list_tbl thead tr th, .oe_user_list_tbl tbody tr td {padding: 10px !important;}
            .oepl_pagination > .active_page {background: #FAFAFA;}
            .oepl_pagination a {padding: 10px 15px;border-radius: 5px;margin: 2px;}
            .oepl_pagination {text-align: right;margin: 20px 0;}
        </style>

        <?php include 'modules/OE_SuitePro/loader.php'; ?>

        <h2 style="font-size: 25px; font-weight: 300; text-transform: uppercase; letter-spacing: 2px;">SuitePro User Wise Theme Settings</h2>

        <?php
        require_once 'modules/OE_SuitePro/include/OE_Get_Theme_Subthemes.php';

        ## =============================================================================
        ## START Pagination 
        $page_limit = 20; 
        if ( isset($_REQUEST['offset']) && $_REQUEST['offset'] == 0 ) $_REQUEST['offset'] = 1;

        $page_total = 0;  
        $pre_offset = $cur_offset = $start_page = $total_record = 0;
        if ( isset($_REQUEST['offset']) && !empty($_REQUEST['offset'] ) ){
            $pre_offset = $_REQUEST['offset'] - 1;
            $cur_offset = $_REQUEST['offset'];
            
            if ( $cur_offset > 1 )
                $start_page = ( $pre_offset * $page_limit );
        }

        if ($cur_offset === 0 ) {
            $cur_offset = 1;
        }

        ## END Pagination
        ## =============================================================================
        ## get Users
        $query1 = 'FROM users WHERE deleted = 0 AND status = "Active"';

        $query = "SELECT COUNT(id) AS total ".$query1;
        $result = $db->query( $query );
        $fetchRow = $db->fetchByAssoc( $result );
        $total_record = $fetchRow['total'];

        $query = "SELECT id, user_name ".$query1." LIMIT ".$start_page.", ".$page_limit;

        $getResult = $db->query( $query, true );
        $page_total = $db->getRowCount( $getResult );
        ## =============================================================================
        ## START Pagination 
        $next_offset = $cur_offset + 1;
        if( ceil( $total_record / $page_limit ) < $next_offset ) $next_offset = 'No Page';

        $paging = array();
        $paging['pre_offset'] = $pre_offset;
        $paging['offset'] = $cur_offset;
        $paging['next_offset'] = $next_offset;
        $paging['page_total'] = $page_total;
        $paging['page_limit'] = $page_limit;
        $paging['total_record'] = $total_record;
        if ( $start_page == 0 ) $start_page = 1;
        $paging['start_page'] = $start_page;
        $last_page = ceil( $total_record / $page_limit );
        $paging['last_page'] = $last_page;

        echo $this->getPagination( $paging );

        if ( $getResult->num_rows > 0 ) {
            ?>

            <div style="background: #FAFAFA;padding: 30px 20px;">
                <table class="list view table-responsive oe_user_list_tbl">
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Theme</th>
                            <th>SubTheme</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $i = 0;
                        while ( $row = $db->fetchByAssoc( $getResult ) ) {

                            $user_id = $row['id'];
                            $user_name = $row['user_name'];

                            $class = 'oddListRowS1';
                            if ( $i % 2 == 0 ) {
                                $class = 'evenListRowS1';
                            }

                            ## START get user's selected theme
                            $selected_theme = 'SuiteP';
                            $selected_subtheme = 'Dawn';

                            $query_pre = "SELECT contents FROM user_preferences WHERE deleted = 0 AND assigned_user_id = '".$user_id."' AND category = 'global' ";
                            $results_pre = $db->query($query_pre, true);
                            $num_row_pre = $db->getRowCount($results_pre);

                            if ( $num_row_pre > 0 ) {
                                $row_pre = $db->fetchByAssoc($results_pre);
                                $tmp = unserialize(base64_decode($row_pre['contents']));
                                if (isset($tmp['user_theme'])) {
                                    $selected_theme = $tmp['user_theme'];
                                }
                                if (isset($tmp['subtheme'])) {
                                    $selected_subtheme = $tmp['subtheme'];
                                }    
                                
                            }
                            ## END get user's selected theme
                            if (isset($SugarThemeArr[$selected_theme]['option'])) {
                                $subtheme_arr = $SugarThemeArr[$selected_theme]['option'];
                            }
                            ?>

                            <tr class="<?php echo $class; ?>">

                                <td><?php echo $user_name; ?></td>

                                <td>
                                    <select name="user_wise_data[<?php echo $i; ?>][theme]" id="theme_<?php echo $i; ?>" onchange="OE_getSubThemeOptions(this.value, '<?php echo $user_id; ?>', '<?php echo $i; ?>');">
                                        <option value="SuiteP" <?php if($selected_theme == 'SuiteP') echo 'selected="selected"'; ?>>SuiteP</option>
                                        <option value="OEPLTheme" <?php if($selected_theme == 'OEPLTheme') echo 'selected="selected"'; ?>>SuitePro</option>
                                    </select>
                                </td>

                                <td>
                                    <select name="user_wise_data[<?php echo $i; ?>][subtheme]" id="subtheme_<?php echo $i; ?>">
                                        <?php
                                        foreach ( $subtheme_arr as $key => $value ) {
                                            $selected = '';
                                            if ( $key == $selected_subtheme ) {
                                                $selected = 'selected = "selected"';
                                            }
                                            echo '<option value="' . $key . '" ' . $selected . '>' . $value . '</option>';
                                        }
                                        ?>
                                    </select>
                                </td>

                                <td>
                                    <input type="submit" id="oe_save_<?php echo $i; ?>" value="Save" onclick="return OE_SaveTheme('<?php echo $user_id; ?>', '<?php echo $user_name; ?>', '<?php echo $i; ?>');"/>
                                </td>

                            </tr>
                            <?php
                            $i++;
                        }
            ?>
                    <tbody>
                </table>
            </div>

            <?php
        }
        echo $this->getPagination( $paging );
        ?>

        <script type="text/javascript">

            $(document).ready(function(){
                var getBGColor = $('input[type="submit"]').css('background');
                $('.oepl_pagination .active_page').css('color', getBGColor);

                $(".oepl_pagination .active_page").mouseover(function() {
                    $(this).css('color', '#FAFAFA');
                    $(this).css('background', getBGColor);
                }).mouseout(function() {
                    $(this).css('color', getBGColor);
                    $(this).css('background', '#FAFAFA');
                });
            });

            /* get sub theme options */
            function OE_getSubThemeOptions(themeName, user_id, cnt) {
                    
                $('.oe-loader-section').show();

                $.ajax({
                    url : 'index.php?module=OE_SuitePro&action=OE_GetThemeStyleOpt_AJAX&sugar_body_only=true',
                    dataType : "json",
                    data : {
                        'themeName' : themeName,
                        'user_id' : user_id
                    },
                    success : function(response) {
                        
                        $('.oe-loader-section').hide();
                        
                        if (response.status) {
                            $('#subtheme_' + cnt).html(response.style_opt);
                        } else {
                            alert('Something went wrong.');
                            return false;
                        }
                    },
                });
                return false;
            }

            /* save theme and subtheme */
            function OE_SaveTheme(userID, userName, number) {

                $('.oe-loader-section').show();

                var getTheme = $('#theme_' + number).val();
                var getSubTheme = $('#subtheme_' + number).val();

                $.ajax({
                    url : 'index.php?module=OE_SuitePro&action=OE_SaveUserWiseTheme_AJAX&sugar_body_only=true',
                    dataType : "json",
                    data : {
                        'user_id' : userID,
                        'user_name' : userName,
                        'user_theme' : getTheme,
                        'subtheme' : getSubTheme
                    },
                    success : function(response) {
                        
                        $('.oe-loader-section').hide();
                        
                        if (response.status) {
                            alert('Theme saved successfully');
                        } else {
                            alert('Something went wrong.');
                        }
                    }
                });
                return false;
            }
        </script>

        <?php
    }

    ## get html of the pagination
    function getPagination($paging) {
        
        $module = $_REQUEST['module'];
        $action = $_REQUEST['action'];
        
        $link = 'index.php?module=' . $module . '&action=' . $action . '&offset=%d';
        
        $pre_offset = $paging['pre_offset'];
        $cur_offset = $paging['offset'];
        $last_page = $paging['last_page'];
            
        $pagerContainer = '<div class="oepl_pagination">';
        
        if( $paging['page_total'] != 0 ) {
            
            ## first page link
            if($pre_offset > 0) {
                $pagerContainer .= sprintf( '<a href="' . $link . '" class="button"> First </a>', 1);
            }
            
            ## prev page link
            if($cur_offset >= 2) {
                $pagerContainer .= sprintf( '<a href="' . $link . '" class="button"> '.$pre_offset.' </a>', $pre_offset);
            }

            ## active page link
            $pagerContainer .= sprintf( '<a href="' . $link . '" class="active_page button"><b> '.$cur_offset.' </b></a>', $cur_offset);
            
            ## next page link
            if($cur_offset != $last_page) {
                $pagerContainer .= sprintf( '<a href="' . $link . '" class="button"> '.$paging['next_offset'].' </a>', $paging['next_offset']);
            }
            
            if($cur_offset != $last_page) {
                $pagerContainer .= sprintf( '<a href="' . $link . '" class="button"> Last </a>', $last_page);
            }
        }
        $pagerContainer .= '</div>';
        return $pagerContainer;
    }
}