<?php

global $db, $beanFiles, $log, $current_user, $sugar_config;

require_once('include/entryPoint.php');
require_once($beanFiles["OPS_agendas"]);
require_once($beanFiles["User"]);
require_once($beanFiles["Meeting"]);
require_once($beanFiles["OPS_agendas_motifs"]);
require_once($beanFiles["OPS_agendas_ressources"]);
require_once($beanFiles["OPS_individu"]);
require_once($beanFiles["OPS_dossier"]);

use Datetime;

if (empty($current_user->id)) {
	$obj_user = new User();
	$current_user = BeanFactory::getBean("Users", '1');
}


if (isset($_POST['id_agenda']) && isset($_POST['start']) && isset($_POST['end']) && "visualisation" == $_GET['methode']) { // Visualisation

	try {

		$obj_agenda = BeanFactory::getBean("OPS_agendas", $_POST['id_agenda']);

		$liste_rendez_vous = $obj_agenda->liste_rendez_vous($_POST['start'], $_POST['end'], $_POST['ressource'], $_POST['motif'], $_POST['lieu']);

		if (isset($liste_rendez_vous) && !empty($liste_rendez_vous)) {
			echo json_encode($liste_rendez_vous);
		} else {
			echo json_encode("{}");
		}
	} catch (Error $e) {
		$GLOBALS['log']->fatal('Erreur agenda visualisation' . print_r($var, true));
		echo json_encode("{}");
	} catch (Exception $e) {
		$GLOBALS['log']->fatal('Exception agenda visualisation' . print_r($var, true));
		echo json_encode("{}");
	}
} elseif (isset($_POST['id_agenda']) && isset($_POST['start']) && isset($_POST['end']) && "creneaux_disponibles" == $_GET['methode']) { // Récupération créneaux dispos


	try {
		$obj_agenda = BeanFactory::getBean("OPS_agendas", $_POST['id_agenda']);

		$canal = "gru";
		$obj_meeting = BeanFactory::getBean("Meetings", $id_meeting);
		if (isset($obj_meeting) && !empty($obj_meeting->id) && $obj_meeting->provenance_rdv == "internet") {
			$canal = "internet";
		}

		// On écarte le rdv courant pour pouvoir récupérer les rdv d'un autre motif sur la même tranche horaire 
		$meeting_id = "" ;
		if( isset( $_GET['meeting_id'])  && !empty($_GET["meeting_id"]) ){
			$meeting_id = $_GET['meeting_id'] ; 
		}

		$liste_rendez_vous = $obj_agenda->liste_creneaux_dispos($_POST['start'], $_POST['end'], $_POST['motif'], $canal, $_POST['lieu'], $meeting_id );

		if (isset($liste_rendez_vous) && !empty($liste_rendez_vous)) {
			echo json_encode($liste_rendez_vous);
		} elseif (empty($liste_rendez_vous)) {
			echo json_encode("");
		}

	} catch (Exception $e) {
		$cause_ex = "Exception";
		$GLOBALS["log"]->fatal("Exception :: creneaux_disponibles ::" . print_r($e->getMessage(), true));
		echo json_encode("");
	} catch (Error $e) {
		$cause_ex = "Error";
		$GLOBALS["log"]->fatal("Error :: creneaux_disponibles  ::" . print_r($e->getMessage(), true));
		echo json_encode("");
	}
} elseif (isset($_POST['params']) && (isset($_POST['methode']) && "creneaux_verification" == $_POST['methode'])) { // Vérification du créneau: est toujours disponible?

	$obj_meeting = new Meeting();
	$params = explode("|", $_POST['params']);

	$id_motif = $params['0'];
	$id_agenda = $params['1'];
	$date_debut = $params['2'];

	$param_individu_id = $_POST['individu_id'];
	$id_meeting = $_POST['meeting_id'];
	$id_meeting_2 = str_replace(" ", "", $_POST['meeting_id_2']);

	$obj_agenda = BeanFactory::getBean("OPS_agendas", $id_agenda);

	try {

		$canal = "gru";
		$obj_meeting = BeanFactory::getBean("Meetings", $id_meeting);
		if (isset($obj_meeting) && !empty($obj_meeting->id) && $obj_meeting->provenance_rdv == "internet") {
			$canal = "internet";
		}
		$resultat = $obj_agenda->verif_disponibilite_creneau($date_debut, $canal, $id_meeting, $id_meeting_2, $id_motif, $_POST['lieu_id']);

		if ($resultat === true) {
			echo "OK";
		} elseif ($resultat === "surbooking") {
			echo "surbooking";
		} else {
			echo "";
		}
	} catch (Exception $e) {
		$cause_ex = "Exception";
		$GLOBALS["log"]->fatal("Exception :: verif creno  ::" . print_r($e->getMessage(), true));
		echo "";
	} catch (Error $e) {
		$cause_ex = "Error";
		$GLOBALS["log"]->fatal("Error :: verif creno   ::" . print_r($e->getMessage(), true));
		echo "";
	}
} elseif (isset($_POST['params']) && (isset($_POST['methode']) && "rdv_save" == $_POST['methode'])) { // Création/Modification RDV

	$params = explode("|", $_POST['params']);
	/*
		Params explode : 
		0  => id agenda
		1  => date début
		2  => date fin
		3  => nom individu (usager)
		4  => action = creation | modification
		5  => présence
		6  => commentaire rdv
		7  => lieu_id
		8  => type_rdv
		9  => nature
		10 => motif id
		11 => ressource id
		12 => accompagnant
		13 => date naissance
		14 => mail
		15 => bool notif mail
		16 => tel
		17 => bool notif tel
		18 => date de naissance
		19 => n° de rue
		20 => rue
		21 => n° de batiment
		22 => lieu-dit
		23 => cp
		24 => commune
		*/
		
	$param_agenda_id = $params['0'];
	$param_date_debut = $params['1'];
	$param_date_fin = $params['2'];
	$param_nom = $params['3'];
	$methode = $params['4'];
	$param_presence = $params['5'];
	$param_commentaire = $params['6'];
	$param_lieu = $params['7'];
	$param_type_rdv = $params['8'];
	$param_nature = $params['9'];
	$param_motif_id = urldecode($params['10']);
	$param_ressource_id = $params['11'];
	$param_accompagnant = urldecode($params['12']);

	$param_date_naissance = $params['13'];
	$param_mail = $params['14'];
	$param_bool_mail = $params['15'];
	$param_tel = $params['16'];
	$param_bool_tel = $params['17'];

	$param_date_naissance = $params['18'];
	$param_num_street = $params['19'];
	$param_street = $params['20'];
	$param_num_bat = $params['21'];
	$param_lieu_dit = $params['22'];
	$param_cp = $params['23'];
	$param_commune = $params['24'];



	$GLOBALS["log"]->debug("param_date_debut :: $param_date_debut");
	$GLOBALS["log"]->debug("param_date_fin :: $param_date_fin");
	$GLOBALS["log"]->debug("param_nom :: $param_nom");
	$GLOBALS["log"]->debug("param_methode :: $methode");
	$GLOBALS["log"]->debug("param_lieu :: $param_lieu");
	$GLOBALS["log"]->debug("param_type_rdv :: $param_type_rdv");
	$GLOBALS["log"]->debug("param_motif_id :: $param_motif_id");
	$GLOBALS["log"]->debug("param_ressource_id :: $param_ressource_id");
	$GLOBALS["log"]->debug("obj_meeting   :: " . $_POST['meeting_id']);
	$GLOBALS["log"]->debug("obj_meeting_2 :: " . $_POST['meeting_id_2']);
	$GLOBALS["log"]->debug("id_individu " . $_POST['id_individu']);
	$GLOBALS["log"]->debug("param_accompagnant:: " . $param_accompagnant);


	$GLOBALS["log"]->debug("param_date_naissance " . $param_date_naissance);
	$GLOBALS["log"]->debug("param_mail " . $param_mail);
	$GLOBALS["log"]->debug("param_bool_mail " . $param_bool_mail);
	$GLOBALS["log"]->debug("param_tel " . $param_tel);
	$GLOBALS["log"]->debug("param_bool_tel " . $param_bool_tel);

	$GLOBALS["log"]->debug("param_date_naissance :: " . $param_date_naissance);
	$GLOBALS["log"]->debug("param_num_street " . $param_num_street);
	$GLOBALS["log"]->debug("param_street " . $param_street);
	$GLOBALS["log"]->debug("param_num_bat " . $param_num_bat);
	$GLOBALS["log"]->debug("param_lieu_dit " . $param_lieu_dit);
	$GLOBALS["log"]->debug("param_cp " . $param_cp);
	$GLOBALS["log"]->debug("param_commune " . $param_commune);


	// Si modification sur individu
	if (isset($_POST['id_individu']) && !empty($_POST['id_individu'])) {

		$cur_individu = BeanFactory::getBean('OPS_individu', $_POST['id_individu']);

		// Tel
		if ($cur_individu->phone_mobile != $param_tel) {
			$cur_individu->phone_mobile = $param_tel;
			$cur_individu->save();
		}
		// Date de naissance
		if ($cur_individu->date_naissance != $param_date_naissance) {
			$cur_individu->date_naissance = $param_date_naissance;
			$cur_individu->save();
		}
		// n° de rue
		if ($cur_individu->primary_address_number != $param_num_street) {
			$cur_individu->primary_address_number = $param_num_street;
			$cur_individu->save();
		}
		// Rue
		if ($cur_individu->primary_address_street != $param_street) {
			$cur_individu->primary_address_street = $param_street;
			$cur_individu->save();
		}
		// n° de Bat
		if ($cur_individu->primary_address_complement_batiment != $param_num_bat) {
			$cur_individu->primary_address_complement_batiment = $param_num_bat;
			$cur_individu->save();
		}
		// Lieu dit
		if ($cur_individu->primary_address_complement_lieu != $param_lieu_dit) {
			$cur_individu->primary_address_complement_lieu = $param_lieu_dit;
			$cur_individu->save();
		}
		// CP
		if ($cur_individu->primary_address_postalcode != $param_cp) {
			$cur_individu->primary_address_postalcode = $param_cp;
			$cur_individu->save();
		}
		// Lieu dit
		if ($cur_individu->primary_address_city != $param_commune) {
			$cur_individu->primary_address_city = $param_commune;
			$cur_individu->save();
		}
	}


	$obj_agenda = BeanFactory::getBean("OPS_agendas", $param_agenda_id);

	// LIEU
	if (str_contains($param_lieu, 'Autre')) {
		$lieu = urldecode($param_lieu);
		$lieu_id = "";
	} elseif ($param_lieu == "Aucun" || $param_lieu == "") {
		$lieu = "Aucun";
		$lieu_id = "";
	} else {
		$bean_lieu = BeanFactory::getBean('OPS_lieux', $param_lieu);
		$lieu = $bean_lieu->name;
		$lieu_id = $bean_lieu->id;
	}

	// ACTION
	$obj_meeting = new Meeting();
	$id_meeting = "";

	if (isset($_POST['meeting_id']) && $_POST['meeting_id'] != "") { // RDV EXISTANT
		$id_meeting = $_POST['meeting_id'];
		$obj_meeting = BeanFactory::getBean("Meetings", $_POST['meeting_id']);

		if (isset($_POST['user_assigned_id']) && !empty($_POST['user_assigned_id'])) {
			$user_id = $_POST['user_assigned_id'];

		} else {
			$user_id = '1';
		}

		if (
			(isset($_POST["meeting_id"]) && !empty($_POST["meeting_id"]) && $methode == "modification") // MODIFICATION RDV
			&& (
				$obj_meeting->date_start != $param_date_debut
				|| $obj_meeting->date_end != $param_date_fin
				|| $obj_meeting->location != $param_lieu
				|| $obj_meeting->duration_hours != $duration_hours
				|| $obj_meeting->duration_minutes != $duration_minutes
				|| $obj_meeting->description != $param_commentaire
			)
		) {
			$send_notif_modif = false;
			$send_notif_agent = false;
			$timedate = new TimeDate();
			$modif_date_deb = $timedate->to_db($param_date_debut);


			// Vérification si la durée du rdv a changé
			$duree_old = 0;
			$duree_new = 0;
			if ($obj_meeting->type_rdv == "Réservé"){
				$duree_new = BeanFactory::getBean("OPS_agendas_motifs", $param_motif_id)->duree;
			} else {

				$timedate_d = new TimeDate();
				$date_deb = $timedate_d->to_db($param_date_debut);
				$timedate_e = new TimeDate();
				$date_end = $timedate_e->to_db($param_date_fin);

				$d1 = new DateTime($date_deb);
				$d2 = new DateTime($date_end);

				$duration = $d2->diff($d1);

				$duree_new = ( $duration->format('%H hours') * 60 ) +  $duration->format('%I minutes') ; 
			}

			$duree_old = ( $obj_meeting->duration_hours * 60 ) + $obj_meeting->duration_minutes ; 


			if ($obj_meeting->date_start != $param_date_debut || $obj_meeting->location_id != $param_lieu || $duree_old != $duree_new ) {
				$send_notif_modif = true;
				$GLOBALS['log']->debug(" a envoyé all");
			} elseif ($obj_meeting->assigned_user_id != $user_id) {
				$send_notif_agent = true;
				$GLOBALS['log']->debug(" a envoyé agent");
			} else {
				$GLOBALS['log']->debug("ne pas envoyer");
			}

			$methode = "modification";
			$param_canal = $obj_meeting->provenance_rdv;
		}

		$outlook_id = 0;
		if ($obj_meeting->assigned_user_id != $user_id && $user_id != 1) { // MODIFICATION Agent
			$send_notif_agent = true;
			$methode = "creation_agent";
			$outlook_id = 1;
		}

	} elseif (!empty($_POST['meeting_id_2'])) { // RDV tmp
		$id_meeting_2 = str_replace(" ", "", $_POST['meeting_id_2']);

		$obj_meeting = BeanFactory::getBean("Meetings", $_POST['meeting_id_2']);
		$methode = "creation";
		$outlook_id = 0;
		$id_meeting = $_POST['meeting_id_2'];
	} else { // RDV NEW
		$methode = "creation";
		$outlook_id = 0;
	}


	// On vérifie si une modification a été effectuée sur le N° de téléphone de l'individu // /TODO: MAIL?
	if (isset($_POST['id_individu']) && !empty($_POST['id_individu'])) {
		$cur_individu = BeanFactory::getBean('OPS_individu', $_POST['id_individu']);

		// Si le numéro de téléphone saisi sur le rendez-vous n'est pas le téléphone de l'individu, on met à jour la métadonnée
		if ($cur_individu->phone_mobile != $param_tel) {
			$cur_individu->phone_mobile = $param_tel;
			$cur_individu->save();
		}
	}
	// USERS
	$obj_user_assigned = BeanFactory::newBean("Users");
	if (isset($_POST['user_assigned_id']) && !empty($_POST['user_assigned_id'])) {
		$obj_user_assigned = BeanFactory::getBean("Users", $_POST['user_assigned_id']);
	} else {
		$obj_user_assigned =  BeanFactory::getBean("Users", 1);
	}


	$obj_user_cur = null;
	if (isset($_POST['user_id']) && !empty($_POST['user_id'])) {
		$obj_user_cur = BeanFactory::getBean("Users", $_POST['user_id']);
	} else {
		$obj_user_cur = BeanFactory::getBean("Users", 1);
	}


	// DATES & DUREES
	$timedate_d = new TimeDate();
	$date_deb = $timedate_d->to_db($param_date_debut);
	$timedate_e = new TimeDate();
	$date_end = $timedate_e->to_db($param_date_fin);

	if ($param_type_rdv == "Réservé") { // RDV Réservé

		$obj_motif = BeanFactory::getBean("OPS_agendas_motifs", $param_motif_id);

		$heures = floor($obj_motif->duree / 60);
		$minutes = $obj_motif->duree - ($heures * 60);

	} else { // RDV Hors Plage

		$d1 = new DateTime($date_deb);
		$d2 = new DateTime($date_end);

		$duration = $d2->diff($d1);
		$heures = $duration->format('%H hours');
		$minutes = $duration->format('%I minutes');
		
	}

	try {

		$succes_crea = false;

		$obj_meeting->date_start = $date_deb;
		$obj_meeting->date_end = $date_end;
		$obj_meeting->duration_hours = $heures;
		$obj_meeting->duration_minutes = $minutes;
		$obj_meeting->motif_autre = str_contains($param_motif_id, "Autre -")?$param_motif_id: "";
		$obj_meeting->tel_rdv = $param_tel;
		$obj_meeting->ops_individu_id = $_POST['id_individu'];
		$obj_meeting->accompagnant = $param_accompagnant;

		$obj_meeting->notif_mail = $param_bool_mail;
		$obj_meeting->notif_sms = $param_bool_tel;


		// Check des envois des notifications
		$date_debut = DateTime::createFromFormat('d/m/Y H:i', $param_date_debut);
		$date_debut = $date_debut->format('Y-m-d H:i:s');

		$date_now = new DateTime();
		$date_now = $date_now->format('Y-m-d H:i:s');

		$bool_date = false;
		if ($date_now <= $date_debut) {
			$bool_date = true;
		}


		if ($methode == "creation") {
			$obj_meeting->created_by = $obj_user_cur->id;
			$obj_meeting->provenance_rdv = 'guichet';
		}
/* 		if ($obj_meeting->provenance_rdv = 'guichet') {
			$obj_meeting->provenance_rdv = 'crm';
		} */

		if ($methode == "creation" && $bool_date) {
			$obj_meeting->confirmation_sms = 0;
			$obj_meeting->confirmation_mail = 0;
			$obj_meeting->usager_rappel = 0;
			$obj_meeting->nb_relances_agent = 0;
			$obj_meeting->nb_relances_usager_mail = 0;
			$obj_meeting->nb_relances_usager_sms = 0;
		}
		if ($methode == "modification" && $bool_date) {
			$obj_meeting->usager_rappel = 0;
		}

		// Synchro
		if ($obj_meeting->outlook_id == null || $obj_meeting->outlook_id == "") {
			$obj_meeting->outlook_id = $outlook_id;
		} else {
			$obj_meeting->outlook_id = intval($obj_meeting->outlook_id) + $outlook_id;
		}

		$obj_meeting->assigned_user_id = $obj_user_assigned->id;
		$obj_meeting->created_by = $obj_user_cur->id;
		$obj_meeting->assigned_user_name = $obj_user_assigned->name;

		$obj_meeting->location = $lieu;
		$obj_meeting->location_id = $lieu_id;

		$obj_meeting->type_rdv = $param_type_rdv;


		$obj_meeting->rdv_statut_presence = $param_presence;
		$obj_meeting->nature = $param_nature;
		$obj_meeting->description = $param_commentaire;

		$obj_meeting->name = $param_nom;
		$id_meet = $obj_meeting->save();

		// Bug :: infos qui ne s'enregistrent pas  ...
		$obj_meeting = BeanFactory::getBean('Meetings', $obj_meeting->id);
		$obj_meeting->assigned_user_id = $obj_user_assigned->id;
		$obj_meeting->created_by = $obj_user_cur->id;
		$obj_meeting->assigned_user_name = $obj_user_assigned->name;
		$obj_meeting->location = $lieu;
		$obj_meeting->location_id = $lieu_id;
		$obj_meeting->type_rdv = $param_type_rdv;
		$obj_meeting->date_end = $date_end;
		$obj_meeting->motif_autre = str_contains($param_motif_id, "Autre -")?$param_motif_id: "";
		$id_meet = $obj_meeting->save();

		if (!empty($id_meet)) {

			$obj_meeting->ops_agendas_meetings->delete($obj_meeting, "");
			$obj_meeting->ops_agendas_meetings->add($obj_agenda);

			if ($param_ressource_id != "") {

				$obj_ressource = BeanFactory::getBean("OPS_agendas_ressources", $param_ressource_id);

				$obj_meeting->ops_agendas_ressources_meetings->delete($obj_meeting, "");
				$obj_meeting->ops_agendas_ressources_meetings_name = $obj_ressource->name;
				$obj_meeting->ops_agendas_ressources_meetings->add($obj_ressource);
			} else {

				$obj_meeting->load_relationship('ops_agendas_ressources_meetings');
				$obj_meeting->ops_agendas_ressources_meetings->delete($obj_meeting->id, $obj_ressource);
			}


			if (!str_contains($param_motif_id,"Autre -")){ // Si motif connu
				$obj_meeting = BeanFactory::getBean('Meetings', $id_meet);
				$obj_motifs_new = BeanFactory::getBean('OPS_agendas_motifs', $param_motif_id);
				$id_meet = $obj_meeting->save(); // BUG motif non save

				$obj_meeting->load_relationship('ops_agendas_motifs_meetings');
				$obj_meet_motif = $obj_meeting->ops_agendas_motifs_meetings->get();

				$obj_motifs_old = BeanFactory::getBean('OPS_agendas_motifs', $obj_meet_motif[0]);
				$obj_meeting->ops_agendas_motifs_meetings->delete($obj_meeting->id, $obj_motifs_old);
				$obj_meeting->ops_agendas_motifs_meetings->add($obj_motifs_new);
				$obj_meeting->load_relationship('ops_agendas_motifs_meetings');

			} else {
				$obj_meeting->load_relationship('ops_agendas_motifs_meetings');
				$obj_meet_motif = $obj_meeting->ops_agendas_motifs_meetings->get();

				$obj_motifs_old = BeanFactory::getBean('OPS_agendas_motifs', $obj_meet_motif[0]);
				$obj_meeting->ops_agendas_motifs_meetings->delete($obj_meeting->id, $obj_motifs_old);
			}

			// BUG Motif non save
			$obj_meeting = BeanFactory::getBean('Meetings', $id_meet);

			if ($bool_date && ((($obj_meeting->provenance_rdv == "guichet" || $obj_meeting->provenance_rdv == "crm") && !empty($methode) && $methode != "modification") || ($methode == "modification" && isset($send_notif_modif) && $send_notif_modif == true))) {

				$obj_agenda->gestion_notifications_agent($obj_meeting, $methode);
				$obj_agenda->gestion_notifications_usager($obj_meeting, $methode);

			} elseif ($bool_date && isset($send_notif_agent) && $send_notif_agent == true) {
				$obj_agenda->gestion_notifications_agent($obj_meeting, "modification");
			}

			// Mise à jour du dossier back si existant
			$obj_dossier_back = BeanFactory::getBean("OPS_dossier", $obj_meeting->parent_id);
			if (isset($obj_dossier_back) && !empty($obj_dossier_back->id)){
				$customChamp = json_decode(base64_decode($obj_dossier_back->champs_custom));

				if (empty($current_user->id)) {
					$current_user = BeanFactory::getBean("Users", '1');
				}
				$format = $current_user->getPreference('datef') . " " . $current_user->getPreference('timef');
				$timeZone = TimeDate::userTimezone($current_user);
				date_default_timezone_set($timeZone);

	
				$rdv_date_start = DateTime::createFromFormat("Y-m-d H:i:s", $obj_meeting->date_start, new DateTimeZone("UTC"));
				$rdv_date_start = $rdv_date_start->setTimezone(new DateTimeZone($timeZone));

				$customChamp->{"rdv_date"} = $rdv_date_start->format("d/m/Y");
				$customChamp->{"rdv_heure"} = $rdv_date_start->format("H:i");
				$customChamp->{"rdv_lieu"} = $obj_meeting->location;
				$customChamp->{"rdv_accompagnant"} = $obj_meeting->accompagnant;
				$obj_dossier_back->champs_custom = base64_encode(json_encode($customChamp));
				$obj_dossier_back->save();
			}


			unset($obj_meeting);
			unset($obj_agenda);

			echo $id_meet;
		} else {
			$GLOBALS["log"]->fatal("Erreur :: à la save des relations");
			$res = "error";
		}
	} catch (Error $e) {
		$cause_error = "unk";
		$GLOBALS["log"]->fatal("Erreur :: save Meeting  ::" . print_r($e->getMessage(), true));

		unset($obj_meeting);
		unset($obj_agenda);

		// TEST :: Rendez-vous temporaire arrivé à expiration
		$obj_meeting = new Meeting();
		$where = " meetings.id = '$id_meeting'";
		$liste_rendez_vous_temporaire = $obj_meeting->get_full_list('date_entered', $where, false, 1);

		if (isset($liste_rendez_vous_temporaire[0]->id) && !empty($liste_rendez_vous_temporaire[0]->id) && $liste_rendez_vous_temporaire[0]->deleted == 1) {
			$cause_error = "RDV temporaire supprimé";
			$GLOBALS["log"]->debug("rdv tmp suppre::" . print_r($where, true));
			$res = "TMP";
		} else {
			$cause_error = "Non traité";
			$res = "error";
		}

		$GLOBALS["log"]->fatal("DEBUG :: Error (Meeting save) :: " . print_r($cause_error, true));
		echo $res;
	} catch (Exception $e) {
		$cause_ex = "Exception";
		$GLOBALS["log"]->fatal("DEBUG :: Exception (Meeting save) ::" . print_r($e->getMessage(), true));
		$res = "error";
		echo $res;
	} finally {
		$GLOBALS["log"]->debug("FINAL :: res :: " . print_r($res, true));
	}

} elseif (isset($_POST['meeting_id']) && (isset($_POST['methode']) && "rdv_suppr" == $_POST['methode'])) { // Suppression rdv

	try {

		$current_user = BeanFactory::getBean("Users",$_POST['user_id']);
		$meeting_id = str_replace(" ", "", $_POST['meeting_id']);

		$obj_meeting = BeanFactory::getBean("Meetings", $meeting_id);

		if(!empty($obj_meeting)){
			// Gestion des envois des notifications
			//$date_debut = DateTime::createFromFormat('d/m/Y H:i', $obj_meeting->date_start);
			$format = $current_user->getPreference('datef') . " " . $current_user->getPreference('timef');
			$date_debut = DateTime::createFromFormat($format, $obj_meeting->date_start);
			$date_debut = $date_debut->format('Y-m-d H:i:s');

			$date_now = new DateTime();
			$date_now = $date_now->format('Y-m-d H:i:s');

			$bool_date = false;
			if ($date_now <= $date_debut) {
				$bool_date = true;
			}

			if ($bool_date  && isset($_POST['methode_btn']) && $_POST['methode_btn'] == "annulation") {
				$obj_agenda = BeanFactory::getBean("OPS_agendas", $obj_meeting->ops_agendas_id);

				$obj_agenda->gestion_notifications_agent($obj_meeting, "annulation");
				$obj_agenda->gestion_notifications_usager($obj_meeting, "annulation");
			}

			$obj_meeting = BeanFactory::newBean("Meetings");
			$obj_meeting->mark_deleted($meeting_id);
			echo json_encode($_POST['meeting_id']);
		}

		//$GLOBALS['log']->fatal('fail suprr rdv tmp:'.print_r($_POST['meeting_id'], true));
		echo "";
	} catch (Exception $e) {
		$GLOBALS["log"]->fatal("$e");
		echo "error";
	} catch (Error $e) {


		// TEST :: Si tentative de suppr un rdv déjà suppr == refresh la page
		$obj_meeting = BeanFactory::newBean("Meetings");
		$where = " meetings.id = '" . $_POST['meeting_id'] . "'";
		$liste_rendez_vous_suppr = $obj_meeting->get_full_list('date_entered', $where, false, 1);

		if (str_contains($e, "Call to a member function mark_deleted() on null") && isset($liste_rendez_vous_suppr[0]->id) && !empty($liste_rendez_vous_suppr[0]->id) && $liste_rendez_vous_suppr[0]->deleted == 1) {
			echo json_encode($_POST['meeting_id']);
		} else {
			$GLOBALS["log"]->fatal("$e");
			echo "error";
		}
	}
} elseif (isset($_POST['params']) && (isset($_POST['methode']) && "rdv_temporaire" == $_POST['methode'])) { // Création rdv tmp


	$params = explode("|", $_POST['params']);
	/*
				Params explode : TMP
				0 => id agenda
				1 => date début
				2 => id motif
				*/
	try {


		$param_agenda_id = $params['0'];
		$param_date_debut = $params['1'];
		$param_motif_id = $params['2'];

		$param_lieu = $_POST['lieu_id'];
		$param_individu_id = $_POST['individu_id'];
		$id_meeting = $_POST['meeting_id'];
		$id_meeting_2 = str_replace(" ", "", $_POST['meeting_id_2']);
		$current_user = BeanFactory::getBean("Users", $_POST['user_id']);

		//Suppression du RDV temporaire non réservé
		if ($id_meeting_2 != "") {
			$objet_meeting =BeanFactory::newBean("Meetings");
			$objet_meeting->mark_deleted($id_meeting_2);
			$objet_meeting->save();
		}

		$timedate = new TimeDate();
		$date_deb = $timedate->to_db($param_date_debut);

		$obj_motif = BeanFactory::getBean("OPS_agendas_motif",$param_motif_id);

		// Mise en place de relations
		$obj_agenda = BeanFactory::getBean("OPS_agendas",$param_agenda_id);

		// LIEU
		$bean_lieu = BeanFactory::getBean('OPS_lieux', $param_lieu);
		$lieu = $bean_lieu->name;
		$lieu_id = $bean_lieu->id;


		$obj_meeting = BeanFactory::newBean("Meetings");
		$obj_meeting->location = $lieu;
		$obj_meeting->location_id = $lieu_id;

		$obj_meeting->date_start = $date_deb;
		$obj_meeting->duration_minutes = $obj_motif->duree;

		$obj_meeting->name = "RDV_TEMP";
		$obj_meeting->ops_individu_id = $param_individu_id;
		$obj_meeting->created_by = $current_user->id;

		$id_meet = $obj_meeting->save();


		if (!empty($id_meet)) {
			$obj_meeting->ops_agendas_meetings->delete($obj_meeting, "");
			$obj_meeting->ops_agendas_meetings->add($obj_agenda);

			$obj_meeting->ops_agendas_meetings->delete($obj_meeting, "");
			$obj_meeting->ops_agendas_meetings->add($obj_agenda);

			$obj_meeting->ops_agendas_motifs_meetings->delete($obj_meeting, "");
			$obj_meeting->ops_agendas_motifs_meetings->add($obj_motif);
			echo $id_meet;
		} else {
			echo json_encode("");
		}
	} catch (Error $e) {
		$GLOBALS["log"]->fatal("$e");
	} catch (Exception $e) {
		$GLOBALS["log"]->fatal("$e");
	}
} elseif (isset($_POST['meeting_id']) && !empty($_POST['meeting_id']) && isset($_POST['service_id']) && !empty($_POST['service_id']) && "dossier_crea" == $_POST['methode']) { // Création dossier


try{
	$retour = false;
	$obj_meeting= BeanFactory::getBean('Meetings', $_POST['meeting_id']);

	if (!empty($obj_meeting->ops_individu_id)) {

		$obj_individu = BeanFactory::getBean('OPS_individu', $obj_meeting->ops_individu_id);
		$obj_dispositif = BeanFactory::getBean('OPS_dispositif', $_POST['service_id']);


		if (!empty($obj_individu->id) && !empty($obj_dispositif->id)) {

			$data_dossier = array();
			$data_dossier["canal"] = "crm";
			$data_dossier["demandeur"] = $obj_individu->id;
			$data_dossier['ops_personne_morale'] = "";
			$data_dossier['beneficiaire_id'] = $obj_individu->id;
			$data_dossier["dispositif"] = $obj_dispositif->id;
			$data_dossier["type_tiers"] = "OPS_individu";

			$obj_dossier = BeanFactory::newBean('OPS_dossier');
			$id_dossier = $obj_dossier->createDossier($data_dossier);

			$retour = $id_dossier;
			$obj_dossier = BeanFactory::getBean('OPS_dossier', $id_dossier);
			$customChamp = json_decode(base64_decode($obj_dossier->champs_custom));


			if (empty($current_user->id)) {
				$current_user = BeanFactory::getBean("Users", '1');
			}
			$format = $current_user->getPreference('datef') . " " . $current_user->getPreference('timef');

			$rdv_date_start = DateTime::createFromFormat($format, $obj_meeting->date_start);
			$customChamp->{"rdv_date"} = $rdv_date_start->format("d/m/Y");
			$customChamp->{"rdv_heure"} = $rdv_date_start->format("H:i");
			$customChamp->{"rdv_lieu"} = $obj_meeting->location;
			$customChamp->{"rdv_accompagnant"} = $obj_meeting->accompagnant;
			$obj_dossier->champs_custom = base64_encode(json_encode($customChamp));

			$obj_dossier->save();

			if (!empty($id_dossier)) {
				$obj_meeting->parent_type = "OPS_dossier";
				$obj_meeting->parent_id = $id_dossier;
				$obj_meeting->save();
				$retour = $id_dossier;
			}
		}
	}

	echo $retour;
}catch(Exception $e){

	$GLOBALS['log']->fatal('Exception create dossier : '.print_r($e, true));
	echo false;
}

} elseif (isset($_POST['meeting_id']) && !empty($_POST['meeting_id']) && isset($_POST['dossier_id']) && !empty($_POST['dossier_id']) && "dossier_suppr" == $_POST['methode']) {

	$GLOBALS['log']->debug("agenda_visu:: fct suppr dossier ::::");
	$retour = false;
	$dossier_id = $_POST['dossier_id'];

	$obj_dossier = BeanFactory::getBean("OPS_dossier", $dossier_id);
	// Suppression du dossier
	if (!empty($obj_dossier->id)) {


		$obj_meeting = BeanFactory::getBean('Meetings',$_POST['meeting_id']);
		$obj_meeting->parent_type = "";
		$obj_meeting->parent_id = "";
		$obj_meeting->save();

		$obj_dossier->mark_deleted($obj_dossier->id);


		if (!$obj_dossier->save()) {
			$libelle_erreur = "Echec de la suppression du dossier id = " . $dossier_id;
		} else {
			$retour = true;
		}
	}

	echo $retour;
}