/**
 * Recherche & Création Individu
 * Masks sur les champs individu
 * Gestion formulaire Individu 
 */
function call_ajax_recherche() {
	var result_verif_obligatoire = this.verif_champs_obligatoires();

	if (result_verif_obligatoire == true) {
		var array_champs = this.get_valeurs_champs_recherche();

		jQuery.ajax({
			type: "POST",
			url: 'index.php?entryPoint=agenda_recherche_individu',
			dataType: 'json',
			data: {
				array_champs: array_champs
			},

			success: function (data) {
				if (typeof (data) != "undefined" && data.length > 0) {
					jQuery('#modal-individu-body').empty();
					jQuery('#myModal').modal();

					jQuery("#nombre_max").hide();
					// Si il y a plus de 10 individus trouvés, on tronque les résultats pour en garder 10 et on affiche le message "d'erreur"
					if (data.length > 10) {
						jQuery("#nombre_max").show();
						data.splice(9, 1);
					}

					//affichage de la modal resultats des indi trouvé en btn radio
					for (let index = 0; index < data.length; index++) {

						var input = document.createElement("input");
						input.type = "radio";
						input.id = String(data[index].id) + "_recherche";
						input.name = "individu_trouve";
						input.value = data[index].id;
						input.className = "input_individu_trouve";
						input.style.verticalAlign = 'top';
						input.style.marginTop = '3px';
						var label = document.createElement("label");
						label.setAttribute("for", String(data[index].id) + "_recherche");
						label.innerHTML = '<p>' + data[index].salutation + " " +
							data[index].last_name +(data[index].nom_usage != ''?"("+data[index].nom_usage+")":'' )+ " " + data[index].first_name + " "+ 
							(data[index].date_naissance.length != 0 ? ", né(e) le " + data[index].date_naissance : "") + "</p>" +
							"<p style='font-style:italic;font-weight:400;margin-left:20px'>" + (data[index].email.length != 0 ? "Email : " + data[index].email : "") +
							(data[index].phone_number.length != 0 ? ", Tél. : " + data[index].phone_number : "") + "</p>" +
							(data[index].primary_address_street.length != 0 ? "<p style='font-style:italic;font-weight:400;margin-left:20px'>Adresse : " +
								data[index].primary_address_street + ", " +
								data[index].primary_address_postalcode + " " +
								data[index].primary_address_city + "</p>" : "");

						var container = document.getElementById('modal-individu-body');
						var div_input = document.createElement("div");
						div_input.setAttribute("id", "block_result_" + String(data[index].id));

						div_input.appendChild(input);
						div_input.appendChild(label);
						container.appendChild(div_input);

						//auto-remplissage des champs

						//type
						var input_type = document.createElement("input");
						input_type.type = "hidden";
						input_type.id = String(data[index].id) + "_type_individu_recherche";
						input_type.name = "type_individu_trouve";
						input_type.value = data[index].type_individu;
						input_type.className = "input_type_individu_trouve";

						var container_type = document.getElementById('modal-individu-body');

						div_input.appendChild(input_type);
						container_type.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_type.id)).attr('rel', 'type_individu_recherche'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.


						//civilite 
						var input_civ = document.createElement("input");
						input_civ.type = "hidden";
						input_civ.id = String(data[index].id) + "_civilite_recherche";
						input_civ.name = "civilite_individu_trouve";
						input_civ.value = data[index].salutation;
						input_civ.className = "input_civilite_individu_trouve";

						var container_civ = document.getElementById('modal-individu-body');

						div_input.appendChild(input_civ);
						container_civ.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_civ.id)).attr('rel', 'civilite_recherche'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.

						//name
						var input_name = document.createElement("input");
						input_name.type = "hidden";
						input_name.id = String(data[index].id) + "_last_name_recherche";
						input_name.name = "last_name_individu_trouve";
						input_name.value = data[index].last_name;
						input_name.className = "input_last_name_individu_trouve";

						var container_name = document.getElementById('modal-individu-body');

						div_input.appendChild(input_name);
						container_name.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_name.id)).attr('rel', 'last_name_recherche'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.


						//nom usage
						var input_nom_usage = document.createElement("input");
						input_nom_usage.type = "hidden";
						input_nom_usage.id = String(data[index].id) + "_nom_usage_recherche";
						input_nom_usage.name = "nom_usage_individu_trouve";
						input_nom_usage.value = data[index].nom_usage;
						input_nom_usage.className = "input_nom_usage_individu_trouve";

						var container_nom_usage = document.getElementById('modal-individu-body');

						div_input.appendChild(input_nom_usage);
						container_nom_usage.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_nom_usage.id)).attr('rel', 'nom_usage_recherche'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.


						//prenom
						var input_first_name = document.createElement("input");
						input_first_name.type = "hidden";
						input_first_name.id = String(data[index].id) + "_first_name_recherche";
						input_first_name.name = "first_name_individu_trouve";
						input_first_name.value = data[index].first_name;
						input_first_name.className = "input_first_name_individu_trouve";

						var container_first_name = document.getElementById('modal-individu-body');

						div_input.appendChild(input_first_name);
						container_first_name.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_first_name.id)).attr('rel', 'first_name_recherche'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.

						//date_naissance
						var input_date_naissance = document.createElement("input");
						input_date_naissance.type = "hidden";
						input_date_naissance.id = data[index].id + "_date_naissance_recherche";
						input_date_naissance.name = "date_naissance_individu_trouve";
						input_date_naissance.value = data[index].date_naissance;
						input_date_naissance.className = "input_date_naissance_individu_trouve";

						var container_date_naissance = document.getElementById('modal-individu-body');

						div_input.appendChild(input_date_naissance);
						container_date_naissance.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_date_naissance.id)).attr('rel', 'date_naissance_recherche'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.

						//tel
						var numero = data[index].phone_number;

						var num_longueur = numero.length;
						if (num_longueur == '10') {
							var parttel1 = numero.substr(0, 2);
							var parttel2 = numero.substr(2, 2);
							var parttel3 = numero.substr(4, 2);
							var parttel4 = numero.substr(6, 2);
							var parttel5 = numero.substr(8, 2);
							numero = parttel1 + '.' + parttel2 + '.' + parttel3 + '.' + parttel4 + '.' + parttel5;
						}

						var input_phone_number = document.createElement("input");
						input_phone_number.type = "hidden";
						input_phone_number.id = data[index].id + "_phone_number_recherche";
						input_phone_number.name = "phone_number_individu_trouve";
						input_phone_number.value = numero;
						input_phone_number.className = "input_phone_number_individu_trouve";

						var container_input_phone = document.getElementById('modal-individu-body');

						div_input.appendChild(input_phone_number);
						container_input_phone.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_phone_number.id)).attr('rel', 'tel'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.

						//mail
						var input_email = document.createElement("input");
						input_email.type = "hidden";
						input_email.id = data[index].id + "_email_recherche";
						input_email.name = "email_individu_trouve";
						input_email.value = data[index].email;
						input_email.className = "input_email_individu_trouve";

						var container_email = document.getElementById('modal-individu-body');

						div_input.appendChild(input_email);
						container_email.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_email.id)).attr('rel', 'email_recherche'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.

						
						//adresse n°
						var input_adr_num = document.createElement("input");
						input_adr_num.type = "hidden";
						input_adr_num.id = data[index].id + "_adr_num_recherche";
						input_adr_num.name = "adr_num_individu_trouve";
						input_adr_num.value = data[index].primary_address_num;
						input_adr_num.className = "input_adr_pp_individu_trouve";

						var container_adr_num = document.getElementById('modal-individu-body');

						div_input.appendChild(input_adr_num);
						container_adr_num.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_adr_num.id)).attr('rel', 'adr-num'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
						

						//adresse rue
						var input_adr_street = document.createElement("input");
						input_adr_street.type = "hidden";
						input_adr_street.id = data[index].id + "_adr_street_recherche";
						input_adr_street.name = "adr_street_individu_trouve";
						input_adr_street.value = data[index].primary_address_street;
						input_adr_street.className = "input_adr_street_individu_trouve";

						var container_adr_street = document.getElementById('modal-individu-body');

						div_input.appendChild(input_adr_street);
						container_adr_street.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_adr_street.id)).attr('rel', 'adr-street'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.

						
						//adresse batiment
						var input_adr_bat = document.createElement("input");
						input_adr_bat.type = "hidden";
						input_adr_bat.id = data[index].id + "_adr_bat_recherche";
						input_adr_bat.name = "adr_bat_individu_trouve";
						input_adr_bat.value = data[index].primary_address_bat;
						input_adr_bat.className = "input_adr_bat_individu_trouve";

						var container_adr_bat = document.getElementById('modal-individu-body');

						div_input.appendChild(input_adr_bat);
						container_adr_bat.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_adr_bat.id)).attr('rel', 'adr-bat'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
		
						
						//adresse lieu
						var input_adr_lieu = document.createElement("input");
						input_adr_lieu.type = "hidden";
						input_adr_lieu.id = data[index].id + "_adr_lieu_recherche";
						input_adr_lieu.name = "adr_lieu_individu_trouve";
						input_adr_lieu.value = data[index].primary_address_lieu;
						input_adr_lieu.className = "input_adr_lieu_individu_trouve";

						var container_adr_lieu = document.getElementById('modal-individu-body');

						div_input.appendChild(input_adr_lieu);
						container_adr_lieu.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_adr_lieu.id)).attr('rel', 'adr-lieu'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
		
						
						//adresse code postal
						var input_adr_cp = document.createElement("input");
						input_adr_cp.type = "hidden";
						input_adr_cp.id = data[index].id + "_adr_cp_recherche";
						input_adr_cp.name = "adr_cp_individu_trouve";
						input_adr_cp.value = data[index].primary_address_postalcode;
						input_adr_cp.className = "input_adr_cp_individu_trouve";

						var container_adr_cp = document.getElementById('modal-individu-body');

						div_input.appendChild(input_adr_cp);
						container_adr_cp.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_adr_cp.id)).attr('rel', 'code-postal'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.


						//adresse commune
						var input_adr_city = document.createElement("input");
						input_adr_city.type = "hidden";
						input_adr_city.id = data[index].id + "_adr_city_recherche";
						input_adr_city.name = "adr_city_individu_trouve";
						input_adr_city.value = data[index].primary_address_city;
						input_adr_city.className = "input_adr_city_individu_trouve";

						var container_adr_city = document.getElementById('modal-individu-body');

						div_input.appendChild(input_adr_city);
						container_adr_city.appendChild(div_input);

						$('input[type="hidden"]#' + String(input_adr_city.id)).attr('rel', 'commune'); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.

						
					}
						let divCreateIndivi = document.createElement('div');
						divCreateIndivi.setAttribute('style', "border-top: 1px solid #e5e5e5; padding-top: 15px; margin-top: 15px");
						divCreateIndivi.innerHTML= `<input name="individu_trouve" type="radio" id="individu_non_trouve" class="input_individu_trouve" value="creer" style="vertical-align: top; margin-top: 3px;">
						<label for="individu_non_trouve" >L\'individu n\'a pas été trouvé, je souhaite le créer</label>`;

						document.getElementById("modal-individu-body").appendChild(divCreateIndivi);
				} else {

					jQuery('#ops_individu_introuvable_modal').modal();
				}

			},
			error: function (data) {
				console.log(data);
				console.log("Erreur à la recherche");
			}

		});
	}
}

function verif_champs_obligatoires() {
	var array_champs = this.get_valeurs_champs_recherche();

	if (Object.keys(array_champs).length == 0) {
		alert('Veuillez saisir des critères de recherches.');
		return false;

	} else if (Object.keys(array_champs).length != 0) {
		if (
			typeof array_champs.last_name == 'undefined' &&
			typeof array_champs.first_name == 'undefined' &&
			typeof array_champs.nom_usage == 'undefined'

		) {
			alert('Veuillez saisir au moins le nom, le nom d\'usage ou le prénom.');
			return false;

		} else {
			var error_msg = "";

			if (array_champs.first_name !== undefined && array_champs.first_name.length > 0 && array_champs.first_name.length < 3) {
				error_msg += '\n- Prénom';
			}

			if (array_champs.last_name !== undefined && array_champs.last_name.length > 0 && array_champs.last_name.length < 3) {
				error_msg += '\n- Nom';
			}

			if (array_champs.nom_usage !== undefined && array_champs.nom_usage.length > 0 && array_champs.nom_usage.length < 3) {
				error_msg += '\n- Nom d\'usage';
			}

			if (error_msg != "") {
				alert('Veuillez saisir au moins 3 caractères dans le champ suivant :' + error_msg);
				return false;

			} else {
				return true;

			}
		}

	} else {
		return true;
	}
}

function reset_champs(type_block) {

	document.getElementById('tr_table').innerHTML = "";
	document.getElementById("historic_link_id").innerHTML = "Historique(0)";


	if (type_block == 'recherche') {
		jQuery('#champs_recherche :input').val('');
		document.getElementById('champs_recherche').style.display = 'block';
		document.getElementById('individu_selectionne').style.display = 'none';

		// On réactive les champs qu'on a mit en Readonly après une recherche
		$("#civilite_recherche").css('pointer-events', '');
		document.getElementById("last_name_recherche").removeAttribute('readonly');
		document.getElementById("first_name_recherche").removeAttribute('readonly');
		document.getElementById("date_naissance_recherche").removeAttribute('readonly');
		document.getElementById("tel").removeAttribute('readonly');
		document.getElementById("email_recherche").removeAttribute('readonly');
		document.getElementById("adr-num").removeAttribute('readonly');
		document.getElementById("adr-bat").removeAttribute('readonly');
		document.getElementById("adr-street").removeAttribute('readonly');
		document.getElementById("adr-lieu").removeAttribute('readonly');
		document.getElementById("code-postal").removeAttribute('readonly');
		document.getElementById("commune").removeAttribute('readonly');
	} else {
		jQuery('#creation_individu :input').val('');
	}
	document.getElementById("rechercher").style.display = "block";
	
}


function select_modal_individu_trouve(){
	var radioValue = jQuery("#modal-individu-body input[name='individu_trouve']:checked").val();

	if(radioValue == 'creer'){
		trigger_creation_individu();

	}
	else{
		save_modal_recherche(radioValue);
		get_historics_selected_indi();
		document.getElementById("rechercher").style.display = "none";
	}
    
}


function save_modal_recherche(radioValue) {

	if (typeof radioValue != "undefined") {
		jQuery('#block_result_' + String(radioValue) + ' input[type="hidden"]').each(function (i, o) {
			let _source_field = $(o);
			_relation_field_id = _source_field.attr('rel');
			$('#' + _relation_field_id).val(_source_field.val());
			jQuery('#myModal').modal('hide');
			$("#id_individu_trouve_id").val(radioValue);
			var last_name = $("#last_name_recherche").val();
			var first_name = $("#first_name_recherche").val();
			$("#usager").val(String(last_name) + ' ' + String(first_name));

			/* 
			 * On bloque les inputs après validation d'une recherche pour éviter une différence d'informations saisies
			 * Sauf le téléphone, s'il est modifié on propage la modification à la fiche individu 
			 */
			$("#civilite_recherche").css('pointer-events', 'none');
			document.getElementById("type_individu_recherche").removeAttribute('readonly');
			document.getElementById("last_name_recherche").setAttribute('readonly', true);
			document.getElementById("first_name_recherche").setAttribute('readonly', true);
			document.getElementById("date_naissance_recherche").removeAttribute('readonly');
			//document.getElementById("tel").setAttribute('readonly', true);
			document.getElementById("email_recherche").setAttribute('readonly', true);
			document.getElementById("adr-num").removeAttribute('readonly');
			document.getElementById("adr-bat").removeAttribute('readonly');
			document.getElementById("adr-street").removeAttribute('readonly');
			document.getElementById("adr-lieu").removeAttribute('readonly');
			document.getElementById("code-postal").removeAttribute('readonly');
			document.getElementById("commune").removeAttribute('readonly');
			
		});

	} else {
		alert("Veuillez sélectionner un individu ou effectuez une nouvelle recherche.")
	}
}


function get_valeurs_champs_recherche() {
	var array_valeurs_champs = {};

	jQuery('#champs_recherche :input').each(function () {
		if (this.value != "") {
			id = this.id.replace('_recherche', '');

			if (id == 'last_name') {
				array_valeurs_champs[id] = this.value;
			}

			if (id == 'nom_usage') {
				array_valeurs_champs[id] = this.value;
			}

			if (id == 'first_name') {
				array_valeurs_champs[id] = this.value;
			}

			if (id == 'date_naissance') {
				array_valeurs_champs[id] = this.value;
			}
		}
	});

	return array_valeurs_champs;
}


function trigger_creation_individu() {
	document.getElementById("individu_creation_area").innerHTML = "Création de l'individu";
	document.getElementById("individu_creation_area").style = "width: 70%;";
	//document.getElementById('date_naissance_recherche').removeAttribute('readonly');
	//document.getElementById('email_recherche').removeAttribute('readonly');
	$('input[name=action]').val('creation_individu');
}

/**
 * Gestion de l'affichage de l'onglet Historique dans la modale de création d'un rdv
 */
function get_historics_selected_indi() {



	$('input[name=action]').val('');
	var id_individu = $("#id_individu_trouve_id").val();
	var agenda_id = $("#visua_agenda").val();

	jQuery.ajax({
		type: "POST",
		url: 'index.php?entryPoint=agenda_recherche_historic',
		dataType: 'json',
		data: {
			id_individu: id_individu,
			agenda_id: agenda_id
		},

		success: function (data) {


			if (data != null && typeof (data) != "undefined" && data.length > 0) {

				var a_historic = document.getElementById('historic_link_id').textContent = "Historique(" + data.length + ")";
				var container = document.getElementById('tr_table');

				//label tableau
				var tr_input_label = document.createElement("tr");
				tr_input_label.setAttribute("class", "label_data");

				var td_imput_label_date = document.createElement("th");
				var td_imput_label_heures = document.createElement("th");
				var td_imput_label_lieu = document.createElement("th");
				var td_imput_label_agenda = document.createElement("th");
				var td_imput_label_motif = document.createElement("th");
				var td_imput_label_participant = document.createElement("th");
				var td_imput_label_accompagnant = document.createElement("th");
				var td_imput_label_assigne = document.createElement("th");
				var td_imput_label_presence = document.createElement("th");

				var text_label_date = document.createTextNode('Date');
				var text_label_heures = document.createTextNode('Heure');
				var text_label_lieu = document.createTextNode('Lieu');

				var text_label_agenda = document.createTextNode('Agenda');
				var text_label_motif = document.createTextNode('Motif');
				var text_label_participant = document.createTextNode('Participant');
				var text_label_accompagnant = document.createTextNode('Accompagnant');

				var text_label_assigne = document.createTextNode('Assigné à');
				var text_label_presence = document.createTextNode('Présence');

				td_imput_label_date.appendChild(text_label_date);
				td_imput_label_heures.appendChild(text_label_heures);
				td_imput_label_lieu.appendChild(text_label_lieu);

				td_imput_label_agenda.appendChild(text_label_agenda);
				td_imput_label_motif.appendChild(text_label_motif);

				td_imput_label_participant.appendChild(text_label_participant);
				td_imput_label_accompagnant.appendChild(text_label_accompagnant);

				td_imput_label_assigne.appendChild(text_label_assigne);
				td_imput_label_presence.appendChild(text_label_presence);

				tr_input_label.appendChild(td_imput_label_date);
				tr_input_label.appendChild(td_imput_label_heures);
				tr_input_label.appendChild(td_imput_label_lieu);
				tr_input_label.appendChild(td_imput_label_agenda);
				tr_input_label.appendChild(td_imput_label_motif);

				tr_input_label.appendChild(td_imput_label_participant);
				tr_input_label.appendChild(td_imput_label_accompagnant);

				tr_input_label.appendChild(td_imput_label_assigne);
				tr_input_label.appendChild(td_imput_label_presence);

				container.appendChild(tr_input_label);


				for (let index = 0; index < data.length; index++) {

					//les différents resultats a afficher dans le tableau
					var tr_input = document.createElement("tr");
					tr_input.setAttribute("class", "value_data");
					
					var td_imput_date = document.createElement("th");
					var td_imput_heures = document.createElement("th");
					var td_imput_lieu = document.createElement("th");
					var td_imput_agenda = document.createElement("th");
					var td_imput_motif = document.createElement("th");
					var td_imput_participant = document.createElement("th");
					var td_imput_accompagnant = document.createElement("th");
					var td_imput_assigne = document.createElement("th");
					var td_imput_presence = document.createElement("th");


					let str_datetime_start = data[index].date_start;
					let str_datetime_end = data[index].date_end;

					let str_date  = str_datetime_start.split(" ")[0];
					let str_heures = "De " + str_datetime_start.split(" ")[1] + " à " + str_datetime_end.split(" ")[1];
					
					let text_date = document.createTextNode(str_date);
					var text_heures = document.createTextNode(str_heures);
					var text_lieu = document.createTextNode(data[index].lieu);
					var text_agenda = document.createTextNode(data[index].agenda);
					var text_motif = document.createTextNode(data[index].motif);
					var text_participant = document.createTextNode(data[index].participant);
					var text_accompagnant = document.createTextNode(data[index].accompagnant);
					var text_assigne = document.createTextNode(data[index].assigned);
					var text_presence = document.createTextNode(data[index].rdv_statut_presence);

					td_imput_date.appendChild(text_date);
					td_imput_heures.appendChild(text_heures);
					td_imput_lieu.appendChild(text_lieu);
					td_imput_agenda.appendChild(text_agenda);
					td_imput_motif.appendChild(text_motif);
					td_imput_participant.appendChild(text_participant);
					td_imput_accompagnant.appendChild(text_accompagnant);
					td_imput_assigne.appendChild(text_assigne);
					td_imput_presence.appendChild(text_presence);

					tr_input.appendChild(td_imput_date);
					tr_input.appendChild(td_imput_heures);
					tr_input.appendChild(td_imput_lieu);
					tr_input.appendChild(td_imput_agenda);
					tr_input.appendChild(td_imput_motif);
					tr_input.appendChild(td_imput_participant);
					tr_input.appendChild(td_imput_accompagnant);
					tr_input.appendChild(td_imput_assigne);
					tr_input.appendChild(td_imput_presence);
					container.appendChild(tr_input);
				}

				//Récupération du nombre de lignes
				var nbLignes = container.getElementsByClassName('value_data').length;

				var Lignes = container.getElementsByClassName('value_data');
				for (var i = 0; i < nbLignes; i++) {
					if ((i - 1) % 2 == 0) {
						Lignes[i].style.backgroundColor = '#FFFFFF;';
					} else {
						Lignes[i].style.backgroundColor = '#f5f5f5';
					}
				}

			} else {

				document.getElementById('historic_link_id').textContent = "Historique(0)";
			}
		},
		error: function (data) {

			console.log("Erreur à la recherche de l'historique");
		}

	});
}


function upFirstLetter(event){
	let strElmValue = document.getElementById(event.target.id).value;
	document.getElementById(event.target.id).value = strElmValue.charAt(0).toUpperCase() + strElmValue.slice(1).toLowerCase();
}